% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_area_intersection_weights.R
\name{calculate_area_intersection_weights}
\alias{calculate_area_intersection_weights}
\title{Area Weighted Intersection (areal implementation)}
\usage{
calculate_area_intersection_weights(x, y, allow_lonlat = FALSE)
}
\arguments{
\item{x}{sf data.frame source features including one geometry column and one identifier column}

\item{y}{sf data.frame target features including one geometry column and one identifier column}

\item{allow_lonlat}{boolean If FALSE (the default) lon/lat target features are not allowed.
Intersections in lon/lat are generally not valid and problematic at the international date line.}
}
\value{
data.frame containing fraction of each feature in x that is
covered by each feature in y. e.g. If a feature from x is entirely within a feature in y,
w will be 1. If a feature from x is 50% in one feature for y and 50% in another, there
will be two rows, one for each x/y pair of features with w = 0.5 in each.
}
\description{
Returns the fractional percent of each
feature in x that is covered by each intersecting feature
in y. These can be used as the weights in an area-weighted
mean overlay analysis where x is the data source and area-
weighted means are being generated for the target, y.

This function is a lightwieght wrapper around the functions
\link[areal]{aw_intersect} \link[areal]{aw_total} and \link[areal]{aw_weight}
from the \href{https://chris-prener.github.io/areal/}{areal package}.
}
\examples{
b1 = sf::st_polygon(list(rbind(c(-1,-1), c(1,-1),
                           c(1,1), c(-1,1),
                           c(-1,-1))))
b2 = b1 + 2
b3 = b1 + c(-0.2, 2)
b4 = b1 + c(2.2, 0)
b = sf::st_sfc(b1, b2, b3, b4)
a1 = b1 * 0.8
a2 = a1 + c(1, 2)
a3 = a1 + c(-1, 2)
a = sf::st_sfc(a1,a2,a3)
plot(b, border = 'red')
plot(a, border = 'green', add = TRUE)

sf::st_crs(b) <- sf::st_crs(a) <- sf::st_crs(5070)

b <- sf::st_sf(b, data.frame(idb = c(1, 2, 3, 4)))
a <- sf::st_sf(a, data.frame(ida = c(1, 2, 3)))

sf::st_agr(a) <- sf::st_agr(b) <- "constant"

a_b <- calculate_area_intersection_weights(a, b)
b_a <- calculate_area_intersection_weights(b, a)

}
