% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_model_parameters.R
\name{model_parameters}
\alias{model_parameters}
\alias{parameters}
\title{Model Parameters}
\usage{
model_parameters(model, ...)

parameters(model, ...)
}
\arguments{
\item{model}{Statistical Model.}

\item{...}{Arguments passed to or from other methods. Non-documented arguments are \code{digits}, \code{p_digits} and \code{ci_digits} to set the number of digits for the output. See 'Examples' in \code{\link{model_parameters.default}}.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Compute and extract model parameters. See the documentation for your object's class:
\itemize{
 \item{\link[=model_parameters.htest]{Correlations, t-tests, ...} (\code{htest}, \code{pairwise.htest})}
 \item{\link[=model_parameters.aov]{ANOVAs} (\code{aov}, \code{anova}, \pkg{afex}, ...)}
 \item{\link[=model_parameters.default]{Regression models} (\code{lm}, \code{glm}, \pkg{survey}, ...)}
 \item{\link[=model_parameters.cgam]{Additive models} (\code{gam}, \code{gamm}, ...)}
 \item{\link[=model_parameters.zcpglm]{Zero-inflated models} (\code{hurdle}, \code{zeroinfl}, \code{zerocount})}
 \item{\link[=model_parameters.mlm]{Multinomial, ordinal and cumulative link models} (\code{bracl}, \code{multinom}, \code{mlm}, ...)}
 \item{\link[=model_parameters.averaging]{Other special models} (\code{model.avg}, \code{betareg}, \code{glmx}, ...)}
 \item{\link[=model_parameters.merMod]{Mixed models} (\pkg{lme4}, \pkg{nlme}, \pkg{glmmTMB}, \pkg{afex}, ...)}
 \item{\link[=model_parameters.BFBayesFactor]{Bayesian tests} (\pkg{BayesFactor})}
 \item{\link[=model_parameters.stanreg]{Bayesian models} (\pkg{rstanarm}, \pkg{brms}, \pkg{MCMCglmm}, ...)}
 \item{\link[=model_parameters.principal]{PCA and FA} (\pkg{psych})}
 \item{\link[=model_parameters.lavaan]{CFA and SEM} (\pkg{lavaan}, \pkg{blavaan})}
 \item{\link[=model_parameters.kmeans]{Cluster models} (k-means, ...)}
 \item{\link[=model_parameters.rma]{Meta-Analysis via linear (mixed) models} (\code{rma}, \code{metaplus}, \pkg{metaBMA}, ...)}
 \item{\link[=model_parameters.glht]{Hypothesis testing} (\code{glht}, \pkg{PMCMRplus})}
 \item{\link[=model_parameters.t1way]{Robust statistical tests} (\pkg{WRS2})}
 \item{\link[=model_parameters.mira]{Multiply imputed repeated analyses} (\code{mira})}
 }
}
\details{
Standardization is based on \code{\link[effectsize:standardize_parameters]{standardize_parameters()}}.
  In case of \code{standardize = "refit"}, the data used to fit the model
  will be standardized and the model is completely refitted. In such cases,
  standard errors and confidence intervals refer to the standardized coefficient.
}
\note{
The \code{\link[=print.parameters_model]{print()}} method has several arguments to tweak the output. There is also a \href{https://easystats.github.io/see/articles/parameters.html}{\code{plot()}-method} implemented in the \href{https://easystats.github.io/see/}{\pkg{see}-package}, and a dedicated method for use inside rmarkdown files, \code{\link[=print_md.parameters_model]{print_md()}}.
}
\section{Labeling the Degrees of Freedom}{

Throughout the \pkg{parameters} package, we decided to label the residual
degrees of freedom \emph{df_error}. The reason for this is that these degrees
of freedom not always refer to the residuals. For certain models, they refer
to the estimate error - in a linear model these are the same, but in - for
instance - any mixed effects model, this isn't strictly true. Hence, we
think that \code{df_error} is the most generic label for these degrees of
freedom.
}

\section{Interpretation of Interaction Terms}{

Note that the \emph{interpretation} of interaction terms depends on many
characteristics of the model. The number of parameters, and overall
performance of the model, can differ \emph{or not} between \code{a * b}
\code{a : b}, and \code{a / b}, suggesting that sometimes interaction terms
give different parameterizations of the same model, but other times it gives
completely different models (depending on \code{a} or \code{b} being factors
of covariates, included as main effects or not, etc.). Their interpretation
depends of the full context of the model, which should not be inferred
from the parameters table alone - rather, we recommend to use packages
that calculate estimated marginal means or marginal effects, such as
\CRANpkg{modelbased}, \CRANpkg{emmeans} or \CRANpkg{ggeffects}. To raise
awareness for this issue, you may use \code{print(...,show_formula=TRUE)}
to add the model-specification to the output of the
\code{\link[=print.parameters_model]{print()}} method for \code{model_parameters()}.
}

\seealso{
\code{\link[insight:standardize_names]{standardize_names()}} to rename
  columns into a consistent, standardized naming scheme.
}
