% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-sum.R
\name{type_sum}
\alias{type_sum}
\alias{obj_sum}
\title{Provide a succinct summary of an object}
\usage{
type_sum(x)

obj_sum(x)
}
\arguments{
\item{x}{an object to summarise. Generally only methods of atomic vectors
and variants have been implemented.}
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#questioning'><img src='figures/lifecycle-questioning.svg' alt='Questioning lifecycle'></a>}}{\strong{Questioning}}

\code{type_sum()} gives a brief summary of object type. Objects that commonly
occur in a data frame should return a string with four or less characters.
For most inputs, the argument is forwarded to \code{\link[vctrs:vec_ptype_full]{vctrs::vec_ptype_abbr()}}.

\code{obj_sum()} also includes the size of the object if \code{vctrs::vec_is()}
is \code{TRUE}.
}
\section{Lifecycle}{

\code{type_sum()} is in the "questioning" stage, because \code{\link[vctrs:vec_ptype_full]{vctrs::vec_ptype_abbr()}}
provides essentially the same functionality based on a robust framework.
The generic will remain available for a while.
Users and implementers are encouraged to consider \code{vctrs::vec_ptype_abbr()}
once it becomes stable.
}

\examples{
obj_sum(1:10)
obj_sum(matrix(1:10))
obj_sum(Sys.Date())
obj_sum(Sys.time())
obj_sum(mean)
}
\keyword{internal}
