# encoding: utf-8
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::RecoveryServicesBackup
  module Models
    #
    # IaaS VM workload-specific backup request.
    #
    class IaasVMBackupRequest < BackupRequest

      include MsRestAzure

      include MsRest::JSONable

      def initialize
        @objectType = "IaasVMBackupRequest"
      end

      attr_accessor :objectType

      # @return [DateTime] Backup copy will expire after the time specified
      # (UTC).
      attr_accessor :recovery_point_expiry_time_in_utc


      #
      # Mapper for IaasVMBackupRequest class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'IaasVMBackupRequest',
          type: {
            name: 'Composite',
            class_name: 'IaasVMBackupRequest',
            model_properties: {
              objectType: {
                required: true,
                serialized_name: 'objectType',
                type: {
                  name: 'String'
                }
              },
              recovery_point_expiry_time_in_utc: {
                required: false,
                serialized_name: 'recoveryPointExpiryTimeInUTC',
                type: {
                  name: 'DateTime'
                }
              }
            }
          }
        }
      end
    end
  end
end
