# The Rustc Book

- [What is rustc?](what-is-rustc.md)
- [Command-line arguments](command-line-arguments.md)
- [Lints](lints/index.md)
    - [Lint levels](lints/levels.md)
    - [Lint Groups](lints/groups.md)
    - [Lint listing](lints/listing/index.md)
        - [Allowed-by-default lints](lints/listing/allowed-by-default.md)
        - [Warn-by-default lints](lints/listing/warn-by-default.md)
        - [Deny-by-default lints](lints/listing/deny-by-default.md)
- [Codegen options](codegen-options/index.md)
- [JSON Output](json.md)
- [Tests](tests/index.md)
- [Platform Support](platform-support.md)
    - [Template for target-specific documentation](platform-support/TEMPLATE.md)
    - [aarch64-apple-ios-sim](platform-support/aarch64-apple-ios-sim.md)
    - [armv7-unknown-linux-uclibceabi](platform-support/armv7-unknown-linux-uclibceabi.md)
    - [armv7-unknown-linux-uclibceabihf](platform-support/armv7-unknown-linux-uclibceabihf.md)
    - [aarch64-unknown-none-hermitkernel](platform-support/aarch64-unknown-none-hermitkernel.md)
    - [\*-kmc-solid_\*](platform-support/kmc-solid.md)
    - [*-unknown-openbsd](platform-support/openbsd.md)
    - [x86_64-unknown-none](platform-support/x86_64-unknown-none.md)
    - [wasm64-unknown-unknown](platform-support/wasm64-unknown-unknown.md)
- [Target Tier Policy](target-tier-policy.md)
- [Targets](targets/index.md)
    - [Built-in Targets](targets/built-in.md)
    - [Custom Targets](targets/custom.md)
    - [Known Issues](targets/known-issues.md)
- [Profile-guided Optimization](profile-guided-optimization.md)
- [Instrumentation-based Code Coverage](instrument-coverage.md)
- [Linker-plugin based LTO](linker-plugin-lto.md)
- [Exploit Mitigations](exploit-mitigations.md)
- [Contributing to `rustc`](contributing.md)
