/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file CLIOpt.h
 *  \author Romain BONDUE
 *  \date 28/10/2006 */
#ifndef __CLIOPT_H__
#define __CLIOPT_H__

#include <string>

#include "Exceptions.h"



namespace nsCore
{
    class CCLIOpt
    {
      public :
        CCLIOpt (int, char* []) throw (nsErrors::CException);
        bool Help () const throw();
        bool Version () const throw();
        bool Hidden () const throw();
        bool Exit () const throw();
        bool Dhcp () const throw();
        bool Profile () const throw();
        bool Iface () const throw();
        const std::string& ProfileName () const throw();
        const std::string& IfaceName () const throw();


      private :
        enum {None, HelpFlag, VersionFlag, HiddenFlag = 4, ExitFlag = 8,
              DhcpFlag = 16, ProfileFlag = 32};

        int ParseShortOption (const char*) throw (nsErrors::CException);
        int ParseLongOption (const char*) throw (nsErrors::CException);
        int m_Flags;
        std::string m_ProfileName;
        std::string m_IfaceName;

    }; // CCLIOpt

} // namespace nsCore

#include "private/CLIOpt.hxx"

#endif // __CLIOPT_H__
