/* Generated by GIWS (version 1.2.4) */
/*

Copyright 2007-2008 INRIA
Copyright 2008-2011 DIGITEO

Author : Sylvestre Ledru & others

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/


#ifndef __SCILABOBJECTS_SCILABJAVAOBJECT__
#define __SCILABOBJECTS_SCILABJAVAOBJECT__
#include <iostream>
#include <string>
#include <string.h>
#include <stdlib.h>
#include <jni.h>

#include "GiwsException.hxx"

#ifndef _MSC_VER /* Defined anyway with Visual */
#if !defined(byte)
typedef signed char byte;
#else
#pragma message("Byte has been redefined elsewhere. Some problems can happen")
#endif
#endif


namespace ScilabObjects {
class  ScilabJavaObject {

private:
JavaVM * jvm;

protected:
jmethodID jintinvokejintjstringjintArray_ID; // cache method id
jmethodID voidinitScilabJavaObjectID; // cache method id
jmethodID voidgarbageCollectID; // cache method id
jmethodID jstringgetRepresentationjintID; // cache method id
jmethodID jbooleanisValidJavaObjectjintID; // cache method id
jmethodID voidenableTracejstringID; // cache method id
jmethodID voiddisableTraceID; // cache method id
jmethodID voidsetFieldjintjstringjintID; // cache method id
jmethodID jintgetFieldjintjstringID; // cache method id
jmethodID jintgetFieldTypejintjstringID; // cache method id
jmethodID jintjavaCastjintjstringID; // cache method id
jmethodID jintjavaCastjintjintID; // cache method id
jmethodID jstringgetClassNamejintID; // cache method id
jmethodID jintgetArrayElementjintjintArray_ID; // cache method id
jmethodID voidsetArrayElementjintjintArray_jintID; // cache method id
jmethodID voidremoveScilabJavaObjectjintID; // cache method id
jmethodID voidlimitDirectBufferjintID; // cache method id
jmethodID jintisUnwrappablejintID; // cache method id
jmethodID jintwrapDoublejdoubleID; // cache method id
jmethodID jintwrapDoublejdoubleArray_ID; // cache method id
jmethodID jintwrapDoublejobjectArray__ID; // cache method id
jmethodID jintwrapIntjintID; // cache method id
jmethodID jintwrapIntjintArray_ID; // cache method id
jmethodID jintwrapIntjobjectArray__ID; // cache method id
jmethodID jintwrapUIntjlongID; // cache method id
jmethodID jintwrapUIntjlongArray_ID; // cache method id
jmethodID jintwrapUIntjobjectArray__ID; // cache method id
jmethodID jintwrapBytejbyteID; // cache method id
jmethodID jintwrapBytejbyteArray_ID; // cache method id
jmethodID jintwrapBytejobjectArray__ID; // cache method id
jmethodID jintwrapUBytejshortID; // cache method id
jmethodID jintwrapUBytejshortArray_ID; // cache method id
jmethodID jintwrapUBytejobjectArray__ID; // cache method id
jmethodID jintwrapShortjshortID; // cache method id
jmethodID jintwrapShortjshortArray_ID; // cache method id
jmethodID jintwrapShortjobjectArray__ID; // cache method id
jmethodID jintwrapUShortjintID; // cache method id
jmethodID jintwrapUShortjintArray_ID; // cache method id
jmethodID jintwrapUShortjobjectArray__ID; // cache method id
jmethodID jintwrapStringjstringID; // cache method id
jmethodID jintwrapStringjobjectArray_ID; // cache method id
jclass stringArrayClass;
jmethodID jintwrapStringjobjectArray__ID; // cache method id
jmethodID jintwrapBooleanjbooleanID; // cache method id
jmethodID jintwrapBooleanjbooleanArray_ID; // cache method id
jmethodID jintwrapBooleanjobjectArray__ID; // cache method id
jmethodID jintwrapCharjcharID; // cache method id
jmethodID jintwrapCharjcharArray_ID; // cache method id
jmethodID jintwrapCharjobjectArray__ID; // cache method id
jmethodID jintwrapFloatjfloatID; // cache method id
jmethodID jintwrapFloatjfloatArray_ID; // cache method id
jmethodID jintwrapFloatjobjectArray__ID; // cache method id
jmethodID jintwrapLongjlongID; // cache method id
jmethodID jintwrapLongjlongArray_ID; // cache method id
jmethodID jintwrapLongjobjectArray__ID; // cache method id



jobject instance;
jclass instanceClass; // cache class


/**
* Get the environment matching to the current thread.
*/
virtual JNIEnv * getCurrentEnv();

public:
// Constructor
/**
* Create a wrapping of the object from a JNIEnv.
* It will call the default constructor
* @param JEnv_ the Java Env
*/
ScilabJavaObject(JavaVM * jvm_);

/**
* Create a wrapping of an already existing object from a JNIEnv.
* The object must have already been instantiated
* @param JEnv_ the Java Env
* @param JObj the object
*/
ScilabJavaObject(JavaVM * jvm_, jobject JObj);


/** 
* This is a fake constructor to avoid the constructor
* chaining when dealing with extended giws classes 
*/
#ifdef FAKEGIWSDATATYPE
ScilabJavaObject(fakeGiwsDataType::fakeGiwsDataType /* unused */) {}
#endif

// Destructor
~ScilabJavaObject();

// Generic method
// Synchronization methods
/**
* Enter monitor associated with the object.
* Equivalent of creating a "synchronized(obj)" scope in Java.
*/
void synchronize();

/**
* Exit monitor associated with the object.
* Equivalent of ending a "synchronized(obj)" scope.
*/
void endSynchronize();

// Methods
static int invoke(JavaVM * jvm_, int id, char * methodName, int* args, int argsSize);

static void initScilabJavaObject(JavaVM * jvm_);

static void garbageCollect(JavaVM * jvm_);

static char * getRepresentation(JavaVM * jvm_, int id);

static bool isValidJavaObject(JavaVM * jvm_, int id);

static void enableTrace(JavaVM * jvm_, char * filename);

static void disableTrace(JavaVM * jvm_);

static void setField(JavaVM * jvm_, int id, char * fieldName, int idarg);

static int getField(JavaVM * jvm_, int id, char * fieldName);

static int getFieldType(JavaVM * jvm_, int id, char * fieldName);

static int javaCast(JavaVM * jvm_, int id, char * objName);

static int javaCast(JavaVM * jvm_, int id, int classId);

static char * getClassName(JavaVM * jvm_, int id);

static int getArrayElement(JavaVM * jvm_, int id, int* index, int indexSize);

static void setArrayElement(JavaVM * jvm_, int id, int* index, int indexSize, int idArg);

static void removeScilabJavaObject(JavaVM * jvm_, int id);

static void limitDirectBuffer(JavaVM * jvm_, int id);

static int isUnwrappable(JavaVM * jvm_, int id);

static int wrapDouble(JavaVM * jvm_, double x);

static int wrapDouble(JavaVM * jvm_, double* x, int xSize);

static int wrapDouble(JavaVM * jvm_, double** x, int xSize, int xSizeCol);

static int wrapInt(JavaVM * jvm_, int x);

static int wrapInt(JavaVM * jvm_, int* x, int xSize);

static int wrapInt(JavaVM * jvm_, int** x, int xSize, int xSizeCol);

static int wrapUInt(JavaVM * jvm_, long long x);

static int wrapUInt(JavaVM * jvm_, long long* x, int xSize);

static int wrapUInt(JavaVM * jvm_, long long** x, int xSize, int xSizeCol);

static int wrapByte(JavaVM * jvm_, byte x);

static int wrapByte(JavaVM * jvm_, byte* x, int xSize);

static int wrapByte(JavaVM * jvm_, byte** x, int xSize, int xSizeCol);

static int wrapUByte(JavaVM * jvm_, short x);

static int wrapUByte(JavaVM * jvm_, short* x, int xSize);

static int wrapUByte(JavaVM * jvm_, short** x, int xSize, int xSizeCol);

static int wrapShort(JavaVM * jvm_, short x);

static int wrapShort(JavaVM * jvm_, short* x, int xSize);

static int wrapShort(JavaVM * jvm_, short** x, int xSize, int xSizeCol);

static int wrapUShort(JavaVM * jvm_, int x);

static int wrapUShort(JavaVM * jvm_, int* x, int xSize);

static int wrapUShort(JavaVM * jvm_, int** x, int xSize, int xSizeCol);

static int wrapString(JavaVM * jvm_, char * x);

static int wrapString(JavaVM * jvm_, char ** x, int xSize);

static int wrapString(JavaVM * jvm_, char *** x, int xSize, int xSizeCol);

static int wrapBoolean(JavaVM * jvm_, bool x);

static int wrapBoolean(JavaVM * jvm_, bool* x, int xSize);

static int wrapBoolean(JavaVM * jvm_, bool** x, int xSize, int xSizeCol);

static int wrapChar(JavaVM * jvm_, unsigned short x);

static int wrapChar(JavaVM * jvm_, unsigned short* x, int xSize);

static int wrapChar(JavaVM * jvm_, unsigned short** x, int xSize, int xSizeCol);

static int wrapFloat(JavaVM * jvm_, float x);

static int wrapFloat(JavaVM * jvm_, float* x, int xSize);

static int wrapFloat(JavaVM * jvm_, float** x, int xSize, int xSizeCol);

static int wrapLong(JavaVM * jvm_, long long x);

static int wrapLong(JavaVM * jvm_, long long* x, int xSize);

static int wrapLong(JavaVM * jvm_, long long** x, int xSize, int xSizeCol);


                        /**
                        * Get class name to use for static methods
                        * @return class name to use for static methods
                        */
                        
                static const std::string className()
                {
                return "org/scilab/forge/jims/ScilabJavaObject";
                }
                
};


}
#endif
