#include <options.h>
#include "opt.h"
#include <helper.h>

#include <stdlib.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


static struct args_t args;

#include "config.h"
void args_init () {
  args.system_charset = NULL;
  args.encoding = ENC_EIGHTBIT;
  args.charset = "UTF-8";
  args.vcard_version = VCARD_VERSION_21;

  args.help = 0;
  args.version = 0;
}

static void arg_fill (int short_opt,
		      const char* long_opt,
		      char* argument)
{
  switch (short_opt) {
  case 'h':
    args.help=1;
    break;
  case 'V':
    args.version=1;
    break;
  case 0:
    if (str_len(long_opt)) {
      if (!strcmp(long_opt,"system-charset")) {
	args.system_charset = argument;
      } else if (!strcmp(long_opt,"7bit")) {
	args.encoding = ENC_SEVENBIT;
      } else if (!strcmp(long_opt,"8bit")) {
	args.encoding = ENC_EIGHTBIT;
      } else if (!strcmp(long_opt,"base64")) {
	args.encoding = ENC_BASE64;
      } else if (!strcmp(long_opt,"quoted-printable")) {
	args.encoding = ENC_QUOTEDPRINTABLE;
      } else if (!strcmp(long_opt,"vcard3")) {
	args.vcard_version = VCARD_VERSION_30;
      }
    }
    break;
  }
}

//gettext workaround
#ifdef _
#undef _
#endif
#define _(s) s
struct args_def_type args_type_list[] = {
  { 0, _("options"), 0 },
  ARGS_DEF_TYPE_LAST
};

struct args_def args_list[] = {
  {"7bit",0,NULL,ARGS_PARAM_NONE,NULL,0,
   "select 7 bit encoding"},
  {"8bit",0,NULL,ARGS_PARAM_NONE,NULL,0,
   "select 8 bit encoding (default)"},
  {"base64",0,NULL,ARGS_PARAM_NONE,NULL,0,
   "select base64 encoding"},
  {"help",'h',NULL,ARGS_PARAM_NONE,NULL,0,
   "print this message"},
  {"quoted-printable",0,NULL,ARGS_PARAM_NONE,NULL,0,
   "select quoted-printable encoding"},
  {"system-charset",0,NULL,ARGS_PARAM_REQ,_("charset"),0,
   "use charset for output (default: UTF-8)"},
  {"vcard3",0,NULL,ARGS_PARAM_NONE,NULL,0,
   "output vCard-3.0 instead of vCard-2.1"},
  {"version",'V',NULL,ARGS_PARAM_NONE,NULL,0,
   "print the version number"},
  ARGS_DEF_LAST
};

char** adr2vcf_args_parse (int argc, char** argv) {
  return args_parse(argc,argv,args_list,arg_fill);
}

struct args_t* adr2vcf_get_args () {
  return &args;
}
