
from __future__ import division

import sympy as sm

names = ['bulk', 'lam', 'mu', 'young', 'poisson', 'p_wave']
bulk, lam, mu, young, poisson, p_wave = sm.symbols(names, real=True)

relations = {
    ('mu', 'poisson', 'young') : 2*mu + 2*mu*poisson,
    ('p_wave', 'poisson', 'mu') : (p_wave - 2*p_wave*poisson)/(2 - 2*poisson),
    ('bulk', 'lam', 'poisson') : lam/(-lam + 3*bulk),
    ('bulk', 'poisson', 'lam') : 3*bulk*poisson/(1 + poisson),
    ('lam', 'poisson', 'p_wave') : (lam - lam*poisson)/poisson,
    ('p_wave', 'poisson', 'lam') : p_wave*poisson/(1 - poisson),
    ('bulk', 'young', 'p_wave') : (3*bulk*young + 9*bulk**2)/(-young + 9*bulk),
    ('p_wave', 'poisson', 'bulk') : (p_wave + p_wave*poisson)/(3 - 3*poisson),
    ('bulk', 'mu', 'p_wave') : bulk + 4*mu/3,
    ('lam', 'mu', 'poisson') : lam/(2*lam + 2*mu),
    ('bulk', 'mu', 'poisson') : (-2*mu + 3*bulk)/(2*mu + 6*bulk),
    ('lam', 'mu', 'p_wave') : lam + 2*mu,
    ('bulk', 'p_wave', 'poisson') : (-p_wave + 3*bulk)/(p_wave + 3*bulk),
    ('bulk', 'p_wave', 'lam') : -p_wave/2 + 3*bulk/2,
    ('lam', 'p_wave', 'mu') : p_wave/2 - lam/2,
    ('bulk', 'p_wave', 'young') : (-9*bulk*p_wave + 9*bulk**2)/(-p_wave - 3*bulk),
    ('bulk', 'poisson', 'p_wave') : (3*bulk - 3*bulk*poisson)/(1 + poisson),
    ('p_wave', 'young', 'bulk') : p_wave/2 - young/6 + (-90*p_wave*young + 9*young**2 + 81*p_wave**2)**(1/2)/18,
    ('bulk', 'poisson', 'young') : 3*bulk - 6*bulk*poisson,
    ('lam', 'mu', 'young') : (3*lam*mu + 2*mu**2)/(lam + mu),
    ('lam', 'p_wave', 'young') : (lam*p_wave + p_wave**2 - 2*lam**2)/(lam + p_wave),
    ('lam', 'young', 'poisson') : (-lam - young + (2*lam*young + young**2 + 9*lam**2)**(1/2))/(4*lam),
    ('bulk', 'mu', 'young') : 9*bulk*mu/(mu + 3*bulk),
    ('mu', 'young', 'p_wave') : (-mu*young + 4*mu**2)/(-young + 3*mu),
    ('bulk', 'poisson', 'mu') : (3*bulk - 6*bulk*poisson)/(2 + 2*poisson),
    ('mu', 'young', 'poisson') : (young - 2*mu)/(2*mu),
    ('mu', 'p_wave', 'bulk') : p_wave - 4*mu/3,
    ('lam', 'young', 'mu') : -3*lam/4 + young/4 + (2*lam*young + young**2 + 9*lam**2)**(1/2)/4,
    ('lam', 'poisson', 'bulk') : (lam + lam*poisson)/(3*poisson),
    ('lam', 'poisson', 'young') : (lam - lam*poisson - 2*lam*poisson**2)/poisson,
    ('mu', 'p_wave', 'lam') : p_wave - 2*mu,
    ('mu', 'p_wave', 'poisson') : (-p_wave + 2*mu)/(-2*p_wave + 2*mu),
    ('poisson', 'young', 'bulk') : young/(3 - 6*poisson),
    ('mu', 'p_wave', 'young') : (-3*mu*p_wave + 4*mu**2)/(mu - p_wave),
    ('bulk', 'young', 'lam') : (-3*bulk*young + 9*bulk**2)/(-young + 9*bulk),
    ('lam', 'p_wave', 'poisson') : lam/(lam + p_wave),
    ('bulk', 'young', 'mu') : 3*bulk*young/(-young + 9*bulk),
    ('bulk', 'lam', 'p_wave') : -2*lam + 3*bulk,
    ('lam', 'young', 'p_wave') : young/2 - lam/2 + (2*lam*young + young**2 + 9*lam**2)**(1/2)/2,
    ('bulk', 'young', 'poisson') : (-2*young + 6*bulk)/(12*bulk),
    ('poisson', 'young', 'lam') : poisson*young/(1 - poisson - 2*poisson**2),
    ('mu', 'young', 'lam') : (-mu*young + 2*mu**2)/(young - 3*mu),
    ('lam', 'poisson', 'mu') : (lam - 2*lam*poisson)/(2*poisson),
    ('bulk', 'lam', 'mu') : -3*lam/2 + 3*bulk/2,
    ('poisson', 'young', 'mu') : young/(2 + 2*poisson),
    ('lam', 'p_wave', 'bulk') : p_wave/3 + 2*lam/3,
    ('p_wave', 'young', 'poisson') : (young - p_wave + (-10*p_wave*young + young**2 + 9*p_wave**2)**(1/2))/(4*p_wave),
    ('p_wave', 'young', 'mu') : young/8 + 3*p_wave/8 - (-10*p_wave*young + young**2 + 9*p_wave**2)**(1/2)/8,
    ('mu', 'poisson', 'p_wave') : (2*mu - 2*mu*poisson)/(1 - 2*poisson),
    ('lam', 'mu', 'bulk') : lam + 2*mu/3,
    ('p_wave', 'young', 'lam') : -young/4 + p_wave/4 + (-10*p_wave*young + young**2 + 9*p_wave**2)**(1/2)/4,
    ('bulk', 'mu', 'lam') : bulk - 2*mu/3,
    ('mu', 'poisson', 'bulk') : (2*mu + 2*mu*poisson)/(3 - 6*poisson),
    ('poisson', 'young', 'p_wave') : (young - poisson*young)/(1 - poisson - 2*poisson**2),
    ('mu', 'young', 'bulk') : mu*young/(-3*young + 9*mu),
    ('p_wave', 'poisson', 'young') : (p_wave - p_wave*poisson - 2*p_wave*poisson**2)/(1 - poisson),
    ('bulk', 'lam', 'young') : (-9*bulk*lam + 9*bulk**2)/(-lam + 3*bulk),
    ('mu', 'poisson', 'lam') : 2*mu*poisson/(1 - 2*poisson),
    ('bulk', 'p_wave', 'mu') : -3*bulk/4 + 3*p_wave/4,
    ('lam', 'young', 'bulk') : lam/2 + young/6 + (18*lam*young + 9*young**2 + 81*lam**2)**(1/2)/18
}
        