/* config.h  --  The file holding every overall needed info for the entire program.. 

   Copyright (C) Kenneth 'Redhead' Nielsen <kn@redhead.dk>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */


/****
 * $Id: config.h,v 1.7 2003/07/22 22:03:42 redhead Exp $ 
 * $Log: config.h,v $
 * Revision 1.7  2003/07/22 22:03:42  redhead
 * Cleaned up the code, which included rewriting every structure in the program.
 * Fixed some error checking, to make sure theres no undocumentet parts that might
 * produce an error.
 *
 * Revision 1.6  2003/07/18 10:58:10  redhead
 * This is going to be the 0.2.4 release, just fixed some spelling errors in teh documentation
 * fixed the bug with zombie processes of boxes, when using the boxing feature
 * fixed the long time waited sigit.rc(5) error reported by moffe
 * plus some minor changes here and there.
 *
 * Revision 1.5  2003/07/16 21:02:13  redhead
 * Fixed some more error checking, and worked on killing the zombie boxes
 * processes that seems to emerge.. At this point still no solution for it.
 *
 * Revision 1.4  2003/07/16 12:53:37  redhead
 * Added a conversion char %L to the usual conversions, this one will
 * display the load avarage on the machine.
 * Fixed some error checkign to ensure the right info will be displayed.
 *
 * Revision 1.3  2003/03/07 20:36:48  redhead
 * Fixed a flaw in the call to boxes, so it now takes several arguments in the
 * boxes_flags setting.
 * Added the functionality of having it giving random boxes, when the boxes_config
 * setting is pointing to the location of your boxes designs.
 *
 * Revision 1.2  2002/10/18 18:25:23  redhead
 * Added the use of boxes to create a surrounding box around the signature
 * This introduced the --with-boxes flag to configure.
 * If that flag isn't used it will default be assumed boxes isn't installed
 * Else the configure script will search for boxes, if none should be found
 * in the search path, you can use --with-boxes=/where to specify it.
 *
 ****/


#ifndef __CONFIG__H__
#define __CONFIG__H__   1


/* we better remember to change this for any upgrade */
#define VERSION   "0.3.2"
/*#define CALLSIGN  "M. Ali"*/
#define CALLSIGN  "CVS-$Date: 2005/09/30 22:03:42 $"
#define HOMEPAGE  "http://www.redhead.dk"

#include <fcntl.h>       /* O_CREAT, O_WRONLY, O_NONBLOCK */
#include <pwd.h>         /* getpwuid(), getuid() */
#include <signal.h>      /* signalhandler */
#include <stdarg.h>      /* va_start(), va_list */
#include <stdio.h>       /* snprintf(), fopen(), feof(), fgets(), fclose(), fwrite() */
#include <stdlib.h>      /* getenv(), alloca() */
#include <string.h>      /* strcmp(), strncpy(), strcpy() */
#include <time.h>        /* localtime(), ctime(), */
#include <unistd.h>      /* access(), getpid(), getppid(), fork() */

#include <pthread.h>     /* pthread_create(), pthread_join(), pthread_exit(), */
                         /* pthread_mutex_lock(), pthread_mutex_unlock() */
#include <zlib.h>        /* gzopen(), gzread(), gzwrite(), gzseek(), gzclose() */

#ifdef I__HAVE__GETOPT_LONG
#define _GNU_SOURCE
#include <getopt.h>      /* getopt_long() */
#else
#include "getopt.h"      /* self defined getopt_long() */
#endif

#ifdef SYSTEM_V_ALLOCA
#include <alloca.h>      /* alloca() */
#endif

#include <netinet/in.h>  /* htonl(), ntohl() */
#include <sys/stat.h>    /* umask() */
#include <sys/types.h>   /* open() */
#include <sys/wait.h>    /* wait() */
#include <sys/utsname.h> /* uname() */

#if defined(__linux__)

#define _GNU_SOURCE

#elif defined(__sun__)

#define _POSIX_SOURCE
#define __EXTENSIONS__

#elif defined(__FreeBSD__)
    /* do nothing */
#else

#define _POSIX_SOURCE

#endif


/* to conform with the ANSI C standard, we need a few things here.. */
#ifdef __ANSI__COMPILED__

#ifndef SIG_UNBLOCK
# define SIG_BLOCK 0
# define SIG_UNBLOCK 1
#endif
 
#ifndef __sigset_t
   typedef __sigset_t sigset_t;
#endif

#ifndef WCOREDUMP  
# define WCOREDUMP(status) ((status) & __WCOREFLAG)
#endif

#endif /* __ANSI__COMPILED */


#ifdef __NO__ALLOCA__USED__
#define USE__MALLOC(s) __NO__ALLOCA__USED__(s)
#else
#define USE__MALLOC(s) alloca(s)
#endif

#define BFREE(p) {                       /* free memory and clear pointer */ \
   if (p) {           \
      free (p);       \
     (p) = NULL;      \
   }                  \
}

/* first we need to make sure, what size of a sig we can accept.. */

#define LINE_SIZE 72                             /* in order to pressent a fine pretty print */
#define NUM_LINES 8                              /* how many lines can the max signature hold. */
#define BUFF_SIZE (LINE_SIZE * NUM_LINES +1)     /* making sure theres room for a signature */
#define MAXFD 64                                 /* max file descriptors used when shifting to deamon.*/
#define HEXCOUNT 10                              /* the max length, of the unique identifier every sig has */
#define NFS_DELAY 15                             /* The default time to wait and check for changes on NFS systems */


/* where are the default files to use.. */
#define DEFAULT_EDITOR "vi"
#ifdef __CONF__FILE__
  #define DEFAULT_CONF_FILE __CONF__FILE__
#else
  #define DEFAULT_CONF_FILE "/etc/sigit.rc"
#endif
#ifdef __DATA__FILE__
  #define DEFAULT_DATA_FILE __DATA__FILE__ 
#else
  #define DEFAULT_DATA_FILE "/usr/share/sigit/sigit.data"
#endif
#ifdef BOXING_SUPPORT
  #ifdef LOCATE_BOXES
    #define BOXES_PROGRAM LOCATE_BOXES
  #else
/* some error happened in deciding the boxing program, not valid to rely on it */
    #undef BOXING_SUPPORT 
  #endif
  #ifdef BOXES_VERSION
    #define BOX_VERSION BOXES_VERSION
  #else
    #define BOXES_VERSION "Undefined boxes version"
  #endif
#endif


#define DEFAULT_SIG_FILE  ".signature"
#define DEFAULT_EDIT_FILE "signature.edit"
#define DEFAULT_SIG  "#### due to errors the intended signature has been replaced with ####\n\"The significant problems we face cannot be solved at the\n same level of thinking we were at when we created them.\"\n                -Albert Einstein"

#ifdef sigit
#define PACKAGE   "Sigit"
#endif
#ifdef sigitdb
#define PACKAGE   "Sigitdb"
#endif


/***************************************************
 *  WARNING: Do NOT change what's below this line  *
 ***************************************************/

#ifndef _PATH_BSHELL
# define _PATH_BSHELL "/bin/sh"
#endif

/*
 *   The error types that can be returned. 
 *
 *   NO_READ     <-- We are not allowed to read from a file, or an error happende while reading 
 *   COUNT_MISS  <-- The file was either not found, or found empty when reading from it, or counter is out of order
 *   EXCEEDED    <-- The size exceeded the buffer length
 *   CONF_MI     <-- when missing every sign of sigit.rc file 
 *   CONF_ER     <-- when the sigit.rc file in /etc has no read access
 *   CONF_HR     <-- when the .sigitrc file in the homedir has no read access
 *   SUCCESS     <-- Well we all know what that means..
 *   FAILURE     <-- That is prity much known too..
 *   FAIL_FO     <-- If theres not enough heap to use fork()
 *   FAIL_EX     <-- If something happened during execution of the child process
 *   SEEK_ERR    <-- If we cant seek to the desired point in the data file
 *   WRITE_ERR   <-- If at some point a write error happens once we start writing to the files
 *
 */

#define NO_READ    -13
#define COUNT_MISS -12
#define EXCEEDED   -11
#define CONF_MI     -3
#define CONF_ER     -2
#define CONF_HR     -1
#define SUCCESS      0
#define FAILURE      1
#define FAIL_FO      2 
#define FAIL_EX      3
#define SEEK_ERR    11
#define WRITE_ERR   12


/* here are the lists that will be used to deliver pre set arguments */

#ifdef __cplusplus
extern "C" {
#endif
  

  /* a hack for OSF1/HP_UX systems (and probably BSD systems too) */
#ifdef MANUAL__DEFINE__SNPRINTF
#ifdef DECLARE_SNPRINTF
  int snprintf(char *, int, const char *, ...);
#endif
#endif
  /* well we're gonna need a mutex, in order to keep control of our threads. */
  
  pthread_mutex_t mutex;
  
  
  /*
   * The sig_struct will hold info on what the signature holds.   
   * In this, it is very essential, that the structure dosn't change
   * Else I would have no compatibillety to what ever old version the 
   * user had last time. 
   */
  
  typedef struct{
    char sig[NUM_LINES*LINE_SIZE  +1];
    unsigned long int count;
    char ident[HEXCOUNT +1];
  }SIG;
  
  /*
   * Same question arise with this counter struct, it is used in the old versions, 
   * So there is no way I can change it, else every old datafile will be outdated.
   */
  
  typedef struct{
    char ver[11];
    unsigned long int count;
  }OLD_COUNTER;
  
  /* for any new versions using gzip support. */
  
  typedef struct{
    char ver[11];
    unsigned long int count;
    unsigned long int remain;
  }COUNTER;
  
  /*
   * A more understandable pretty setting, making it easier for me to formate
   * the ouput from pretty_printer.. 
   */
  
  typedef struct{
    short int slash;
    char pretty_setting[NUM_LINES*LINE_SIZE +1];
    char top_line[LINE_SIZE +1];
    char bottom_line[LINE_SIZE +1];
    char email_address[LINE_SIZE +1];
    char name_setting[LINE_SIZE +1];
  }PRETTY;
  
  /*
   * Instead of the old config setting, we gather all the info in a fifo setting, since every
   * thread of this program in the end will have a special fifo to monitor. 
   */
  
  typedef struct FIFO{
    short int verbose;
    short int debug;
    short int spam_catcher;
    int nfs_delay;
    int seek_indent;
    char show_sig_ident[LINE_SIZE +1];
    char delete[HEXCOUNT +1];
    char fifo_name[LINE_SIZE +1];
    char data_name[LINE_SIZE +1];
    char temp_data[LINE_SIZE +1];
    char debug_file[LINE_SIZE +1];
    char limit_sig[LINE_SIZE +1];
    char* limit_start;
    char* limit_end;
#ifdef BOXING_SUPPORT
    char boxes_flags[LINE_SIZE +1];
    char boxes_config[LINE_SIZE +1];
    short int boxes_support;
#endif
    SIG sig;
    PRETTY pretty;
    struct FIFO* next;
    struct FIFO* prev;
  }FIFO;
  
#ifdef __cplusplus
};
#endif


#ifdef sigit
/* creating a Proccess ID lockfile as ~/.Sigit-$(USER).lck */

int create_pid_file(void);

/* Well guess what, it deletes the process ID lockfile */

int remove_pid_file(void);

/* a function, to write to the given debug file */

int logging(FIFO* fifo, const char* fmt, ...);

/* To check if the file is a valid configuration file */

FILE* open_config_file(const char* file_name, int verbose);

/*
 * well this should be an obvius function, it reads the config file,
 * and fills in the list of prefered arguments..
 */
int read_config_fifo(FIFO* fifo, FILE* file);

#endif /* defined sigit */

/* print the GPL copyright */

int print_copyright(void);

/* yeah yeah, guess what this one does.. */

int _shine_on_you_crazy_diamond_(void);

#endif








