/* files.h  --  The file holding all i/o functions required by Sigit..

   Copyright (C) Kenneth 'Redhead' Nielsen <kn@redhead.dk>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */


/****
 * $Id: files-db.h,v 1.3 2003/07/22 22:03:42 redhead Exp $ 
 * $Log: files-db.h,v $
 * Revision 1.3  2003/07/22 22:03:42  redhead
 * Cleaned up the code, which included rewriting every structure in the program.
 * Fixed some error checking, to make sure theres no undocumentet parts that might
 * produce an error.
 *
 * Revision 1.2  2002/10/18 18:25:23  redhead
 * Added the use of boxes to create a surrounding box around the signature
 * This introduced the --with-boxes flag to configure.
 * If that flag isn't used it will default be assumed boxes isn't installed
 * Else the configure script will search for boxes, if none should be found
 * in the search path, you can use --with-boxes=/where to specify it.
 *
 ****/


#ifdef sigitdb
#ifndef __FILES__DB__H__
#define __FILES__DB__H__    1

#include "config.h" /* #include <every_fucking_thing> */


/*
  the add_sig will read the file parsed to the function, and update the default datafile
  If the person wants to update another file, they will have to set the end file in the 
  configuration file. This feature is used like:
   sigit -a <srcfile>
  which will update the default data file.
*/

int add_sig(FIFO* fifo);


/*
  The get_sig will read the signature from the file parsed to it, if theres 
  another setting in the config file this will be used instead.
 */

int edit_db_file(FIFO* fifo);


int set_sig(FIFO* fifo);

int print_sig(FILE* out_file, char* sig);

#endif
#endif
