C Copyright(C) 2011-2017 National Technology & Engineering Solutions
C of Sandia, LLC (NTESS).  Under the terms of Contract DE-NA0003525 with
C NTESS, the U.S. Government retains certain rights in this software.
C
C Redistribution and use in source and binary forms, with or without
C modification, are permitted provided that the following conditions are
C met:
C
C * Redistributions of source code must retain the above copyright
C    notice, this list of conditions and the following disclaimer.
C
C * Redistributions in binary form must reproduce the above
C   copyright notice, this list of conditions and the following
C   disclaimer in the documentation and/or other materials provided
C   with the distribution.
C
C * Neither the name of NTESS nor the names of its
C   contributors may be used to endorse or promote products derived
C   from this software without specific prior written permission.
C
C THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
C "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
C LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
C A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
C OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
C SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
C LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
C DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
C THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
C (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
C OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

C=======================================================================
      SUBROUTINE FNPCEN (LINK, N4, NUMCOL, NEROW, IELCEN,
     &   IRBOT, IRTOP, NUMROW, NPCEN, NREL, IELCOL, NRNP, NRBOT, NRTOP)
C=======================================================================

C   --*** FNPCEN *** (GEN3D) Compute center block row x column nodes
C   --   Written by Amy Gilkey - revised 04/26/88
C   --   Modified by Greg Sjaardema, 07/06/90
C   --       Problem with noncontiguous material blocks in center
C   --       blocks. (ie. Slidelines separating materials.)
C   --       Problem not fixed, error checking enabled.
C   --       Problem is in setting node numbers in NPCEN.
C   --
C   --FNPCEN sets the number of elements generated by each element (if the
C   --column is within NUMCOL), and returns the nodes by row and column.
C   --
C   --Parameters:
C   --   LINK - IN - the connectivity for the 2D elements, always 4 nodes
C   --   N4 - IN - the number of quadrants
C   --   NUMCOL - IN - the number of columns in the center blocks
C   --   NEROW - IN - the number of element rows in the center blocks
C   --   IELCEN - IN - the element numbers of the center elements
C   --      by column and row
C   --   IRBOT, IRTOP - IN - the row number of the row on top and bottom
C   --   NUMROW - OUT - the number of nodal rows in the center blocks
C   --   NPCEN - OUT - the node numbers of the center nodes by column and row
C   --   NREL - IN/OUT - the number of new elements generated for each element
C   --   IELCOL - IN/OUT - the row number for each element
C   --   NRNP - IN/OUT - the number of new nodes generated for each node
C   --   NRBOT, NRTOP - SCRATCH - size = NEROW
C   --
C   --Common Variables:
C   --   Uses IX1, IX2, IX3, IX4 of /CENPAR/

      INCLUDE 'g3_cenpar.blk'

      INTEGER LINK(4,*)
      INTEGER NPCEN(NUMCOL,*)
      INTEGER IELCEN(NUMCOL,*)
      INTEGER IRBOT(*), IRTOP(*)
      INTEGER NREL(*), IELCOL(*)
      INTEGER NRNP(*)
      INTEGER NRBOT(*), NRTOP(*)

C   --The number of elements generated for center elements is dependent on
C   --the column

      DO 20 ICOL = 1, MAX (NUMCOL-1, 1)
         NR = (ICOL*2-1) * N4
         DO 10 IROW = 1, NEROW
            IEL = IELCEN(ICOL,IROW)
            IF (IEL .LE. 0) GOTO 10
            NREL(IEL) = NR
            IELCOL(IEL) = ICOL
   10    CONTINUE
   20 CONTINUE

C   --Fill in the node rows, checking if bottom or top row has already been
C   --inserted

      CALL INIINT (NEROW, 0, NRBOT)
      CALL INIINT (NEROW, 0, NRTOP)

      NUMROW = 0
      DO 40 IROW = 1, NEROW
         IBOT = NRBOT(IROW)
         IF (IBOT .EQ. 0) THEN
            NUMROW = NUMROW + 1
            IBOT = NUMROW
            IF (IRBOT(IROW) .GT. 0) NRTOP(IRBOT(IROW)) = IBOT
         END IF
         ITOP = NRTOP(IROW)
         IF (ITOP .EQ. 0) THEN
            NUMROW = NUMROW + 1
            ITOP = NUMROW
            IF (IRTOP(IROW) .GT. 0) NRBOT(IRTOP(IROW)) = ITOP
         END IF

         DO 30 ICOL = 1, NUMCOL
            IEL = IELCEN(ICOL,IROW)
            IF (IEL .LE. 0) GOTO 30
            INP = LINK(IX1,IEL)
            IF (NPCEN(ICOL,IBOT) .NE. 0 .AND.
     $          NPCEN(ICOL,IBOT) .NE. INP) THEN
               CALL PRTERR ('FATAL',
     $              'Center blocks must be contiguous')
               CALL PRTERR ('CMDSPEC',
     $              'Slidelines are not allowed')
               STOP 'CENTER BLOCK NONCONTIGUOUS'
            ELSE
               NPCEN(ICOL,IBOT) = INP
            END IF
            INP = LINK(IX4,IEL)
            IF (NPCEN(ICOL,ITOP) .NE. 0 .AND.
     $          NPCEN(ICOL,ITOP) .NE. INP) THEN
               CALL PRTERR ('FATAL',
     $              'Center blocks must be contiguous')
               CALL PRTERR ('CMDSPEC',
     $              'Slidelines are not allowed')
               STOP 'CENTER BLOCK NONCONTIGUOUS'
            ELSE
               NPCEN(ICOL,ITOP) = INP
            END IF
   30    CONTINUE
   40 CONTINUE

C   --The number of nodes generated for center nodes is dependent on
C   --the column

      DO 70 ICOL = 1, MAX (NUMCOL, 1)
         IF (ICOL .EQ. 1) THEN
            NR = 1
         ELSE IF (N4 .EQ. 4) THEN
            NR = (ICOL-1) * 2 * N4
         ELSE
            NR = (ICOL-1) * 2 * N4 + 1
         END IF
         DO 60 IROW = 1, NUMROW
            INP = NPCEN(ICOL,IROW)
            IF (INP .EQ. 0) GOTO 60
            NRNP(INP) = NR
   60    CONTINUE
   70 CONTINUE

      RETURN
      END
