//    _   _____   __________
//   | | / / _ | / __/_  __/     Visibility
//   | |/ / __ |_\ \  / /          Across
//   |___/_/ |_/___/ /_/       Space and Time
//
// SPDX-FileCopyrightText: (c) 2018 The VAST Contributors
// SPDX-License-Identifier: BSD-3-Clause

#pragma once

#include "vast/command.hpp"

#include <memory>
#include <string>
#include <string_view>
#include <utility>

namespace vast::system {

/// Creates the applications command tree based on a single root command.
/// @returns the root command.
std::pair<std::unique_ptr<vast::command>, vast::command::factory>
make_application(std::string_view path);

/// Formats a useful human readable error message on the output stream.
/// @param root The root command of the application.
/// @param err An error generated by the application.
/// @param os The output stream to write to.
void render_error(const command& root, const caf::error& err, std::ostream& os);

/// @returns default options for commands.
command::opts_builder opts(std::string_view category);

} // namespace vast::system
