(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import ZArith.
Require Import Rbase.
Inductive list (a:Type) :=
  | Nil : list a
  | Cons : a -> (list a) -> list a.
Set Contextual Implicit.
Implicit Arguments Nil.
Unset Contextual Implicit.
Implicit Arguments Cons.

Set Implicit Arguments.
Fixpoint mem (a:Type)(x:a) (l:(list a)) {struct l}: Prop :=
  match l with
  | Nil => False
  | (Cons y r) => (x = y) \/ (mem x r)
  end.
Unset Implicit Arguments.

Parameter t : Type.

Parameter infix_lseq: t -> t -> Prop.


Axiom le_refl : forall (x:t), (infix_lseq x x).

Axiom le_asym : forall (x:t) (y:t), (infix_lseq x y) -> ((infix_lseq y x) ->
  (x = y)).

Axiom le_trans : forall (x:t) (y:t) (z:t), (infix_lseq x y) -> ((infix_lseq y
  z) -> (infix_lseq x z)).

Inductive sorted : (list t) -> Prop :=
  | sorted_nil : (sorted (Nil:(list t)))
  | sorted_one : forall (x:t), (sorted (Cons x (Nil:(list t))))
  | sorted_two : forall (x:t) (y:t) (l:(list t)), (infix_lseq x y) ->
      ((sorted (Cons y l)) -> (sorted (Cons x (Cons y l)))).

Axiom sorted_inf : forall (x:t) (y:t) (l:(list t)), (infix_lseq x y) ->
  ((sorted (Cons y l)) -> (sorted (Cons x l))).

(* YOU MAY EDIT THE CONTEXT BELOW *)

(* DO NOT EDIT BELOW *)

Theorem sorted_mem : forall (x:t) (l:(list t)), (sorted (Cons x l)) ->
  forall (y:t), (mem y l) -> (infix_lseq x y).
(* YOU MAY EDIT THE PROOF BELOW *)
induction l.
simpl; tauto.
simpl.
intro H.
inversion H.
intros y0 [Heq | Hmem].
subst; auto.
apply IHl; auto.
apply sorted_inf with (y:=a); auto.
Qed.
(* DO NOT EDIT BELOW *)


