/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Selector;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.CircleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.FixedCircleObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.SegmentObject;

public class SetFixedCircle
extends ObjectConstructor
implements Selector {
    ObjectConstructor OC;
    FixedCircleObject C;
    PointObject P1;
    PointObject P2;

    public SetFixedCircle(ZirkelCanvas zirkelCanvas, FixedCircleObject fixedCircleObject, ObjectConstructor objectConstructor) {
        this.C = fixedCircleObject;
        this.OC = objectConstructor;
        fixedCircleObject.setSelected(true);
        zirkelCanvas.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (this.P1 == null) {
            ConstructionObject constructionObject = zirkelCanvas.selectWithSelector(mouseEvent.getX(), mouseEvent.getY(), this);
            if (constructionObject == null) {
                return;
            }
            if (constructionObject instanceof PointObject) {
                this.P1 = (PointObject)constructionObject;
                this.P1.setSelected(true);
                this.showStatus(zirkelCanvas);
                zirkelCanvas.repaint();
                return;
            }
            this.C.setFixed(constructionObject.getName());
            this.C.setDragable(false);
            this.C.updateText();
            this.reset(zirkelCanvas);
        } else {
            this.P2 = zirkelCanvas.selectPoint(mouseEvent.getX(), mouseEvent.getY());
            if (this.P2 == null) {
                return;
            }
            this.C.setFixed("d(" + this.P1.getName() + "," + this.P2.getName() + ")");
            this.reset(zirkelCanvas);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas, boolean bl) {
        zirkelCanvas.indicateWithSelector(mouseEvent.getX(), mouseEvent.getY(), this);
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.P1 == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.setfixedcircle.first"));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.setfixedcircle.second"));
        }
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        super.reset(zirkelCanvas);
        zirkelCanvas.setTool(this.OC);
        zirkelCanvas.validate();
        this.showStatus(zirkelCanvas);
        zirkelCanvas.repaint();
        zirkelCanvas.check();
    }

    public boolean useSmartBoard() {
        return this.P1 != null;
    }

    public boolean isAdmissible(ZirkelCanvas zirkelCanvas, ConstructionObject constructionObject) {
        return (constructionObject instanceof PointObject || constructionObject instanceof SegmentObject || constructionObject instanceof FixedCircleObject || constructionObject instanceof CircleObject || constructionObject instanceof ExpressionObject) && !zirkelCanvas.getConstruction().dependsOn(constructionObject, this.C);
    }
}

