/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.Zirkel;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.BracketExpression;
import rene.zirkel.expression.ElementaryExpression;
import rene.zirkel.expression.ExpressionText;
import rene.zirkel.expression.MinusExpression;
import rene.zirkel.expression.TopExpression;

class BasicExpression {
    BasicExpression E;
    static final int MINUS = -1;
    static final int PLUS = 1;

    BasicExpression() {
    }

    public static BasicExpression scan(ExpressionText expressionText) throws ConstructionException {
        if (expressionText.next() == '-') {
            expressionText.advance();
            return BasicExpression.scan(expressionText, -1);
        }
        if (expressionText.next() == '+') {
            expressionText.advance();
            return BasicExpression.scan(expressionText, 1);
        }
        if (expressionText.next() == '(') {
            return new BracketExpression(BasicExpression.scanBracket(expressionText));
        }
        return ElementaryExpression.scan(expressionText);
    }

    public static BasicExpression scan(ExpressionText expressionText, int n) throws ConstructionException {
        if (n == -1) {
            if (expressionText.next() == '(') {
                return new MinusExpression(BasicExpression.scanBracket(expressionText));
            }
            return new MinusExpression(ElementaryExpression.scan(expressionText));
        }
        if (expressionText.next() == '(') {
            return BasicExpression.scanBracket(expressionText);
        }
        return ElementaryExpression.scan(expressionText);
    }

    public static BasicExpression scanBracket(ExpressionText expressionText) throws ConstructionException {
        expressionText.advance();
        BasicExpression basicExpression = TopExpression.scan(expressionText);
        if (expressionText.next() != ')') {
            throw new ConstructionException(Zirkel.name("exception.bracket"));
        }
        expressionText.advance();
        return basicExpression;
    }

    public double getValue() throws ConstructionException {
        throw new ConstructionException("");
    }

    public void translate() {
    }

    public boolean isNumber() {
        return false;
    }

    public void reset() {
    }

    public boolean isLogical() {
        return false;
    }
}

