/* 
   Normal size chessboard by Stefano Bodrato - 14/02/2007
   Converted from ZX to BMP and then from BMP to sprites
   with the Daniel McKinnon's z88dk Sprite Editor
   
   This one is a fancy replacement for "chessboard.h"
*/

#include <graphics.h>
#include <games.h>

#define P_BLACK 0
#define P_WHITE 1

#define P_PAWN 0
#define P_ROOK 1
#define P_KNIGHT 2
#define P_BISHOP 5
#define P_QUEEN 3
#define P_KING 4

// 6 x BLACK + 6 x WHITE + 6 x MASK
char pieces[] = { 
	
24, 24, 0x00 , 0x00 , 0x00 , 0x00 , 0x18 , 0x00 , 0x00 , 0x2C , 0x20 , 0x00 , 0x5E 
, 0x20 , 0x00 , 0x5E , 0x70 , 0x00 , 0x7E , 0x20 , 0x00 , 0xFF , 0x20 , 0x00 
, 0xFF , 0x20 , 0x00 , 0x3C , 0x20 , 0x00 , 0x3C , 0x20 , 0x00 , 0x18 , 0x20 
, 0x00 , 0x7F , 0xE0 , 0x00 , 0xFF , 0xE0 , 0x00 , 0xBF , 0x20 , 0x01 , 0xBF 
, 0xA0 , 0x01 , 0x7F , 0xA0 , 0x01 , 0x7F , 0xA0 , 0x01 , 0xFF , 0xA0 , 0x00 
, 0x66 , 0x20 , 0x00 , 0x66 , 0x00 , 0x00 , 0xE7 , 0x00 , 0x01 , 0xE7 , 0x80 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,

24, 24, 0x00 , 0x00 , 0x00 , 0x0E , 0x38 , 0xE0 , 0x0A , 0x28 , 0xA0 , 0x0E , 0x38 
, 0xE0 , 0x0B , 0xEF , 0xA0 , 0x0E , 0x6C , 0xE0 , 0x03 , 0xFF , 0x80 , 0x01 
, 0x25 , 0x00 , 0x01 , 0xFF , 0x00 , 0x01 , 0x49 , 0x00 , 0x01 , 0xFF , 0x00 
, 0x01 , 0x25 , 0x00 , 0x01 , 0xFF , 0x00 , 0x01 , 0x49 , 0x00 , 0x01 , 0xFF 
, 0x00 , 0x01 , 0x25 , 0x00 , 0x03 , 0xFF , 0x80 , 0x04 , 0x92 , 0xC0 , 0x0F 
, 0xFF , 0xE0 , 0x15 , 0x24 , 0xB0 , 0x1F , 0xFF , 0xF0 , 0x12 , 0x52 , 0x90 
, 0x1F , 0xFF , 0xF0 , 0x00 , 0x00 , 0x00 ,

24, 24, 0x00 , 0x00 , 0x00 , 0x03 , 0x68 , 0x00 , 0x0D , 0x5E , 0x00 , 0x15 , 0xFF 
, 0x00 , 0x2B , 0xFF , 0x80 , 0x17 , 0xF9 , 0xC0 , 0x3B , 0xFF , 0xE0 , 0x17 
, 0xFF , 0xF0 , 0x2B , 0xFF , 0xF8 , 0x27 , 0xFF , 0xF8 , 0x39 , 0xF9 , 0xF8 
, 0x4E , 0xF8 , 0x70 , 0x33 , 0xFC , 0x00 , 0x2D , 0xFC , 0x00 , 0x15 , 0xFE 
, 0x00 , 0x3B , 0xFE , 0x00 , 0x6B , 0xFF , 0x00 , 0x17 , 0xFF , 0x80 , 0x6F 
, 0xFF , 0xC0 , 0x5F , 0xFF , 0xE0 , 0x3F , 0xFF , 0xE0 , 0x5F , 0xFF , 0xE0 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,

24, 24, 0x00 , 0x00 , 0x00 , 0x00 , 0x58 , 0x00 , 0x00 , 0x2C , 0x00 , 0x00 , 0xD2 
, 0x00 , 0x01 , 0x52 , 0x00 , 0x01 , 0x54 , 0x00 , 0x00 , 0xA8 , 0x00 , 0x01 
, 0x5C , 0x00 , 0x02 , 0xBE , 0x00 , 0x02 , 0xDE , 0x00 , 0x01 , 0x3C , 0x00 
, 0x01 , 0x5C , 0x00 , 0x00 , 0x3C , 0x00 , 0x00 , 0x3C , 0x00 , 0x00 , 0x7C 
, 0x00 , 0x00 , 0x7C , 0x00 , 0x00 , 0x7E , 0x00 , 0x00 , 0x7E , 0x00 , 0x00 
, 0x7F , 0x00 , 0x00 , 0x5F , 0x00 , 0x00 , 0x1C , 0x00 , 0x00 , 0x1E , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,

24, 24, 0x00 , 0x00 , 0x00 , 0x01 , 0x54 , 0x00 , 0x01 , 0x54 , 0x00 , 0x01 , 0x54 
, 0x00 , 0x01 , 0xFC , 0xC0 , 0x00 , 0xA9 , 0xE0 , 0x01 , 0x45 , 0xE0 , 0x00 
, 0xC4 , 0xC0 , 0x01 , 0x78 , 0xC0 , 0x00 , 0xF0 , 0xC0 , 0x01 , 0x7F , 0xC0 
, 0x00 , 0x7F , 0xC0 , 0x00 , 0x7F , 0xC0 , 0x00 , 0x7C , 0xC0 , 0x00 , 0x7C 
, 0xC0 , 0x00 , 0x7C , 0xC0 , 0x00 , 0x7C , 0xC0 , 0x00 , 0x7C , 0xC0 , 0x00 
, 0x7C , 0x00 , 0x00 , 0x7C , 0x00 , 0x00 , 0x7C , 0x00 , 0x00 , 0xFE , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,

24, 24, 0x00 , 0x00 , 0x00 , 0x00 , 0x60 , 0x00 , 0x00 , 0xF0 , 0x00 , 0x01 , 0xF8 
, 0x0C , 0x03 , 0x88 , 0x14 , 0x05 , 0x88 , 0x28 , 0x03 , 0xF8 , 0x50 , 0x05 
, 0xFA , 0xA0 , 0x00 , 0xF1 , 0x40 , 0x01 , 0x0E , 0x80 , 0x02 , 0xF1 , 0x40 
, 0x02 , 0xC6 , 0x00 , 0x01 , 0x38 , 0x00 , 0x01 , 0xF8 , 0x00 , 0x01 , 0xF8 
, 0x00 , 0x01 , 0xF8 , 0x00 , 0x01 , 0xF8 , 0x00 , 0x01 , 0xF8 , 0x00 , 0x01 
, 0x98 , 0x00 , 0x01 , 0x98 , 0x00 , 0x01 , 0x98 , 0x00 , 0x01 , 0xDC , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,

24, 24, 0x00 , 0x00 , 0x00 , 0x00 , 0x18 , 0x00 , 0x00 , 0x24 , 0x20 , 0x00 , 0x42 
, 0x20 , 0x00 , 0x52 , 0x70 , 0x00 , 0x52 , 0x20 , 0x00 , 0x81 , 0x20 , 0x00 
, 0xFF , 0x20 , 0x00 , 0x3C , 0x20 , 0x00 , 0x3C , 0x20 , 0x00 , 0x18 , 0x20 
, 0x00 , 0x7F , 0xE0 , 0x00 , 0x81 , 0xE0 , 0x00 , 0x91 , 0x20 , 0x01 , 0x20 
, 0xA0 , 0x01 , 0x20 , 0xA0 , 0x01 , 0x00 , 0xA0 , 0x01 , 0xFF , 0xA0 , 0x00 
, 0x66 , 0x20 , 0x00 , 0x66 , 0x00 , 0x00 , 0xE7 , 0x00 , 0x01 , 0xE7 , 0x80 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,

24, 24, 0x00 , 0x00 , 0x00 , 0x0F , 0x7D , 0xE0 , 0x09 , 0x45 , 0x20 , 0x09 , 0x45 
, 0x20 , 0x09 , 0xC7 , 0x20 , 0x08 , 0x82 , 0x20 , 0x07 , 0xFF , 0xC0 , 0x01 
, 0x21 , 0x00 , 0x01 , 0x21 , 0x00 , 0x01 , 0xFF , 0x00 , 0x01 , 0x09 , 0x00 
, 0x01 , 0x09 , 0x00 , 0x01 , 0xFF , 0x00 , 0x01 , 0x11 , 0x00 , 0x01 , 0x11 
, 0x00 , 0x01 , 0xFF , 0x00 , 0x02 , 0x44 , 0x80 , 0x04 , 0x44 , 0x40 , 0x0F 
, 0xFF , 0xE0 , 0x11 , 0x11 , 0x10 , 0x11 , 0x11 , 0x10 , 0x1F , 0xFF , 0xF0 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,

24, 24, 0x00 , 0x00 , 0x00 , 0x00 , 0x50 , 0x00 , 0x02 , 0xAA , 0x00 , 0x0D , 0x55 
, 0x00 , 0x02 , 0xA0 , 0x80 , 0x0D , 0x06 , 0x40 , 0x25 , 0x00 , 0x20 , 0x1A 
, 0x00 , 0x10 , 0x24 , 0x00 , 0x08 , 0x0A , 0x0E , 0x08 , 0x34 , 0x09 , 0x88 
, 0x0A , 0x08 , 0x70 , 0x34 , 0x04 , 0x00 , 0x13 , 0x04 , 0x00 , 0x2C , 0x02 
, 0x00 , 0x12 , 0x02 , 0x00 , 0x29 , 0x01 , 0x00 , 0x16 , 0x00 , 0x80 , 0x68 
, 0x00 , 0x40 , 0x14 , 0x00 , 0x20 , 0x30 , 0x00 , 0x20 , 0x5F , 0xFF , 0xE0 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,

24, 24, 0x00 , 0x00 , 0x00 , 0x00 , 0x18 , 0x00 , 0x00 , 0x2C , 0x00 , 0x00 , 0xD2 
, 0x00 , 0x00 , 0xA2 , 0x00 , 0x00 , 0x54 , 0x00 , 0x01 , 0xA8 , 0x00 , 0x00 
, 0x56 , 0x00 , 0x01 , 0xB1 , 0x00 , 0x02 , 0x51 , 0x00 , 0x00 , 0x92 , 0x00 
, 0x00 , 0x14 , 0x00 , 0x00 , 0x24 , 0x00 , 0x00 , 0x44 , 0x00 , 0x00 , 0x44 
, 0x00 , 0x00 , 0x44 , 0x00 , 0x00 , 0x42 , 0x00 , 0x00 , 0x81 , 0x00 , 0x00 
, 0xF7 , 0x00 , 0x00 , 0x14 , 0x00 , 0x00 , 0x14 , 0x00 , 0x00 , 0x1E , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,

24, 24, 0x00 , 0x00 , 0x00 , 0x01 , 0x54 , 0x00 , 0x01 , 0x54 , 0x00 , 0x01 , 0x54 
, 0x00 , 0x01 , 0xFC , 0xE0 , 0x02 , 0xA9 , 0x10 , 0x01 , 0x45 , 0x10 , 0x02 
, 0xC4 , 0xA0 , 0x01 , 0x78 , 0xA0 , 0x02 , 0xD0 , 0xA0 , 0x00 , 0x8F , 0xA0 
, 0x00 , 0x80 , 0xA0 , 0x00 , 0x87 , 0xA0 , 0x00 , 0x84 , 0xA0 , 0x00 , 0x84 
, 0xA0 , 0x00 , 0x84 , 0xA0 , 0x00 , 0x84 , 0xA0 , 0x00 , 0x84 , 0xE0 , 0x00 
, 0x84 , 0x00 , 0x00 , 0x84 , 0x00 , 0x01 , 0x02 , 0x00 , 0x01 , 0xFE , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,

24, 24, 0x00 , 0x00 , 0x00 , 0x00 , 0x60 , 0x00 , 0x00 , 0x90 , 0x00 , 0x01 , 0x08 
, 0x0C , 0x03 , 0x78 , 0x14 , 0x05 , 0x78 , 0x28 , 0x03 , 0x08 , 0x50 , 0x05 
, 0x0A , 0xA0 , 0x00 , 0xF1 , 0x40 , 0x01 , 0xFE , 0x80 , 0x02 , 0x01 , 0x40 
, 0x02 , 0x1E , 0x00 , 0x01 , 0xE8 , 0x00 , 0x01 , 0x08 , 0x00 , 0x01 , 0x08 
, 0x00 , 0x01 , 0x08 , 0x00 , 0x01 , 0x08 , 0x00 , 0x01 , 0x64 , 0x00 , 0x01 
, 0x54 , 0x00 , 0x01 , 0x54 , 0x00 , 0x01 , 0x54 , 0x00 , 0x01 , 0xDE , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,

24, 24, 0x00 , 0x18 , 0x00 , 0x00 , 0x3C , 0x20 , 0x00 , 0x7E , 0x30 , 0x00 , 0xFE 
, 0x70 , 0x00 , 0xFE , 0x78 , 0x00 , 0xFF , 0x70 , 0x01 , 0xFF , 0x70 , 0x01 
, 0xFF , 0x70 , 0x00 , 0x7F , 0x70 , 0x00 , 0x7F , 0x70 , 0x00 , 0x3F , 0xF0 
, 0x00 , 0xFF , 0xF0 , 0x01 , 0xFF , 0xF0 , 0x01 , 0xFF , 0xF0 , 0x03 , 0xFF 
, 0xB0 , 0x03 , 0xFF , 0xB0 , 0x03 , 0xFF , 0xB0 , 0x03 , 0xFF , 0xB0 , 0x00 
, 0xFF , 0xB0 , 0x00 , 0xE7 , 0x20 , 0x01 , 0xE7 , 0x80 , 0x03 , 0xE7 , 0xC0 
, 0x01 , 0xE7 , 0x80 , 0x00 , 0x00 , 0x00 ,

24, 24, 0x0E , 0x38 , 0xE0 , 0x1E , 0x38 , 0xF0 , 0x1E , 0x38 , 0xF0 , 0x1F , 0xFF 
, 0xF0 , 0x1F , 0xFF , 0xF0 , 0x1F , 0xFF , 0xF0 , 0x07 , 0xFF , 0xC0 , 0x03 
, 0xFF , 0x80 , 0x03 , 0xFF , 0x80 , 0x03 , 0xFF , 0x80 , 0x03 , 0xFF , 0x80 
, 0x03 , 0xFF , 0x80 , 0x03 , 0xFF , 0x80 , 0x03 , 0xFF , 0x80 , 0x03 , 0xFF 
, 0x80 , 0x03 , 0xFF , 0x80 , 0x07 , 0xFF , 0xC0 , 0x0F , 0xFF , 0xE0 , 0x1F 
, 0xFF , 0xF0 , 0x3F , 0xFF , 0xF8 , 0x3F , 0xFF , 0xF8 , 0x3F , 0xFF , 0xF8 
, 0x3F , 0xFF , 0xF8 , 0x1F , 0xFF , 0xF0 ,

24, 24, 0x03 , 0x68 , 0x00 , 0x0F , 0x7E , 0x00 , 0x1F , 0xFF , 0x00 , 0x3F , 0xFF 
, 0x80 , 0x7F , 0xFF , 0xC0 , 0x3F , 0xFF , 0xE0 , 0x7F , 0xFF , 0xF0 , 0x3F 
, 0xFF , 0xF8 , 0x7F , 0xFF , 0xFC , 0x7F , 0xFF , 0xFC , 0x7F , 0xFF , 0xFC 
, 0xFF , 0xFF , 0xF8 , 0x7F , 0xFE , 0x10 , 0x7F , 0xFE , 0x00 , 0x3F , 0xFF 
, 0x00 , 0x7F , 0xFF , 0x00 , 0xFF , 0xFF , 0x80 , 0x3F , 0xFF , 0xC0 , 0xFF 
, 0xFF , 0xE0 , 0xFF , 0xFF , 0xF0 , 0x7F , 0xFF , 0xF0 , 0xFF , 0xFF , 0xF0 
, 0x5F , 0xFF , 0xE0 , 0x00 , 0x00 , 0x00 ,

24, 24, 0x00 , 0x58 , 0x00 , 0x00 , 0xFC , 0x00 , 0x00 , 0xFE , 0x00 , 0x01 , 0xFF 
, 0x00 , 0x03 , 0xFF , 0x00 , 0x03 , 0xFE , 0x00 , 0x01 , 0xFC , 0x00 , 0x03 
, 0xFE , 0x00 , 0x07 , 0xFF , 0x00 , 0x07 , 0xFF , 0x00 , 0x03 , 0xFE , 0x00 
, 0x03 , 0x7E , 0x00 , 0x01 , 0x7E , 0x00 , 0x00 , 0x7E , 0x00 , 0x00 , 0xFE 
, 0x00 , 0x00 , 0xFE , 0x00 , 0x00 , 0xFF , 0x00 , 0x00 , 0xFF , 0x00 , 0x00 
, 0xFF , 0x80 , 0x00 , 0xFF , 0x80 , 0x00 , 0x7F , 0x00 , 0x00 , 0x3F , 0x00 
, 0x00 , 0x1E , 0x00 , 0x00 , 0x00 , 0x00 ,

24, 24, 0x01 , 0x54 , 0x00 , 0x03 , 0x56 , 0x00 , 0x03 , 0x56 , 0x00 , 0x03 , 0xFE 
, 0xC0 , 0x03 , 0xFD , 0xE0 , 0x01 , 0xFD , 0xF0 , 0x03 , 0xFD , 0xF0 , 0x01 
, 0xFD , 0xE0 , 0x03 , 0xFD , 0xE0 , 0x01 , 0xFF , 0xE0 , 0x03 , 0xFF , 0xE0 
, 0x01 , 0xFF , 0xE0 , 0x00 , 0xFF , 0xE0 , 0x00 , 0xFF , 0xE0 , 0x00 , 0xFE 
, 0xE0 , 0x00 , 0xFE , 0xE0 , 0x00 , 0xFE , 0xE0 , 0x00 , 0xFE , 0xE0 , 0x00 
, 0xFE , 0xC0 , 0x00 , 0xFE , 0x00 , 0x00 , 0xFE , 0x00 , 0x01 , 0xFF , 0x00 
, 0x00 , 0xFE , 0x00 , 0x00 , 0x00 , 0x00 ,

24, 24, 0x00 , 0x60 , 0x00 , 0x00 , 0xF0 , 0x00 , 0x01 , 0xF8 , 0x0C , 0x03 , 0xF8 
, 0x1E , 0x07 , 0xF8 , 0x3E , 0x0F , 0xF8 , 0x7C , 0x07 , 0xFA , 0xF8 , 0x0F 
, 0xFB , 0xF0 , 0x05 , 0xFF , 0xE0 , 0x03 , 0xFF , 0xC0 , 0x07 , 0xFF , 0xE0 
, 0x07 , 0xFF , 0x40 , 0x03 , 0xFE , 0x00 , 0x03 , 0xFC , 0x00 , 0x03 , 0xFC 
, 0x00 , 0x03 , 0xFC , 0x00 , 0x03 , 0xFC , 0x00 , 0x03 , 0xFC , 0x00 , 0x03 
, 0xFC , 0x00 , 0x03 , 0xDC , 0x00 , 0x03 , 0xDC , 0x00 , 0x03 , 0xDE , 0x00 
, 0x01 , 0xDC , 0x00 , 0x00 , 0x00 , 0x00

};


PutPiece (int x, int y, int piece,int b_w)
{
  putsprite(spr_and,7+21*x+10*y,15+10*y,pieces+888+piece*74);
  putsprite(spr_or,7+21*x+10*y,15+10*y,pieces+444*b_w+piece*74);
}


DrawBoard()
{

  int     x,y,z,a,b;

  clg();

  for (x=1 ; x!=82; x++)
  {
    draw(x,x+30,x+170,x+30);
  }

  for (x=0 ; x!=8; x++)
  {
    for (y=0 ; y!=8; y++)
    {
      if (!((x+y) & 1))
      {
	  for (z=0 ; z!=9; z++)
	  {
	    a=3+21*x+10*y+z;
	    b=32+10*y+z;

	    undraw(a,b,a+20,b);
	  }
      }
    }
  }
}


