/* telepathy-observer.c generated by valac 0.16.0, the Vala compiler
 * generated from telepathy-observer.vala, do not modify */

/*
 * Zeitgeist
 *
 * Copyright (C) 2012 Collabora Ltd.
 *               Authored by: Seif Lotfy <seif.lotfy@collabora.co.uk>
 * Copyright (C) 2012 Eslam Mostafa <cseslam@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <telepathy-glib/telepathy-glib.h>
#include <zeitgeist.h>
#include <float.h>
#include <math.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>


#define TYPE_DATA_PROVIDER (data_provider_get_type ())
#define DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_PROVIDER, DataProvider))
#define DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_PROVIDER, DataProviderClass))
#define IS_DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_PROVIDER))
#define IS_DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_PROVIDER))
#define DATA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_PROVIDER, DataProviderClass))

typedef struct _DataProvider DataProvider;
typedef struct _DataProviderClass DataProviderClass;
typedef struct _DataProviderPrivate DataProviderPrivate;

#define TYPE_DATA_HUB (data_hub_get_type ())
#define DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_HUB, DataHub))
#define DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_HUB, DataHubClass))
#define IS_DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_HUB))
#define IS_DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_HUB))
#define DATA_HUB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_HUB, DataHubClass))

typedef struct _DataHub DataHub;
typedef struct _DataHubClass DataHubClass;

#define TYPE_TELEPATHY_OBSERVER (telepathy_observer_get_type ())
#define TELEPATHY_OBSERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TELEPATHY_OBSERVER, TelepathyObserver))
#define TELEPATHY_OBSERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TELEPATHY_OBSERVER, TelepathyObserverClass))
#define IS_TELEPATHY_OBSERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TELEPATHY_OBSERVER))
#define IS_TELEPATHY_OBSERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TELEPATHY_OBSERVER))
#define TELEPATHY_OBSERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TELEPATHY_OBSERVER, TelepathyObserverClass))

typedef struct _TelepathyObserver TelepathyObserver;
typedef struct _TelepathyObserverClass TelepathyObserverClass;
typedef struct _TelepathyObserverPrivate TelepathyObserverPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block4Data Block4Data;
#define __vala_TpCallStateReason_free0(var) ((var == NULL) ? NULL : (var = (_vala_TpCallStateReason_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define __vala_JsonObject_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonObject_free (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
typedef struct _TelepathyObserverHandleFtchannelChangeData TelepathyObserverHandleFtchannelChangeData;
typedef struct _Block5Data Block5Data;

struct _DataProvider {
	GObject parent_instance;
	DataProviderPrivate * priv;
};

struct _DataProviderClass {
	GObjectClass parent_class;
	void (*start) (DataProvider* self);
	void (*stop) (DataProvider* self);
	const gchar* (*get_unique_id) (DataProvider* self);
	void (*set_unique_id) (DataProvider* self, const gchar* value);
	const gchar* (*get_name) (DataProvider* self);
	void (*set_name) (DataProvider* self, const gchar* value);
	const gchar* (*get_description) (DataProvider* self);
	void (*set_description) (DataProvider* self, const gchar* value);
	DataHub* (*get_datahub) (DataProvider* self);
	void (*set_datahub) (DataProvider* self, DataHub* value);
	gboolean (*get_enabled) (DataProvider* self);
	void (*set_enabled) (DataProvider* self, gboolean value);
	gboolean (*get_register) (DataProvider* self);
	void (*set_register) (DataProvider* self, gboolean value);
};

struct _TelepathyObserver {
	DataProvider parent_instance;
	TelepathyObserverPrivate * priv;
};

struct _TelepathyObserverClass {
	DataProviderClass parent_class;
};

struct _TelepathyObserverPrivate {
	TpDBusDaemon* dbus;
	TpAutomaticClientFactory* factory;
	TpSimpleObserver* observer;
	GHashTable* call_timers;
	gchar* _unique_id;
	gchar* _name;
	gchar* _description;
	DataHub* _datahub;
	gboolean _enabled;
	gboolean _register;
};

struct _Block2Data {
	int _ref_count_;
	TelepathyObserver * self;
	TpTextChannel* channel;
	TpAccount* account;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	ZeitgeistEvent* event_template;
};

struct _Block4Data {
	int _ref_count_;
	TelepathyObserver * self;
	TpCallChannel* channel;
	TpAccount* account;
};

struct _TelepathyObserverHandleFtchannelChangeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TelepathyObserver* self;
	TpSimpleObserver* observer;
	TpAccount* account;
	TpConnection* connection;
	TpFileTransferChannel* channel;
	TpChannelDispatchOperation* dispatch_operation;
	GList* requests;
	TpObserveChannelsContext* context;
	gboolean _tmp0_;
	TpFileTransferChannel* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	TpFileTransferChannel* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	gboolean _tmp7_;
	TpFileTransferChannel* _tmp8_;
	TpContact* _tmp9_;
	TpContact* _tmp10_;
	TpContact* target;
	gchar* _tmp11_;
	gchar* attr;
	TpFileTransferChannel* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	const gchar* _tmp16_;
	GFileInfo* _tmp17_;
	GFileInfo* _tmp18_;
	GFileInfo* info;
	TpAccount* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* obj_path;
	const gchar* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	const gchar* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	ZeitgeistEvent* _tmp31_;
	ZeitgeistEvent* _tmp32_;
	ZeitgeistEvent* event_template;
	TpFileTransferChannel* _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	ZeitgeistEvent* _tmp36_;
	ZeitgeistEvent* _tmp37_;
	ZeitgeistEvent* _tmp38_;
	ZeitgeistEvent* _tmp39_;
	ZeitgeistEvent* _tmp40_;
	ZeitgeistSubject* _tmp41_;
	ZeitgeistSubject* _tmp42_;
	ZeitgeistSubject* subj;
	ZeitgeistSubject* _tmp43_;
	TpFileTransferChannel* _tmp44_;
	GFile* _tmp45_;
	GFile* _tmp46_;
	GFile* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	ZeitgeistSubject* _tmp50_;
	GFileInfo* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	ZeitgeistSubject* _tmp54_;
	ZeitgeistSubject* _tmp55_;
	GFileInfo* _tmp56_;
	const gchar* _tmp57_;
	ZeitgeistSubject* _tmp58_;
	GFileInfo* _tmp59_;
	const gchar* _tmp60_;
	TpFileTransferChannel* _tmp61_;
	gboolean _tmp62_;
	gboolean _tmp63_;
	TpFileTransferChannel* _tmp64_;
	GFile* _tmp65_;
	GFile* _tmp66_;
	GFile* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar** _tmp70_;
	gchar** _tmp71_;
	gchar** _tmp72_;
	gint _tmp72__length1;
	gchar** split_uri;
	gint split_uri_length1;
	gint _split_uri_size_;
	gchar** _tmp73_;
	gint _tmp73__length1;
	gchar** _tmp74_;
	gint _tmp74__length1;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* uri;
	ZeitgeistSubject* _tmp79_;
	const gchar* _tmp80_;
	ZeitgeistSubject* _tmp81_;
	TpContact* _tmp82_;
	const gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	ZeitgeistEvent* _tmp86_;
	ZeitgeistSubject* _tmp87_;
	ZeitgeistEvent* _tmp88_;
	TpContact* _tmp89_;
	const gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	const gchar* _tmp93_;
	TpContact* _tmp94_;
	const gchar* _tmp95_;
	ZeitgeistSubject* _tmp96_;
	ZeitgeistSubject* _tmp97_;
	JsonGenerator* _tmp98_;
	JsonGenerator* gen;
	JsonNode* _tmp99_;
	JsonNode* root;
	JsonObject* _tmp100_;
	JsonObject* object;
	JsonNode* _tmp101_;
	JsonObject* _tmp102_;
	JsonGenerator* _tmp103_;
	JsonNode* _tmp104_;
	JsonGenerator* _tmp105_;
	JsonObject* _tmp106_;
	JsonObject* details_obj;
	TpFileTransferStateChangeReason reason;
	TpFileTransferChannel* _tmp107_;
	TpFileTransferStateChangeReason _tmp108_;
	TpFileTransferState _tmp109_;
	TpFileTransferState state;
	JsonObject* _tmp110_;
	TpFileTransferState _tmp111_;
	JsonObject* _tmp112_;
	TpFileTransferStateChangeReason _tmp113_;
	JsonObject* _tmp114_;
	TpFileTransferChannel* _tmp115_;
	gboolean _tmp116_;
	gboolean _tmp117_;
	JsonObject* _tmp118_;
	TpFileTransferChannel* _tmp119_;
	const gchar* _tmp120_;
	JsonObject* _tmp121_;
	TpFileTransferChannel* _tmp122_;
	guint64 _tmp123_;
	JsonObject* _tmp124_;
	TpFileTransferChannel* _tmp125_;
	const gchar* _tmp126_;
	gsize length;
	JsonObject* _tmp127_;
	JsonObject* _tmp128_;
	JsonObject* _tmp129_;
	JsonGenerator* _tmp130_;
	gsize _tmp131_;
	gchar* _tmp132_;
	gchar* payload_string;
	ZeitgeistEvent* _tmp133_;
	const gchar* _tmp134_;
	guint8* _tmp135_;
	gint _tmp135__length1;
	guint8* _tmp136_;
	gint _tmp136__length1;
	guint8* _tmp137_;
	gint _tmp137__length1;
	GByteArray* _tmp138_;
	ZeitgeistEvent* _tmp139_;
	GError * _inner_error_;
};

struct _Block5Data {
	int _ref_count_;
	TelepathyObserver * self;
	TpFileTransferChannel* channel;
	TpSimpleObserver* observer;
	TpAccount* account;
	TpConnection* connection;
	TpChannelDispatchOperation* dispatch_operation;
	GList* requests;
	TpObserveChannelsContext* context;
};


static gpointer telepathy_observer_parent_class = NULL;

GType data_provider_get_type (void) G_GNUC_CONST;
GType data_hub_get_type (void) G_GNUC_CONST;
GType telepathy_observer_get_type (void) G_GNUC_CONST;
#define TELEPATHY_OBSERVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TELEPATHY_OBSERVER, TelepathyObserverPrivate))
enum  {
	TELEPATHY_OBSERVER_DUMMY_PROPERTY,
	TELEPATHY_OBSERVER_UNIQUE_ID,
	TELEPATHY_OBSERVER_NAME,
	TELEPATHY_OBSERVER_DESCRIPTION,
	TELEPATHY_OBSERVER_DATAHUB,
	TELEPATHY_OBSERVER_ENABLED,
	TELEPATHY_OBSERVER_REGISTER
};
#define TELEPATHY_OBSERVER_actor "dbus://org.freedesktop.Telepathy.Logger.service"
#define TELEPATHY_OBSERVER_tp_account_path "x-telepathy-account-path:%s"
#define TELEPATHY_OBSERVER_tp_identifier "x-telepathy-identifier:%s"
#define TELEPATHY_OBSERVER_ft_json_domain "http://zeitgeist-project.com/1.0/telepathy/filetransfer"
#define TELEPATHY_OBSERVER_call_json_domain "http://zeitgeist-project.com/1.0/telepathy/call"
TelepathyObserver* telepathy_observer_new (DataHub* datahub, GError** error);
TelepathyObserver* telepathy_observer_construct (GType object_type, DataHub* datahub, GError** error);
static void telepathy_observer_push_event (TelepathyObserver* self, ZeitgeistEvent* event);
static void _g_object_unref0_ (gpointer var);
static ZeitgeistEvent* telepathy_observer_create_text_event (TelepathyObserver* self, TpAccount* account, TpChannel* channel);
static void telepathy_observer_observe_text_channel (TelepathyObserver* self, TpSimpleObserver* observer, TpAccount* account, TpConnection* connection, TpChannel* b_channel, TpChannelDispatchOperation* dispatch_operation, GList* requests, TpObserveChannelsContext* context);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda3_ (Block3Data* _data3_);
static void ____lambda3__tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self);
static void ___lambda4_ (Block3Data* _data3_);
static void ____lambda4__tp_text_channel_message_received (TpTextChannel* _sender, TpSignalledMessage* message, gpointer self);
static void ___lambda5_ (Block3Data* _data3_);
static void ____lambda5__tp_text_channel_message_sent (TpTextChannel* _sender, TpSignalledMessage* message, guint flags, const gchar* token, gpointer self);
static ZeitgeistEvent* telepathy_observer_create_call_event (TelepathyObserver* self, TpAccount* account, TpCallChannel* channel);
static void telepathy_observer_observe_call_channel (TelepathyObserver* self, TpSimpleObserver* observer, TpAccount* account, TpConnection* connection, TpChannel* b_channel, TpChannelDispatchOperation* dispatch_operation, GList* requests, TpObserveChannelsContext* context);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda6_ (Block4Data* _data4_);
static void _vala_TpCallStateReason_free (TpCallStateReason* self);
static TpCallStateReason* _vala_TpCallStateReason_copy (TpCallStateReason* self);
static JsonObject* _vala_JsonObject_copy (JsonObject* self);
static guint8* _vala_array_dup2 (guint8* self, int length);
static void _vala_JsonObject_free (JsonObject* self);
static void _vala_JsonNode_free (JsonNode* self);
static void ___lambda6__tp_call_channel_state_changed (TpCallChannel* _sender, guint state, guint flags, TpCallStateReason* reason, GHashTable* details, gpointer self);
static void telepathy_observer_handle_ftchannel_change_data_free (gpointer _data);
static void telepathy_observer_handle_ftchannel_change (TelepathyObserver* self, TpSimpleObserver* observer, TpAccount* account, TpConnection* connection, TpFileTransferChannel* channel, TpChannelDispatchOperation* dispatch_operation, GList* requests, TpObserveChannelsContext* context, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void telepathy_observer_handle_ftchannel_change_finish (TelepathyObserver* self, GAsyncResult* _res_);
static gboolean telepathy_observer_handle_ftchannel_change_co (TelepathyObserverHandleFtchannelChangeData* _data_);
static void telepathy_observer_handle_ftchannel_change_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static guint8* _vala_array_dup3 (guint8* self, int length);
static void telepathy_observer_observe_ft_channel (TelepathyObserver* self, TpSimpleObserver* observer, TpAccount* account, TpConnection* connection, TpChannel* b_channel, TpChannelDispatchOperation* dispatch_operation, GList* requests, TpObserveChannelsContext* context);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda7_ (Block5Data* _data5_);
static void ___lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void telepathy_observer_observe_channels (TelepathyObserver* self, TpSimpleObserver* observer, TpAccount* account, TpConnection* connection, GList* channels, TpChannelDispatchOperation* dispatch_operation, GList* requests, TpObserveChannelsContext* context);
static void telepathy_observer_real_start (DataProvider* base);
static void _telepathy_observer_observe_channels_tp_simple_observer_observe_channels_impl (TpSimpleObserver* observer, TpAccount* account, TpConnection* connection, GList* channels, TpChannelDispatchOperation* dispatch_operation, GList* requests, TpObserveChannelsContext* context, gpointer self);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static void telepathy_observer_real_stop (DataProvider* base);
static GObject * telepathy_observer_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _g_timer_destroy0_ (gpointer var);
static void telepathy_observer_finalize (GObject* obj);
const gchar* data_provider_get_unique_id (DataProvider* self);
const gchar* data_provider_get_name (DataProvider* self);
const gchar* data_provider_get_description (DataProvider* self);
DataHub* data_provider_get_datahub (DataProvider* self);
gboolean data_provider_get_enabled (DataProvider* self);
gboolean data_provider_get_register (DataProvider* self);
static void _vala_telepathy_observer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void data_provider_set_unique_id (DataProvider* self, const gchar* value);
void data_provider_set_name (DataProvider* self, const gchar* value);
void data_provider_set_description (DataProvider* self, const gchar* value);
void data_provider_set_datahub (DataProvider* self, DataHub* value);
void data_provider_set_enabled (DataProvider* self, gboolean value);
void data_provider_set_register (DataProvider* self, gboolean value);
static void _vala_telepathy_observer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


TelepathyObserver* telepathy_observer_construct (GType object_type, DataHub* datahub, GError** error) {
	TelepathyObserver * self = NULL;
	DataHub* _tmp0_;
	g_return_val_if_fail (datahub != NULL, NULL);
	_tmp0_ = datahub;
	self = (TelepathyObserver*) g_object_new (object_type, "unique-id", "com.zeitgeist-project,datahub,telepathy-observer", "name", "Telepathy Observer", "description", "Logs IM, call and filetransfer from telepathy", "datahub", _tmp0_, NULL);
	return self;
}


TelepathyObserver* telepathy_observer_new (DataHub* datahub, GError** error) {
	return telepathy_observer_construct (TYPE_TELEPATHY_OBSERVER, datahub, error);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void telepathy_observer_push_event (TelepathyObserver* self, ZeitgeistEvent* event) {
	GPtrArray* _tmp0_;
	GPtrArray* events;
	ZeitgeistEvent* _tmp1_;
	ZeitgeistEvent* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	events = _tmp0_;
	_tmp1_ = event;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	g_ptr_array_add (events, _tmp2_);
	g_signal_emit_by_name ((DataProvider*) self, "items-available", events);
	_g_ptr_array_unref0 (events);
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static ZeitgeistEvent* telepathy_observer_create_text_event (TelepathyObserver* self, TpAccount* account, TpChannel* channel) {
	ZeitgeistEvent* result = NULL;
	TpChannel* _tmp0_;
	TpContact* _tmp1_ = NULL;
	TpContact* _tmp2_;
	TpContact* target;
	TpAccount* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* obj_path;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_;
	ZeitgeistEvent* _tmp16_;
	ZeitgeistEvent* _tmp17_;
	ZeitgeistEvent* event_template;
	TpChannel* _tmp18_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_;
	ZeitgeistEvent* _tmp23_;
	TpContact* _tmp24_;
	const gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	ZeitgeistSubject* _tmp28_;
	ZeitgeistSubject* _tmp29_;
	ZeitgeistEvent* _tmp30_;
	TpContact* _tmp31_;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	TpContact* _tmp36_;
	const gchar* _tmp37_ = NULL;
	ZeitgeistSubject* _tmp38_;
	ZeitgeistSubject* _tmp39_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (channel != NULL, NULL);
	_tmp0_ = channel;
	_tmp1_ = tp_channel_get_target_contact (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	target = _tmp2_;
	_tmp3_ = account;
	_tmp4_ = tp_proxy_get_object_path ((TpProxy*) _tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	obj_path = _tmp5_;
	_tmp6_ = obj_path;
	_tmp7_ = strlen (TP_ACCOUNT_OBJECT_PATH_BASE);
	_tmp8_ = _tmp7_;
	_tmp9_ = obj_path;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = string_slice (_tmp6_, (glong) _tmp8_, (glong) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strdup_printf (TELEPATHY_OBSERVER_tp_account_path, _tmp13_);
	_g_free0 (obj_path);
	obj_path = _tmp14_;
	_g_free0 (_tmp13_);
	_tmp15_ = obj_path;
	_tmp16_ = zeitgeist_event_new_full (ZEITGEIST_ZG_ACCESS_EVENT, "", TELEPATHY_OBSERVER_actor, NULL, _tmp15_, NULL);
	_tmp17_ = g_object_ref_sink (_tmp16_);
	event_template = _tmp17_;
	_tmp18_ = channel;
	g_object_get (_tmp18_, "requested", &_tmp19_, NULL);
	_tmp20_ = _tmp19_;
	if (!_tmp20_) {
		ZeitgeistEvent* _tmp21_;
		_tmp21_ = event_template;
		zeitgeist_event_set_manifestation (_tmp21_, ZEITGEIST_ZG_WORLD_ACTIVITY);
	} else {
		ZeitgeistEvent* _tmp22_;
		_tmp22_ = event_template;
		zeitgeist_event_set_manifestation (_tmp22_, ZEITGEIST_ZG_USER_ACTIVITY);
	}
	_tmp23_ = event_template;
	_tmp24_ = target;
	_tmp25_ = tp_contact_get_identifier (_tmp24_);
	_tmp26_ = g_strdup_printf (TELEPATHY_OBSERVER_tp_identifier, _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = zeitgeist_subject_new_full ("", ZEITGEIST_NMO_IMMESSAGE, ZEITGEIST_NFO_SOFTWARE_SERVICE, "plain/text", _tmp27_, "", "net");
	_tmp29_ = g_object_ref_sink (_tmp28_);
	zeitgeist_event_add_subject (_tmp23_, _tmp29_);
	_g_object_unref0 (_tmp29_);
	_g_free0 (_tmp27_);
	_tmp30_ = event_template;
	_tmp31_ = target;
	_tmp32_ = tp_contact_get_identifier (_tmp31_);
	_tmp33_ = g_strdup_printf (TELEPATHY_OBSERVER_tp_identifier, _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = obj_path;
	_tmp36_ = target;
	_tmp37_ = tp_contact_get_alias (_tmp36_);
	_tmp38_ = zeitgeist_subject_new_full (_tmp34_, ZEITGEIST_NCO_CONTACT, ZEITGEIST_NCO_CONTACT_LIST_DATA_OBJECT, "", _tmp35_, _tmp37_, "net");
	_tmp39_ = g_object_ref_sink (_tmp38_);
	zeitgeist_event_add_subject (_tmp30_, _tmp39_);
	_g_object_unref0 (_tmp39_);
	_g_free0 (_tmp34_);
	result = event_template;
	_g_free0 (obj_path);
	_g_object_unref0 (target);
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		TelepathyObserver * self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->channel);
		_g_object_unref0 (_data2_->account);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		TelepathyObserver * self;
		self = _data3_->_data2_->self;
		_g_object_unref0 (_data3_->event_template);
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}


static void ___lambda3_ (Block3Data* _data3_) {
	Block2Data* _data2_;
	TelepathyObserver * self;
	TpAccount* _tmp0_;
	TpTextChannel* _tmp1_;
	ZeitgeistEvent* _tmp2_ = NULL;
	ZeitgeistEvent* _tmp3_;
	ZeitgeistEvent* _tmp4_;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	_tmp0_ = _data2_->account;
	_tmp1_ = _data2_->channel;
	_tmp2_ = telepathy_observer_create_text_event (self, _tmp0_, (TpChannel*) _tmp1_);
	_g_object_unref0 (_data3_->event_template);
	_data3_->event_template = _tmp2_;
	_tmp3_ = _data3_->event_template;
	zeitgeist_event_set_interpretation (_tmp3_, ZEITGEIST_ZG_LEAVE_EVENT);
	_tmp4_ = _data3_->event_template;
	telepathy_observer_push_event (self, _tmp4_);
}


static void ____lambda3__tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self) {
	___lambda3_ (self);
}


static void ___lambda4_ (Block3Data* _data3_) {
	Block2Data* _data2_;
	TelepathyObserver * self;
	TpAccount* _tmp0_;
	TpTextChannel* _tmp1_;
	ZeitgeistEvent* _tmp2_ = NULL;
	ZeitgeistEvent* _tmp3_;
	ZeitgeistEvent* _tmp4_;
	ZeitgeistEvent* _tmp5_;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	_tmp0_ = _data2_->account;
	_tmp1_ = _data2_->channel;
	_tmp2_ = telepathy_observer_create_text_event (self, _tmp0_, (TpChannel*) _tmp1_);
	_g_object_unref0 (_data3_->event_template);
	_data3_->event_template = _tmp2_;
	_tmp3_ = _data3_->event_template;
	zeitgeist_event_set_interpretation (_tmp3_, ZEITGEIST_ZG_RECEIVE_EVENT);
	_tmp4_ = _data3_->event_template;
	zeitgeist_event_set_manifestation (_tmp4_, ZEITGEIST_ZG_WORLD_ACTIVITY);
	_tmp5_ = _data3_->event_template;
	telepathy_observer_push_event (self, _tmp5_);
}


static void ____lambda4__tp_text_channel_message_received (TpTextChannel* _sender, TpSignalledMessage* message, gpointer self) {
	___lambda4_ (self);
}


static void ___lambda5_ (Block3Data* _data3_) {
	Block2Data* _data2_;
	TelepathyObserver * self;
	TpAccount* _tmp0_;
	TpTextChannel* _tmp1_;
	ZeitgeistEvent* _tmp2_ = NULL;
	ZeitgeistEvent* _tmp3_;
	ZeitgeistEvent* _tmp4_;
	ZeitgeistEvent* _tmp5_;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	_tmp0_ = _data2_->account;
	_tmp1_ = _data2_->channel;
	_tmp2_ = telepathy_observer_create_text_event (self, _tmp0_, (TpChannel*) _tmp1_);
	_g_object_unref0 (_data3_->event_template);
	_data3_->event_template = _tmp2_;
	_tmp3_ = _data3_->event_template;
	zeitgeist_event_set_interpretation (_tmp3_, ZEITGEIST_ZG_SEND_EVENT);
	_tmp4_ = _data3_->event_template;
	zeitgeist_event_set_manifestation (_tmp4_, ZEITGEIST_ZG_USER_ACTIVITY);
	_tmp5_ = _data3_->event_template;
	telepathy_observer_push_event (self, _tmp5_);
}


static void ____lambda5__tp_text_channel_message_sent (TpTextChannel* _sender, TpSignalledMessage* message, guint flags, const gchar* token, gpointer self) {
	___lambda5_ (self);
}


static void telepathy_observer_observe_text_channel (TelepathyObserver* self, TpSimpleObserver* observer, TpAccount* account, TpConnection* connection, TpChannel* b_channel, TpChannelDispatchOperation* dispatch_operation, GList* requests, TpObserveChannelsContext* context) {
	Block2Data* _data2_;
	TpAccount* _tmp0_;
	TpAccount* _tmp1_;
	TpChannel* _tmp2_;
	TpTextChannel* _tmp3_;
	TpTextChannel* _tmp4_;
	TpContact* _tmp5_ = NULL;
	TpContact* _tmp6_;
	TpContact* target;
	TpContact* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (observer != NULL);
	g_return_if_fail (account != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (b_channel != NULL);
	g_return_if_fail (context != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data2_->account = _tmp1_;
	_tmp2_ = b_channel;
	_tmp3_ = _g_object_ref0 (TP_TEXT_CHANNEL (_tmp2_));
	_data2_->channel = _tmp3_;
	_tmp4_ = _data2_->channel;
	_tmp5_ = tp_channel_get_target_contact ((TpChannel*) _tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	target = _tmp6_;
	_tmp7_ = target;
	if (_tmp7_ != NULL) {
		Block3Data* _data3_;
		TpAccount* _tmp8_;
		TpTextChannel* _tmp9_;
		ZeitgeistEvent* _tmp10_ = NULL;
		ZeitgeistEvent* _tmp11_;
		TpTextChannel* _tmp12_;
		GList* _tmp13_ = NULL;
		TpTextChannel* _tmp22_;
		TpTextChannel* _tmp23_;
		TpTextChannel* _tmp24_;
		_data3_ = g_slice_new0 (Block3Data);
		_data3_->_ref_count_ = 1;
		_data3_->_data2_ = block2_data_ref (_data2_);
		_tmp8_ = _data2_->account;
		_tmp9_ = _data2_->channel;
		_tmp10_ = telepathy_observer_create_text_event (self, _tmp8_, (TpChannel*) _tmp9_);
		_data3_->event_template = _tmp10_;
		_tmp11_ = _data3_->event_template;
		telepathy_observer_push_event (self, _tmp11_);
		_tmp12_ = _data2_->channel;
		_tmp13_ = tp_text_channel_get_pending_messages (_tmp12_);
		{
			GList* message_collection = NULL;
			GList* message_it = NULL;
			message_collection = _tmp13_;
			for (message_it = message_collection; message_it != NULL; message_it = message_it->next) {
				TpSignalledMessage* message = NULL;
				message = (TpSignalledMessage*) message_it->data;
				{
					TpSignalledMessage* _tmp14_;
					gboolean _tmp15_ = FALSE;
					_tmp14_ = message;
					_tmp15_ = tp_message_is_delivery_report ((TpMessage*) _tmp14_);
					if (!_tmp15_) {
						TpAccount* _tmp16_;
						TpTextChannel* _tmp17_;
						ZeitgeistEvent* _tmp18_ = NULL;
						ZeitgeistEvent* _tmp19_;
						ZeitgeistEvent* _tmp20_;
						ZeitgeistEvent* _tmp21_;
						_tmp16_ = _data2_->account;
						_tmp17_ = _data2_->channel;
						_tmp18_ = telepathy_observer_create_text_event (self, _tmp16_, (TpChannel*) _tmp17_);
						_g_object_unref0 (_data3_->event_template);
						_data3_->event_template = _tmp18_;
						_tmp19_ = _data3_->event_template;
						zeitgeist_event_set_interpretation (_tmp19_, ZEITGEIST_ZG_RECEIVE_EVENT);
						_tmp20_ = _data3_->event_template;
						zeitgeist_event_set_manifestation (_tmp20_, ZEITGEIST_ZG_WORLD_ACTIVITY);
						_tmp21_ = _data3_->event_template;
						telepathy_observer_push_event (self, _tmp21_);
					}
				}
			}
			_g_list_free0 (message_collection);
		}
		_tmp22_ = _data2_->channel;
		g_signal_connect_data ((TpProxy*) _tmp22_, "invalidated", (GCallback) ____lambda3__tp_proxy_invalidated, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
		_tmp23_ = _data2_->channel;
		g_signal_connect_data (_tmp23_, "message-received", (GCallback) ____lambda4__tp_text_channel_message_received, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
		_tmp24_ = _data2_->channel;
		g_signal_connect_data (_tmp24_, "message-sent", (GCallback) ____lambda5__tp_text_channel_message_sent, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
		block3_data_unref (_data3_);
		_data3_ = NULL;
	}
	_g_object_unref0 (target);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static ZeitgeistEvent* telepathy_observer_create_call_event (TelepathyObserver* self, TpAccount* account, TpCallChannel* channel) {
	ZeitgeistEvent* result = NULL;
	TpCallChannel* _tmp0_;
	GHashTable* _tmp1_ = NULL;
	GHashTable* _tmp2_;
	GHashTable* targets;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GList* _tmp5_ = NULL;
	GList* _tmp6_;
	gconstpointer _tmp7_;
	TpContact* _tmp8_;
	TpContact* target;
	TpAccount* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* obj_path;
	const gchar* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	const gchar* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	gchar* _tmp20_ = NULL;
	const gchar* _tmp21_;
	ZeitgeistEvent* _tmp22_;
	ZeitgeistEvent* _tmp23_;
	ZeitgeistEvent* event_template;
	TpCallChannel* _tmp24_;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_;
	ZeitgeistEvent* _tmp28_;
	TpContact* _tmp29_;
	const gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_;
	TpContact* _tmp33_;
	const gchar* _tmp34_ = NULL;
	ZeitgeistSubject* _tmp35_;
	ZeitgeistSubject* _tmp36_;
	ZeitgeistEvent* _tmp37_;
	TpContact* _tmp38_;
	const gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_;
	const gchar* _tmp42_;
	TpContact* _tmp43_;
	const gchar* _tmp44_ = NULL;
	ZeitgeistSubject* _tmp45_;
	ZeitgeistSubject* _tmp46_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (channel != NULL, NULL);
	_tmp0_ = channel;
	_tmp1_ = tp_call_channel_get_members (_tmp0_);
	_tmp2_ = _g_hash_table_ref0 (_tmp1_);
	targets = _tmp2_;
	_tmp3_ = targets;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_hash_table_unref0 (targets);
		return result;
	}
	_tmp4_ = targets;
	_tmp5_ = g_hash_table_get_keys (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->data;
	_tmp8_ = (TpContact*) _tmp7_;
	_g_list_free0 (_tmp6_);
	target = _tmp8_;
	_tmp9_ = account;
	_tmp10_ = tp_proxy_get_object_path ((TpProxy*) _tmp9_);
	_tmp11_ = g_strdup (_tmp10_);
	obj_path = _tmp11_;
	_tmp12_ = obj_path;
	_tmp13_ = strlen (TP_ACCOUNT_OBJECT_PATH_BASE);
	_tmp14_ = _tmp13_;
	_tmp15_ = obj_path;
	_tmp16_ = strlen (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = string_slice (_tmp12_, (glong) _tmp14_, (glong) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf (TELEPATHY_OBSERVER_tp_account_path, _tmp19_);
	_g_free0 (obj_path);
	obj_path = _tmp20_;
	_g_free0 (_tmp19_);
	_tmp21_ = obj_path;
	_tmp22_ = zeitgeist_event_new_full (ZEITGEIST_ZG_ACCESS_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, TELEPATHY_OBSERVER_actor, NULL, _tmp21_, NULL);
	_tmp23_ = g_object_ref_sink (_tmp22_);
	event_template = _tmp23_;
	_tmp24_ = channel;
	g_object_get ((TpChannel*) _tmp24_, "requested", &_tmp25_, NULL);
	_tmp26_ = _tmp25_;
	if (!_tmp26_) {
		ZeitgeistEvent* _tmp27_;
		_tmp27_ = event_template;
		zeitgeist_event_set_manifestation (_tmp27_, ZEITGEIST_ZG_WORLD_ACTIVITY);
	}
	_tmp28_ = event_template;
	_tmp29_ = target;
	_tmp30_ = tp_contact_get_identifier (_tmp29_);
	_tmp31_ = g_strdup_printf (TELEPATHY_OBSERVER_tp_identifier, _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = target;
	_tmp34_ = tp_contact_get_alias (_tmp33_);
	_tmp35_ = zeitgeist_subject_new_full ("", ZEITGEIST_NFO_AUDIO, ZEITGEIST_NFO_MEDIA_STREAM, "x-telepathy/call", _tmp32_, _tmp34_, "net");
	_tmp36_ = g_object_ref_sink (_tmp35_);
	zeitgeist_event_add_subject (_tmp28_, _tmp36_);
	_g_object_unref0 (_tmp36_);
	_g_free0 (_tmp32_);
	_tmp37_ = event_template;
	_tmp38_ = target;
	_tmp39_ = tp_contact_get_identifier (_tmp38_);
	_tmp40_ = g_strdup_printf (TELEPATHY_OBSERVER_tp_identifier, _tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = obj_path;
	_tmp43_ = target;
	_tmp44_ = tp_contact_get_alias (_tmp43_);
	_tmp45_ = zeitgeist_subject_new_full (_tmp41_, ZEITGEIST_NCO_CONTACT, ZEITGEIST_NCO_CONTACT_LIST_DATA_OBJECT, "", _tmp42_, _tmp44_, "net");
	_tmp46_ = g_object_ref_sink (_tmp45_);
	zeitgeist_event_add_subject (_tmp37_, _tmp46_);
	_g_object_unref0 (_tmp46_);
	_g_free0 (_tmp41_);
	result = event_template;
	_g_free0 (obj_path);
	_g_hash_table_unref0 (targets);
	return result;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		TelepathyObserver * self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->channel);
		_g_object_unref0 (_data4_->account);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void _vala_TpCallStateReason_free (TpCallStateReason* self) {
	g_boxed_free (tp_call_state_reason_get_type (), self);
}


static TpCallStateReason* _vala_TpCallStateReason_copy (TpCallStateReason* self) {
	return g_boxed_copy (tp_call_state_reason_get_type (), self);
}


static gpointer __vala_TpCallStateReason_copy0 (gpointer self) {
	return self ? _vala_TpCallStateReason_copy (self) : NULL;
}


static JsonObject* _vala_JsonObject_copy (JsonObject* self) {
	return g_boxed_copy (json_object_get_type (), self);
}


static gpointer __vala_JsonObject_copy0 (gpointer self) {
	return self ? _vala_JsonObject_copy (self) : NULL;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static guint8* _vala_array_dup2 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static void _vala_JsonObject_free (JsonObject* self) {
	g_boxed_free (json_object_get_type (), self);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static void __lambda6_ (Block4Data* _data4_) {
	TelepathyObserver * self;
	TpCallFlags flags = 0;
	TpCallStateReason* reason = NULL;
	TpCallFlags _tmp0_ = 0;
	TpCallStateReason* _tmp1_ = NULL;
	TpCallState _tmp2_ = 0;
	TpCallStateReason* _tmp3_;
	TpCallState state;
	TpAccount* _tmp4_;
	ZeitgeistEvent* _tmp5_ = NULL;
	ZeitgeistEvent* event_template;
	TpCallState _tmp6_;
	self = _data4_->self;
	_tmp2_ = tp_call_channel_get_state (_data4_->channel, &_tmp0_, NULL, &_tmp1_);
	flags = _tmp0_;
	__vala_TpCallStateReason_free0 (reason);
	_tmp3_ = __vala_TpCallStateReason_copy0 (_tmp1_);
	reason = _tmp3_;
	state = _tmp2_;
	_tmp4_ = _data4_->account;
	_tmp5_ = telepathy_observer_create_call_event (self, _tmp4_, _data4_->channel);
	event_template = _tmp5_;
	_tmp6_ = state;
	if (_tmp6_ == TP_CALL_STATE_INITIALISED) {
		ZeitgeistEvent* _tmp7_;
		GTimer* _tmp8_;
		GTimer* t;
		GTimer* _tmp9_;
		GHashTable* _tmp10_;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		GTimer* _tmp13_;
		ZeitgeistEvent* _tmp14_;
		_tmp7_ = event_template;
		zeitgeist_event_set_interpretation (_tmp7_, ZEITGEIST_ZG_CREATE_EVENT);
		_tmp8_ = g_timer_new ();
		t = _tmp8_;
		_tmp9_ = t;
		g_timer_stop (_tmp9_);
		_tmp10_ = self->priv->call_timers;
		_tmp11_ = tp_proxy_get_object_path ((TpProxy*) _data4_->channel);
		_tmp12_ = g_strdup (_tmp11_);
		_tmp13_ = t;
		t = NULL;
		g_hash_table_insert (_tmp10_, _tmp12_, _tmp13_);
		_tmp14_ = event_template;
		telepathy_observer_push_event (self, _tmp14_);
		_g_timer_destroy0 (t);
	} else {
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		TpCallState _tmp17_;
		gboolean _tmp19_;
		gboolean _tmp23_;
		_tmp17_ = state;
		if (_tmp17_ == TP_CALL_STATE_ACTIVE) {
			_tmp16_ = TRUE;
		} else {
			TpCallState _tmp18_;
			_tmp18_ = state;
			_tmp16_ = _tmp18_ == TP_CALL_STATE_ENDED;
		}
		_tmp19_ = _tmp16_;
		if (_tmp19_) {
			GHashTable* _tmp20_;
			const gchar* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
			_tmp20_ = self->priv->call_timers;
			_tmp21_ = tp_proxy_get_object_path ((TpProxy*) _data4_->channel);
			_tmp22_ = g_hash_table_contains (_tmp20_, _tmp21_);
			_tmp15_ = _tmp22_;
		} else {
			_tmp15_ = FALSE;
		}
		_tmp23_ = _tmp15_;
		if (_tmp23_) {
			TpCallState _tmp24_;
			_tmp24_ = state;
			if (_tmp24_ == TP_CALL_STATE_ACTIVE) {
				ZeitgeistEvent* _tmp25_;
				GHashTable* _tmp26_;
				const gchar* _tmp27_ = NULL;
				gconstpointer _tmp28_ = NULL;
				ZeitgeistEvent* _tmp29_;
				_tmp25_ = event_template;
				zeitgeist_event_set_interpretation (_tmp25_, ZEITGEIST_ZG_ACCESS_EVENT);
				_tmp26_ = self->priv->call_timers;
				_tmp27_ = tp_proxy_get_object_path ((TpProxy*) _data4_->channel);
				_tmp28_ = g_hash_table_lookup (_tmp26_, _tmp27_);
				g_timer_start ((GTimer*) _tmp28_);
				_tmp29_ = event_template;
				telepathy_observer_push_event (self, _tmp29_);
			} else {
				TpCallState _tmp30_;
				_tmp30_ = state;
				if (_tmp30_ == TP_CALL_STATE_ENDED) {
					ZeitgeistEvent* _tmp31_;
					gboolean _tmp32_ = FALSE;
					TpCallStateReason* _tmp33_;
					TpCallStateChangeReason _tmp34_;
					gboolean _tmp37_;
					GHashTable* _tmp46_;
					const gchar* _tmp47_ = NULL;
					gconstpointer _tmp48_ = NULL;
					gdouble _tmp49_ = 0.0;
					gdouble duration;
					GHashTable* _tmp50_;
					const gchar* _tmp51_ = NULL;
					gconstpointer _tmp52_ = NULL;
					GHashTable* _tmp53_;
					const gchar* _tmp54_ = NULL;
					JsonGenerator* _tmp55_;
					JsonGenerator* gen;
					JsonNode* _tmp56_;
					JsonNode* root;
					JsonObject* _tmp57_;
					JsonObject* object;
					JsonNode* _tmp58_;
					JsonObject* _tmp59_;
					JsonGenerator* _tmp60_;
					JsonNode* _tmp61_;
					JsonGenerator* _tmp62_;
					JsonObject* _tmp63_;
					JsonObject* details_obj;
					JsonObject* _tmp64_;
					TpCallState _tmp65_;
					JsonObject* _tmp66_;
					TpCallStateReason* _tmp67_;
					TpCallStateChangeReason _tmp68_;
					JsonObject* _tmp69_;
					gboolean _tmp70_ = FALSE;
					gboolean _tmp71_;
					JsonObject* _tmp72_;
					gdouble _tmp73_;
					gsize length = 0UL;
					JsonObject* _tmp74_;
					JsonObject* _tmp75_;
					JsonObject* _tmp76_;
					JsonGenerator* _tmp77_;
					gsize _tmp78_ = 0UL;
					gchar* _tmp79_ = NULL;
					gchar* payload_string;
					ZeitgeistEvent* _tmp80_;
					const gchar* _tmp81_;
					guint8* _tmp82_;
					gint _tmp82__length1;
					guint8* _tmp83_;
					gint _tmp83__length1;
					guint8* _tmp84_;
					gint _tmp84__length1;
					GByteArray* _tmp85_;
					ZeitgeistEvent* _tmp86_;
					_tmp31_ = event_template;
					zeitgeist_event_set_interpretation (_tmp31_, ZEITGEIST_ZG_LEAVE_EVENT);
					_tmp33_ = reason;
					_tmp34_ = _tmp33_->reason;
					if (_tmp34_ == TP_CALL_STATE_CHANGE_REASON_REJECTED) {
						_tmp32_ = TRUE;
					} else {
						TpCallStateReason* _tmp35_;
						TpCallStateChangeReason _tmp36_;
						_tmp35_ = reason;
						_tmp36_ = _tmp35_->reason;
						_tmp32_ = _tmp36_ == TP_CALL_STATE_CHANGE_REASON_NO_ANSWER;
					}
					_tmp37_ = _tmp32_;
					if (_tmp37_) {
						gboolean _tmp38_ = FALSE;
						gboolean _tmp39_;
						TpCallStateReason* _tmp42_;
						TpCallStateChangeReason _tmp43_;
						g_object_get ((TpChannel*) _data4_->channel, "requested", &_tmp38_, NULL);
						_tmp39_ = _tmp38_;
						if (_tmp39_) {
							ZeitgeistEvent* _tmp40_;
							_tmp40_ = event_template;
							zeitgeist_event_set_manifestation (_tmp40_, ZEITGEIST_ZG_WORLD_ACTIVITY);
						} else {
							ZeitgeistEvent* _tmp41_;
							_tmp41_ = event_template;
							zeitgeist_event_set_interpretation (_tmp41_, ZEITGEIST_ZG_USER_ACTIVITY);
						}
						_tmp42_ = reason;
						_tmp43_ = _tmp42_->reason;
						if (_tmp43_ == TP_CALL_STATE_CHANGE_REASON_NO_ANSWER) {
							ZeitgeistEvent* _tmp44_;
							_tmp44_ = event_template;
							zeitgeist_event_set_interpretation (_tmp44_, ZEITGEIST_ZG_EXPIRE_EVENT);
						} else {
							ZeitgeistEvent* _tmp45_;
							_tmp45_ = event_template;
							zeitgeist_event_set_interpretation (_tmp45_, ZEITGEIST_ZG_DENY_EVENT);
						}
					}
					_tmp46_ = self->priv->call_timers;
					_tmp47_ = tp_proxy_get_object_path ((TpProxy*) _data4_->channel);
					_tmp48_ = g_hash_table_lookup (_tmp46_, _tmp47_);
					_tmp49_ = g_timer_elapsed ((GTimer*) _tmp48_, NULL);
					duration = _tmp49_;
					_tmp50_ = self->priv->call_timers;
					_tmp51_ = tp_proxy_get_object_path ((TpProxy*) _data4_->channel);
					_tmp52_ = g_hash_table_lookup (_tmp50_, _tmp51_);
					_tmp53_ = self->priv->call_timers;
					_tmp54_ = tp_proxy_get_object_path ((TpProxy*) _data4_->channel);
					g_hash_table_remove (_tmp53_, _tmp54_);
					_tmp55_ = json_generator_new ();
					gen = _tmp55_;
					_tmp56_ = json_node_new (JSON_NODE_OBJECT);
					root = _tmp56_;
					_tmp57_ = json_object_new ();
					object = _tmp57_;
					_tmp58_ = root;
					_tmp59_ = object;
					json_node_set_object (_tmp58_, _tmp59_);
					_tmp60_ = gen;
					_tmp61_ = root;
					json_generator_set_root (_tmp60_, _tmp61_);
					_tmp62_ = gen;
					json_generator_set_pretty (_tmp62_, TRUE);
					_tmp63_ = json_object_new ();
					details_obj = _tmp63_;
					_tmp64_ = details_obj;
					_tmp65_ = state;
					json_object_set_int_member (_tmp64_, "state", (gint64) _tmp65_);
					_tmp66_ = details_obj;
					_tmp67_ = reason;
					_tmp68_ = _tmp67_->reason;
					json_object_set_int_member (_tmp66_, "reason", (gint64) _tmp68_);
					_tmp69_ = details_obj;
					g_object_get ((TpChannel*) _data4_->channel, "requested", &_tmp70_, NULL);
					_tmp71_ = _tmp70_;
					json_object_set_boolean_member (_tmp69_, "requested", _tmp71_);
					_tmp72_ = details_obj;
					_tmp73_ = duration;
					json_object_set_double_member (_tmp72_, "duration", _tmp73_);
					_tmp74_ = object;
					_tmp75_ = details_obj;
					_tmp76_ = __vala_JsonObject_copy0 (_tmp75_);
					json_object_set_object_member (_tmp74_, TELEPATHY_OBSERVER_call_json_domain, _tmp76_);
					_tmp77_ = gen;
					_tmp79_ = json_generator_to_data (_tmp77_, &_tmp78_);
					length = _tmp78_;
					payload_string = _tmp79_;
					_tmp80_ = event_template;
					_tmp81_ = payload_string;
					_tmp82_ = string_get_data (_tmp81_, &_tmp82__length1);
					_tmp83_ = _tmp82_;
					_tmp83__length1 = _tmp82__length1;
					_tmp84_ = (_tmp83_ != NULL) ? _vala_array_dup2 (_tmp83_, _tmp83__length1) : ((gpointer) _tmp83_);
					_tmp84__length1 = _tmp83__length1;
					_tmp85_ = g_byte_array_new_take (_tmp84_, _tmp84__length1);
					zeitgeist_event_set_payload (_tmp80_, _tmp85_);
					_tmp86_ = event_template;
					telepathy_observer_push_event (self, _tmp86_);
					_g_free0 (payload_string);
					__vala_JsonObject_free0 (details_obj);
					__vala_JsonObject_free0 (object);
					__vala_JsonNode_free0 (root);
					_g_object_unref0 (gen);
				}
			}
		}
	}
	_g_object_unref0 (event_template);
	__vala_TpCallStateReason_free0 (reason);
}


static void ___lambda6__tp_call_channel_state_changed (TpCallChannel* _sender, guint state, guint flags, TpCallStateReason* reason, GHashTable* details, gpointer self) {
	__lambda6_ (self);
}


static void telepathy_observer_observe_call_channel (TelepathyObserver* self, TpSimpleObserver* observer, TpAccount* account, TpConnection* connection, TpChannel* b_channel, TpChannelDispatchOperation* dispatch_operation, GList* requests, TpObserveChannelsContext* context) {
	Block4Data* _data4_;
	TpAccount* _tmp0_;
	TpAccount* _tmp1_;
	TpChannel* _tmp2_;
	TpCallChannel* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (observer != NULL);
	g_return_if_fail (account != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (b_channel != NULL);
	g_return_if_fail (context != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data4_->account = _tmp1_;
	_tmp2_ = b_channel;
	_tmp3_ = _g_object_ref0 (TP_CALL_CHANNEL (_tmp2_));
	_data4_->channel = _tmp3_;
	g_signal_connect_data (_data4_->channel, "state-changed", (GCallback) ___lambda6__tp_call_channel_state_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static void telepathy_observer_handle_ftchannel_change_data_free (gpointer _data) {
	TelepathyObserverHandleFtchannelChangeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->observer);
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->connection);
	_g_object_unref0 (_data_->channel);
	_g_object_unref0 (_data_->dispatch_operation);
	_g_object_unref0 (_data_->context);
	_g_object_unref0 (_data_->self);
	g_slice_free (TelepathyObserverHandleFtchannelChangeData, _data_);
}


static void telepathy_observer_handle_ftchannel_change (TelepathyObserver* self, TpSimpleObserver* observer, TpAccount* account, TpConnection* connection, TpFileTransferChannel* channel, TpChannelDispatchOperation* dispatch_operation, GList* requests, TpObserveChannelsContext* context, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TelepathyObserverHandleFtchannelChangeData* _data_;
	TelepathyObserver* _tmp0_;
	TpSimpleObserver* _tmp1_;
	TpSimpleObserver* _tmp2_;
	TpAccount* _tmp3_;
	TpAccount* _tmp4_;
	TpConnection* _tmp5_;
	TpConnection* _tmp6_;
	TpFileTransferChannel* _tmp7_;
	TpFileTransferChannel* _tmp8_;
	TpChannelDispatchOperation* _tmp9_;
	TpChannelDispatchOperation* _tmp10_;
	GList* _tmp11_;
	TpObserveChannelsContext* _tmp12_;
	TpObserveChannelsContext* _tmp13_;
	_data_ = g_slice_new0 (TelepathyObserverHandleFtchannelChangeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, telepathy_observer_handle_ftchannel_change);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, telepathy_observer_handle_ftchannel_change_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = observer;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->observer = _tmp2_;
	_tmp3_ = account;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->account = _tmp4_;
	_tmp5_ = connection;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_data_->connection = _tmp6_;
	_tmp7_ = channel;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_data_->channel = _tmp8_;
	_tmp9_ = dispatch_operation;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_data_->dispatch_operation = _tmp10_;
	_tmp11_ = requests;
	_data_->requests = _tmp11_;
	_tmp12_ = context;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_data_->context = _tmp13_;
	telepathy_observer_handle_ftchannel_change_co (_data_);
}


static void telepathy_observer_handle_ftchannel_change_finish (TelepathyObserver* self, GAsyncResult* _res_) {
	TelepathyObserverHandleFtchannelChangeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void telepathy_observer_handle_ftchannel_change_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TelepathyObserverHandleFtchannelChangeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	telepathy_observer_handle_ftchannel_change_co (_data_);
}


static guint8* _vala_array_dup3 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static gboolean telepathy_observer_handle_ftchannel_change_co (TelepathyObserverHandleFtchannelChangeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->channel;
	_data_->_tmp2_ = 0U;
	g_object_get (_data_->_tmp1_, "state", &_data_->_tmp2_, NULL);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_tmp3_ == ((guint) TP_FILE_TRANSFER_STATE_COMPLETED)) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp4_ = _data_->channel;
		_data_->_tmp5_ = 0U;
		g_object_get (_data_->_tmp4_, "state", &_data_->_tmp5_, NULL);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp0_ = _data_->_tmp6_ == ((guint) TP_FILE_TRANSFER_STATE_CANCELLED);
	}
	_data_->_tmp7_ = _data_->_tmp0_;
	if (_data_->_tmp7_) {
		_data_->_tmp8_ = _data_->channel;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = tp_channel_get_target_contact ((TpChannel*) _data_->_tmp8_);
		_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp9_);
		_data_->target = _data_->_tmp10_;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = g_strdup_printf ("%s, %s, %s", G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_ATTRIBUTE_STANDARD_SIZE);
		_data_->attr = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->channel;
		_data_->_tmp13_ = NULL;
		g_object_get (_data_->_tmp12_, "file", &_data_->_tmp13_, NULL);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = _data_->attr;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->_tmp15_, _data_->_tmp16_, 0, G_PRIORITY_DEFAULT, NULL, telepathy_observer_handle_ftchannel_change_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = g_file_query_info_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_g_object_unref0 (_data_->_tmp15_);
		_data_->info = _data_->_tmp18_;
		if (_data_->_inner_error_ != NULL) {
			_g_free0 (_data_->attr);
			_g_object_unref0 (_data_->target);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp19_ = _data_->account;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = tp_proxy_get_object_path ((TpProxy*) _data_->_tmp19_);
		_data_->_tmp21_ = g_strdup (_data_->_tmp20_);
		_data_->obj_path = _data_->_tmp21_;
		_data_->_tmp22_ = _data_->obj_path;
		_data_->_tmp23_ = strlen (TP_ACCOUNT_OBJECT_PATH_BASE);
		_data_->_tmp24_ = _data_->_tmp23_;
		_data_->_tmp25_ = _data_->obj_path;
		_data_->_tmp26_ = strlen (_data_->_tmp25_);
		_data_->_tmp27_ = _data_->_tmp26_;
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = string_slice (_data_->_tmp22_, (glong) _data_->_tmp24_, (glong) _data_->_tmp27_);
		_data_->_tmp29_ = _data_->_tmp28_;
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = g_strdup_printf (TELEPATHY_OBSERVER_tp_account_path, "%s", _data_->_tmp29_);
		_g_free0 (_data_->obj_path);
		_data_->obj_path = _data_->_tmp30_;
		_g_free0 (_data_->_tmp29_);
		_data_->_tmp31_ = zeitgeist_event_new ();
		_data_->_tmp32_ = g_object_ref_sink (_data_->_tmp31_);
		_data_->event_template = _data_->_tmp32_;
		_data_->_tmp33_ = _data_->channel;
		_data_->_tmp34_ = FALSE;
		g_object_get ((TpChannel*) _data_->_tmp33_, "requested", &_data_->_tmp34_, NULL);
		_data_->_tmp35_ = _data_->_tmp34_;
		if (_data_->_tmp35_) {
			_data_->_tmp36_ = _data_->event_template;
			zeitgeist_event_set_interpretation (_data_->_tmp36_, ZEITGEIST_ZG_SEND_EVENT);
			_data_->_tmp37_ = _data_->event_template;
			zeitgeist_event_set_manifestation (_data_->_tmp37_, ZEITGEIST_ZG_USER_ACTIVITY);
		} else {
			_data_->_tmp38_ = _data_->event_template;
			zeitgeist_event_set_interpretation (_data_->_tmp38_, ZEITGEIST_ZG_RECEIVE_EVENT);
			_data_->_tmp39_ = _data_->event_template;
			zeitgeist_event_set_manifestation (_data_->_tmp39_, ZEITGEIST_ZG_WORLD_ACTIVITY);
		}
		_data_->_tmp40_ = _data_->event_template;
		zeitgeist_event_set_actor (_data_->_tmp40_, TELEPATHY_OBSERVER_actor);
		_data_->_tmp41_ = zeitgeist_subject_new ();
		_data_->_tmp42_ = g_object_ref_sink (_data_->_tmp41_);
		_data_->subj = _data_->_tmp42_;
		_data_->_tmp43_ = _data_->subj;
		_data_->_tmp44_ = _data_->channel;
		_data_->_tmp45_ = NULL;
		g_object_get (_data_->_tmp44_, "file", &_data_->_tmp45_, NULL);
		_data_->_tmp46_ = _data_->_tmp45_;
		_data_->_tmp47_ = _data_->_tmp46_;
		_data_->_tmp48_ = NULL;
		_data_->_tmp48_ = g_file_get_uri (_data_->_tmp47_);
		_data_->_tmp49_ = _data_->_tmp48_;
		zeitgeist_subject_set_uri (_data_->_tmp43_, _data_->_tmp49_);
		_g_free0 (_data_->_tmp49_);
		_g_object_unref0 (_data_->_tmp47_);
		_data_->_tmp50_ = _data_->subj;
		_data_->_tmp51_ = _data_->info;
		_data_->_tmp52_ = NULL;
		_data_->_tmp52_ = g_file_info_get_content_type (_data_->_tmp51_);
		_data_->_tmp53_ = NULL;
		_data_->_tmp53_ = zeitgeist_interpretation_for_mimetype (_data_->_tmp52_);
		zeitgeist_subject_set_interpretation (_data_->_tmp50_, _data_->_tmp53_);
		_data_->_tmp54_ = _data_->subj;
		zeitgeist_subject_set_manifestation (_data_->_tmp54_, ZEITGEIST_NFO_FILE_DATA_OBJECT);
		_data_->_tmp55_ = _data_->subj;
		_data_->_tmp56_ = _data_->info;
		_data_->_tmp57_ = NULL;
		_data_->_tmp57_ = g_file_info_get_display_name (_data_->_tmp56_);
		zeitgeist_subject_set_text (_data_->_tmp55_, _data_->_tmp57_);
		_data_->_tmp58_ = _data_->subj;
		_data_->_tmp59_ = _data_->info;
		_data_->_tmp60_ = NULL;
		_data_->_tmp60_ = g_file_info_get_content_type (_data_->_tmp59_);
		zeitgeist_subject_set_mimetype (_data_->_tmp58_, _data_->_tmp60_);
		_data_->_tmp61_ = _data_->channel;
		_data_->_tmp62_ = FALSE;
		g_object_get ((TpChannel*) _data_->_tmp61_, "requested", &_data_->_tmp62_, NULL);
		_data_->_tmp63_ = _data_->_tmp62_;
		if (_data_->_tmp63_ == TRUE) {
			_data_->_tmp64_ = _data_->channel;
			_data_->_tmp65_ = NULL;
			g_object_get (_data_->_tmp64_, "file", &_data_->_tmp65_, NULL);
			_data_->_tmp66_ = _data_->_tmp65_;
			_data_->_tmp67_ = _data_->_tmp66_;
			_data_->_tmp68_ = NULL;
			_data_->_tmp68_ = g_file_get_uri (_data_->_tmp67_);
			_data_->_tmp69_ = _data_->_tmp68_;
			_data_->_tmp71_ = NULL;
			_data_->_tmp71_ = _data_->_tmp70_ = g_strsplit (_data_->_tmp69_, "/", 0);
			_data_->_tmp72_ = _data_->_tmp71_;
			_data_->_tmp72__length1 = _vala_array_length (_data_->_tmp70_);
			_g_free0 (_data_->_tmp69_);
			_g_object_unref0 (_data_->_tmp67_);
			_data_->split_uri = _data_->_tmp72_;
			_data_->split_uri_length1 = _data_->_tmp72__length1;
			_data_->_split_uri_size_ = _data_->split_uri_length1;
			_data_->_tmp73_ = _data_->split_uri;
			_data_->_tmp73__length1 = _data_->split_uri_length1;
			_data_->_tmp74_ = _data_->split_uri;
			_data_->_tmp74__length1 = _data_->split_uri_length1;
			_data_->_tmp75_ = NULL;
			_data_->_tmp75_ = g_strjoin ("/", _data_->_tmp73_ + 0, NULL);
			_data_->_tmp76_ = _data_->_tmp75_;
			_data_->_tmp77_ = NULL;
			_data_->_tmp77_ = g_strdup_printf ("%s/", _data_->_tmp76_);
			_data_->_tmp78_ = _data_->_tmp77_;
			_g_free0 (_data_->_tmp76_);
			_data_->uri = _data_->_tmp78_;
			_data_->_tmp79_ = _data_->subj;
			_data_->_tmp80_ = _data_->uri;
			zeitgeist_subject_set_origin (_data_->_tmp79_, _data_->_tmp80_);
			_g_free0 (_data_->uri);
			_data_->split_uri = (_vala_array_free (_data_->split_uri, _data_->split_uri_length1, (GDestroyNotify) g_free), NULL);
		} else {
			_data_->_tmp81_ = _data_->subj;
			_data_->_tmp82_ = _data_->target;
			_data_->_tmp83_ = NULL;
			_data_->_tmp83_ = tp_contact_get_identifier (_data_->_tmp82_);
			_data_->_tmp84_ = NULL;
			_data_->_tmp84_ = g_strdup_printf (TELEPATHY_OBSERVER_tp_identifier, _data_->_tmp83_);
			_data_->_tmp85_ = _data_->_tmp84_;
			zeitgeist_subject_set_origin (_data_->_tmp81_, _data_->_tmp85_);
			_g_free0 (_data_->_tmp85_);
		}
		_data_->_tmp86_ = _data_->event_template;
		_data_->_tmp87_ = _data_->subj;
		zeitgeist_event_add_subject (_data_->_tmp86_, _data_->_tmp87_);
		_data_->_tmp88_ = _data_->event_template;
		_data_->_tmp89_ = _data_->target;
		_data_->_tmp90_ = NULL;
		_data_->_tmp90_ = tp_contact_get_identifier (_data_->_tmp89_);
		_data_->_tmp91_ = NULL;
		_data_->_tmp91_ = g_strdup_printf (TELEPATHY_OBSERVER_tp_identifier, _data_->_tmp90_);
		_data_->_tmp92_ = _data_->_tmp91_;
		_data_->_tmp93_ = _data_->obj_path;
		_data_->_tmp94_ = _data_->target;
		_data_->_tmp95_ = NULL;
		_data_->_tmp95_ = tp_contact_get_alias (_data_->_tmp94_);
		_data_->_tmp96_ = zeitgeist_subject_new_full (_data_->_tmp92_, ZEITGEIST_NCO_CONTACT, ZEITGEIST_NCO_CONTACT_LIST_DATA_OBJECT, "", _data_->_tmp93_, _data_->_tmp95_, "net");
		_data_->_tmp97_ = g_object_ref_sink (_data_->_tmp96_);
		zeitgeist_event_add_subject (_data_->_tmp88_, _data_->_tmp97_);
		_g_object_unref0 (_data_->_tmp97_);
		_g_free0 (_data_->_tmp92_);
		_data_->_tmp98_ = json_generator_new ();
		_data_->gen = _data_->_tmp98_;
		_data_->_tmp99_ = json_node_new (JSON_NODE_OBJECT);
		_data_->root = _data_->_tmp99_;
		_data_->_tmp100_ = json_object_new ();
		_data_->object = _data_->_tmp100_;
		_data_->_tmp101_ = _data_->root;
		_data_->_tmp102_ = _data_->object;
		json_node_set_object (_data_->_tmp101_, _data_->_tmp102_);
		_data_->_tmp103_ = _data_->gen;
		_data_->_tmp104_ = _data_->root;
		json_generator_set_root (_data_->_tmp103_, _data_->_tmp104_);
		_data_->_tmp105_ = _data_->gen;
		json_generator_set_pretty (_data_->_tmp105_, TRUE);
		_data_->_tmp106_ = json_object_new ();
		_data_->details_obj = _data_->_tmp106_;
		_data_->_tmp107_ = _data_->channel;
		_data_->_tmp108_ = 0;
		_data_->_tmp109_ = 0;
		_data_->_tmp109_ = tp_file_transfer_channel_get_state (_data_->_tmp107_, &_data_->_tmp108_);
		_data_->reason = _data_->_tmp108_;
		_data_->state = _data_->_tmp109_;
		_data_->_tmp110_ = _data_->details_obj;
		_data_->_tmp111_ = _data_->state;
		json_object_set_int_member (_data_->_tmp110_, "state", (gint64) _data_->_tmp111_);
		_data_->_tmp112_ = _data_->details_obj;
		_data_->_tmp113_ = _data_->reason;
		json_object_set_int_member (_data_->_tmp112_, "reason", (gint64) _data_->_tmp113_);
		_data_->_tmp114_ = _data_->details_obj;
		_data_->_tmp115_ = _data_->channel;
		_data_->_tmp116_ = FALSE;
		g_object_get ((TpChannel*) _data_->_tmp115_, "requested", &_data_->_tmp116_, NULL);
		_data_->_tmp117_ = _data_->_tmp116_;
		json_object_set_boolean_member (_data_->_tmp114_, "requested", _data_->_tmp117_);
		_data_->_tmp118_ = _data_->details_obj;
		_data_->_tmp119_ = _data_->channel;
		_data_->_tmp120_ = NULL;
		_data_->_tmp120_ = tp_file_transfer_channel_get_description (_data_->_tmp119_);
		json_object_set_string_member (_data_->_tmp118_, "description", _data_->_tmp120_);
		_data_->_tmp121_ = _data_->details_obj;
		_data_->_tmp122_ = _data_->channel;
		_data_->_tmp123_ = 0ULL;
		_data_->_tmp123_ = tp_file_transfer_channel_get_size (_data_->_tmp122_);
		json_object_set_double_member (_data_->_tmp121_, "size", (gdouble) ((gint64) _data_->_tmp123_));
		_data_->_tmp124_ = _data_->details_obj;
		_data_->_tmp125_ = _data_->channel;
		_data_->_tmp126_ = NULL;
		_data_->_tmp126_ = tp_file_transfer_channel_get_service_name (_data_->_tmp125_);
		json_object_set_string_member (_data_->_tmp124_, "service", _data_->_tmp126_);
		_data_->_tmp127_ = _data_->object;
		_data_->_tmp128_ = _data_->details_obj;
		_data_->_tmp129_ = __vala_JsonObject_copy0 (_data_->_tmp128_);
		json_object_set_object_member (_data_->_tmp127_, TELEPATHY_OBSERVER_ft_json_domain, _data_->_tmp129_);
		_data_->_tmp130_ = _data_->gen;
		_data_->_tmp131_ = 0UL;
		_data_->_tmp132_ = NULL;
		_data_->_tmp132_ = json_generator_to_data (_data_->_tmp130_, &_data_->_tmp131_);
		_data_->length = _data_->_tmp131_;
		_data_->payload_string = _data_->_tmp132_;
		_data_->_tmp133_ = _data_->event_template;
		_data_->_tmp134_ = _data_->payload_string;
		_data_->_tmp135_ = string_get_data (_data_->_tmp134_, &_data_->_tmp135__length1);
		_data_->_tmp136_ = _data_->_tmp135_;
		_data_->_tmp136__length1 = _data_->_tmp135__length1;
		_data_->_tmp137_ = (_data_->_tmp136_ != NULL) ? _vala_array_dup3 (_data_->_tmp136_, _data_->_tmp136__length1) : ((gpointer) _data_->_tmp136_);
		_data_->_tmp137__length1 = _data_->_tmp136__length1;
		_data_->_tmp138_ = g_byte_array_new_take (_data_->_tmp137_, _data_->_tmp137__length1);
		zeitgeist_event_set_payload (_data_->_tmp133_, _data_->_tmp138_);
		_data_->_tmp139_ = _data_->event_template;
		telepathy_observer_push_event (_data_->self, _data_->_tmp139_);
		_g_free0 (_data_->payload_string);
		__vala_JsonObject_free0 (_data_->details_obj);
		__vala_JsonObject_free0 (_data_->object);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->gen);
		_g_object_unref0 (_data_->subj);
		_g_object_unref0 (_data_->event_template);
		_g_free0 (_data_->obj_path);
		_g_object_unref0 (_data_->info);
		_g_free0 (_data_->attr);
		_g_object_unref0 (_data_->target);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		TelepathyObserver * self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->channel);
		_g_object_unref0 (_data5_->observer);
		_g_object_unref0 (_data5_->account);
		_g_object_unref0 (_data5_->connection);
		_g_object_unref0 (_data5_->dispatch_operation);
		_g_object_unref0 (_data5_->context);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void __lambda7_ (Block5Data* _data5_) {
	TelepathyObserver * self;
	TpSimpleObserver* _tmp0_;
	TpAccount* _tmp1_;
	TpConnection* _tmp2_;
	TpChannelDispatchOperation* _tmp3_;
	GList* _tmp4_;
	TpObserveChannelsContext* _tmp5_;
	self = _data5_->self;
	_tmp0_ = _data5_->observer;
	_tmp1_ = _data5_->account;
	_tmp2_ = _data5_->connection;
	_tmp3_ = _data5_->dispatch_operation;
	_tmp4_ = _data5_->requests;
	_tmp5_ = _data5_->context;
	telepathy_observer_handle_ftchannel_change (self, _tmp0_, _tmp1_, _tmp2_, _data5_->channel, _tmp3_, _tmp4_, _tmp5_, NULL, NULL);
}


static void ___lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda7_ (self);
}


static void telepathy_observer_observe_ft_channel (TelepathyObserver* self, TpSimpleObserver* observer, TpAccount* account, TpConnection* connection, TpChannel* b_channel, TpChannelDispatchOperation* dispatch_operation, GList* requests, TpObserveChannelsContext* context) {
	Block5Data* _data5_;
	TpSimpleObserver* _tmp0_;
	TpSimpleObserver* _tmp1_;
	TpAccount* _tmp2_;
	TpAccount* _tmp3_;
	TpConnection* _tmp4_;
	TpConnection* _tmp5_;
	TpChannelDispatchOperation* _tmp6_;
	TpChannelDispatchOperation* _tmp7_;
	GList* _tmp8_;
	TpObserveChannelsContext* _tmp9_;
	TpObserveChannelsContext* _tmp10_;
	TpChannel* _tmp11_;
	TpFileTransferChannel* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (observer != NULL);
	g_return_if_fail (account != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (b_channel != NULL);
	g_return_if_fail (context != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = observer;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data5_->observer = _tmp1_;
	_tmp2_ = account;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_data5_->account = _tmp3_;
	_tmp4_ = connection;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_data5_->connection = _tmp5_;
	_tmp6_ = dispatch_operation;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_data5_->dispatch_operation = _tmp7_;
	_tmp8_ = requests;
	_data5_->requests = _tmp8_;
	_tmp9_ = context;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_data5_->context = _tmp10_;
	_tmp11_ = b_channel;
	_tmp12_ = _g_object_ref0 (TP_FILE_TRANSFER_CHANNEL (_tmp11_));
	_data5_->channel = _tmp12_;
	g_signal_connect_data ((GObject*) _data5_->channel, "notify::state", (GCallback) ___lambda7__g_object_notify, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static void telepathy_observer_observe_channels (TelepathyObserver* self, TpSimpleObserver* observer, TpAccount* account, TpConnection* connection, GList* channels, TpChannelDispatchOperation* dispatch_operation, GList* requests, TpObserveChannelsContext* context) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (observer != NULL);
	g_return_if_fail (account != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (context != NULL);
	{
		GList* _tmp0_;
		_tmp0_ = channels;
		{
			GList* channel_collection = NULL;
			GList* channel_it = NULL;
			channel_collection = _tmp0_;
			for (channel_it = channel_collection; channel_it != NULL; channel_it = channel_it->next) {
				TpChannel* _tmp1_;
				TpChannel* channel = NULL;
				_tmp1_ = _g_object_ref0 ((TpChannel*) channel_it->data);
				channel = _tmp1_;
				{
					TpChannel* _tmp2_;
					_tmp2_ = channel;
					if (TP_IS_TEXT_CHANNEL (_tmp2_)) {
						TpSimpleObserver* _tmp3_;
						TpAccount* _tmp4_;
						TpConnection* _tmp5_;
						TpChannel* _tmp6_;
						TpChannelDispatchOperation* _tmp7_;
						GList* _tmp8_;
						TpObserveChannelsContext* _tmp9_;
						_tmp3_ = observer;
						_tmp4_ = account;
						_tmp5_ = connection;
						_tmp6_ = channel;
						_tmp7_ = dispatch_operation;
						_tmp8_ = requests;
						_tmp9_ = context;
						telepathy_observer_observe_text_channel (self, _tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_, _tmp8_, _tmp9_);
					} else {
						TpChannel* _tmp10_;
						_tmp10_ = channel;
						if (TP_IS_CALL_CHANNEL (_tmp10_)) {
							TpSimpleObserver* _tmp11_;
							TpAccount* _tmp12_;
							TpConnection* _tmp13_;
							TpChannel* _tmp14_;
							TpChannelDispatchOperation* _tmp15_;
							GList* _tmp16_;
							TpObserveChannelsContext* _tmp17_;
							_tmp11_ = observer;
							_tmp12_ = account;
							_tmp13_ = connection;
							_tmp14_ = channel;
							_tmp15_ = dispatch_operation;
							_tmp16_ = requests;
							_tmp17_ = context;
							telepathy_observer_observe_call_channel (self, _tmp11_, _tmp12_, _tmp13_, _tmp14_, _tmp15_, _tmp16_, _tmp17_);
						} else {
							TpChannel* _tmp18_;
							_tmp18_ = channel;
							if (TP_IS_FILE_TRANSFER_CHANNEL (_tmp18_)) {
								TpSimpleObserver* _tmp19_;
								TpAccount* _tmp20_;
								TpConnection* _tmp21_;
								TpChannel* _tmp22_;
								TpChannelDispatchOperation* _tmp23_;
								GList* _tmp24_;
								TpObserveChannelsContext* _tmp25_;
								_tmp19_ = observer;
								_tmp20_ = account;
								_tmp21_ = connection;
								_tmp22_ = channel;
								_tmp23_ = dispatch_operation;
								_tmp24_ = requests;
								_tmp25_ = context;
								telepathy_observer_observe_ft_channel (self, _tmp19_, _tmp20_, _tmp21_, _tmp22_, _tmp23_, _tmp24_, _tmp25_);
							}
						}
					}
					_g_object_unref0 (channel);
				}
			}
		}
	}
	__finally10:
	{
		TpObserveChannelsContext* _tmp26_;
		_tmp26_ = context;
		tp_observe_channels_context_accept (_tmp26_);
	}
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _telepathy_observer_observe_channels_tp_simple_observer_observe_channels_impl (TpSimpleObserver* observer, TpAccount* account, TpConnection* connection, GList* channels, TpChannelDispatchOperation* dispatch_operation, GList* requests, TpObserveChannelsContext* context, gpointer self) {
	telepathy_observer_observe_channels (self, observer, account, connection, channels, dispatch_operation, requests, context);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static void telepathy_observer_real_start (DataProvider* base) {
	TelepathyObserver * self;
	TpAutomaticClientFactory* _tmp0_;
	TpSimpleObserver* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* call_filter;
	gchar* _tmp5_;
	GValue* _tmp6_ = NULL;
	gchar* _tmp7_;
	GValue* _tmp8_ = NULL;
	TpSimpleObserver* _tmp9_;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GHashTable* _tmp12_;
	GHashTable* text_filter;
	gchar* _tmp13_;
	GValue* _tmp14_ = NULL;
	gchar* _tmp15_;
	GValue* _tmp16_ = NULL;
	TpSimpleObserver* _tmp17_;
	GHashFunc _tmp18_;
	GEqualFunc _tmp19_;
	GHashTable* _tmp20_;
	GHashTable* ft_filter;
	gchar* _tmp21_;
	GValue* _tmp22_ = NULL;
	gchar* _tmp23_;
	GValue* _tmp24_ = NULL;
	TpSimpleObserver* _tmp25_;
	TpSimpleObserver* _tmp26_;
	GError * _inner_error_ = NULL;
	self = (TelepathyObserver*) base;
	_tmp0_ = self->priv->factory;
	_tmp1_ = (TpSimpleObserver*) tp_simple_observer_new_with_factory ((TpSimpleClientFactory*) _tmp0_, TRUE, "Zeitgeist", FALSE, _telepathy_observer_observe_channels_tp_simple_observer_observe_channels_impl, g_object_ref (self), g_object_unref);
	_g_object_unref0 (self->priv->observer);
	self->priv->observer = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, __vala_GValue_free0_);
	call_filter = _tmp4_;
	_tmp5_ = g_strdup (TP_PROP_CHANNEL_CHANNEL_TYPE);
	_tmp6_ = g_new0 (GValue, 1);
	g_value_init (_tmp6_, G_TYPE_STRING);
	g_value_set_string (_tmp6_, TP_IFACE_CHANNEL_TYPE_CALL);
	g_hash_table_insert (call_filter, _tmp5_, _tmp6_);
	_tmp7_ = g_strdup (TP_PROP_CHANNEL_TARGET_HANDLE_TYPE);
	_tmp8_ = g_new0 (GValue, 1);
	g_value_init (_tmp8_, G_TYPE_INT);
	g_value_set_int (_tmp8_, 1);
	g_hash_table_insert (call_filter, _tmp7_, _tmp8_);
	_tmp9_ = self->priv->observer;
	tp_base_client_add_observer_filter ((TpBaseClient*) _tmp9_, call_filter);
	_tmp10_ = g_str_hash;
	_tmp11_ = g_str_equal;
	_tmp12_ = g_hash_table_new_full (_tmp10_, _tmp11_, _g_free0_, __vala_GValue_free0_);
	text_filter = _tmp12_;
	_tmp13_ = g_strdup (TP_PROP_CHANNEL_CHANNEL_TYPE);
	_tmp14_ = g_new0 (GValue, 1);
	g_value_init (_tmp14_, G_TYPE_STRING);
	g_value_set_string (_tmp14_, TP_IFACE_CHANNEL_TYPE_TEXT);
	g_hash_table_insert (text_filter, _tmp13_, _tmp14_);
	_tmp15_ = g_strdup (TP_PROP_CHANNEL_TARGET_HANDLE_TYPE);
	_tmp16_ = g_new0 (GValue, 1);
	g_value_init (_tmp16_, G_TYPE_INT);
	g_value_set_int (_tmp16_, 1);
	g_hash_table_insert (text_filter, _tmp15_, _tmp16_);
	_tmp17_ = self->priv->observer;
	tp_base_client_add_observer_filter ((TpBaseClient*) _tmp17_, text_filter);
	_tmp18_ = g_str_hash;
	_tmp19_ = g_str_equal;
	_tmp20_ = g_hash_table_new_full (_tmp18_, _tmp19_, _g_free0_, __vala_GValue_free0_);
	ft_filter = _tmp20_;
	_tmp21_ = g_strdup (TP_PROP_CHANNEL_CHANNEL_TYPE);
	_tmp22_ = g_new0 (GValue, 1);
	g_value_init (_tmp22_, G_TYPE_STRING);
	g_value_set_string (_tmp22_, TP_IFACE_CHANNEL_TYPE_FILE_TRANSFER);
	g_hash_table_insert (ft_filter, _tmp21_, _tmp22_);
	_tmp23_ = g_strdup (TP_PROP_CHANNEL_TARGET_HANDLE_TYPE);
	_tmp24_ = g_new0 (GValue, 1);
	g_value_init (_tmp24_, G_TYPE_INT);
	g_value_set_int (_tmp24_, 1);
	g_hash_table_insert (ft_filter, _tmp23_, _tmp24_);
	_tmp25_ = self->priv->observer;
	tp_base_client_add_observer_filter ((TpBaseClient*) _tmp25_, ft_filter);
	_tmp26_ = self->priv->observer;
	tp_base_client_register ((TpBaseClient*) _tmp26_, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_hash_table_unref0 (ft_filter);
		_g_hash_table_unref0 (text_filter);
		_g_hash_table_unref0 (call_filter);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_hash_table_unref0 (ft_filter);
	_g_hash_table_unref0 (text_filter);
	_g_hash_table_unref0 (call_filter);
}


static void telepathy_observer_real_stop (DataProvider* base) {
	TelepathyObserver * self;
	TpSimpleObserver* _tmp0_;
	self = (TelepathyObserver*) base;
	_tmp0_ = self->priv->observer;
	tp_base_client_unregister ((TpBaseClient*) _tmp0_);
}


static const gchar* telepathy_observer_real_get_unique_id (DataProvider* base) {
	const gchar* result;
	TelepathyObserver* self;
	const gchar* _tmp0_;
	self = (TelepathyObserver*) base;
	_tmp0_ = self->priv->_unique_id;
	result = _tmp0_;
	return result;
}


static void telepathy_observer_real_set_unique_id (DataProvider* base, const gchar* value) {
	TelepathyObserver* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (TelepathyObserver*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_unique_id);
	self->priv->_unique_id = _tmp1_;
	g_object_notify ((GObject *) self, "unique-id");
}


static const gchar* telepathy_observer_real_get_name (DataProvider* base) {
	const gchar* result;
	TelepathyObserver* self;
	const gchar* _tmp0_;
	self = (TelepathyObserver*) base;
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void telepathy_observer_real_set_name (DataProvider* base, const gchar* value) {
	TelepathyObserver* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (TelepathyObserver*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


static const gchar* telepathy_observer_real_get_description (DataProvider* base) {
	const gchar* result;
	TelepathyObserver* self;
	const gchar* _tmp0_;
	self = (TelepathyObserver*) base;
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


static void telepathy_observer_real_set_description (DataProvider* base, const gchar* value) {
	TelepathyObserver* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (TelepathyObserver*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp1_;
	g_object_notify ((GObject *) self, "description");
}


static DataHub* telepathy_observer_real_get_datahub (DataProvider* base) {
	DataHub* result;
	TelepathyObserver* self;
	DataHub* _tmp0_;
	self = (TelepathyObserver*) base;
	_tmp0_ = self->priv->_datahub;
	result = _tmp0_;
	return result;
}


static void telepathy_observer_real_set_datahub (DataProvider* base, DataHub* value) {
	TelepathyObserver* self;
	DataHub* _tmp0_;
	DataHub* _tmp1_;
	self = (TelepathyObserver*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_datahub);
	self->priv->_datahub = _tmp1_;
	g_object_notify ((GObject *) self, "datahub");
}


static gboolean telepathy_observer_real_get_enabled (DataProvider* base) {
	gboolean result;
	TelepathyObserver* self;
	gboolean _tmp0_;
	self = (TelepathyObserver*) base;
	_tmp0_ = self->priv->_enabled;
	result = _tmp0_;
	return result;
}


static void telepathy_observer_real_set_enabled (DataProvider* base, gboolean value) {
	TelepathyObserver* self;
	gboolean _tmp0_;
	self = (TelepathyObserver*) base;
	_tmp0_ = value;
	self->priv->_enabled = _tmp0_;
	g_object_notify ((GObject *) self, "enabled");
}


static gboolean telepathy_observer_real_get_register (DataProvider* base) {
	gboolean result;
	TelepathyObserver* self;
	gboolean _tmp0_;
	self = (TelepathyObserver*) base;
	_tmp0_ = self->priv->_register;
	result = _tmp0_;
	return result;
}


static void telepathy_observer_real_set_register (DataProvider* base, gboolean value) {
	TelepathyObserver* self;
	gboolean _tmp0_;
	self = (TelepathyObserver*) base;
	_tmp0_ = value;
	self->priv->_register = _tmp0_;
	g_object_notify ((GObject *) self, "register");
}


static void _g_timer_destroy0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL));
}


static GObject * telepathy_observer_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TelepathyObserver * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	TpDBusDaemon* _tmp3_ = NULL;
	TpDBusDaemon* _tmp4_;
	TpDBusDaemon* _tmp5_;
	TpAutomaticClientFactory* _tmp6_;
	GQuark _tmp7_ = 0U;
	GQuark* _tmp8_ = NULL;
	GQuark* channel_quark;
	gint channel_quark_length1;
	gint _channel_quark_size_;
	TpContactFeature* _tmp9_ = NULL;
	TpContactFeature* contact_quark;
	gint contact_quark_length1;
	gint _contact_quark_size_;
	TpAutomaticClientFactory* _tmp10_;
	GQuark* _tmp11_;
	gint _tmp11__length1;
	TpAutomaticClientFactory* _tmp12_;
	TpContactFeature* _tmp13_;
	gint _tmp13__length1;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (telepathy_observer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TELEPATHY_OBSERVER (obj);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_timer_destroy0_);
	_g_hash_table_unref0 (self->priv->call_timers);
	self->priv->call_timers = _tmp2_;
	_tmp3_ = tp_dbus_daemon_dup (&_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_g_object_unref0 (self->priv->dbus);
	self->priv->dbus = _tmp4_;
	_tmp5_ = self->priv->dbus;
	_tmp6_ = tp_automatic_client_factory_new (_tmp5_);
	_g_object_unref0 (self->priv->factory);
	self->priv->factory = _tmp6_;
	_tmp7_ = tp_channel_get_feature_quark_contacts ();
	_tmp8_ = g_new0 (GQuark, 1);
	_tmp8_[0] = _tmp7_;
	channel_quark = _tmp8_;
	channel_quark_length1 = 1;
	_channel_quark_size_ = channel_quark_length1;
	_tmp9_ = g_new0 (TpContactFeature, 1);
	_tmp9_[0] = TP_CONTACT_FEATURE_ALIAS;
	contact_quark = _tmp9_;
	contact_quark_length1 = 1;
	_contact_quark_size_ = contact_quark_length1;
	_tmp10_ = self->priv->factory;
	_tmp11_ = channel_quark;
	_tmp11__length1 = channel_quark_length1;
	tp_simple_client_factory_add_channel_features ((TpSimpleClientFactory*) _tmp10_, _tmp11_);
	_tmp12_ = self->priv->factory;
	_tmp13_ = contact_quark;
	_tmp13__length1 = contact_quark_length1;
	tp_simple_client_factory_add_contact_features ((TpSimpleClientFactory*) _tmp12_, (guint) _tmp13__length1, _tmp13_);
	contact_quark = (g_free (contact_quark), NULL);
	channel_quark = (g_free (channel_quark), NULL);
	return obj;
}


static void telepathy_observer_class_init (TelepathyObserverClass * klass) {
	telepathy_observer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TelepathyObserverPrivate));
	DATA_PROVIDER_CLASS (klass)->start = telepathy_observer_real_start;
	DATA_PROVIDER_CLASS (klass)->stop = telepathy_observer_real_stop;
	DATA_PROVIDER_CLASS (klass)->get_unique_id = telepathy_observer_real_get_unique_id;
	DATA_PROVIDER_CLASS (klass)->set_unique_id = telepathy_observer_real_set_unique_id;
	DATA_PROVIDER_CLASS (klass)->get_name = telepathy_observer_real_get_name;
	DATA_PROVIDER_CLASS (klass)->set_name = telepathy_observer_real_set_name;
	DATA_PROVIDER_CLASS (klass)->get_description = telepathy_observer_real_get_description;
	DATA_PROVIDER_CLASS (klass)->set_description = telepathy_observer_real_set_description;
	DATA_PROVIDER_CLASS (klass)->get_datahub = telepathy_observer_real_get_datahub;
	DATA_PROVIDER_CLASS (klass)->set_datahub = telepathy_observer_real_set_datahub;
	DATA_PROVIDER_CLASS (klass)->get_enabled = telepathy_observer_real_get_enabled;
	DATA_PROVIDER_CLASS (klass)->set_enabled = telepathy_observer_real_set_enabled;
	DATA_PROVIDER_CLASS (klass)->get_register = telepathy_observer_real_get_register;
	DATA_PROVIDER_CLASS (klass)->set_register = telepathy_observer_real_set_register;
	G_OBJECT_CLASS (klass)->get_property = _vala_telepathy_observer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_telepathy_observer_set_property;
	G_OBJECT_CLASS (klass)->constructor = telepathy_observer_constructor;
	G_OBJECT_CLASS (klass)->finalize = telepathy_observer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TELEPATHY_OBSERVER_UNIQUE_ID, g_param_spec_string ("unique-id", "unique-id", "unique-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TELEPATHY_OBSERVER_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TELEPATHY_OBSERVER_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TELEPATHY_OBSERVER_DATAHUB, g_param_spec_object ("datahub", "datahub", "datahub", TYPE_DATA_HUB, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TELEPATHY_OBSERVER_ENABLED, g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TELEPATHY_OBSERVER_REGISTER, g_param_spec_boolean ("register", "register", "register", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void telepathy_observer_instance_init (TelepathyObserver * self) {
	self->priv = TELEPATHY_OBSERVER_GET_PRIVATE (self);
	self->priv->dbus = NULL;
	self->priv->factory = NULL;
	self->priv->observer = NULL;
	self->priv->call_timers = NULL;
	self->priv->_enabled = TRUE;
	self->priv->_register = TRUE;
}


static void telepathy_observer_finalize (GObject* obj) {
	TelepathyObserver * self;
	self = TELEPATHY_OBSERVER (obj);
	_g_object_unref0 (self->priv->dbus);
	_g_object_unref0 (self->priv->factory);
	_g_object_unref0 (self->priv->observer);
	_g_hash_table_unref0 (self->priv->call_timers);
	_g_free0 (self->priv->_unique_id);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->_datahub);
	G_OBJECT_CLASS (telepathy_observer_parent_class)->finalize (obj);
}


GType telepathy_observer_get_type (void) {
	static volatile gsize telepathy_observer_type_id__volatile = 0;
	if (g_once_init_enter (&telepathy_observer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TelepathyObserverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) telepathy_observer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TelepathyObserver), 0, (GInstanceInitFunc) telepathy_observer_instance_init, NULL };
		GType telepathy_observer_type_id;
		telepathy_observer_type_id = g_type_register_static (TYPE_DATA_PROVIDER, "TelepathyObserver", &g_define_type_info, 0);
		g_once_init_leave (&telepathy_observer_type_id__volatile, telepathy_observer_type_id);
	}
	return telepathy_observer_type_id__volatile;
}


static void _vala_telepathy_observer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TelepathyObserver * self;
	self = TELEPATHY_OBSERVER (object);
	switch (property_id) {
		case TELEPATHY_OBSERVER_UNIQUE_ID:
		g_value_set_string (value, data_provider_get_unique_id ((DataProvider*) self));
		break;
		case TELEPATHY_OBSERVER_NAME:
		g_value_set_string (value, data_provider_get_name ((DataProvider*) self));
		break;
		case TELEPATHY_OBSERVER_DESCRIPTION:
		g_value_set_string (value, data_provider_get_description ((DataProvider*) self));
		break;
		case TELEPATHY_OBSERVER_DATAHUB:
		g_value_set_object (value, data_provider_get_datahub ((DataProvider*) self));
		break;
		case TELEPATHY_OBSERVER_ENABLED:
		g_value_set_boolean (value, data_provider_get_enabled ((DataProvider*) self));
		break;
		case TELEPATHY_OBSERVER_REGISTER:
		g_value_set_boolean (value, data_provider_get_register ((DataProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_telepathy_observer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TelepathyObserver * self;
	self = TELEPATHY_OBSERVER (object);
	switch (property_id) {
		case TELEPATHY_OBSERVER_UNIQUE_ID:
		data_provider_set_unique_id ((DataProvider*) self, g_value_get_string (value));
		break;
		case TELEPATHY_OBSERVER_NAME:
		data_provider_set_name ((DataProvider*) self, g_value_get_string (value));
		break;
		case TELEPATHY_OBSERVER_DESCRIPTION:
		data_provider_set_description ((DataProvider*) self, g_value_get_string (value));
		break;
		case TELEPATHY_OBSERVER_DATAHUB:
		data_provider_set_datahub ((DataProvider*) self, g_value_get_object (value));
		break;
		case TELEPATHY_OBSERVER_ENABLED:
		data_provider_set_enabled ((DataProvider*) self, g_value_get_boolean (value));
		break;
		case TELEPATHY_OBSERVER_REGISTER:
		data_provider_set_register ((DataProvider*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



