/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.range.Range;
import com.jidesoft.range.StringRange;
import java.util.List;

public class StringUtils {
    public static String toCamelCase(String str) {
        String firstLetter = str.substring(0, 1);
        String rest = str.substring(1);
        return firstLetter.toUpperCase() + rest.toLowerCase();
    }

    public static String stringList(String prefix, String suffix, String separator, Object ... objects) {
        StringBuilder builder = new StringBuilder(prefix);
        for (int i = 0; i < objects.length; ++i) {
            builder.append(objects[i].toString());
            if (i >= objects.length - 1) continue;
            builder.append(separator);
        }
        builder.append(suffix);
        return builder.toString();
    }

    public static String stringList(Object[] objects) {
        return StringUtils.stringList("[", "]", ",", objects);
    }

    public static String stringList(List<?> objects) {
        if (objects == null) {
            return "";
        }
        return StringUtils.stringList(objects.toArray());
    }

    public static String min(List<String> strings) {
        String min = null;
        for (String value : strings) {
            if (min != null && value.compareTo(min) >= 0) continue;
            min = value;
        }
        return min;
    }

    public static String max(List<String> strings) {
        String max = null;
        for (String value : strings) {
            if (max != null && value.compareTo(max) <= 0) continue;
            max = value;
        }
        return max;
    }

    public static Range<String> range(List<String> strings) {
        String min = null;
        String max = null;
        for (String value : strings) {
            if (max == null || value.compareTo(max) > 0) {
                max = value;
            }
            if (min != null && value.compareTo(min) >= 0) continue;
            min = value;
        }
        return new StringRange(min, max);
    }
}

