/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.CommandConfig;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.policy.InputModeSelectionPolicy;
import amazon.fws.clicommando.processors.CommandProcessor;
import amazon.fws.clicommando.security.SecurityKeys;
import amazon.fws.clicommando.util.StringUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class LoadAWSCredentialFileCommandProcessor
implements CommandProcessor {
    public static final String AWSAccessKeyId = "AWSAccessKeyId";
    public static final String AWSSecretKey = "AWSSecretKey";
    public static final String AWSCredentialFileLocation = "AWSCredentialFileLocation";
    public static final String AWSCredentialFileEncoding = "String";

    public Command process(Command process) throws CliCommandoException {
        CommandConfig commandConfig = process.getCurrentCommandConfig();
        String fileName = null;
        if (this.isCredentialPresent(commandConfig) && !this.awsCredentialsDefined(commandConfig)) {
            ParamConfig credentialFileNameParamConfig = commandConfig.getParameter(AWSCredentialFileLocation);
            if (credentialFileNameParamConfig == null) {
                return process;
            }
            fileName = credentialFileNameParamConfig.getValue();
            if (StringUtils.notEmpty(fileName)) {
                this.loadCredentials(commandConfig, fileName);
            }
        }
        if (this.isCredentialPresent(commandConfig) && this.awsCredentialsDefined(commandConfig)) {
            this.loadSecretKeys(commandConfig);
        }
        return process;
    }

    private boolean isCredentialPresent(CommandConfig commandConfig) {
        Map<String, ParamConfig> pMap = commandConfig.getParameterMap();
        boolean defined = false;
        if (pMap.containsKey(AWSSecretKey) && pMap.containsKey(AWSAccessKeyId)) {
            defined = true;
        }
        return defined;
    }

    private boolean awsCredentialsDefined(CommandConfig commandConfig) {
        ParamConfig secretKeyParamConfig = commandConfig.getParameter(AWSSecretKey);
        ParamConfig secretKeyIdParamConfig = commandConfig.getParameter(AWSAccessKeyId);
        return StringUtils.notEmpty(secretKeyParamConfig.getValue()) && StringUtils.notEmpty(secretKeyIdParamConfig.getValue());
    }

    private void loadCredentials(CommandConfig commandConfig, String fileName) {
        String awsKeyId;
        String awsKey;
        Properties credentials = this.loadCredentialFile(fileName);
        if (credentials != null) {
            awsKey = credentials.getProperty(AWSSecretKey);
            awsKeyId = credentials.getProperty(AWSAccessKeyId);
            if (StringUtils.isEmpty(awsKeyId) || StringUtils.isEmpty(awsKey)) {
                throw new BadInputException(ErrorMessages.ErrorCode.BAD_CREDENTIALS_IN_FILE, fileName, awsKeyId, awsKey);
            }
        } else {
            throw new BadInputException(ErrorMessages.ErrorCode.FILE_NOT_FOUND, fileName);
        }
        ParamConfig secretKeyParam = commandConfig.getParameter(AWSSecretKey);
        ParamConfig secretKeyIdParam = commandConfig.getParameter(AWSAccessKeyId);
        secretKeyParam.setValue(awsKey);
        secretKeyIdParam.setValue(awsKeyId);
    }

    private void loadSecretKeys(CommandConfig commandConfig) {
        InputModeSelectionPolicy inputModeSelector = new InputModeSelectionPolicy();
        ParamConfig secretKeyParam = commandConfig.getParameter(AWSSecretKey);
        String awsKey = secretKeyParam.getValue();
        ParamConfig secretKeyIdParam = commandConfig.getParameter(AWSAccessKeyId);
        String awsKeyId = secretKeyIdParam.getValue();
        ParamConfig.InputMode inputMode = inputModeSelector.select((T[])new ParamConfig.InputMode[]{secretKeyParam.getInputMode(), secretKeyIdParam.getInputMode()});
        commandConfig.getSecurityKeys().add(new SecurityKeys(SecurityKeys.KeyType.AWS_KEYS, awsKey, awsKeyId, inputMode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadCredentialFile(String fileName) {
        Properties properties;
        Properties properties2 = new Properties();
        FileInputStream propIn = null;
        try {
            try {
                propIn = new FileInputStream(fileName);
                properties2.load(propIn);
                propIn.close();
                properties = properties2;
                Object var7_6 = null;
                if (propIn == null) return properties;
            }
            catch (IOException e) {
                Properties properties3 = null;
                Object var7_7 = null;
                if (propIn == null) return properties3;
                try {
                    propIn.close();
                    return properties3;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                return properties3;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (propIn == null) throw throwable;
            try {}
            catch (Exception ignore) {
                throw throwable;
            }
            propIn.close();
            throw throwable;
        }
        try {}
        catch (Exception ignore) {
            // empty catch block
            return properties;
        }
        propIn.close();
        return properties;
    }
}

