/* Copyright (C) 2001, 2007 United States Government as represented by
   the Administrator of the National Aeronautics and Space Administration.
   All Rights Reserved.
*/
package gov.nasa.worldwind.servers.wms;

/**
 *
 * @author brownrigg
 * @version $Id: WMSRequest.java 5011 2008-04-10 16:53:54Z rick $
 */
public abstract class WMSRequest {
    
    // common to all requests...
    protected static final String CAPABILITIES = "GetCapabilities";
    protected static final String GETMAP = "GetMap";
    protected static final String FEATUREINFO = "GetFeatureInfo";
    protected static final String GETIMAGERYLIST = "GetImageryList";
    protected static final String REQUEST = "REQUEST";
    protected static final String WMSSERVICE = "WMS";
    protected static final String VERSION = "VERSION";
    protected static final String EXCEPTIONS = "EXCEPTIONS";
    protected static final String FORMAT = "FORMAT";
    
    public static WMSRequest createWMSRequest(WMSHttpServletRequest req)
    throws WMSServiceException {
        
        String request = req.getParameter(REQUEST);
        if (request == null)
            throw new WMSServiceException("Missing REQUEST parameter");
        
        if (request.equals(CAPABILITIES)) 
            return new WMSGetCapabilitiesRequest(req);
        if (request.equals(GETMAP))
            return new WMSGetMapRequest(req);
        if (request.equals(FEATUREINFO))
            return new WMSGetFeatureInfoRequest(req);
        if (request.equals(GETIMAGERYLIST))
            return new WMSGetImageryListRequest(req);
        
        throw new WMSServiceException("Unknown WMS Request: " + request);
    }

    public abstract boolean isValid();
    public abstract String getParseReport();
    public WMSHttpServletRequest getHttpRequest() { return this.request; }
    
    protected WMSRequest(WMSHttpServletRequest request) {
        this.request = request;
    }
    
    private WMSHttpServletRequest request;
}
