/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) Jeremy Harris 2019 */
/* See the file NOTICE for conditions of use and distribution. */
/* SPDX-License-Identifier: GPL-2.0-or-later */

/* Translate an IETF TLS ciphersuite code to an IETF ciphersuite name,
for use when the TLS library do not provide such names.
This file is #included by the tls-<library>.c file.

Values for these tables pulled on 2019/02/03 from
https://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml */



static const uschar * ctb_00[] = {
[0x00] = US "TLS_NULL_WITH_NULL_NULL",
[0x01] = US "TLS_RSA_WITH_NULL_MD5",
[0x02] = US "TLS_RSA_WITH_NULL_SHA",
[0x03] = US "TLS_RSA_EXPORT_WITH_RC4_40_MD5",
[0x04] = US "TLS_RSA_WITH_RC4_128_MD5",
[0x05] = US "TLS_RSA_WITH_RC4_128_SHA",
[0x06] = US "TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5",
[0x07] = US "TLS_RSA_WITH_IDEA_CBC_SHA",
[0x08] = US "TLS_RSA_EXPORT_WITH_DES40_CBC_SHA",
[0x09] = US "TLS_RSA_WITH_DES_CBC_SHA",
[0x0A] = US "TLS_RSA_WITH_3DES_EDE_CBC_SHA",
[0x0B] = US "TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA",
[0x0C] = US "TLS_DH_DSS_WITH_DES_CBC_SHA",
[0x0D] = US "TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA",
[0x0E] = US "TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA",
[0x0F] = US "TLS_DH_RSA_WITH_DES_CBC_SHA",
[0x10] = US "TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA",
[0x11] = US "TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA",
[0x12] = US "TLS_DHE_DSS_WITH_DES_CBC_SHA",
[0x13] = US "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA",
[0x14] = US "TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA",
[0x15] = US "TLS_DHE_RSA_WITH_DES_CBC_SHA",
[0x16] = US "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA",
[0x17] = US "TLS_DH_anon_EXPORT_WITH_RC4_40_MD5",
[0x18] = US "TLS_DH_anon_WITH_RC4_128_MD5",
[0x19] = US "TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA",
[0x1A] = US "TLS_DH_anon_WITH_DES_CBC_SHA",
[0x1B] = US "TLS_DH_anon_WITH_3DES_EDE_CBC_SHA",

[0x1E] = US "TLS_KRB5_WITH_DES_CBC_SHA",
[0x1F] = US "TLS_KRB5_WITH_3DES_EDE_CBC_SHA",
[0x20] = US "TLS_KRB5_WITH_RC4_128_SHA",
[0x21] = US "TLS_KRB5_WITH_IDEA_CBC_SHA",
[0x22] = US "TLS_KRB5_WITH_DES_CBC_MD5",
[0x23] = US "TLS_KRB5_WITH_3DES_EDE_CBC_MD5",
[0x24] = US "TLS_KRB5_WITH_RC4_128_MD5",
[0x25] = US "TLS_KRB5_WITH_IDEA_CBC_MD5",
[0x26] = US "TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA",
[0x27] = US "TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA",
[0x28] = US "TLS_KRB5_EXPORT_WITH_RC4_40_SHA",
[0x29] = US "TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5",
[0x2A] = US "TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5",
[0x2B] = US "TLS_KRB5_EXPORT_WITH_RC4_40_MD5",
[0x2C] = US "TLS_PSK_WITH_NULL_SHA",
[0x2D] = US "TLS_DHE_PSK_WITH_NULL_SHA",
[0x2E] = US "TLS_RSA_PSK_WITH_NULL_SHA",
[0x2F] = US "TLS_RSA_WITH_AES_128_CBC_SHA",
[0x30] = US "TLS_DH_DSS_WITH_AES_128_CBC_SHA",
[0x31] = US "TLS_DH_RSA_WITH_AES_128_CBC_SHA",
[0x32] = US "TLS_DHE_DSS_WITH_AES_128_CBC_SHA",
[0x33] = US "TLS_DHE_RSA_WITH_AES_128_CBC_SHA",
[0x34] = US "TLS_DH_anon_WITH_AES_128_CBC_SHA",
[0x35] = US "TLS_RSA_WITH_AES_256_CBC_SHA",
[0x36] = US "TLS_DH_DSS_WITH_AES_256_CBC_SHA",
[0x37] = US "TLS_DH_RSA_WITH_AES_256_CBC_SHA",
[0x38] = US "TLS_DHE_DSS_WITH_AES_256_CBC_SHA",
[0x39] = US "TLS_DHE_RSA_WITH_AES_256_CBC_SHA",
[0x3A] = US "TLS_DH_anon_WITH_AES_256_CBC_SHA",
[0x3B] = US "TLS_RSA_WITH_NULL_SHA256",
[0x3C] = US "TLS_RSA_WITH_AES_128_CBC_SHA256",
[0x3D] = US "TLS_RSA_WITH_AES_256_CBC_SHA256",
[0x3E] = US "TLS_DH_DSS_WITH_AES_128_CBC_SHA256",
[0x3F] = US "TLS_DH_RSA_WITH_AES_128_CBC_SHA256",
[0x40] = US "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256",
[0x41] = US "TLS_RSA_WITH_CAMELLIA_128_CBC_SHA",
[0x42] = US "TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA",
[0x43] = US "TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA",
[0x44] = US "TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA",
[0x45] = US "TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA",
[0x46] = US "TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA",

[0x67] = US "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256",
[0x68] = US "TLS_DH_DSS_WITH_AES_256_CBC_SHA256",
[0x69] = US "TLS_DH_RSA_WITH_AES_256_CBC_SHA256",
[0x6A] = US "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256",
[0x6B] = US "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256",
[0x6C] = US "TLS_DH_anon_WITH_AES_128_CBC_SHA256",
[0x6D] = US "TLS_DH_anon_WITH_AES_256_CBC_SHA256",

[0x84] = US "TLS_RSA_WITH_CAMELLIA_256_CBC_SHA",
[0x85] = US "TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA",
[0x86] = US "TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA",
[0x87] = US "TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA",
[0x88] = US "TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA",
[0x89] = US "TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA",
[0x8A] = US "TLS_PSK_WITH_RC4_128_SHA",
[0x8B] = US "TLS_PSK_WITH_3DES_EDE_CBC_SHA",
[0x8C] = US "TLS_PSK_WITH_AES_128_CBC_SHA",
[0x8D] = US "TLS_PSK_WITH_AES_256_CBC_SHA",
[0x8E] = US "TLS_DHE_PSK_WITH_RC4_128_SHA",
[0x8F] = US "TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA",
[0x90] = US "TLS_DHE_PSK_WITH_AES_128_CBC_SHA",
[0x91] = US "TLS_DHE_PSK_WITH_AES_256_CBC_SHA",
[0x92] = US "TLS_RSA_PSK_WITH_RC4_128_SHA",
[0x93] = US "TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA",
[0x94] = US "TLS_RSA_PSK_WITH_AES_128_CBC_SHA",
[0x95] = US "TLS_RSA_PSK_WITH_AES_256_CBC_SHA",
[0x96] = US "TLS_RSA_WITH_SEED_CBC_SHA",
[0x97] = US "TLS_DH_DSS_WITH_SEED_CBC_SHA",
[0x98] = US "TLS_DH_RSA_WITH_SEED_CBC_SHA",
[0x99] = US "TLS_DHE_DSS_WITH_SEED_CBC_SHA",
[0x9A] = US "TLS_DHE_RSA_WITH_SEED_CBC_SHA",
[0x9B] = US "TLS_DH_anon_WITH_SEED_CBC_SHA",
[0x9C] = US "TLS_RSA_WITH_AES_128_GCM_SHA256",
[0x9D] = US "TLS_RSA_WITH_AES_256_GCM_SHA384",
[0x9E] = US "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256",
[0x9F] = US "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384",
[0xA0] = US "TLS_DH_RSA_WITH_AES_128_GCM_SHA256",
[0xA1] = US "TLS_DH_RSA_WITH_AES_256_GCM_SHA384",
[0xA2] = US "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256",
[0xA3] = US "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384",
[0xA4] = US "TLS_DH_DSS_WITH_AES_128_GCM_SHA256",
[0xA5] = US "TLS_DH_DSS_WITH_AES_256_GCM_SHA384",
[0xA6] = US "TLS_DH_anon_WITH_AES_128_GCM_SHA256",
[0xA7] = US "TLS_DH_anon_WITH_AES_256_GCM_SHA384",
[0xA8] = US "TLS_PSK_WITH_AES_128_GCM_SHA256",
[0xA9] = US "TLS_PSK_WITH_AES_256_GCM_SHA384",
[0xAA] = US "TLS_DHE_PSK_WITH_AES_128_GCM_SHA256",
[0xAB] = US "TLS_DHE_PSK_WITH_AES_256_GCM_SHA384",
[0xAC] = US "TLS_RSA_PSK_WITH_AES_128_GCM_SHA256",
[0xAD] = US "TLS_RSA_PSK_WITH_AES_256_GCM_SHA384",
[0xAE] = US "TLS_PSK_WITH_AES_128_CBC_SHA256",
[0xAF] = US "TLS_PSK_WITH_AES_256_CBC_SHA384",
[0xB0] = US "TLS_PSK_WITH_NULL_SHA256",
[0xB1] = US "TLS_PSK_WITH_NULL_SHA384",
[0xB2] = US "TLS_DHE_PSK_WITH_AES_128_CBC_SHA256",
[0xB3] = US "TLS_DHE_PSK_WITH_AES_256_CBC_SHA384",
[0xB4] = US "TLS_DHE_PSK_WITH_NULL_SHA256",
[0xB5] = US "TLS_DHE_PSK_WITH_NULL_SHA384",
[0xB6] = US "TLS_RSA_PSK_WITH_AES_128_CBC_SHA256",
[0xB7] = US "TLS_RSA_PSK_WITH_AES_256_CBC_SHA384",
[0xB8] = US "TLS_RSA_PSK_WITH_NULL_SHA256",
[0xB9] = US "TLS_RSA_PSK_WITH_NULL_SHA384",
[0xBA] = US "TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256",
[0xBB] = US "TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256",
[0xBC] = US "TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256",
[0xBD] = US "TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256",
[0xBE] = US "TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256",
[0xBF] = US "TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256",
[0xC0] = US "TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256",
[0xC1] = US "TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256",
[0xC2] = US "TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256",
[0xC3] = US "TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256",
[0xC4] = US "TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256",
[0xC5] = US "TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256",
};
static const uschar * ctb_13[] = {
[0x01] = US "TLS_AES_128_GCM_SHA256",
[0x02] = US "TLS_AES_256_GCM_SHA384",
[0x03] = US "TLS_CHACHA20_POLY1305_SHA256",
[0x04] = US "TLS_AES_128_CCM_SHA256",
[0x05] = US "TLS_AES_128_CCM_8_SHA256",
};
static const uschar * ctb_c0[] = {
[0x01] = US "TLS_ECDH_ECDSA_WITH_NULL_SHA",
[0x02] = US "TLS_ECDH_ECDSA_WITH_RC4_128_SHA",
[0x03] = US "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA",
[0x04] = US "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA",
[0x05] = US "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA",
[0x06] = US "TLS_ECDHE_ECDSA_WITH_NULL_SHA",
[0x07] = US "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA",
[0x08] = US "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA",
[0x09] = US "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA",
[0x0A] = US "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA",
[0x0B] = US "TLS_ECDH_RSA_WITH_NULL_SHA",
[0x0C] = US "TLS_ECDH_RSA_WITH_RC4_128_SHA",
[0x0D] = US "TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA",
[0x0E] = US "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA",
[0x0F] = US "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA",
[0x10] = US "TLS_ECDHE_RSA_WITH_NULL_SHA",
[0x11] = US "TLS_ECDHE_RSA_WITH_RC4_128_SHA",
[0x12] = US "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA",
[0x13] = US "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA",
[0x14] = US "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA",
[0x15] = US "TLS_ECDH_anon_WITH_NULL_SHA",
[0x16] = US "TLS_ECDH_anon_WITH_RC4_128_SHA",
[0x17] = US "TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA",
[0x18] = US "TLS_ECDH_anon_WITH_AES_128_CBC_SHA",
[0x19] = US "TLS_ECDH_anon_WITH_AES_256_CBC_SHA",
[0x1A] = US "TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA",
[0x1B] = US "TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA",
[0x1C] = US "TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA",
[0x1D] = US "TLS_SRP_SHA_WITH_AES_128_CBC_SHA",
[0x1E] = US "TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA",
[0x1F] = US "TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA",
[0x20] = US "TLS_SRP_SHA_WITH_AES_256_CBC_SHA",
[0x21] = US "TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA",
[0x22] = US "TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA",
[0x23] = US "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256",
[0x24] = US "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384",
[0x25] = US "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256",
[0x26] = US "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384",
[0x27] = US "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256",
[0x28] = US "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384",
[0x29] = US "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256",
[0x2A] = US "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384",
[0x2B] = US "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256",
[0x2C] = US "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384",
[0x2D] = US "TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256",
[0x2E] = US "TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384",
[0x2F] = US "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256",
[0x30] = US "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
[0x31] = US "TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256",
[0x32] = US "TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384",
[0x33] = US "TLS_ECDHE_PSK_WITH_RC4_128_SHA",
[0x34] = US "TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA",
[0x35] = US "TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA",
[0x36] = US "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA",
[0x37] = US "TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256",
[0x38] = US "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384",
[0x39] = US "TLS_ECDHE_PSK_WITH_NULL_SHA",
[0x3A] = US "TLS_ECDHE_PSK_WITH_NULL_SHA256",
[0x3B] = US "TLS_ECDHE_PSK_WITH_NULL_SHA384",
[0x3C] = US "TLS_RSA_WITH_ARIA_128_CBC_SHA256",
[0x3D] = US "TLS_RSA_WITH_ARIA_256_CBC_SHA384",
[0x3E] = US "TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256",
[0x3F] = US "TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384",
[0x40] = US "TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256",
[0x41] = US "TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384",
[0x42] = US "TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256",
[0x43] = US "TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384",
[0x44] = US "TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256",
[0x45] = US "TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384",
[0x46] = US "TLS_DH_anon_WITH_ARIA_128_CBC_SHA256",
[0x47] = US "TLS_DH_anon_WITH_ARIA_256_CBC_SHA384",
[0x48] = US "TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256",
[0x49] = US "TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384",
[0x4A] = US "TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256",
[0x4B] = US "TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384",
[0x4C] = US "TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256",
[0x4D] = US "TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384",
[0x4E] = US "TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256",
[0x4F] = US "TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384",
[0x50] = US "TLS_RSA_WITH_ARIA_128_GCM_SHA256",
[0x51] = US "TLS_RSA_WITH_ARIA_256_GCM_SHA384",
[0x52] = US "TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256",
[0x53] = US "TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384",
[0x54] = US "TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256",
[0x55] = US "TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384",
[0x56] = US "TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256",
[0x57] = US "TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384",
[0x58] = US "TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256",
[0x59] = US "TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384",
[0x5A] = US "TLS_DH_anon_WITH_ARIA_128_GCM_SHA256",
[0x5B] = US "TLS_DH_anon_WITH_ARIA_256_GCM_SHA384",
[0x5C] = US "TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256",
[0x5D] = US "TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384",
[0x5E] = US "TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256",
[0x5F] = US "TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384",
[0x60] = US "TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256",
[0x61] = US "TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384",
[0x62] = US "TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256",
[0x63] = US "TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384",
[0x64] = US "TLS_PSK_WITH_ARIA_128_CBC_SHA256",
[0x65] = US "TLS_PSK_WITH_ARIA_256_CBC_SHA384",
[0x66] = US "TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256",
[0x67] = US "TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384",
[0x68] = US "TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256",
[0x69] = US "TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384",
[0x6A] = US "TLS_PSK_WITH_ARIA_128_GCM_SHA256",
[0x6B] = US "TLS_PSK_WITH_ARIA_256_GCM_SHA384",
[0x6C] = US "TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256",
[0x6D] = US "TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384",
[0x6E] = US "TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256",
[0x6F] = US "TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384",
[0x70] = US "TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256",
[0x71] = US "TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384",
[0x72] = US "TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256",
[0x73] = US "TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384",
[0x74] = US "TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256",
[0x75] = US "TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384",
[0x76] = US "TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256",
[0x77] = US "TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384",
[0x78] = US "TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256",
[0x79] = US "TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384",
[0x7A] = US "TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256",
[0x7B] = US "TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384",
[0x7C] = US "TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256",
[0x7D] = US "TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384",
[0x7E] = US "TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256",
[0x7F] = US "TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384",
[0x80] = US "TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256",
[0x81] = US "TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384",
[0x82] = US "TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256",
[0x83] = US "TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384",
[0x84] = US "TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256",
[0x85] = US "TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384",
[0x86] = US "TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256",
[0x87] = US "TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384",
[0x88] = US "TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256",
[0x89] = US "TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384",
[0x8A] = US "TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256",
[0x8B] = US "TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384",
[0x8C] = US "TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256",
[0x8D] = US "TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384",
[0x8E] = US "TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256",
[0x8F] = US "TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384",
[0x90] = US "TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256",
[0x91] = US "TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384",
[0x92] = US "TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256",
[0x93] = US "TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384",
[0x94] = US "TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256",
[0x95] = US "TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384",
[0x96] = US "TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256",
[0x97] = US "TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384",
[0x98] = US "TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256",
[0x99] = US "TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384",
[0x9A] = US "TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256",
[0x9B] = US "TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384",
[0x9C] = US "TLS_RSA_WITH_AES_128_CCM",
[0x9D] = US "TLS_RSA_WITH_AES_256_CCM",
[0x9E] = US "TLS_DHE_RSA_WITH_AES_128_CCM",
[0x9F] = US "TLS_DHE_RSA_WITH_AES_256_CCM",
[0xA0] = US "TLS_RSA_WITH_AES_128_CCM_8",
[0xA1] = US "TLS_RSA_WITH_AES_256_CCM_8",
[0xA2] = US "TLS_DHE_RSA_WITH_AES_128_CCM_8",
[0xA3] = US "TLS_DHE_RSA_WITH_AES_256_CCM_8",
[0xA4] = US "TLS_PSK_WITH_AES_128_CCM",
[0xA5] = US "TLS_PSK_WITH_AES_256_CCM",
[0xA6] = US "TLS_DHE_PSK_WITH_AES_128_CCM",
[0xA7] = US "TLS_DHE_PSK_WITH_AES_256_CCM",
[0xA8] = US "TLS_PSK_WITH_AES_128_CCM_8",
[0xA9] = US "TLS_PSK_WITH_AES_256_CCM_8",
[0xAA] = US "TLS_PSK_DHE_WITH_AES_128_CCM_8",
[0xAB] = US "TLS_PSK_DHE_WITH_AES_256_CCM_8",
[0xAC] = US "TLS_ECDHE_ECDSA_WITH_AES_128_CCM",
[0xAD] = US "TLS_ECDHE_ECDSA_WITH_AES_256_CCM",
[0xAE] = US "TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8",
[0xAF] = US "TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8",
[0xB0] = US "TLS_ECCPWD_WITH_AES_128_GCM_SHA256",
[0xB1] = US "TLS_ECCPWD_WITH_AES_256_GCM_SHA384",
[0xB2] = US "TLS_ECCPWD_WITH_AES_128_CCM_SHA256",
[0xB3] = US "TLS_ECCPWD_WITH_AES_256_CCM_SHA384",
[0xB4] = US "TLS_SHA256_SHA256",
[0xB5] = US "TLS_SHA384_SHA384",
};
static const uschar * ctb_cc[] = {
[0xA8] = US "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256",
[0xA9] = US "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256",
[0xAA] = US "TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256",
[0xAB] = US "TLS_PSK_WITH_CHACHA20_POLY1305_SHA256",
[0xAC] = US "TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256",
[0xAD] = US "TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256",
[0xAE] = US "TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256",
};
static const uschar * ctb_d0[] = {
[0x01] = US "TLS_ECDHE_PSK_WITH_AES_128_GCM_SHA256",
[0x02] = US "TLS_ECDHE_PSK_WITH_AES_256_GCM_SHA384",
[0x03] = US "TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256",

[0x05] = US "TLS_ECDHE_PSK_WITH_AES_128_CCM_SHA256",
};

static const uschar *
cipher_stdname_tb(uschar idx, const uschar ** tb, int lim)
{
return idx >= lim ? NULL : tb[idx];
}

static const uschar *
cipher_stdname(uschar id0, uschar id1)
{
switch (id0)
  {
  case 0x00:	return cipher_stdname_tb(id1, ctb_00, nelem(ctb_00));
  case 0x13:	return cipher_stdname_tb(id1, ctb_13, nelem(ctb_00));
  case 0xc0:	return cipher_stdname_tb(id1, ctb_c0, nelem(ctb_c0));
  case 0xcc:	return cipher_stdname_tb(id1, ctb_cc, nelem(ctb_cc));
  case 0xd0:	return cipher_stdname_tb(id1, ctb_d0, nelem(ctb_d0));
  default:	return NULL;
  }
}

/* vi: aw ai sw=2
*/
/* End of tls-cipher-stdname.c */
