#ifndef HAVE_DEFINE_VEC_SAT_DATA_H
#define HAVE_DEFINE_VEC_SAT_DATA_H

#define N 16
#define TEST_UNARY_DATA(T, NAME) test_##T##_##NAME##_data
#define TEST_UNARY_DATA_WRAP(T, NAME) TEST_UNARY_DATA(T, NAME)
#define TEST_UNARY_STRUCT_NAME(T1, T2) test_##T1##_##T2##_s
#define TEST_UNARY_STRUCT_DECL(T1, T2) struct TEST_UNARY_STRUCT_NAME(T1, T2)
#define TEST_UNARY_STRUCT(T1, T2)       \
  struct TEST_UNARY_STRUCT_NAME(T1, T2) \
    {                                   \
      T2 in[N];                         \
      T1 expect[N];                     \
      T1 out[N];                        \
    };

TEST_UNARY_STRUCT(uint8_t, uint16_t)
TEST_UNARY_STRUCT(uint8_t, uint32_t)
TEST_UNARY_STRUCT(uint8_t, uint64_t)

TEST_UNARY_STRUCT(uint16_t, uint32_t)
TEST_UNARY_STRUCT(uint16_t, uint64_t)

TEST_UNARY_STRUCT(uint32_t, uint64_t)

TEST_UNARY_STRUCT(int8_t, int16_t)
TEST_UNARY_STRUCT(int8_t, int32_t)
TEST_UNARY_STRUCT(int8_t, int64_t)

TEST_UNARY_STRUCT(int16_t, int32_t)
TEST_UNARY_STRUCT(int16_t, int64_t)

TEST_UNARY_STRUCT(int32_t, int64_t)

uint8_t TEST_UNARY_DATA(uint8_t, sat_u_add_imm)[][2][N] =
{
  { /* For add imm 0 */
    {
      0, 1, 5, 255,
      0, 1, 5, 255,
      0, 1, 5, 255,
      0, 1, 5, 255,
    },
    {
      0, 1, 5, 255,
      0, 1, 5, 255,
      0, 1, 5, 255,
      0, 1, 5, 255,
    },
  },
  { /* For add imm 1 */
    {
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
    },
    {
      1, 2, 1, 9,
      1, 2, 1, 9,
      1, 2, 1, 9,
      1, 2, 1, 9,
    },
  },
  { /* For add imm 254 */
    {
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
    },
    {
      254, 255, 254, 255,
      254, 255, 254, 255,
      254, 255, 254, 255,
      254, 255, 254, 255,
    },
  },
  { /* For add imm 255 */
    {
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
    },
    {
      255, 255, 255, 255,
      255, 255, 255, 255,
      255, 255, 255, 255,
      255, 255, 255, 255,
    },
  },
};

uint16_t TEST_UNARY_DATA(uint16_t, sat_u_add_imm)[][2][N] =
{
  { /* For add imm 0 */
    {
      0, 1, 5, 65535,
      0, 1, 5, 65535,
      0, 1, 5, 65535,
      0, 1, 5, 65535,
    },
    {
      0, 1, 5, 65535,
      0, 1, 5, 65535,
      0, 1, 5, 65535,
      0, 1, 5, 65535,
    },
  },
  { /* For add imm 1 */
    {
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
    },
    {
      1, 2, 1, 9,
      1, 2, 1, 9,
      1, 2, 1, 9,
      1, 2, 1, 9,
    },
  },
  { /* For add imm 65534 */
    {
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
    },
    {
      65534, 65535, 65534, 65535,
      65534, 65535, 65534, 65535,
      65534, 65535, 65534, 65535,
      65534, 65535, 65534, 65535,
    },
  },
  { /* For add imm 65535 */
    {
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
    },
    {
      65535, 65535, 65535, 65535,
      65535, 65535, 65535, 65535,
      65535, 65535, 65535, 65535,
      65535, 65535, 65535, 65535,
    },
  },
};

uint32_t TEST_UNARY_DATA(uint32_t, sat_u_add_imm)[][2][N] =
{
  { /* For add imm 0 */
    {
      0, 1, 5, 4294967295,
      0, 1, 5, 4294967295,
      0, 1, 5, 4294967295,
      0, 1, 5, 4294967295,
    },
    {
      0, 1, 5, 4294967295,
      0, 1, 5, 4294967295,
      0, 1, 5, 4294967295,
      0, 1, 5, 4294967295,
    },
  },
  { /* For add imm 1 */
    {
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
    },
    {
      1, 2, 1, 9,
      1, 2, 1, 9,
      1, 2, 1, 9,
      1, 2, 1, 9,
    },
  },
  { /* For add imm 4294967294 */
    {
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
    },
    {
      4294967294, 4294967295, 4294967294, 4294967295,
      4294967294, 4294967295, 4294967294, 4294967295,
      4294967294, 4294967295, 4294967294, 4294967295,
      4294967294, 4294967295, 4294967294, 4294967295,
    },
  },
  { /* For add imm 4294967295 */
    {
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
    },
    {
      4294967295, 4294967295, 4294967295, 4294967295,
      4294967295, 4294967295, 4294967295, 4294967295,
      4294967295, 4294967295, 4294967295, 4294967295,
      4294967295, 4294967295, 4294967295, 4294967295,
    },
  },
};

uint64_t TEST_UNARY_DATA(uint64_t, sat_u_add_imm)[][2][N] =
{
  { /* For add imm 0 */
    {
      0, 1, 5, 18446744073709551615u,
      0, 1, 5, 18446744073709551615u,
      0, 1, 5, 18446744073709551615u,
      0, 1, 5, 18446744073709551615u,
    },
    {
      0, 1, 5, 18446744073709551615u,
      0, 1, 5, 18446744073709551615u,
      0, 1, 5, 18446744073709551615u,
      0, 1, 5, 18446744073709551615u,
    },
  },
  { /* For add imm 1 */
    {
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
    },
    {
      1, 2, 1, 9,
      1, 2, 1, 9,
      1, 2, 1, 9,
      1, 2, 1, 9,
    },
  },
  { /* For add imm 18446744073709551614 */
    {
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
    },
    {
      18446744073709551614u, 18446744073709551615u,
      18446744073709551614u, 18446744073709551615u,
      18446744073709551614u, 18446744073709551615u,
      18446744073709551614u, 18446744073709551615u,
      18446744073709551614u, 18446744073709551615u,
      18446744073709551614u, 18446744073709551615u,
      18446744073709551614u, 18446744073709551615u,
      18446744073709551614u, 18446744073709551615u,
    },
  },
  { /* For add imm 18446744073709551615 */
    {
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
      0, 1, 0, 8,
    },
    {
      18446744073709551615u, 18446744073709551615u,
      18446744073709551615u, 18446744073709551615u,
      18446744073709551615u, 18446744073709551615u,
      18446744073709551615u, 18446744073709551615u,
      18446744073709551615u, 18446744073709551615u,
      18446744073709551615u, 18446744073709551615u,
      18446744073709551615u, 18446744073709551615u,
      18446744073709551615u, 18446744073709551615u,
    },
  },
};

uint8_t TEST_UNARY_DATA(uint8_t, sat_u_sub_imm)[][2][N] =
{
  { /* For sub form1 & form3 imm 0 */
    {
      0, 1, 5, 255,
      0, 1, 5, 255,
      0, 1, 5, 255,
      0, 1, 5, 255,
    },
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
  },
  { /* For sub form1 & form3 imm 1 */
    {
      0, 1, 2, 8,
      0, 1, 2, 8,
      0, 1, 2, 8,
      0, 1, 2, 8,
    },
    {
      1, 0, 0, 0,
      1, 0, 0, 0,
      1, 0, 0, 0,
      1, 0, 0, 0,
    },
  },
  { /* For sub form1 & form3 imm 254 */
    {
      0, 1, 254, 255,
      0, 1, 254, 255,
      0, 1, 254, 255,
      0, 1, 254, 255,
    },
    {
      254, 253, 0, 0,
      254, 253, 0, 0,
      254, 253, 0, 0,
      254, 253, 0, 0,
    },
  },
  { /* For sub form1 & form3 imm 255 */
    {
      0, 1, 5, 255,
      0, 1, 5, 255,
      0, 1, 5, 255,
      0, 1, 5, 255,
    },
    {
      255, 254, 250, 0,
      255, 254, 250, 0,
      255, 254, 250, 0,
      255, 254, 250, 0,
    },
  },
  { /* For sub form2 & form4 imm 0 */
    {
      0, 1, 5, 255,
      0, 1, 5, 255,
      0, 1, 5, 255,
      0, 1, 5, 255,
    },
    {
      0, 1, 5, 255,
      0, 1, 5, 255,
      0, 1, 5, 255,
      0, 1, 5, 255,
    },
  },
  { /* For sub form2 & form4 imm 1 */
    {
      0, 1, 2, 8,
      0, 1, 2, 8,
      0, 1, 2, 8,
      0, 1, 2, 8,
    },
    {
      0, 0, 1, 7,
      0, 0, 1, 7,
      0, 0, 1, 7,
      0, 0, 1, 7,
    },
  },
  { /* For sub form2 & form4 imm 254 */
    {
      0, 1, 254, 255,
      0, 1, 254, 255,
      0, 1, 254, 255,
      0, 1, 254, 255,
    },
    {
      0, 0, 0, 1,
      0, 0, 0, 1,
      0, 0, 0, 1,
      0, 0, 0, 1,
    },
  },
  { /* For sub form2 & form4 imm 255 */
    {
      0, 1, 5, 255,
      0, 1, 5, 255,
      0, 1, 5, 255,
      0, 1, 5, 255,
    },
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
  },
};

uint16_t TEST_UNARY_DATA(uint16_t, sat_u_sub_imm)[][2][N] =
{
  { /* For sub form1 & form3 imm 0 */
    {
      0, 1, 5, 65535,
      0, 1, 5, 65535,
      0, 1, 5, 65535,
      0, 1, 5, 65535,
    },
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
  },
  { /* For sub form1 & form3 imm 1 */
    {
      0, 1, 5, 8,
      0, 1, 5, 8,
      0, 1, 5, 8,
      0, 1, 5, 8,
    },
    {
      1, 0, 0, 0,
      1, 0, 0, 0,
      1, 0, 0, 0,
      1, 0, 0, 0,
    },
  },
  { /* For sub form1 & form3 imm 65534 */
    {
      0, 1, 65534, 65535,
      0, 1, 65534, 65535,
      0, 1, 65534, 65535,
      0, 1, 65534, 65535,
    },
    {
      65534, 65533, 0, 0,
      65534, 65533, 0, 0,
      65534, 65533, 0, 0,
      65534, 65533, 0, 0,
    },
  },
  { /* For sub form1 & form3 imm 65535 */
    {
      0, 1, 65534, 65535,
      0, 1, 65534, 65535,
      0, 1, 65534, 65535,
      0, 1, 65534, 65535,
    },
    {
      65535, 65534, 1, 0,
      65535, 65534, 1, 0,
      65535, 65534, 1, 0,
      65535, 65534, 1, 0,
    },
  },
  { /* For sub form2 & form4 imm 0 */
    {
      0, 1, 5, 65535,
      0, 1, 5, 65535,
      0, 1, 5, 65535,
      0, 1, 5, 65535,
    },
    {
      0, 1, 5, 65535,
      0, 1, 5, 65535,
      0, 1, 5, 65535,
      0, 1, 5, 65535,
    },
  },
  { /* For sub form2 & form4 imm 1 */
    {
      0, 1, 5, 8,
      0, 1, 5, 8,
      0, 1, 5, 8,
      0, 1, 5, 8,
    },
    {
      0, 0, 4, 7,
      0, 0, 4, 7,
      0, 0, 4, 7,
      0, 0, 4, 7,
    },
  },
  { /* For sub form2 & form4 imm 65534 */
    {
      0, 1, 65534, 65535,
      0, 1, 65534, 65535,
      0, 1, 65534, 65535,
      0, 1, 65534, 65535,
    },
    {
      0, 0, 0, 1,
      0, 0, 0, 1,
      0, 0, 0, 1,
      0, 0, 0, 1,
    },
  },
  { /* For sub form2 & form4 imm 65535 */
    {
      0, 1, 65534, 65535,
      0, 1, 65534, 65535,
      0, 1, 65534, 65535,
      0, 1, 65534, 65535,
    },
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
  },
};

uint32_t TEST_UNARY_DATA(uint32_t, sat_u_sub_imm)[][2][N] =
{
  { /* For sub form1 & form3 imm 0 */
    {
      0, 1, 5, 4294967295,
      0, 1, 5, 4294967295,
      0, 1, 5, 4294967295,
      0, 1, 5, 4294967295,
    },
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
  },
  { /* For sub form1 & form3 imm 1 */
    {
      0, 1, 5, 8,
      0, 1, 5, 8,
      0, 1, 5, 8,
      0, 1, 5, 8,
    },
    {
      1, 0, 0, 0,
      1, 0, 0, 0,
      1, 0, 0, 0,
      1, 0, 0, 0,
    },
  },
  { /* For sub form1 & form3 imm 4294967294 */
    {
      0, 1, 4294967294, 4294967295,
      0, 1, 4294967294, 4294967295,
      0, 1, 4294967294, 4294967295,
      0, 1, 4294967294, 4294967295,
    },
    {
      4294967294, 4294967293, 0, 0,
      4294967294, 4294967293, 0, 0,
      4294967294, 4294967293, 0, 0,
      4294967294, 4294967293, 0, 0,
    },
  },
  { /* For sub form1 & form3 imm 4294967295 */
    {
      0, 1, 4294967294, 4294967295,
      0, 1, 4294967294, 4294967295,
      0, 1, 4294967294, 4294967295,
      0, 1, 4294967294, 4294967295,
    },
    {
      4294967295, 4294967294, 1, 0,
      4294967295, 4294967294, 1, 0,
      4294967295, 4294967294, 1, 0,
      4294967295, 4294967294, 1, 0,
    },
  },
  { /* For sub form2 & form4 imm 0 */
    {
      0, 1, 5, 4294967295,
      0, 1, 5, 4294967295,
      0, 1, 5, 4294967295,
      0, 1, 5, 4294967295,
    },
    {
      0, 1, 5, 4294967295,
      0, 1, 5, 4294967295,
      0, 1, 5, 4294967295,
      0, 1, 5, 4294967295,
    },
  },
  { /* For sub form2 & form4 imm 1 */
    {
      0, 1, 5, 8,
      0, 1, 5, 8,
      0, 1, 5, 8,
      0, 1, 5, 8,
    },
    {
      0, 0, 4, 7,
      0, 0, 4, 7,
      0, 0, 4, 7,
      0, 0, 4, 7,
    },
  },
  { /* For sub form2 & form4 imm 4294967294 */
    {
      0, 1, 4294967294, 4294967295,
      0, 1, 4294967294, 4294967295,
      0, 1, 4294967294, 4294967295,
      0, 1, 4294967294, 4294967295,
    },
    {
      0, 0, 0, 1,
      0, 0, 0, 1,
      0, 0, 0, 1,
      0, 0, 0, 1,
    },
  },
  { /* For sub form2 & form4 imm 4294967295 */
    {
      0, 1, 4294967294, 4294967295,
      0, 1, 4294967294, 4294967295,
      0, 1, 4294967294, 4294967295,
      0, 1, 4294967294, 4294967295,
    },
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
  },
};

uint64_t TEST_UNARY_DATA(uint64_t, sat_u_sub_imm)[][2][N] =
{
  { /* For sub form1 & form3 imm 0 */
    {
      0, 1, 5, 18446744073709551615u,
      0, 1, 5, 18446744073709551615u,
      0, 1, 5, 18446744073709551615u,
      0, 1, 5, 18446744073709551615u,
    },
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
  },
  { /* For sub form1 & form3 imm 1 */
    {
      0, 1, 5, 8,
      0, 1, 5, 8,
      0, 1, 5, 8,
      0, 1, 5, 8,
    },
    {
      1, 0, 0, 0,
      1, 0, 0, 0,
      1, 0, 0, 0,
      1, 0, 0, 0,
    },
  },
  { /* For sub form1 & form3 imm 18446744073709551614 */
    {
      0, 1, 18446744073709551614u, 18446744073709551615u,
      0, 1, 18446744073709551614u, 18446744073709551615u,
      0, 1, 18446744073709551614u, 18446744073709551615u,
      0, 1, 18446744073709551614u, 18446744073709551615u,
    },
    {
      18446744073709551614u, 18446744073709551613u, 0, 0,
      18446744073709551614u, 18446744073709551613u, 0, 0,
      18446744073709551614u, 18446744073709551613u, 0, 0,
      18446744073709551614u, 18446744073709551613u, 0, 0,
    },
  },
  { /* For sub form1 & form3 imm 18446744073709551615 */
    {
      0, 1, 18446744073709551614u, 18446744073709551615u,
      0, 1, 18446744073709551614u, 18446744073709551615u,
      0, 1, 18446744073709551614u, 18446744073709551615u,
      0, 1, 18446744073709551614u, 18446744073709551615u,
    },
    {
      18446744073709551615u, 18446744073709551614u, 1, 0,
      18446744073709551615u, 18446744073709551614u, 1, 0,
      18446744073709551615u, 18446744073709551614u, 1, 0,
      18446744073709551615u, 18446744073709551614u, 1, 0,
    },
  },
  { /* For sub form2 & form4 imm 0 */
    {
      0, 1, 5, 18446744073709551615u,
      0, 1, 5, 18446744073709551615u,
      0, 1, 5, 18446744073709551615u,
      0, 1, 5, 18446744073709551615u,
    },
    {
      0, 1, 5, 18446744073709551615u,
      0, 1, 5, 18446744073709551615u,
      0, 1, 5, 18446744073709551615u,
      0, 1, 5, 18446744073709551615u,
    },
  },
  { /* For sub form2 & form4 imm 1 */
    {
      0, 1, 5, 8,
      0, 1, 5, 8,
      0, 1, 5, 8,
      0, 1, 5, 8,
    },
    {
      0, 0, 4, 7,
      0, 0, 4, 7,
      0, 0, 4, 7,
      0, 0, 4, 7,
    },
  },
  { /* For sub form2 & form4 imm 18446744073709551614 */
    {
      0, 1, 18446744073709551614u, 18446744073709551615u,
      0, 1, 18446744073709551614u, 18446744073709551615u,
      0, 1, 18446744073709551614u, 18446744073709551615u,
      0, 1, 18446744073709551614u, 18446744073709551615u,
    },
    {
      0, 0, 0, 1,
      0, 0, 0, 1,
      0, 0, 0, 1,
      0, 0, 0, 1,
    },
  },
  { /* For sub form2 & form4 imm 18446744073709551615 */
    {
      0, 1, 18446744073709551614u, 18446744073709551615u,
      0, 1, 18446744073709551614u, 18446744073709551615u,
      0, 1, 18446744073709551614u, 18446744073709551615u,
      0, 1, 18446744073709551614u, 18446744073709551615u,
    },
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
  },
};

#define TEST_BINARY_DATA_NAME(T1, T2, NAME) test_bin_##T1##_##T2##_##NAME##_data
#define TEST_BINARY_DATA_NAME_WRAP(T1, T2, NAME) \
  TEST_BINARY_DATA_NAME(T1, T2, NAME)

#define TEST_ZIP_STRUCT_NAME(T1, T2) test_##T1##_##T2##_zip_s
#define TEST_ZIP_STRUCT_DECL(T1, T2) struct TEST_ZIP_STRUCT_NAME(T1, T2)
#define TEST_ZIP_STRUCT(T1, T2) \
  TEST_ZIP_STRUCT_DECL(T1, T2)  \
    {                           \
      T1 x[N];                  \
      T2 b;                     \
      T1 expect[N];             \
    };

TEST_ZIP_STRUCT (uint16_t, uint32_t)

TEST_ZIP_STRUCT_DECL(uint16_t, uint32_t) \
  TEST_BINARY_DATA_NAME(uint16_t, uint32_t, zip)[] =
{
  {
    { /* x.  */
      1, 1, 1, 1,
      1, 1, 1, 1,
      1, 1, 1, 1,
      0, 0, 0, 0,
    },
    1, /* b.  */
    { /* expect.  */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
  },
  {
    { /* x.  */
      65535, 1, 2, 8,
      65535, 1, 2, 8,
      65535, 1, 2, 8,
      65535, 1, 2, 8,
    },
    65536, /* b.  */
    { /* expect.  */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
  },
  {
    { /* x.  */
      65535, 16, 8, 1,
      65535, 16, 8, 1,
      65535, 16, 8, 1,
      65535, 16, 8, 1,
    },
    65535, /* b.  */
    { /* expect.  */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
  },
  {
    { /* x.  */
      65535, 16, 8, 1,
      65535, 16, 8, 1,
      65535, 16, 8, 1,
      65535, 16, 8, 1,
    },
    65500, /* b.  */
    { /* expect.  */
      35, 0, 0, 0,
      35, 0, 0, 0,
      35, 0, 0, 0,
      35, 0, 0, 0,
    },
  },
};

int8_t TEST_BINARY_DATA_NAME(int8_t, int8_t, ssadd)[][3][N] = 
{
  {
    {
        0,   0,   0,   0,
        2,   2,   2,   2,
      126, 126, 126, 126,
      127, 127, 127, 127,
    },
    {
        0,   0,   0,   0,
        2,   2,   2,   2,
        1,   1,   1,   1,
        1,   1,   1,   1,
    },
    {
        0,   0,   0,   0,
        4,   4,   4,   4,
      127, 127, 127, 127,
      127, 127, 127, 127,
    },
  },

  {
    {
        -7,   -7,   -7,   -7,
      -128, -128, -128, -128,
      -127, -127, -127, -127,
      -128, -128, -128, -128,
    },
    {
        -4,   -4,   -4,   -4,
        -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,
      -128, -128, -128, -128,
    },
    {
       -11,  -11,  -11,  -11,
      -128, -128, -128, -128,
      -128, -128, -128, -128,
      -128, -128, -128, -128,
    },
  },

  {
    {
      -128, -128, -128, -128,
      -127, -127, -127, -127,
      -122, -122, -122, -122,
      -122, -122, -122, -122,
    },
    {
       127,  127,  127,  127,
       127,  127,  127,  127,
       105,  105,  105,  105,
       125,  125,  125,  125,
    },
    {
        -1,   -1,   -1,   -1,
         0,    0,    0,    0,
       -17,  -17,  -17,  -17,
         3,    3,    3,    3,
    },
  },
};

int16_t TEST_BINARY_DATA_NAME(int16_t, int16_t, ssadd)[][3][N] = 
{
  {
    {
          0,     0,     0,     0,
          2,     2,     2,     2,
      32766, 32766, 32766, 32766,
      32767, 32767, 32767, 32767,
    },
    {
          0,     0,     0,     0,
          2,     2,     2,     2,
          1,     1,     1,     1,
          1,     1,     1,     1,
    },
    {
          0,     0,     0,     0,
          4,     4,     4,     4,
      32767, 32767, 32767, 32767,
      32767, 32767, 32767, 32767,
    },
  },

  {
    {
          -7,     -7,     -7,     -7,
      -32768, -32768, -32768, -32768,
      -32767, -32767, -32767, -32767,
      -32768, -32768, -32768, -32768,
    },
    {
          -4,     -4,     -4,     -4,
          -1,     -1,     -1,     -1,
          -1,     -1,     -1,     -1,
      -32768, -32768, -32768, -32768,
    },
    {
         -11,    -11,    -11,    -11,
      -32768, -32768, -32768, -32768,
      -32768, -32768, -32768, -32768,
      -32768, -32768, -32768, -32768,
    },
  },

  {
    {
      -32768, -32768, -32768, -32768,
      -32767, -32767, -32767, -32767,
      -32762, -32762, -32762, -32762,
      -32762, -32762, -32762, -32762,
    },
    {
       32767,  32767,  32767,  32767,
       32767,  32767,  32767,  32767,
       32745,  32745,  32745,  32745,
       32765,  32765,  32765,  32765,
    },
    {
          -1,     -1,     -1,     -1,
           0,      0,      0,      0,
         -17,    -17,    -17,    -17,
           3,      3,      3,      3,
    },
  },
};

int32_t TEST_BINARY_DATA_NAME(int32_t, int32_t, ssadd)[][3][N] = 
{
  {
    {
               0,          0,          0,          0,
               2,          2,          2,          2,
      2147483646, 2147483646, 2147483646, 2147483646,
      2147483647, 2147483647, 2147483647, 2147483647,
    },
    {
               0,          0,          0,          0,
               2,          2,          2,          2,
               1,          1,          1,          1,
               1,          1,          1,          1,
    },
    {
               0,          0,          0,          0,
               4,          4,          4,          4,
      2147483647, 2147483647, 2147483647, 2147483647,
      2147483647, 2147483647, 2147483647, 2147483647,
    },
  },

  {
    {
               -7,          -7,          -7,          -7,
      -2147483648, -2147483648, -2147483648, -2147483648,
      -2147483647, -2147483647, -2147483647, -2147483647,
      -2147483648, -2147483648, -2147483648, -2147483648,
    },
    {
               -4,          -4,          -4,          -4,
               -1,          -1,          -1,          -1,
               -1,          -1,          -1,          -1,
      -2147483648, -2147483648, -2147483648, -2147483648,
    },
    {
              -11,         -11,         -11,         -11,
      -2147483648, -2147483648, -2147483648, -2147483648,
      -2147483648, -2147483648, -2147483648, -2147483648,
      -2147483648, -2147483648, -2147483648, -2147483648,
    },
  },

  {
    {
      -2147483648, -2147483648, -2147483648, -2147483648,
      -2147483647, -2147483647, -2147483647, -2147483647,
      -2147483642, -2147483642, -2147483642, -2147483642,
      -2147483642, -2147483642, -2147483642, -2147483642,
    },
    {
       2147483647,  2147483647,  2147483647,  2147483647,
       2147483647,  2147483647,  2147483647,  2147483647,
       2147483625,  2147483625,  2147483625,  2147483625,
       2147483645,  2147483645,  2147483645,  2147483645,
    },
    {
               -1,          -1,          -1,          -1,
                0,           0,           0,           0,
              -17,         -17,         -17,         -17,
                3,           3,           3,           3,
    },
  },
};

int64_t TEST_BINARY_DATA_NAME(int64_t, int64_t, ssadd)[][3][N] = 
{
  {
    {
                          0,                     0,                     0,                     0,
                          2,                     2,                     2,                     2,
      9223372036854775806ll, 9223372036854775806ll, 9223372036854775806ll, 9223372036854775806ll,
      9223372036854775807ll, 9223372036854775807ll, 9223372036854775807ll, 9223372036854775807ll,
    },
    {
                          0,                     0,                     0,                     0,
                          2,                     2,                     2,                     2,
                          1,                     1,                     1,                     1,
                          1,                     1,                     1,                     1,
    },
    {
                          0,                     0,                     0,                     0,
                          4,                     4,                     4,                     4,
      9223372036854775807ll, 9223372036854775807ll, 9223372036854775807ll, 9223372036854775807ll,
      9223372036854775807ll, 9223372036854775807ll, 9223372036854775807ll, 9223372036854775807ll,
    },
  },

  {
    {
                           -7,                      -7,                      -7,                      -7,
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
       -9223372036854775807ll,  -9223372036854775807ll,  -9223372036854775807ll,  -9223372036854775807ll,
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
    },
    {
                           -4,                      -4,                      -4,                      -4,
                           -1,                      -1,                      -1,                      -1,
                           -1,                      -1,                      -1,                      -1,
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
    },
    {
                          -11,                     -11,                     -11,                     -11,
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
    },
  },

  {
    {
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
       -9223372036854775807ll,  -9223372036854775807ll,  -9223372036854775807ll,  -9223372036854775807ll,
       -9223372036854775802ll,  -9223372036854775802ll,  -9223372036854775802ll,  -9223372036854775802ll,
       -9223372036854775802ll,  -9223372036854775802ll,  -9223372036854775802ll,  -9223372036854775802ll,
    },
    {
       9223372036854775807ll,  9223372036854775807ll,  9223372036854775807ll,  9223372036854775807ll,
       9223372036854775807ll,  9223372036854775807ll,  9223372036854775807ll,  9223372036854775807ll,
       9223372036854775785ll,  9223372036854775785ll,  9223372036854775785ll,  9223372036854775785ll,
       9223372036854775805ll,  9223372036854775805ll,  9223372036854775805ll,  9223372036854775805ll,
    },
    {
                          -1,                     -1,                     -1,                     -1,
                           0,                      0,                      0,                      0,
                         -17,                    -17,                    -17,                    -17,
                           3,                      3,                      3,                      3,
    },
  },
};

int8_t TEST_BINARY_DATA_NAME(int8_t, int8_t, sssub)[][3][N] =
{
  {
    {
         0,    0,    0,    0,
         2,    2,    2,    2,
       126,  126,  126,  126,
       127,  127,  127,  127,
    },
    {
         0,    0,    0,    0,
         4,    4,    4,    4,
        -2,   -2,   -2,   -2,
      -127, -127, -127, -127,
    },
    {
         0,    0,    0,    0,
        -2,   -2,   -2,   -2,
       127,  127,  127,  127,
       127,  127,  127,  127,
    },
  },

  {
    {
        -7,   -7,   -7,   -7,
      -128, -128, -128, -128,
      -127, -127, -127, -127,
      -128, -128, -128, -128,
    },
    {
        -4,   -4,   -4,   -4,
         1,    1,    1,    1,
         1,    1,    1,    1,
       127,  127,  127,  127,
    },
    {
        -3,   -3,   -3,   -3,
      -128, -128, -128, -128,
      -128, -128, -128, -128,
      -128, -128, -128, -128,
    },
  },

  {
    {
      -128, -128, -128, -128,
       127,  127,  127,  127,
      -125, -125, -125, -125,
       126,  126,  126,  126,
    },
    {
       127,  127,  127,  127,
      -127, -127, -127, -127,
      -127, -127, -127, -127,
       127,  127,  127,  127,
    },
    {
      -128, -128, -128, -128,
       127,  127,  127,  127,
         2,    2,    2,    2,
        -1,   -1,   -1,   -1,
    },
  },
};

int16_t TEST_BINARY_DATA_NAME(int16_t, int16_t, sssub)[][3][N] =
{
  {
    {
           0,      0,      0,      0,
           2,      2,      2,      2,
       32766,  32766,  32766,  32766,
       32767,  32767,  32767,  32767,
    },
    {
           0,      0,      0,      0,
           4,      4,      4,      4,
          -2,     -2,     -2,     -2,
      -32767, -32767, -32767, -32767,
    },
    {
           0,      0,      0,      0,
          -2,     -2,     -2,     -2,
       32767,  32767,  32767,  32767,
       32767,  32767,  32767,  32767,
    },
  },

  {
    {
          -7,     -7,     -7,     -7,
      -32768, -32768, -32768, -32768,
      -32767, -32767, -32767, -32767,
      -32768, -32768, -32768, -32768,
    },
    {
          -4,     -4,     -4,     -4,
           1,      1,      1,      1,
           1,      1,      1,      1,
       32767,  32767,  32767,  32767,
    },
    {
          -3,     -3,     -3,     -3,
      -32768, -32768, -32768, -32768,
      -32768, -32768, -32768, -32768,
      -32768, -32768, -32768, -32768,
    },
  },

  {
    {
      -32768, -32768, -32768, -32768,
       32767,  32767,  32767,  32767,
      -32765, -32765, -32765, -32765,
       32766,  32766,  32766,  32766,
    },
    {
       32767,  32767,  32767,  32767,
      -32767, -32767, -32767, -32767,
      -32767, -32767, -32767, -32767,
       32767,  32767,  32767,  32767,
    },
    {
      -32768, -32768, -32768, -32768,
       32767,  32767,  32767,  32767,
           2,      2,      2,      2,
          -1,     -1,     -1,     -1,
    },
  },
};

int32_t TEST_BINARY_DATA_NAME(int32_t, int32_t, sssub)[][3][N] =
{
  {
    {
                0,           0,           0,           0,
                2,           2,           2,           2,
       2147483646,  2147483646,  2147483646,  2147483646,
       2147483647,  2147483647,  2147483647,  2147483647,
    },
    {
                0,           0,           0,           0,
                4,           4,           4,           4,
               -2,          -2,          -2,          -2,
      -2147483647, -2147483647, -2147483647, -2147483647,
    },
    {
                0,           0,           0,           0,
               -2,          -2,          -2,          -2,
       2147483647,  2147483647,  2147483647,  2147483647,
       2147483647,  2147483647,  2147483647,  2147483647,
    },
  },

  {
    {
               -7,          -7,          -7,          -7,
      -2147483648, -2147483648, -2147483648, -2147483648,
      -2147483647, -2147483647, -2147483647, -2147483647,
      -2147483648, -2147483648, -2147483648, -2147483648,
    },
    {
               -4,          -4,          -4,          -4,
                1,           1,           1,           1,
                1,           1,           1,           1,
       2147483647,  2147483647,  2147483647,  2147483647,
    },
    {
               -3,          -3,          -3,          -3,
      -2147483648, -2147483648, -2147483648, -2147483648,
      -2147483648, -2147483648, -2147483648, -2147483648,
      -2147483648, -2147483648, -2147483648, -2147483648,
    },
  },

  {
    {
      -2147483648, -2147483648, -2147483648, -2147483648,
       2147483647,  2147483647,  2147483647,  2147483647,
      -2147483645, -2147483645, -2147483645, -2147483645,
       2147483646,  2147483646,  2147483646,  2147483646,
    },
    {
       2147483647,  2147483647,  2147483647,  2147483647,
      -2147483647, -2147483647, -2147483647, -2147483647,
      -2147483647, -2147483647, -2147483647, -2147483647,
       2147483647,  2147483647,  2147483647,  2147483647,
    },
    {
      -2147483648, -2147483648, -2147483648, -2147483648,
       2147483647,  2147483647,  2147483647,  2147483647,
                2,           2,           2,           2,
               -1,          -1,          -1,          -1,
    },
  },
};

int64_t TEST_BINARY_DATA_NAME(int64_t, int64_t, sssub)[][3][N] =
{
  {
    {
                           0,                      0,                      0,                      0,
                           2,                      2,                      2,                      2,
       9223372036854775806ll,  9223372036854775806ll,  9223372036854775806ll,  9223372036854775806ll,
       9223372036854775807ll,  9223372036854775807ll,  9223372036854775807ll,  9223372036854775807ll,
    },
    {
                           0,                      0,                      0,                      0,
                           4,                      4,                      4,                      4,
                          -2,                     -2,                     -2,                     -2,
      -9223372036854775807ll, -9223372036854775807ll, -9223372036854775807ll, -9223372036854775807ll,
    },
    {
                           0,                      0,                      0,                      0,
                          -2,                     -2,                     -2,                     -2,
       9223372036854775807ll,  9223372036854775807ll,  9223372036854775807ll,  9223372036854775807ll,
       9223372036854775807ll,  9223372036854775807ll,  9223372036854775807ll,  9223372036854775807ll,
    },
  },

  {
    {
                           -7,                      -7,                      -7,                      -7,
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
       -9223372036854775807ll,  -9223372036854775807ll,  -9223372036854775807ll,  -9223372036854775807ll,
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
    },
    {
                          -4,                     -4,                     -4,                     -4,
                           1,                      1,                      1,                      1,
                           1,                      1,                      1,                      1,
       9223372036854775807ll,  9223372036854775807ll,  9223372036854775807ll,  9223372036854775807ll,
    },
    {
                           -3,                      -3,                      -3,                      -3,
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
    },
  },

  {
    {
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
        9223372036854775807ll,   9223372036854775807ll,   9223372036854775807ll,   9223372036854775807ll,
       -9223372036854775805ll,  -9223372036854775805ll,  -9223372036854775805ll,  -9223372036854775805ll,
        9223372036854775806ll,   9223372036854775806ll,   9223372036854775806ll,   9223372036854775806ll,
    },
    {
       9223372036854775807ll,  9223372036854775807ll,  9223372036854775807ll,  9223372036854775807ll,
      -9223372036854775807ll, -9223372036854775807ll, -9223372036854775807ll, -9223372036854775807ll,
      -9223372036854775807ll, -9223372036854775807ll, -9223372036854775807ll, -9223372036854775807ll,
       9223372036854775807ll,  9223372036854775807ll,  9223372036854775807ll,  9223372036854775807ll,
    },
    {
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
        9223372036854775807ll,   9223372036854775807ll,   9223372036854775807ll,   9223372036854775807ll,
                            2,                       2,                       2,                       2,
                           -1,                      -1,                      -1,                      -1,
    },
  },
};

TEST_UNARY_STRUCT_DECL(uint8_t, uint16_t) \
  TEST_UNARY_DATA(uint8_t, uint16_t)[] =
{
  {
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
  },
  {
    {
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
    },
    {
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
    },
  },
  {
    {
      254, 255, 256, 257,
      254, 255, 256, 257,
      254, 255, 256, 257,
      254, 255, 256, 257,
    },
    {
      254, 255, 255, 255,
      254, 255, 255, 255,
      254, 255, 255, 255,
      254, 255, 255, 255,
    },
  },
  {
    {
      65534, 65535, 650, 24,
      65534, 65535, 650, 24,
      65534, 65535, 650, 24,
      65534, 65535, 650, 24,
    },
    {
        255,   255, 255, 24,
        255,   255, 255, 24,
        255,   255, 255, 24,
        255,   255, 255, 24,
    },
  },
};

TEST_UNARY_STRUCT_DECL(uint8_t, uint32_t) \
  TEST_UNARY_DATA(uint8_t, uint32_t)[] =
{
  {
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
  },
  {
    {
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
    },
    {
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
    },
  },
  {
    {
      254, 255, 256, 257,
      254, 255, 256, 257,
      254, 255, 256, 257,
      254, 255, 256, 257,
    },
    {
      254, 255, 255, 255,
      254, 255, 255, 255,
      254, 255, 255, 255,
      254, 255, 255, 255,
    },
  },
  {
    {
      65534, 65535, 65536, 4294967291,
      65534, 65535, 65537, 4294967292,
      65534, 65535, 65538, 4294967293,
      65534, 65535, 65539, 4294967294,
    },
    {
        255,   255,   255,        255,
        255,   255,   255,        255,
        255,   255,   255,        255,
        255,   255,   255,        255,
    },
  },
};

TEST_UNARY_STRUCT_DECL(uint8_t, uint64_t) \
  TEST_UNARY_DATA(uint8_t, uint64_t)[] =
{
  {
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
  },
  {
    {
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
    },
    {
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
    },
  },
  {
    {
      254, 255, 256, 257,
      254, 255, 256, 257,
      254, 255, 256, 257,
      254, 255, 256, 257,
    },
    {
      254, 255, 255, 255,
      254, 255, 255, 255,
      254, 255, 255, 255,
      254, 255, 255, 255,
    },
  },
  {
    {
      65534, 65535, 4294967292,            4294967296,
      65534, 65536, 4294967293, 18446744073709551613u,
      65534, 65537, 4294967294, 18446744073709551614u,
      65534, 65538, 4294967295, 18446744073709551615u,
    },
    {
        255,   255,        255,                   255,
        255,   255,        255,                   255,
        255,   255,        255,                   255,
        255,   255,        255,                   255,
    },
  },
};

TEST_UNARY_STRUCT_DECL(uint16_t, uint32_t) \
  TEST_UNARY_DATA(uint16_t, uint32_t)[] =
{
  {
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
  },
  {
    {
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
    },
    {
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
    },
  },
  {
    {
      65534, 65535, 65536, 65537,
      65534, 65535, 65536, 65537,
      65534, 65535, 65536, 65537,
      65534, 65535, 65536, 65537,
    },
    {
      65534, 65535, 65535, 65535,
      65534, 65535, 65535, 65535,
      65534, 65535, 65535, 65535,
      65534, 65535, 65535, 65535,
    },
  },
  {
    {
      65534, 65535, 4294967295, 4294967291,
      65534, 65535, 4294967295, 4294967292,
      65534, 65535, 4294967295, 4294967293,
      65534, 65535, 4294967295, 4294967294,
    },
    {
      65534, 65535,      65535,      65535,
      65534, 65535,      65535,      65535,
      65534, 65535,      65535,      65535,
      65534, 65535,      65535,      65535,
    },
  },
};

TEST_UNARY_STRUCT_DECL(uint16_t, uint64_t) \
  TEST_UNARY_DATA(uint16_t, uint64_t)[] =
{
  {
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
  },
  {
    {
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
    },
    {
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
    },
  },
  {
    {
      65534, 65535, 65536, 65537,
      65534, 65535, 65536, 65537,
      65534, 65535, 65536, 65537,
      65534, 65535, 65536, 65537,
    },
    {
      65534, 65535, 65535, 65535,
      65534, 65535, 65535, 65535,
      65534, 65535, 65535, 65535,
      65534, 65535, 65535, 65535,
    },
  },
  {
    {
      65534, 65535, 4294967294,            4294967298,
      65534, 65536, 4294967295, 18446744073709551613u,
      65534, 65537, 4294967296, 18446744073709551614u,
      65534, 65538, 4294967297, 18446744073709551615u,
    },
    {
      65534, 65535,      65535,                 65535,
      65534, 65535,      65535,                 65535,
      65534, 65535,      65535,                 65535,
      65534, 65535,      65535,                 65535,
    },
  },
};

TEST_UNARY_STRUCT_DECL(uint32_t, uint64_t) \
  TEST_UNARY_DATA(uint32_t, uint64_t)[] =
{
  {
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    {
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
  },
  {
    {
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
    },
    {
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
      1, 2, 3, 4,
    },
  },
  {
    {
      65534, 65535, 65536, 65537,
      65534, 65535, 65536, 65537,
      65534, 65535, 65536, 65537,
      65534, 65535, 65536, 65537,
    },
    {
      65534, 65535, 65536, 65537,
      65534, 65535, 65536, 65537,
      65534, 65535, 65536, 65537,
      65534, 65535, 65536, 65537,
    },
  },
  {
    {
      65534, 65535, 4294967294,            4294967298,
      65534, 65536, 4294967295, 18446744073709551613u,
      65534, 65537, 4294967296, 18446744073709551614u,
      65534, 65538, 4294967297, 18446744073709551615u,
    },
    {
      65534, 65535, 4294967294,            4294967295,
      65534, 65536, 4294967295,            4294967295,
      65534, 65537, 4294967295,            4294967295,
      65534, 65538, 4294967295,            4294967295,
    },
  },
};

TEST_UNARY_STRUCT_DECL(int8_t, int16_t) \
  TEST_UNARY_DATA(int8_t, int16_t)[] =
{
  {
    {
      0,  0,  0,  0,
     -1, -1, -1, -1,
      1,  1,  1,  1,
      2,  2,  2,  2,
    },
    {
      0,  0,  0,  0,
     -1, -1, -1, -1,
      1,  1,  1,  1,
      2,  2,  2,  2,
    },
  },
  {
    {
       127,  127,  127,  127,
       128,  128,  128,  128,
      -128, -128, -128, -128,
      -129, -129, -129, -129,
    },
    {
       127,  127,  127,  127,
       127,  127,  127,  127,
      -128, -128, -128, -128,
      -128, -128, -128, -128,
    },
  },
  {
    {
       32766,  32766,  32766,  32766,
       32767,  32767,  32767,  32767,
      -32767, -32767, -32767, -32767,
      -32768, -32768, -32768, -32768,
    },
    {
       127,  127,  127,  127,
       127,  127,  127,  127,
      -128, -128, -128, -128,
      -128, -128, -128, -128,
    },
  },
};

TEST_UNARY_STRUCT_DECL(int8_t, int32_t) \
  TEST_UNARY_DATA(int8_t, int32_t)[] =
{
  {
    {
      0,  0,  0,  0,
     -1, -1, -1, -1,
      1,  1,  1,  1,
      2,  2,  2,  2,
    },
    {
      0,  0,  0,  0,
     -1, -1, -1, -1,
      1,  1,  1,  1,
      2,  2,  2,  2,
    },
  },
  {
    {
       127,  127,  127,  127,
       128,  128,  128,  128,
      -128, -128, -128, -128,
      -129, -129, -129, -129,
    },
    {
       127,  127,  127,  127,
       127,  127,  127,  127,
      -128, -128, -128, -128,
      -128, -128, -128, -128,
    },
  },
  {
    {
       2147483646,  2147483646,  2147483646,  2147483646,
       2147483647,  2147483647,  2147483647,  2147483647,
      -2147483647, -2147483647, -2147483647, -2147483647,
      -2147483648, -2147483648, -2147483648, -2147483648,
    },
    {
       127,  127,  127,  127,
       127,  127,  127,  127,
      -128, -128, -128, -128,
      -128, -128, -128, -128,
    },
  },
};

TEST_UNARY_STRUCT_DECL(int8_t, int64_t) \
  TEST_UNARY_DATA(int8_t, int64_t)[] =
{
  {
    {
      0,  0,  0,  0,
     -1, -1, -1, -1,
      1,  1,  1,  1,
      2,  2,  2,  2,
    },
    {
      0,  0,  0,  0,
     -1, -1, -1, -1,
      1,  1,  1,  1,
      2,  2,  2,  2,
    },
  },
  {
    {
       127,  127,  127,  127,
       128,  128,  128,  128,
      -128, -128, -128, -128,
      -129, -129, -129, -129,
    },
    {
       127,  127,  127,  127,
       127,  127,  127,  127,
      -128, -128, -128, -128,
      -128, -128, -128, -128,
    },
  },
  {
    {
        9223372036854775806ll,   9223372036854775806ll,   9223372036854775806ll,   9223372036854775806ll,
        9223372036854775807ll,   9223372036854775807ll,   9223372036854775807ll,   9223372036854775807ll,
       -9223372036854775807ll,  -9223372036854775807ll,  -9223372036854775807ll,  -9223372036854775807ll,
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
    },
    {
       127,  127,  127,  127,
       127,  127,  127,  127,
      -128, -128, -128, -128,
      -128, -128, -128, -128,
    },
  },
};

TEST_UNARY_STRUCT_DECL(int16_t, int32_t) \
  TEST_UNARY_DATA(int16_t, int32_t)[] =
{
  {
    {
      0,  0,  0,  0,
     -1, -1, -1, -1,
      1,  1,  1,  1,
      2,  2,  2,  2,
    },
    {
      0,  0,  0,  0,
     -1, -1, -1, -1,
      1,  1,  1,  1,
      2,  2,  2,  2,
    },
  },
  {
    {
       32767,  32767,  32767,  32767,
       32768,  32768,  32768,  32768,
      -32768, -32768, -32768, -32768,
      -32769, -32769, -32769, -32769,
    },
    {
       32767,  32767,  32767,  32767,
       32767,  32767,  32767,  32767,
      -32768, -32768, -32768, -32768,
      -32768, -32768, -32768, -32768,
    },
  },
  {
    {
       2147483646,  2147483646,  2147483646,  2147483646,
       2147483647,  2147483647,  2147483647,  2147483647,
      -2147483647, -2147483647, -2147483647, -2147483647,
      -2147483648, -2147483648, -2147483648, -2147483648,
    },
    {
       32767,  32767,  32767,  32767,
       32767,  32767,  32767,  32767,
      -32768, -32768, -32768, -32768,
      -32768, -32768, -32768, -32768,
    },
  },
};

TEST_UNARY_STRUCT_DECL(int16_t, int64_t) \
  TEST_UNARY_DATA(int16_t, int64_t)[] =
{
  {
    {
      0,  0,  0,  0,
     -1, -1, -1, -1,
      1,  1,  1,  1,
      2,  2,  2,  2,
    },
    {
      0,  0,  0,  0,
     -1, -1, -1, -1,
      1,  1,  1,  1,
      2,  2,  2,  2,
    },
  },
  {
    {
       32767,  32767,  32767,  32767,
       32768,  32768,  32768,  32768,
      -32768, -32768, -32768, -32768,
      -32769, -32769, -32769, -32769,
    },
    {
       32767,  32767,  32767,  32767,
       32767,  32767,  32767,  32767,
      -32768, -32768, -32768, -32768,
      -32768, -32768, -32768, -32768,
    },
  },
  {
    {
        9223372036854775806ll,   9223372036854775806ll,   9223372036854775806ll,   9223372036854775806ll,
        9223372036854775807ll,   9223372036854775807ll,   9223372036854775807ll,   9223372036854775807ll,
       -9223372036854775807ll,  -9223372036854775807ll,  -9223372036854775807ll,  -9223372036854775807ll,
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
    },
    {
       32767,  32767,  32767,  32767,
       32767,  32767,  32767,  32767,
      -32768, -32768, -32768, -32768,
      -32768, -32768, -32768, -32768,
    },
  },
};

TEST_UNARY_STRUCT_DECL(int32_t, int64_t) \
  TEST_UNARY_DATA(int32_t, int64_t)[] =
{
  {
    {
      0,  0,  0,  0,
     -1, -1, -1, -1,
      1,  1,  1,  1,
      2,  2,  2,  2,
    },
    {
      0,  0,  0,  0,
     -1, -1, -1, -1,
      1,  1,  1,  1,
      2,  2,  2,  2,
    },
  },
  {
    {
       2147483647,  2147483647,  2147483647,  2147483647,
       2147483648,  2147483648,  2147483648,  2147483648,
      -2147483648, -2147483648, -2147483648, -2147483648,
      -2147483649, -2147483649, -2147483649, -2147483649,
    },
    {
       2147483647,  2147483647,  2147483647,  2147483647,
       2147483647,  2147483647,  2147483647,  2147483647,
      -2147483648, -2147483648, -2147483648, -2147483648,
      -2147483648, -2147483648, -2147483648, -2147483648,
    },
  },
  {
    {
        9223372036854775806ll,   9223372036854775806ll,   9223372036854775806ll,   9223372036854775806ll,
        9223372036854775807ll,   9223372036854775807ll,   9223372036854775807ll,   9223372036854775807ll,
       -9223372036854775807ll,  -9223372036854775807ll,  -9223372036854775807ll,  -9223372036854775807ll,
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
    },
    {
       2147483647,  2147483647,  2147483647,  2147483647,
       2147483647,  2147483647,  2147483647,  2147483647,
      -2147483648, -2147483648, -2147483648, -2147483648,
      -2147483648, -2147483648, -2147483648, -2147483648,
    },
  },
};

#endif
