/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef PLKRPARSER_H_INCLUDED
#define PLKRPARSER_H_INCLUDED

#include <map>
#include <vector>

#include <boost/shared_ptr.hpp>

#include "PDXParser.h"

class WPXDocumentInterface;
class WPXInputStream;

namespace libebook
{

typedef std::map<unsigned, std::vector<unsigned char> > PLKRImageMap_t;

struct PLKRHeader;
struct PLKRParserState;
struct PLKRRecordHeader;

class PLKRParser : public PDXParser
{
  // -Weffc++
  PLKRParser(const PLKRParser &other);
  PLKRParser &operator=(const PLKRParser &other);

public:
  explicit PLKRParser(WPXInputStream *input, WPXDocumentInterface *document = 0);
  virtual ~PLKRParser();

private:
  virtual bool isFormatSupported(unsigned type, unsigned creator);

  virtual void readAppInfoRecord(WPXInputStream *record);
  virtual void readSortInfoRecord(WPXInputStream *record);
  virtual void readIndexRecord(WPXInputStream *record);
  virtual void readDataRecord(WPXInputStream *record, bool last = false);

  virtual void readDataRecords();

  void readMetadata(WPXInputStream *input, const PLKRRecordHeader &header);
  void readImage(WPXInputStream *input, const PLKRRecordHeader &header);
  void readText(WPXInputStream *input, const PLKRRecordHeader &header, const std::vector<unsigned> &paragraphLengths);

  boost::shared_ptr<WPXInputStream> getUncompressedStream(WPXInputStream *input) const;

private:
  PLKRHeader *m_header;
  PLKRParserState *const m_state;
};

} // namespace libebook

#endif // PLKRPARSER_H_INCLUDED
/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
