/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.reasoner.rulesys.Builtin;
import org.apache.jena.reasoner.rulesys.BuiltinRegistry;

public class OverrideBuiltinRegistry
extends BuiltinRegistry {
    protected final Map<String, Builtin> builtins = new HashMap<String, Builtin>();
    protected final Map<String, Builtin> builtinsByURI = new HashMap<String, Builtin>();
    protected final BuiltinRegistry innerRegistry;

    public OverrideBuiltinRegistry(BuiltinRegistry innerRegistry) {
        this.innerRegistry = innerRegistry;
    }

    @Override
    public void register(String functor, Builtin impl) {
        this.builtins.put(functor, impl);
        this.builtinsByURI.put(impl.getURI(), impl);
    }

    @Override
    public void register(Builtin impl) {
        this.builtins.put(impl.getName(), impl);
        this.builtinsByURI.put(impl.getURI(), impl);
    }

    @Override
    public Builtin getImplementation(String functor) {
        Builtin that = this.builtins.get(functor);
        return that == null ? this.innerRegistry.getImplementation(functor) : that;
    }

    @Override
    public Builtin getImplementationByURI(String uri) {
        Builtin that = this.builtinsByURI.get(uri);
        return that == null ? this.innerRegistry.getImplementationByURI(uri) : that;
    }
}

