# -*- coding: utf-8 -*-

#-------------------------------------------------------------------------
# drawElements Quality Program utilities
# --------------------------------------
#
# Copyright 2015 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
#-------------------------------------------------------------------------

import sys
from argparse import ArgumentParser
from common import getChangedFiles, getAllProjectFiles
from check_include_guards import checkIncludeGuards
from check_whitespace import checkWhitespace

if __name__ == "__main__":
    parser = ArgumentParser()
    parser.add_argument("-e", "--only-errors",  action="store_true", dest="onlyErrors",   default=False, help="Print only on error")
    parser.add_argument("-i", "--only-changed", action="store_true", dest="useGitIndex",  default=False, help="Check only modified files. Uses git.")

    args = parser.parse_args()

    if args.useGitIndex:
        files = getChangedFiles()
    else:
        files = getAllProjectFiles()

    error = not all([
        checkWhitespace(files),
        checkIncludeGuards(files),
        #todo checkRedundantIncludeGuards(files),
        ])

    if error:
        print "One or more checks failed"
        sys.exit(1)
    if not args.onlyErrors:
        print "All checks passed"
