RabbitMQ `3.12.8` is a maintenance release in the `3.12.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from the [3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0)
if upgrading from a version prior to 3.12.0.

This release requires Erlang 25 and supports Erlang versions up to `26.1.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.12.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Users upgrading from 3.11.x (or older releases) on Erlang 25 to 3.12.x on Erlang 26
(both RabbitMQ *and* Erlang are upgraded at the same time) **must** consult
the [v3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0) first.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.12.x/release-notes).


### Core Server

#### Bug Fixes

 * Avoids a potential exception in the `autoheal` partition handler.

   Contributed by @Ayanda-D.

   GitHub issue: [#9818](https://github.com/rabbitmq/rabbitmq-server/pull/9818)

#### Enhancements

 * `raft.segment_max_entries` is now validated to prevent the value from overflowing its 16-bit segment file field.
   Maximum supported value is now `65535`.

   GitHub issue: [#9733](https://github.com/rabbitmq/rabbitmq-server/issues/9733)


### Shovel Plugin

#### Enhancements

 * Significantly faster Shovel startup in environments where there are many of them (one thousand or more).

   GitHub issue: [#9796](https://github.com/rabbitmq/rabbitmq-server/pull/9796)


### AMQP 1.0 Erlang Client

#### Enhancements

 * User-provided credentials are now obfuscated using an one-off key pair generated on node boot.
   This keeps sensitive client state information from being logged by the runtime exception logger.

   GitHub issue: [#9777](https://github.com/rabbitmq/rabbitmq-server/pull/9777)


## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.12.8.tar.xz`
instead of the source tarball produced by GitHub.
