/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.analysis.MetricAccumulationLevel;
import net.sf.picard.analysis.SinglePassSamProgram;
import net.sf.picard.analysis.directed.RnaSeqMetricsCollector;
import net.sf.picard.annotation.Gene;
import net.sf.picard.annotation.GeneAnnotationReader;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.util.CollectionUtil;
import net.sf.picard.util.Histogram;
import net.sf.picard.util.Interval;
import net.sf.picard.util.Log;
import net.sf.picard.util.OverlapDetector;
import net.sf.picard.util.RExecutor;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;

public class CollectRnaSeqMetrics
extends SinglePassSamProgram {
    private static final Log LOG = Log.getInstance(CollectRnaSeqMetrics.class);
    @Usage
    public final String USAGE = this.getStandardUsagePreamble() + "Program to collect metrics about the alignment of RNA to various functional classes of loci in the genome:" + " coding, intronic, UTR, intergenic, ribosomal.\n" + "Also determines strand-specificity for strand-specific libraries.";
    @Option(doc="Gene annotations in refFlat form.  Format described here: http://genome.ucsc.edu/goldenPath/gbdDescriptionsOld.html#RefFlat")
    public File REF_FLAT;
    @Option(doc="Location of rRNA sequences in genome, in interval_list format.  If not specified no bases will be identified as being ribosomal.  Format described here: http://picard.sourceforge.net/javadoc/net/sf/picard/util/IntervalList.html", optional=true)
    public File RIBOSOMAL_INTERVALS;
    @Option(shortName="STRAND", doc="For strand-specific library prep. For unpaired reads, use FIRST_READ_TRANSCRIPTION_STRAND if the reads are expected to be on the transcription strand.")
    public RnaSeqMetricsCollector.StrandSpecificity STRAND_SPECIFICITY;
    @Option(doc="When calculating coverage based values (e.g. CV of coverage) only use transcripts of this length or greater.")
    public int MINIMUM_LENGTH = 500;
    @Option(doc="The PDF file to write out a plot of normalized position vs. coverage.", shortName="CHART", optional=true)
    public File CHART_OUTPUT;
    @Option(doc="If a read maps to a sequence specified with this option, all the bases in the read are counted as ignored bases.  These reads are not counted as ")
    public Set<String> IGNORE_SEQUENCE = new HashSet<String>();
    @Option(doc="This percentage of the length of a fragment must overlap one of the ribosomal intervals for a read or read pair by this must in order to be considered rRNA.")
    public double RRNA_FRAGMENT_PERCENTAGE = 0.8;
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.  ")
    private Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet(MetricAccumulationLevel.ALL_READS);
    private RnaSeqMetricsCollector collector;
    private String plotSubtitle = "";

    public static void main(String[] argv) {
        new CollectRnaSeqMetrics().instanceMainWithExit(argv);
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        if (this.CHART_OUTPUT != null) {
            IoUtil.assertFileIsWritable(this.CHART_OUTPUT);
        }
        OverlapDetector<Gene> geneOverlapDetector = GeneAnnotationReader.loadRefFlat(this.REF_FLAT, header.getSequenceDictionary());
        LOG.info("Loaded " + geneOverlapDetector.getAll().size() + " genes.");
        Long ribosomalBasesInitialValue = this.RIBOSOMAL_INTERVALS != null ? Long.valueOf(0L) : null;
        OverlapDetector<Interval> ribosomalSequenceOverlapDetector = RnaSeqMetricsCollector.makeOverlapDetector(samFile, header, this.RIBOSOMAL_INTERVALS);
        HashSet<Integer> ignoredSequenceIndices = RnaSeqMetricsCollector.makeIgnoredSequenceIndicesSet(header, this.IGNORE_SEQUENCE);
        this.collector = new RnaSeqMetricsCollector(this.METRIC_ACCUMULATION_LEVEL, header.getReadGroups(), ribosomalBasesInitialValue, geneOverlapDetector, ribosomalSequenceOverlapDetector, ignoredSequenceIndices, this.MINIMUM_LENGTH, this.STRAND_SPECIFICITY, this.RRNA_FRAGMENT_PERCENTAGE);
        List readGroups = header.getReadGroups();
        if (readGroups.size() == 1) {
            this.plotSubtitle = ((SAMReadGroupRecord)readGroups.get(0)).getLibrary();
        }
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence refSeq) {
        this.collector.acceptRecord(rec, refSeq);
    }

    @Override
    protected void finish() {
        int rResult;
        this.collector.finish();
        MetricsFile file = this.getMetricsFile();
        this.collector.addAllLevelsToFile(file);
        file.write(this.OUTPUT);
        boolean atLeastOneHistogram = false;
        for (Histogram histo : file.getAllHistograms()) {
            atLeastOneHistogram = atLeastOneHistogram || !histo.isEmpty();
        }
        if (this.CHART_OUTPUT != null && atLeastOneHistogram && (rResult = RExecutor.executeFromClasspath("net/sf/picard/analysis/rnaSeqCoverage.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), this.INPUT.getName(), this.plotSubtitle)) != 0) {
            throw new PicardException("Problem invoking R to generate plot.");
        }
    }
}

