/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pileup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.fragments.FragmentCollection;
import org.broadinstitute.sting.utils.fragments.FragmentUtils;
import org.broadinstitute.sting.utils.pileup.PerSamplePileupElementTracker;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.PileupElementFilter;
import org.broadinstitute.sting.utils.pileup.PileupElementTracker;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.pileup.UnifiedPileupElementTracker;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public abstract class AbstractReadBackedPileup<RBP extends AbstractReadBackedPileup<RBP, PE>, PE extends PileupElement>
implements ReadBackedPileup {
    protected final GenomeLoc loc;
    protected final PileupElementTracker<PE> pileupElementTracker;
    protected int size = 0;
    protected int abstractSize = -1;
    protected int nDeletions = 0;
    protected int nMQ0Reads = 0;

    public AbstractReadBackedPileup(GenomeLoc loc, List<GATKSAMRecord> reads, List<Integer> offsets) {
        this.loc = loc;
        this.pileupElementTracker = this.readsOffsets2Pileup(reads, offsets);
    }

    public AbstractReadBackedPileup(GenomeLoc loc) {
        this(loc, new UnifiedPileupElementTracker());
    }

    public AbstractReadBackedPileup(GenomeLoc loc, List<PE> pileup) {
        if (loc == null) {
            throw new ReviewedStingException("Illegal null genomeloc in ReadBackedPileup");
        }
        if (pileup == null) {
            throw new ReviewedStingException("Illegal null pileup in ReadBackedPileup");
        }
        this.loc = loc;
        this.pileupElementTracker = new UnifiedPileupElementTracker<PE>(pileup);
        this.calculateCachedData();
    }

    public AbstractReadBackedPileup(GenomeLoc loc, List<PE> pileup, int size, int nDeletions, int nMQ0Reads) {
        if (loc == null) {
            throw new ReviewedStingException("Illegal null genomeloc in UnifiedReadBackedPileup");
        }
        if (pileup == null) {
            throw new ReviewedStingException("Illegal null pileup in UnifiedReadBackedPileup");
        }
        this.loc = loc;
        this.pileupElementTracker = new UnifiedPileupElementTracker<PE>(pileup);
        this.size = size;
        this.nDeletions = nDeletions;
        this.nMQ0Reads = nMQ0Reads;
    }

    protected AbstractReadBackedPileup(GenomeLoc loc, PileupElementTracker<PE> tracker) {
        this.loc = loc;
        this.pileupElementTracker = tracker;
        this.calculateCachedData();
    }

    protected AbstractReadBackedPileup(GenomeLoc loc, Map<String, ? extends AbstractReadBackedPileup<RBP, PE>> pileupsBySample) {
        this.loc = loc;
        PerSamplePileupElementTracker<PE> tracker = new PerSamplePileupElementTracker<PE>();
        for (Map.Entry<String, AbstractReadBackedPileup<RBP, PE>> pileupEntry : pileupsBySample.entrySet()) {
            tracker.addElements(pileupEntry.getKey(), pileupEntry.getValue().pileupElementTracker);
            this.addPileupToCumulativeStats(pileupEntry.getValue());
        }
        this.pileupElementTracker = tracker;
    }

    public AbstractReadBackedPileup(GenomeLoc loc, List<GATKSAMRecord> reads, int offset) {
        this.loc = loc;
        this.pileupElementTracker = this.readsOffsets2Pileup(reads, offset);
    }

    protected void calculateCachedData() {
        this.size = 0;
        this.nDeletions = 0;
        this.nMQ0Reads = 0;
        for (PileupElement p : this.pileupElementTracker) {
            ++this.size;
            if (p.isDeletion()) {
                ++this.nDeletions;
            }
            if (p.getRead().getMappingQuality() != 0) continue;
            ++this.nMQ0Reads;
        }
    }

    protected void calculateAbstractSize() {
        this.abstractSize = 0;
        for (PileupElement p : this.pileupElementTracker) {
            this.abstractSize += p.getRepresentativeCount();
        }
    }

    protected void addPileupToCumulativeStats(AbstractReadBackedPileup<RBP, PE> pileup) {
        this.size += pileup.getNumberOfElements();
        this.abstractSize = pileup.depthOfCoverage() + (this.abstractSize == -1 ? 0 : this.abstractSize);
        this.nDeletions += pileup.getNumberOfDeletions();
        this.nMQ0Reads += pileup.getNumberOfMappingQualityZeroReads();
    }

    private PileupElementTracker<PE> readsOffsets2Pileup(List<GATKSAMRecord> reads, List<Integer> offsets) {
        if (reads == null) {
            throw new ReviewedStingException("Illegal null read list in UnifiedReadBackedPileup");
        }
        if (offsets == null) {
            throw new ReviewedStingException("Illegal null offsets list in UnifiedReadBackedPileup");
        }
        if (reads.size() != offsets.size()) {
            throw new ReviewedStingException("Reads and offset lists have different sizes!");
        }
        UnifiedPileupElementTracker<PE> pileup = new UnifiedPileupElementTracker<PE>();
        for (int i = 0; i < reads.size(); ++i) {
            GATKSAMRecord read = reads.get(i);
            int offset = offsets.get(i);
            pileup.add(this.createNewPileupElement(read, offset, false, false, false, false, false, false));
        }
        return pileup;
    }

    private PileupElementTracker<PE> readsOffsets2Pileup(List<GATKSAMRecord> reads, int offset) {
        if (reads == null) {
            throw new ReviewedStingException("Illegal null read list in UnifiedReadBackedPileup");
        }
        if (offset < 0) {
            throw new ReviewedStingException("Illegal offset < 0 UnifiedReadBackedPileup");
        }
        UnifiedPileupElementTracker<PE> pileup = new UnifiedPileupElementTracker<PE>();
        for (GATKSAMRecord read : reads) {
            pileup.add(this.createNewPileupElement(read, offset, false, false, false, false, false, false));
        }
        return pileup;
    }

    protected abstract AbstractReadBackedPileup<RBP, PE> createNewPileup(GenomeLoc var1, PileupElementTracker<PE> var2);

    protected abstract PE createNewPileupElement(GATKSAMRecord var1, int var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8);

    protected abstract PE createNewPileupElement(GATKSAMRecord var1, int var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, String var9, int var10);

    public RBP getPileupWithoutDeletions() {
        if (this.getNumberOfDeletions() > 0) {
            if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
                PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
                PerSamplePileupElementTracker<PE> filteredTracker = new PerSamplePileupElementTracker<PE>();
                for (String sample : tracker.getSamples()) {
                    PileupElementTracker perSampleElements = tracker.getElements(sample);
                    ReadBackedPileup pileup = this.createNewPileup(this.loc, perSampleElements).getPileupWithoutDeletions();
                    filteredTracker.addElements(sample, ((AbstractReadBackedPileup)pileup).pileupElementTracker);
                }
                return (RBP)this.createNewPileup(this.loc, filteredTracker);
            }
            UnifiedPileupElementTracker tracker = (UnifiedPileupElementTracker)this.pileupElementTracker;
            UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
            for (PileupElement p : tracker) {
                if (p.isDeletion()) continue;
                filteredTracker.add(p);
            }
            return (RBP)this.createNewPileup(this.loc, filteredTracker);
        }
        return (RBP)this;
    }

    public RBP getOverlappingFragmentFilteredPileup() {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PerSamplePileupElementTracker<PE> filteredTracker = new PerSamplePileupElementTracker<PE>();
            for (String sample : tracker.getSamples()) {
                PileupElementTracker perSampleElements = tracker.getElements(sample);
                ReadBackedPileup pileup = this.createNewPileup(this.loc, perSampleElements).getOverlappingFragmentFilteredPileup();
                filteredTracker.addElements(sample, ((AbstractReadBackedPileup)pileup).pileupElementTracker);
            }
            return (RBP)this.createNewPileup(this.loc, filteredTracker);
        }
        HashMap<String, PileupElement> filteredPileup = new HashMap<String, PileupElement>();
        for (PileupElement p : this.pileupElementTracker) {
            String readName = p.getRead().getReadName();
            if (!filteredPileup.containsKey(readName)) {
                filteredPileup.put(readName, p);
                continue;
            }
            PileupElement existing = (PileupElement)filteredPileup.get(readName);
            if (existing.getBase() != p.getBase()) {
                filteredPileup.remove(readName);
                continue;
            }
            if (existing.getQual() >= p.getQual()) continue;
            filteredPileup.put(readName, p);
        }
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement filteredElement : filteredPileup.values()) {
            filteredTracker.add(filteredElement);
        }
        return (RBP)this.createNewPileup(this.loc, filteredTracker);
    }

    public RBP getPileupWithoutMappingQualityZeroReads() {
        if (this.getNumberOfMappingQualityZeroReads() > 0) {
            if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
                PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
                PerSamplePileupElementTracker<PE> filteredTracker = new PerSamplePileupElementTracker<PE>();
                for (String sample : tracker.getSamples()) {
                    PileupElementTracker perSampleElements = tracker.getElements(sample);
                    ReadBackedPileup pileup = this.createNewPileup(this.loc, perSampleElements).getPileupWithoutMappingQualityZeroReads();
                    filteredTracker.addElements(sample, ((AbstractReadBackedPileup)pileup).pileupElementTracker);
                }
                return (RBP)this.createNewPileup(this.loc, filteredTracker);
            }
            UnifiedPileupElementTracker tracker = (UnifiedPileupElementTracker)this.pileupElementTracker;
            UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
            for (PileupElement p : tracker) {
                if (p.getRead().getMappingQuality() <= 0) continue;
                filteredTracker.add(p);
            }
            return (RBP)this.createNewPileup(this.loc, filteredTracker);
        }
        return (RBP)this;
    }

    public RBP getPositiveStrandPileup() {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PerSamplePileupElementTracker<PE> filteredTracker = new PerSamplePileupElementTracker<PE>();
            for (String sample : tracker.getSamples()) {
                PileupElementTracker perSampleElements = tracker.getElements(sample);
                ReadBackedPileup pileup = this.createNewPileup(this.loc, perSampleElements).getPositiveStrandPileup();
                filteredTracker.addElements(sample, ((AbstractReadBackedPileup)pileup).pileupElementTracker);
            }
            return (RBP)this.createNewPileup(this.loc, filteredTracker);
        }
        UnifiedPileupElementTracker tracker = (UnifiedPileupElementTracker)this.pileupElementTracker;
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement p : tracker) {
            if (p.getRead().getReadNegativeStrandFlag()) continue;
            filteredTracker.add(p);
        }
        return (RBP)this.createNewPileup(this.loc, filteredTracker);
    }

    public RBP getNegativeStrandPileup() {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PerSamplePileupElementTracker<PE> filteredTracker = new PerSamplePileupElementTracker<PE>();
            for (String sample : tracker.getSamples()) {
                PileupElementTracker perSampleElements = tracker.getElements(sample);
                ReadBackedPileup pileup = this.createNewPileup(this.loc, perSampleElements).getNegativeStrandPileup();
                filteredTracker.addElements(sample, ((AbstractReadBackedPileup)pileup).pileupElementTracker);
            }
            return (RBP)this.createNewPileup(this.loc, filteredTracker);
        }
        UnifiedPileupElementTracker tracker = (UnifiedPileupElementTracker)this.pileupElementTracker;
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement p : tracker) {
            if (!p.getRead().getReadNegativeStrandFlag()) continue;
            filteredTracker.add(p);
        }
        return (RBP)this.createNewPileup(this.loc, filteredTracker);
    }

    public RBP getFilteredPileup(PileupElementFilter filter) {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PerSamplePileupElementTracker<PE> filteredTracker = new PerSamplePileupElementTracker<PE>();
            for (String sample : tracker.getSamples()) {
                PileupElementTracker perSampleElements = tracker.getElements(sample);
                ReadBackedPileup pileup = this.createNewPileup(this.loc, perSampleElements).getFilteredPileup(filter);
                filteredTracker.addElements(sample, ((AbstractReadBackedPileup)pileup).pileupElementTracker);
            }
            return (RBP)this.createNewPileup(this.loc, filteredTracker);
        }
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement p : this.pileupElementTracker) {
            if (!filter.allow(p)) continue;
            filteredTracker.add(p);
        }
        return (RBP)this.createNewPileup(this.loc, filteredTracker);
    }

    public RBP getBaseAndMappingFilteredPileup(int minBaseQ, int minMapQ) {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PerSamplePileupElementTracker<PE> filteredTracker = new PerSamplePileupElementTracker<PE>();
            for (String sample : tracker.getSamples()) {
                PileupElementTracker perSampleElements = tracker.getElements(sample);
                ReadBackedPileup pileup = this.createNewPileup(this.loc, perSampleElements).getBaseAndMappingFilteredPileup(minBaseQ, minMapQ);
                filteredTracker.addElements(sample, ((AbstractReadBackedPileup)pileup).pileupElementTracker);
            }
            return (RBP)this.createNewPileup(this.loc, filteredTracker);
        }
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement p : this.pileupElementTracker) {
            if (p.getRead().getMappingQuality() < minMapQ || !p.isDeletion() && p.getQual() < minBaseQ) continue;
            filteredTracker.add(p);
        }
        return (RBP)this.createNewPileup(this.loc, filteredTracker);
    }

    public RBP getBaseFilteredPileup(int minBaseQ) {
        return (RBP)this.getBaseAndMappingFilteredPileup(minBaseQ, -1);
    }

    public RBP getMappingFilteredPileup(int minMapQ) {
        return (RBP)this.getBaseAndMappingFilteredPileup(-1, minMapQ);
    }

    @Override
    public Collection<String> getReadGroups() {
        HashSet<String> readGroups = new HashSet<String>();
        for (PileupElement pileupElement : this) {
            readGroups.add(pileupElement.getRead().getReadGroup().getReadGroupId());
        }
        return readGroups;
    }

    public RBP getPileupForReadGroup(String targetReadGroupId) {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PerSamplePileupElementTracker<PE> filteredTracker = new PerSamplePileupElementTracker<PE>();
            for (String sample : tracker.getSamples()) {
                PileupElementTracker perSampleElements = tracker.getElements(sample);
                ReadBackedPileup pileup = this.createNewPileup(this.loc, perSampleElements).getPileupForReadGroup(targetReadGroupId);
                if (pileup == null) continue;
                filteredTracker.addElements(sample, ((AbstractReadBackedPileup)pileup).pileupElementTracker);
            }
            return (RBP)(filteredTracker.size() > 0 ? this.createNewPileup(this.loc, filteredTracker) : null);
        }
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement p : this.pileupElementTracker) {
            GATKSAMRecord read = p.getRead();
            if (targetReadGroupId != null) {
                if (read.getReadGroup() == null || !targetReadGroupId.equals(read.getReadGroup().getReadGroupId())) continue;
                filteredTracker.add(p);
                continue;
            }
            if (read.getReadGroup() != null && read.getReadGroup().getReadGroupId() != null) continue;
            filteredTracker.add(p);
        }
        return (RBP)(filteredTracker.size() > 0 ? this.createNewPileup(this.loc, filteredTracker) : null);
    }

    public RBP getPileupForReadGroups(HashSet<String> rgSet) {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PerSamplePileupElementTracker<PE> filteredTracker = new PerSamplePileupElementTracker<PE>();
            for (String sample : tracker.getSamples()) {
                PileupElementTracker perSampleElements = tracker.getElements(sample);
                ReadBackedPileup pileup = this.createNewPileup(this.loc, perSampleElements).getPileupForReadGroups((HashSet)rgSet);
                if (pileup == null) continue;
                filteredTracker.addElements(sample, ((AbstractReadBackedPileup)pileup).pileupElementTracker);
            }
            return (RBP)(filteredTracker.size() > 0 ? this.createNewPileup(this.loc, filteredTracker) : null);
        }
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement p : this.pileupElementTracker) {
            GATKSAMRecord read = p.getRead();
            if (rgSet != null && !rgSet.isEmpty()) {
                if (read.getReadGroup() == null || !rgSet.contains(read.getReadGroup().getReadGroupId())) continue;
                filteredTracker.add(p);
                continue;
            }
            if (read.getReadGroup() != null && read.getReadGroup().getReadGroupId() != null) continue;
            filteredTracker.add(p);
        }
        return (RBP)(filteredTracker.size() > 0 ? this.createNewPileup(this.loc, filteredTracker) : null);
    }

    public RBP getPileupForLane(String laneID) {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PerSamplePileupElementTracker<PE> filteredTracker = new PerSamplePileupElementTracker<PE>();
            for (String sample : tracker.getSamples()) {
                PileupElementTracker perSampleElements = tracker.getElements(sample);
                ReadBackedPileup pileup = this.createNewPileup(this.loc, perSampleElements).getPileupForLane(laneID);
                if (pileup == null) continue;
                filteredTracker.addElements(sample, ((AbstractReadBackedPileup)pileup).pileupElementTracker);
            }
            return (RBP)(filteredTracker.size() > 0 ? this.createNewPileup(this.loc, filteredTracker) : null);
        }
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement p : this.pileupElementTracker) {
            GATKSAMRecord read = p.getRead();
            if (laneID != null) {
                if ((read.getReadGroup() == null || !read.getReadGroup().getReadGroupId().startsWith(laneID + ".")) && !read.getReadGroup().getReadGroupId().equals(laneID)) continue;
                filteredTracker.add(p);
                continue;
            }
            if (read.getReadGroup() != null && read.getReadGroup().getReadGroupId() != null) continue;
            filteredTracker.add(p);
        }
        return (RBP)(filteredTracker.size() > 0 ? this.createNewPileup(this.loc, filteredTracker) : null);
    }

    @Override
    public Collection<String> getSamples() {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            return new HashSet<String>(tracker.getSamples());
        }
        HashSet<String> sampleNames = new HashSet<String>();
        for (PileupElement p : this) {
            GATKSAMRecord read = p.getRead();
            String sampleName = read.getReadGroup() != null ? read.getReadGroup().getSample() : null;
            sampleNames.add(sampleName);
        }
        return sampleNames;
    }

    public RBP getDownsampledPileup(int desiredCoverage) {
        if (this.getNumberOfElements() <= desiredCoverage) {
            return (RBP)this;
        }
        TreeSet<Integer> positions = new TreeSet<Integer>();
        int i = 0;
        while (i < desiredCoverage) {
            if (!positions.add(GenomeAnalysisEngine.getRandomGenerator().nextInt(this.size))) continue;
            ++i;
        }
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PerSamplePileupElementTracker<PE> filteredTracker = new PerSamplePileupElementTracker<PE>();
            int current = 0;
            for (String sample : tracker.getSamples()) {
                PileupElementTracker perSampleElements = tracker.getElements(sample);
                ArrayList<PileupElement> filteredPileup = new ArrayList<PileupElement>();
                for (PileupElement p : perSampleElements) {
                    if (!positions.contains(current)) continue;
                    filteredPileup.add(p);
                }
                if (!filteredPileup.isEmpty()) {
                    AbstractReadBackedPileup pileup = this.createNewPileup(this.loc, perSampleElements);
                    filteredTracker.addElements(sample, pileup.pileupElementTracker);
                }
                ++current;
            }
            return (RBP)this.createNewPileup(this.loc, filteredTracker);
        }
        UnifiedPileupElementTracker tracker = (UnifiedPileupElementTracker)this.pileupElementTracker;
        UnifiedPileupElementTracker filteredTracker = new UnifiedPileupElementTracker();
        Iterator positionIter = positions.iterator();
        while (positionIter.hasNext()) {
            int nextReadToKeep = (Integer)positionIter.next();
            filteredTracker.add(tracker.get(nextReadToKeep));
        }
        return (RBP)this.createNewPileup(this.getLocation(), filteredTracker);
    }

    public RBP getPileupForSamples(Collection<String> sampleNames) {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PileupElementTracker filteredElements = tracker.getElements(sampleNames);
            return (RBP)(filteredElements != null ? this.createNewPileup(this.loc, filteredElements) : null);
        }
        HashSet<String> hashSampleNames = new HashSet<String>(sampleNames);
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement p : this.pileupElementTracker) {
            GATKSAMRecord read = p.getRead();
            if (sampleNames != null) {
                if (read.getReadGroup() == null || !hashSampleNames.contains(read.getReadGroup().getSample())) continue;
                filteredTracker.add(p);
                continue;
            }
            if (read.getReadGroup() != null && read.getReadGroup().getSample() != null) continue;
            filteredTracker.add(p);
        }
        return (RBP)(filteredTracker.size() > 0 ? this.createNewPileup(this.loc, filteredTracker) : null);
    }

    @Override
    public Map<String, ReadBackedPileup> getPileupsForSamples(Collection<String> sampleNames) {
        HashMap<String, ReadBackedPileup> result = new HashMap<String, ReadBackedPileup>();
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            for (String string : sampleNames) {
                PileupElementTracker filteredElements = tracker.getElements(string);
                if (filteredElements == null) continue;
                result.put(string, this.createNewPileup(this.loc, filteredElements));
            }
        } else {
            HashMap trackerMap = new HashMap();
            for (String string : sampleNames) {
                UnifiedPileupElementTracker filteredTracker = new UnifiedPileupElementTracker();
                trackerMap.put(string, filteredTracker);
            }
            for (PileupElement pileupElement : this.pileupElementTracker) {
                String sample;
                UnifiedPileupElementTracker tracker;
                GATKSAMRecord read = pileupElement.getRead();
                if (read.getReadGroup() == null || (tracker = (UnifiedPileupElementTracker)trackerMap.get(sample = read.getReadGroup().getSample())) == null) continue;
                tracker.add(pileupElement);
            }
            for (Map.Entry entry : trackerMap.entrySet()) {
                result.put((String)entry.getKey(), this.createNewPileup(this.loc, (PileupElementTracker)entry.getValue()));
            }
        }
        return result;
    }

    public RBP getPileupForSample(String sampleName) {
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            PileupElementTracker filteredElements = tracker.getElements(sampleName);
            return (RBP)(filteredElements != null ? this.createNewPileup(this.loc, filteredElements) : null);
        }
        UnifiedPileupElementTracker<PileupElement> filteredTracker = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement p : this.pileupElementTracker) {
            GATKSAMRecord read = p.getRead();
            if (sampleName != null) {
                if (read.getReadGroup() == null || !sampleName.equals(read.getReadGroup().getSample())) continue;
                filteredTracker.add(p);
                continue;
            }
            if (read.getReadGroup() != null && read.getReadGroup().getSample() != null) continue;
            filteredTracker.add(p);
        }
        return (RBP)(filteredTracker.size() > 0 ? this.createNewPileup(this.loc, filteredTracker) : null);
    }

    @Override
    public Iterator<PileupElement> iterator() {
        return new Iterator<PileupElement>(){
            private final Iterator<PE> wrappedIterator;
            {
                this.wrappedIterator = AbstractReadBackedPileup.this.pileupElementTracker.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.wrappedIterator.hasNext();
            }

            @Override
            public PileupElement next() {
                return (PileupElement)this.wrappedIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove from a pileup element iterator");
            }
        };
    }

    @Override
    public int getNumberOfDeletions() {
        return this.nDeletions;
    }

    @Override
    public int getNumberOfMappingQualityZeroReads() {
        return this.nMQ0Reads;
    }

    @Override
    public int getNumberOfElements() {
        return this.size;
    }

    @Override
    public int depthOfCoverage() {
        if (this.abstractSize == -1) {
            this.calculateAbstractSize();
        }
        return this.abstractSize;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public GenomeLoc getLocation() {
        return this.loc;
    }

    @Override
    public int[] getBaseCounts() {
        int[] counts = new int[4];
        if (this.pileupElementTracker instanceof PerSamplePileupElementTracker) {
            PerSamplePileupElementTracker tracker = (PerSamplePileupElementTracker)this.pileupElementTracker;
            for (String sample : tracker.getSamples()) {
                int[] countsBySample = this.createNewPileup(this.loc, tracker.getElements(sample)).getBaseCounts();
                for (int i = 0; i < counts.length; ++i) {
                    int n = i;
                    counts[n] = counts[n] + countsBySample[i];
                }
            }
        } else {
            for (PileupElement pile : this) {
                int index;
                if (pile.isDeletion() || (index = BaseUtils.simpleBaseToBaseIndex((char)pile.getBase())) == -1) continue;
                int n = index;
                counts[n] = counts[n] + 1;
            }
        }
        return counts;
    }

    @Override
    public String getPileupString(Character ref) {
        return String.format("%s %s %c %s %s", this.getLocation().getContig(), this.getLocation().getStart(), ref, new String(this.getBases()), this.getQualsString());
    }

    @Override
    public List<GATKSAMRecord> getReads() {
        ArrayList<GATKSAMRecord> reads = new ArrayList<GATKSAMRecord>(this.getNumberOfElements());
        for (PileupElement pile : this) {
            reads.add(pile.getRead());
        }
        return reads;
    }

    @Override
    public int getNumberOfDeletionsAfterThisElement() {
        int count = 0;
        for (PileupElement p : this) {
            if (!p.isBeforeDeletionStart()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getNumberOfInsertionsAfterThisElement() {
        int count = 0;
        for (PileupElement p : this) {
            if (!p.isBeforeInsertion()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public List<Integer> getOffsets() {
        ArrayList<Integer> offsets = new ArrayList<Integer>(this.getNumberOfElements());
        for (PileupElement pile : this) {
            offsets.add(pile.getOffset());
        }
        return offsets;
    }

    @Override
    public byte[] getBases() {
        byte[] v = new byte[this.getNumberOfElements()];
        int pos = 0;
        for (PileupElement pile : this.pileupElementTracker) {
            v[pos++] = pile.getBase();
        }
        return v;
    }

    @Override
    public byte[] getQuals() {
        byte[] v = new byte[this.getNumberOfElements()];
        int pos = 0;
        for (PileupElement pile : this.pileupElementTracker) {
            v[pos++] = pile.getQual();
        }
        return v;
    }

    @Override
    public byte[] getMappingQuals() {
        byte[] v = new byte[this.getNumberOfElements()];
        int pos = 0;
        for (PileupElement pile : this.pileupElementTracker) {
            v[pos++] = (byte)pile.getRead().getMappingQuality();
        }
        return v;
    }

    static String quals2String(byte[] quals) {
        StringBuilder qualStr = new StringBuilder();
        for (int n : quals) {
            n = Math.min(n, 63);
            char qualChar = (char)(33 + n);
            qualStr.append(qualChar);
        }
        return qualStr.toString();
    }

    private String getQualsString() {
        return AbstractReadBackedPileup.quals2String(this.getQuals());
    }

    @Override
    public FragmentCollection<PileupElement> toFragments() {
        return FragmentUtils.create(this);
    }
}

