/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.field;

import org.fest.reflect.field.Invoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldType<T> {
    private final String name;
    private final Class<T> type;

    static <T> FieldType<T> newFieldType(String name, Class<T> type) {
        if (type == null) {
            throw new NullPointerException("The type of the field to access should not be null");
        }
        return new FieldType<T>(name, type);
    }

    private FieldType(String name, Class<T> type) {
        this.name = name;
        this.type = type;
    }

    public Invoker<T> in(Object target) {
        return Invoker.newInvoker(this.name, this.type, target);
    }
}

