/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.recalibration.covariates;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.gatk.tools.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.gatk.utils.recalibration.ReadCovariates;
import org.broadinstitute.gatk.utils.recalibration.covariates.RequiredCovariate;
import org.broadinstitute.gatk.utils.sam.GATKSAMReadGroupRecord;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public class ReadGroupCovariate
implements RequiredCovariate {
    private final HashMap<String, Integer> readGroupLookupTable = new HashMap();
    private final HashMap<Integer, String> readGroupReverseLookupTable = new HashMap();
    private int nextId = 0;
    private String forceReadGroup;

    @Override
    public void initialize(RecalibrationArgumentCollection RAC) {
        this.forceReadGroup = RAC.FORCE_READGROUP;
    }

    @Override
    public void recordValues(GATKSAMRecord read, ReadCovariates values) {
        String readGroupId = this.readGroupValueFromRG(read.getReadGroup());
        int key = this.keyForReadGroup(readGroupId);
        int l = read.getReadLength();
        for (int i = 0; i < l; ++i) {
            values.addCovariate(key, key, key, i);
        }
    }

    @Override
    public final Object getValue(String str) {
        return str;
    }

    @Override
    public synchronized String formatKey(int key) {
        return this.readGroupReverseLookupTable.get(key);
    }

    @Override
    public int keyFromValue(Object value) {
        return this.keyForReadGroup((String)value);
    }

    public Set<Map.Entry<String, Integer>> getKeyMap() {
        return this.readGroupLookupTable.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int keyForReadGroup(String readGroupId) {
        if (!this.readGroupLookupTable.containsKey(readGroupId)) {
            ReadGroupCovariate readGroupCovariate = this;
            synchronized (readGroupCovariate) {
                if (!this.readGroupLookupTable.containsKey(readGroupId)) {
                    this.readGroupLookupTable.put(readGroupId, this.nextId);
                    this.readGroupReverseLookupTable.put(this.nextId, readGroupId);
                    ++this.nextId;
                }
            }
        }
        return this.readGroupLookupTable.get(readGroupId);
    }

    @Override
    public synchronized int maximumKeyValue() {
        return this.readGroupLookupTable.size() - 1;
    }

    private String readGroupValueFromRG(GATKSAMReadGroupRecord rg) {
        if (this.forceReadGroup != null) {
            return this.forceReadGroup;
        }
        String platformUnit = rg.getPlatformUnit();
        return platformUnit == null ? rg.getId() : platformUnit;
    }
}

