/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.File;
import java.io.IOException;
import java.util.List;
import proguard.util.ListUtil;

public class ClassPathEntry {
    private File file;
    private boolean output;
    private List filter;
    private List apkFilter;
    private List jarFilter;
    private List aarFilter;
    private List warFilter;
    private List earFilter;
    private List jmodFilter;
    private List zipFilter;
    private String cachedName;

    public ClassPathEntry(File file, boolean bl) {
        this.file = file;
        this.output = bl;
    }

    public String getName() {
        if (this.cachedName == null) {
            this.cachedName = this.getUncachedName();
        }
        return this.cachedName;
    }

    private String getUncachedName() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return this.file.getPath();
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.cachedName = null;
    }

    public boolean isOutput() {
        return this.output;
    }

    public void setOutput(boolean bl) {
        this.output = bl;
    }

    public boolean isDex() {
        return this.hasExtension(".dex");
    }

    public boolean isApk() {
        return this.hasExtension(".apk") || this.hasExtension(".ap_");
    }

    public boolean isJar() {
        return this.hasExtension(".jar");
    }

    public boolean isAar() {
        return this.hasExtension(".aar");
    }

    public boolean isWar() {
        return this.hasExtension(".war");
    }

    public boolean isEar() {
        return this.hasExtension(".ear");
    }

    public boolean isJmod() {
        return this.hasExtension(".jmod");
    }

    public boolean isZip() {
        return this.hasExtension(".zip");
    }

    private boolean hasExtension(String string) {
        return ClassPathEntry.endsWithIgnoreCase(this.file.getPath(), string);
    }

    private static boolean endsWithIgnoreCase(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        return string.regionMatches(true, n - n2, string2, 0, n2);
    }

    public boolean isFiltered() {
        return this.filter != null || this.apkFilter != null || this.jarFilter != null || this.aarFilter != null || this.warFilter != null || this.earFilter != null || this.jmodFilter != null || this.zipFilter != null;
    }

    public List getFilter() {
        return this.filter;
    }

    public void setFilter(List list) {
        this.filter = list == null || list.size() == 0 ? null : list;
    }

    public List getApkFilter() {
        return this.apkFilter;
    }

    public void setApkFilter(List list) {
        this.apkFilter = list == null || list.size() == 0 ? null : list;
    }

    public List getJarFilter() {
        return this.jarFilter;
    }

    public void setJarFilter(List list) {
        this.jarFilter = list == null || list.size() == 0 ? null : list;
    }

    public List getAarFilter() {
        return this.aarFilter;
    }

    public void setAarFilter(List list) {
        this.aarFilter = list == null || list.size() == 0 ? null : list;
    }

    public List getWarFilter() {
        return this.warFilter;
    }

    public void setWarFilter(List list) {
        this.warFilter = list == null || list.size() == 0 ? null : list;
    }

    public List getEarFilter() {
        return this.earFilter;
    }

    public void setEarFilter(List list) {
        this.earFilter = list == null || list.size() == 0 ? null : list;
    }

    public List getJmodFilter() {
        return this.jmodFilter;
    }

    public void setJmodFilter(List list) {
        this.jmodFilter = list == null || list.size() == 0 ? null : this.jmodFilter;
    }

    public List getZipFilter() {
        return this.zipFilter;
    }

    public void setZipFilter(List list) {
        this.zipFilter = list == null || list.size() == 0 ? null : list;
    }

    public String toString() {
        String string = this.getName();
        if (this.filter != null || this.jarFilter != null || this.aarFilter != null || this.warFilter != null || this.earFilter != null || this.jmodFilter != null || this.zipFilter != null) {
            string = string + "(" + (this.aarFilter != null ? ListUtil.commaSeparatedString(this.aarFilter, true) : "") + ";" + (this.apkFilter != null ? ListUtil.commaSeparatedString(this.apkFilter, true) : "") + ";" + (this.zipFilter != null ? ListUtil.commaSeparatedString(this.zipFilter, true) : "") + ";" + (this.jmodFilter != null ? ListUtil.commaSeparatedString(this.jmodFilter, true) : "") + ";" + (this.earFilter != null ? ListUtil.commaSeparatedString(this.earFilter, true) : "") + ";" + (this.warFilter != null ? ListUtil.commaSeparatedString(this.warFilter, true) : "") + ";" + (this.jarFilter != null ? ListUtil.commaSeparatedString(this.jarFilter, true) : "") + ";" + (this.filter != null ? ListUtil.commaSeparatedString(this.filter, true) : "") + ")";
        }
        return string;
    }
}

