/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;
import proguard.DataEntryWriterFactory;
import proguard.InputReader;
import proguard.classfile.ClassPool;
import proguard.classfile.util.ClassUtil;
import proguard.io.ClassFilter;
import proguard.io.ClassMapDataEntryWriter;
import proguard.io.DataEntryCopier;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryRewriter;
import proguard.io.DataEntryWriter;
import proguard.io.DirectoryFilter;
import proguard.io.ExtraDataEntryWriter;
import proguard.io.IdleRewriter;
import proguard.io.ManifestRewriter;
import proguard.io.NameFilter;
import proguard.io.NameFilteredDataEntryWriter;
import proguard.io.RenamedDataEntryReader;
import proguard.io.RenamedDataEntryWriter;
import proguard.util.MultiValueMap;

public class OutputWriter {
    private final Configuration configuration;

    public OutputWriter(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool classPool, MultiValueMap<String, String> multiValueMap) throws IOException {
        ClassPath classPath = this.configuration.programJars;
        DataEntryWriterFactory dataEntryWriterFactory = new DataEntryWriterFactory(classPool, multiValueMap);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < classPath.size(); ++i) {
            ClassPathEntry classPathEntry = classPath.get(i);
            if (!classPathEntry.isOutput()) {
                n2 = i;
                continue;
            }
            int n3 = i + 1;
            if (n3 != classPath.size() && classPath.get(n3).isOutput()) continue;
            this.writeOutput(dataEntryWriterFactory, classPool, classPath, n, n2 + 1, n3);
            n = n3;
        }
    }

    private void writeOutput(DataEntryWriterFactory dataEntryWriterFactory, ClassPool classPool, ClassPath classPath, int n, int n2, int n3) throws IOException {
        try {
            DataEntryReader dataEntryReader;
            DataEntryCopier dataEntryCopier;
            DataEntryWriter dataEntryWriter = dataEntryWriterFactory.createDataEntryWriter(classPath, n2, n3);
            if (this.configuration.addConfigurationDebugging) {
                dataEntryWriter = new ExtraDataEntryWriter("classmap.txt", dataEntryWriter, new ClassMapDataEntryWriter(classPool, dataEntryWriter));
                System.err.println("Warning: -addconfigurationdebugging is enabled; the resulting build will contain obfuscation information.");
                System.err.println("It should only be used for debugging purposes.");
            }
            DataEntryWriter dataEntryWriter2 = dataEntryWriter;
            if (this.configuration.obfuscate && this.configuration.adaptResourceFileNames != null) {
                dataEntryWriter2 = this.renameResourceFiles(classPool, dataEntryWriter2);
            }
            DataEntryReader dataEntryReader2 = dataEntryCopier = new DataEntryCopier(dataEntryWriter2);
            if ((this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate) && this.configuration.adaptResourceFileContents != null) {
                dataEntryReader = dataEntryReader2;
                if (this.configuration.obfuscate) {
                    dataEntryReader = this.adaptResourceFiles(classPool, dataEntryWriter2);
                }
                dataEntryReader2 = new NameFilter(this.configuration.adaptResourceFileContents, dataEntryReader, dataEntryReader2);
            }
            dataEntryReader = this.writeDirectories(classPool, dataEntryCopier, dataEntryReader2);
            dataEntryReader = new ClassFilter(new IdleRewriter(dataEntryWriter), dataEntryReader);
            new InputReader(this.configuration).readInput("  Copying resources from program ", classPath, n, n2, dataEntryReader);
            dataEntryWriter.close();
        }
        catch (IOException iOException) {
            throw (IOException)new IOException("Can't write [" + classPath.get(n2).getName() + "] (" + iOException.getMessage() + ")").initCause(iOException);
        }
    }

    private DataEntryWriter renameResourceFiles(ClassPool classPool, DataEntryWriter dataEntryWriter) {
        Map map = OutputWriter.createPackagePrefixMap(classPool);
        return new NameFilteredDataEntryWriter(this.configuration.adaptResourceFileNames, (DataEntryWriter)new RenamedDataEntryWriter(classPool, map, dataEntryWriter), dataEntryWriter);
    }

    private DataEntryReader adaptResourceFiles(ClassPool classPool, DataEntryWriter dataEntryWriter) {
        Charset charset = this.configuration.android ? Charset.forName("UTF-8") : Charset.defaultCharset();
        return new NameFilter("META-INF/MANIFEST.MF,META-INF/*.SF", (DataEntryReader)new ManifestRewriter(classPool, charset, dataEntryWriter), (DataEntryReader)new DataEntryRewriter(classPool, charset, dataEntryWriter));
    }

    private DirectoryFilter writeDirectories(ClassPool classPool, DataEntryReader dataEntryReader, DataEntryReader dataEntryReader2) {
        NameFilter nameFilter = null;
        if (this.configuration.keepDirectories != null) {
            Map map = OutputWriter.createPackagePrefixMap(classPool);
            nameFilter = new NameFilter(this.configuration.keepDirectories, (DataEntryReader)new RenamedDataEntryReader(map, dataEntryReader, dataEntryReader));
        }
        return new DirectoryFilter(nameFilter, dataEntryReader2);
    }

    private static Map createPackagePrefixMap(ClassPool classPool) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = classPool.classNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = ClassUtil.internalPackagePrefix(string);
            String string3 = (String)hashMap.get(string2);
            if (string3 != null && string3.equals(string2)) continue;
            String string4 = classPool.getClass(string).getName();
            String string5 = ClassUtil.internalPackagePrefix(string4);
            hashMap.put(string2, string5);
        }
        return hashMap;
    }
}

