/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.InvocationUnit;
import proguard.evaluation.SimplifiedInvocationUnit;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;

public class BasicInvocationUnit
extends SimplifiedInvocationUnit
implements InvocationUnit,
MemberVisitor {
    protected final ValueFactory valueFactory;
    private Clazz returnTypeClass;

    public BasicInvocationUnit(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    @Override
    public Value getExceptionValue(Clazz clazz, ClassConstant classConstant) {
        String string = classConstant != null ? classConstant.getName(clazz) : "java/lang/Throwable";
        Clazz clazz2 = classConstant != null ? classConstant.referencedClass : null;
        return this.valueFactory.createReferenceValue(string, clazz2, true, false);
    }

    @Override
    public void setFieldClassValue(Clazz clazz, RefConstant refConstant, ReferenceValue referenceValue) {
    }

    @Override
    public Value getFieldClassValue(Clazz clazz, RefConstant refConstant, String string) {
        this.returnTypeClass = null;
        refConstant.referencedMemberAccept(this);
        return this.valueFactory.createValue(string, this.returnTypeClass, true, true);
    }

    @Override
    public void setFieldValue(Clazz clazz, RefConstant refConstant, Value value) {
    }

    @Override
    public Value getFieldValue(Clazz clazz, RefConstant refConstant, String string) {
        this.returnTypeClass = null;
        refConstant.referencedMemberAccept(this);
        return this.valueFactory.createValue(string, this.returnTypeClass, true, true);
    }

    @Override
    public void setMethodParameterValue(Clazz clazz, RefConstant refConstant, int n, Value value) {
    }

    @Override
    public Value getMethodParameterValue(Clazz clazz, Method method, int n, String string, Clazz clazz2) {
        boolean bl = n == 0 && (method.getAccessFlags() & 8) == 0;
        return this.valueFactory.createValue(string, clazz2, true, !bl);
    }

    @Override
    public void setMethodReturnValue(Clazz clazz, Method method, Value value) {
    }

    @Override
    public Value getMethodReturnValue(Clazz clazz, RefConstant refConstant, String string) {
        this.returnTypeClass = null;
        refConstant.referencedMemberAccept(this);
        return this.valueFactory.createValue(string, this.returnTypeClass, true, true);
    }

    @Override
    public Value getMethodReturnValue(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant, String string) {
        Clazz[] clazzArray = invokeDynamicConstant.referencedClasses;
        Clazz clazz2 = clazzArray != null && ClassUtil.isInternalClassType(string) ? clazzArray[clazzArray.length - 1] : null;
        return this.valueFactory.createValue(string, clazz2, true, true);
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.returnTypeClass = programField.referencedClass;
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        Clazz[] clazzArray = programMethod.referencedClasses;
        if (clazzArray != null && ClassUtil.isInternalClassType(programMethod.getDescriptor(programClass))) {
            this.returnTypeClass = clazzArray[clazzArray.length - 1];
        }
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        this.returnTypeClass = libraryField.referencedClass;
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        Clazz[] clazzArray = libraryMethod.referencedClasses;
        if (clazzArray != null && ClassUtil.isInternalClassType(libraryMethod.getDescriptor(libraryClass))) {
            this.returnTypeClass = clazzArray[clazzArray.length - 1];
        }
    }
}

