/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.evaluation.TracedStack;
import proguard.evaluation.TracedVariables;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ParticularValueFactory;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.info.SideEffectInstructionChecker;

public class EvaluationSimplifier
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor {
    private static final int POS_ZERO_FLOAT_BITS = Float.floatToIntBits(0.0f);
    private static final long POS_ZERO_DOUBLE_BITS = Double.doubleToLongBits(0.0);
    private static final boolean DEBUG = false;
    private final InstructionVisitor extraInstructionVisitor;
    private final PartialEvaluator partialEvaluator;
    private final SideEffectInstructionChecker sideEffectInstructionChecker = new SideEffectInstructionChecker(true, true);
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(true, true);

    public EvaluationSimplifier() {
        this(new PartialEvaluator(), null);
    }

    public EvaluationSimplifier(PartialEvaluator partialEvaluator, InstructionVisitor instructionVisitor) {
        this.partialEvaluator = partialEvaluator;
        this.extraInstructionVisitor = instructionVisitor;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unexpected error while simplifying instructions after partial evaluation:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
            System.err.println("Not optimizing this method");
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        int n = codeAttribute.u4codeLength;
        this.codeAttributeEditor.reset(n);
        for (int i = 0; i < n; ++i) {
            if (!this.partialEvaluator.isTraced(i)) continue;
            Instruction instruction = InstructionFactory.create(codeAttribute.code, i);
            instruction.accept(clazz, method, codeAttribute, i, this);
        }
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case 108: 
            case 112: {
                if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, simpleInstruction)) {
                    this.replaceIntegerPushInstruction(clazz, n, simpleInstruction);
                    break;
                }
                if (!this.isDivisionByZero(n, 1)) break;
                this.replaceByException(clazz, n, simpleInstruction, "java/lang/ArithmeticException");
                break;
            }
            case 109: 
            case 113: {
                if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, simpleInstruction)) {
                    this.replaceLongPushInstruction(clazz, n, simpleInstruction);
                    break;
                }
                if (!this.isDivisionByZero(n, 2)) break;
                this.replaceByException(clazz, n, simpleInstruction, "java/lang/ArithmeticException");
                break;
            }
            case 110: 
            case 114: {
                if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, simpleInstruction)) {
                    this.replaceFloatPushInstruction(clazz, n, simpleInstruction);
                    break;
                }
                if (!this.isDivisionByZero(n, 3)) break;
                this.replaceByException(clazz, n, simpleInstruction, "java/lang/ArithmeticException");
                break;
            }
            case 111: 
            case 115: {
                if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, simpleInstruction)) {
                    this.replaceDoublePushInstruction(clazz, n, simpleInstruction);
                    break;
                }
                if (!this.isDivisionByZero(n, 4)) break;
                this.replaceByException(clazz, n, simpleInstruction, "java/lang/ArithmeticException");
                break;
            }
            case -66: 
            case 46: 
            case 51: 
            case 52: 
            case 53: {
                if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, simpleInstruction)) {
                    this.replaceIntegerPushInstruction(clazz, n, simpleInstruction);
                    break;
                }
                if (!this.isNullReference(n, simpleInstruction.stackPopCount(clazz) - 1)) break;
                this.replaceByException(clazz, n, simpleInstruction, "java/lang/NullPointerException");
                break;
            }
            case -128: 
            case -126: 
            case -120: 
            case -117: 
            case -114: 
            case -111: 
            case -110: 
            case -109: 
            case 96: 
            case 100: 
            case 104: 
            case 116: 
            case 120: 
            case 122: 
            case 124: 
            case 126: {
                if (this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, simpleInstruction)) break;
                this.replaceIntegerPushInstruction(clazz, n, simpleInstruction);
                break;
            }
            case 47: {
                if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, simpleInstruction)) {
                    this.replaceLongPushInstruction(clazz, n, simpleInstruction);
                    break;
                }
                if (!this.isNullReference(n, simpleInstruction.stackPopCount(clazz) - 1)) break;
                this.replaceByException(clazz, n, simpleInstruction, "java/lang/NullPointerException");
                break;
            }
            case -127: 
            case -125: 
            case -123: 
            case -116: 
            case -113: 
            case 97: 
            case 101: 
            case 105: 
            case 117: 
            case 121: 
            case 123: 
            case 125: 
            case 127: {
                if (this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, simpleInstruction)) break;
                this.replaceLongPushInstruction(clazz, n, simpleInstruction);
                break;
            }
            case 48: {
                if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, simpleInstruction)) {
                    this.replaceFloatPushInstruction(clazz, n, simpleInstruction);
                    break;
                }
                if (!this.isNullReference(n, simpleInstruction.stackPopCount(clazz) - 1)) break;
                this.replaceByException(clazz, n, simpleInstruction, "java/lang/NullPointerException");
                break;
            }
            case -122: 
            case -119: 
            case -112: 
            case 98: 
            case 102: 
            case 106: 
            case 118: {
                if (this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, simpleInstruction)) break;
                this.replaceFloatPushInstruction(clazz, n, simpleInstruction);
                break;
            }
            case 49: {
                if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, simpleInstruction)) {
                    this.replaceDoublePushInstruction(clazz, n, simpleInstruction);
                    break;
                }
                if (!this.isNullReference(n, simpleInstruction.stackPopCount(clazz) - 1)) break;
                this.replaceByException(clazz, n, simpleInstruction, "java/lang/NullPointerException");
                break;
            }
            case -121: 
            case -118: 
            case -115: 
            case 99: 
            case 103: 
            case 107: 
            case 119: {
                if (this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, simpleInstruction)) break;
                this.replaceDoublePushInstruction(clazz, n, simpleInstruction);
                break;
            }
            case 50: {
                if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, simpleInstruction)) {
                    this.replaceReferencePushInstruction(clazz, n, simpleInstruction);
                    break;
                }
                if (!this.isNullReference(n, simpleInstruction.stackPopCount(clazz) - 1)) break;
                this.replaceByException(clazz, n, simpleInstruction, "java/lang/NullPointerException");
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                if (!SideEffectInstructionChecker.OPTIMIZE_CONSERVATIVELY || !this.isNullReference(n, simpleInstruction.stackPopCount(clazz) - 1)) break;
                this.replaceByException(clazz, n, simpleInstruction, "java/lang/NullPointerException");
            }
        }
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        int n2 = variableInstruction.variableIndex;
        switch (variableInstruction.opcode) {
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.replaceIntegerPushInstruction(clazz, n, variableInstruction, n2);
                break;
            }
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.replaceLongPushInstruction(clazz, n, variableInstruction, n2);
                break;
            }
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.replaceFloatPushInstruction(clazz, n, variableInstruction, n2);
                break;
            }
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.replaceDoublePushInstruction(clazz, n, variableInstruction, n2);
                break;
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.replaceReferencePushInstruction(clazz, n, variableInstruction);
                break;
            }
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                this.deleteReferencePopInstruction(clazz, n, variableInstruction);
                break;
            }
            case -87: {
                this.replaceBranchInstruction(clazz, n, variableInstruction);
            }
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -74: 
            case -73: 
            case -71: {
                if (SideEffectInstructionChecker.OPTIMIZE_CONSERVATIVELY && this.isNullReference(n, constantInstruction.stackPopCount(clazz) - 1)) {
                    this.replaceByException(clazz, n, constantInstruction, "java/lang/NullPointerException");
                    break;
                }
            }
            case -78: 
            case -76: 
            case -72: {
                if (constantInstruction.stackPushCount(clazz) <= 0 || this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, constantInstruction)) break;
                this.replaceAnyPushInstruction(clazz, n, constantInstruction);
                break;
            }
            case -64: {
                this.replaceReferencePushInstruction(clazz, n, constantInstruction);
            }
        }
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        switch (branchInstruction.opcode) {
            case -89: 
            case -56: {
                break;
            }
            case -88: 
            case -55: {
                this.replaceJsrInstruction(clazz, n, branchInstruction);
                break;
            }
            default: {
                this.replaceBranchInstruction(clazz, n, branchInstruction);
            }
        }
    }

    @Override
    public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, TableSwitchInstruction tableSwitchInstruction) {
        this.replaceBranchInstruction(clazz, n, tableSwitchInstruction);
        if (!this.codeAttributeEditor.isModified(n)) {
            this.replaceSimpleEnumSwitchInstruction(clazz, codeAttribute, n, tableSwitchInstruction);
            if (!this.codeAttributeEditor.isModified(n)) {
                this.cleanUpSwitchInstruction(clazz, n, tableSwitchInstruction);
                this.trimSwitchInstruction(clazz, n, tableSwitchInstruction);
            }
        }
    }

    @Override
    public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
        this.replaceBranchInstruction(clazz, n, lookUpSwitchInstruction);
        if (!this.codeAttributeEditor.isModified(n)) {
            this.replaceSimpleEnumSwitchInstruction(clazz, codeAttribute, n, lookUpSwitchInstruction);
            if (!this.codeAttributeEditor.isModified(n)) {
                this.cleanUpSwitchInstruction(clazz, n, lookUpSwitchInstruction);
                this.trimSwitchInstruction(clazz, n, lookUpSwitchInstruction);
            }
        }
    }

    private void replaceAnyPushInstruction(Clazz clazz, int n, Instruction instruction) {
        Value value = this.partialEvaluator.getStackAfter(n).getTop(0);
        if (value.isParticular()) {
            switch (value.computationalType()) {
                case 1: {
                    this.replaceIntegerPushInstruction(clazz, n, instruction);
                    break;
                }
                case 2: {
                    this.replaceLongPushInstruction(clazz, n, instruction);
                    break;
                }
                case 3: {
                    this.replaceFloatPushInstruction(clazz, n, instruction);
                    break;
                }
                case 4: {
                    this.replaceDoublePushInstruction(clazz, n, instruction);
                    break;
                }
                case 5: {
                    this.replaceReferencePushInstruction(clazz, n, instruction);
                }
            }
        }
    }

    private void replaceIntegerPushInstruction(Clazz clazz, int n, Instruction instruction) {
        this.replaceIntegerPushInstruction(clazz, n, instruction, this.partialEvaluator.getVariablesBefore(n).size());
    }

    private void replaceIntegerPushInstruction(Clazz clazz, int n, Instruction instruction, int n2) {
        Value value = this.partialEvaluator.getStackAfter(n).getTop(0);
        if (value.isParticular()) {
            int n3 = value.integerValue().value();
            if ((short)n3 == n3) {
                this.replaceConstantPushInstruction(clazz, n, instruction, (byte)17, n3);
            } else {
                ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
                ConstantInstruction constantInstruction = new ConstantInstruction(18, constantPoolEditor.addIntegerConstant(n3));
                this.replaceInstruction(clazz, n, instruction, constantInstruction);
            }
        } else if (value.isSpecific()) {
            TracedVariables tracedVariables = this.partialEvaluator.getVariablesBefore(n);
            for (int i = 0; i < n2; ++i) {
                if (!value.equals(tracedVariables.load(i))) continue;
                this.replaceVariablePushInstruction(clazz, n, instruction, (byte)21, i);
                break;
            }
        }
    }

    private void replaceLongPushInstruction(Clazz clazz, int n, Instruction instruction) {
        this.replaceLongPushInstruction(clazz, n, instruction, this.partialEvaluator.getVariablesBefore(n).size());
    }

    private void replaceLongPushInstruction(Clazz clazz, int n, Instruction instruction, int n2) {
        Value value = this.partialEvaluator.getStackAfter(n).getTop(0);
        if (value.isParticular()) {
            long l = value.longValue().value();
            if (l == 0L || l == 1L) {
                this.replaceConstantPushInstruction(clazz, n, instruction, (byte)9, (int)l);
            } else {
                ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
                ConstantInstruction constantInstruction = new ConstantInstruction(20, constantPoolEditor.addLongConstant(l));
                this.replaceInstruction(clazz, n, instruction, constantInstruction);
            }
        } else if (value.isSpecific()) {
            TracedVariables tracedVariables = this.partialEvaluator.getVariablesBefore(n);
            for (int i = 0; i < n2; ++i) {
                if (!value.equals(tracedVariables.load(i)) || tracedVariables.load(i + 1) == null || tracedVariables.load(i + 1).computationalType() != 7) continue;
                this.replaceVariablePushInstruction(clazz, n, instruction, (byte)22, i);
            }
        }
    }

    private void replaceFloatPushInstruction(Clazz clazz, int n, Instruction instruction) {
        this.replaceFloatPushInstruction(clazz, n, instruction, this.partialEvaluator.getVariablesBefore(n).size());
    }

    private void replaceFloatPushInstruction(Clazz clazz, int n, Instruction instruction, int n2) {
        Value value = this.partialEvaluator.getStackAfter(n).getTop(0);
        if (value.isParticular()) {
            float f = value.floatValue().value();
            if (f == 0.0f && Float.floatToIntBits(f) == POS_ZERO_FLOAT_BITS || f == 1.0f || f == 2.0f) {
                this.replaceConstantPushInstruction(clazz, n, instruction, (byte)11, (int)f);
            } else {
                ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
                ConstantInstruction constantInstruction = new ConstantInstruction(18, constantPoolEditor.addFloatConstant(f));
                this.replaceInstruction(clazz, n, instruction, constantInstruction);
            }
        } else if (value.isSpecific()) {
            TracedVariables tracedVariables = this.partialEvaluator.getVariablesBefore(n);
            for (int i = 0; i < n2; ++i) {
                if (!value.equals(tracedVariables.load(i))) continue;
                this.replaceVariablePushInstruction(clazz, n, instruction, (byte)23, i);
            }
        }
    }

    private void replaceDoublePushInstruction(Clazz clazz, int n, Instruction instruction) {
        this.replaceDoublePushInstruction(clazz, n, instruction, this.partialEvaluator.getVariablesBefore(n).size());
    }

    private void replaceDoublePushInstruction(Clazz clazz, int n, Instruction instruction, int n2) {
        Value value = this.partialEvaluator.getStackAfter(n).getTop(0);
        if (value.isParticular()) {
            double d = value.doubleValue().value();
            if (d == 0.0 && Double.doubleToLongBits(d) == POS_ZERO_DOUBLE_BITS || d == 1.0) {
                this.replaceConstantPushInstruction(clazz, n, instruction, (byte)14, (int)d);
            } else {
                ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
                ConstantInstruction constantInstruction = new ConstantInstruction(20, constantPoolEditor.addDoubleConstant(d));
                this.replaceInstruction(clazz, n, instruction, constantInstruction);
            }
        } else if (value.isSpecific()) {
            TracedVariables tracedVariables = this.partialEvaluator.getVariablesBefore(n);
            for (int i = 0; i < n2; ++i) {
                if (!value.equals(tracedVariables.load(i)) || tracedVariables.load(i + 1) == null || tracedVariables.load(i + 1).computationalType() != 7) continue;
                this.replaceVariablePushInstruction(clazz, n, instruction, (byte)24, i);
            }
        }
    }

    private void replaceReferencePushInstruction(Clazz clazz, int n, Instruction instruction) {
        ReferenceValue referenceValue = this.partialEvaluator.getStackAfter(n).getTop(0).referenceValue();
        if (referenceValue.isNull() == 1) {
            this.replaceConstantPushInstruction(clazz, n, instruction, (byte)1, 0);
        }
    }

    private void replaceConstantPushInstruction(Clazz clazz, int n, Instruction instruction, byte by, int n2) {
        SimpleInstruction simpleInstruction = new SimpleInstruction(by, n2);
        this.replaceInstruction(clazz, n, instruction, simpleInstruction);
    }

    private void replaceVariablePushInstruction(Clazz clazz, int n, Instruction instruction, byte by, int n2) {
        VariableInstruction variableInstruction = new VariableInstruction(by, n2);
        this.replaceInstruction(clazz, n, instruction, variableInstruction);
    }

    private void replaceJsrInstruction(Clazz clazz, int n, BranchInstruction branchInstruction) {
        int n2 = n + branchInstruction.branchOffset;
        if (!this.partialEvaluator.isSubroutineReturning(n2) || this.partialEvaluator.branchOrigins(n2).instructionOffsetCount() == 1) {
            this.replaceBranchInstruction(clazz, n, branchInstruction);
        } else if (!this.partialEvaluator.isTraced(n + branchInstruction.length(n))) {
            this.replaceByInfiniteLoop(clazz, n + branchInstruction.length(n), branchInstruction);
        }
    }

    private void deleteReferencePopInstruction(Clazz clazz, int n, Instruction instruction) {
        if (this.partialEvaluator.isSubroutineStart(n) && (!this.partialEvaluator.isSubroutineReturning(n) || this.partialEvaluator.branchOrigins(n).instructionOffsetCount() == 1)) {
            this.codeAttributeEditor.deleteInstruction(n);
        }
    }

    private void replaceBranchInstruction(Clazz clazz, int n, Instruction instruction) {
        int n2;
        InstructionOffsetValue instructionOffsetValue = this.partialEvaluator.branchTargets(n);
        if (instructionOffsetValue != null && instructionOffsetValue.instructionOffsetCount() == 1 && (n2 = instructionOffsetValue.instructionOffset(0) - n) != instruction.length(n)) {
            BranchInstruction branchInstruction = new BranchInstruction(-89, n2);
            this.replaceInstruction(clazz, n, instruction, branchInstruction);
        }
    }

    private void replaceSimpleEnumSwitchInstruction(Clazz clazz, CodeAttribute codeAttribute, int n, TableSwitchInstruction tableSwitchInstruction) {
        ReferenceValue referenceValue;
        int n2;
        InstructionOffsetValue instructionOffsetValue = this.partialEvaluator.getStackBefore(n).getTopProducerValue(0).instructionOffsetValue();
        if (instructionOffsetValue.instructionOffsetCount() == 1 && codeAttribute.code[n2 = instructionOffsetValue.instructionOffset(0)] == 46 && !this.codeAttributeEditor.isModified(n2) && (referenceValue = this.partialEvaluator.getStackBefore(n2).getTop(1).referenceValue()).isParticular()) {
            this.replaceSimpleEnumSwitchInstruction(clazz, codeAttribute, n2, n, tableSwitchInstruction, referenceValue);
        }
    }

    private void replaceSimpleEnumSwitchInstruction(Clazz clazz, CodeAttribute codeAttribute, int n, int n2, TableSwitchInstruction tableSwitchInstruction, ReferenceValue referenceValue) {
        ParticularValueFactory particularValueFactory = new ParticularValueFactory();
        int[] nArray = tableSwitchInstruction.jumpOffsets;
        int[] nArray2 = new int[referenceValue.arrayLength(particularValueFactory).value()];
        for (int i = 0; i < nArray2.length; ++i) {
            int n3 = referenceValue.integerArrayLoad(particularValueFactory.createIntegerValue(i), particularValueFactory).value();
            nArray2[i] = n3 >= tableSwitchInstruction.lowCase && n3 <= tableSwitchInstruction.highCase ? nArray[n3 - tableSwitchInstruction.lowCase] : tableSwitchInstruction.defaultOffset;
        }
        tableSwitchInstruction.lowCase = 0;
        tableSwitchInstruction.highCase = nArray2.length - 1;
        tableSwitchInstruction.jumpOffsets = nArray2;
        this.replaceSimpleEnumSwitchInstruction(clazz, n, n2, (SwitchInstruction)tableSwitchInstruction);
        this.cleanUpSwitchInstruction(clazz, n2, tableSwitchInstruction);
        this.trimSwitchInstruction(clazz, n2, tableSwitchInstruction);
    }

    private void replaceSimpleEnumSwitchInstruction(Clazz clazz, CodeAttribute codeAttribute, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
        ReferenceValue referenceValue;
        int n2;
        InstructionOffsetValue instructionOffsetValue = this.partialEvaluator.getStackBefore(n).getTopProducerValue(0).instructionOffsetValue();
        if (instructionOffsetValue.instructionOffsetCount() == 1 && codeAttribute.code[n2 = instructionOffsetValue.instructionOffset(0)] == 46 && !this.codeAttributeEditor.isModified(n2) && (referenceValue = this.partialEvaluator.getStackBefore(n2).getTop(1).referenceValue()).isParticular()) {
            this.replaceSimpleEnumSwitchInstruction(clazz, codeAttribute, n2, n, lookUpSwitchInstruction, referenceValue);
        }
    }

    private void replaceSimpleEnumSwitchInstruction(Clazz clazz, CodeAttribute codeAttribute, int n, int n2, LookUpSwitchInstruction lookUpSwitchInstruction, ReferenceValue referenceValue) {
        ParticularValueFactory particularValueFactory = new ParticularValueFactory();
        int[] nArray = lookUpSwitchInstruction.cases;
        int[] nArray2 = lookUpSwitchInstruction.jumpOffsets;
        int[] nArray3 = new int[referenceValue.arrayLength(particularValueFactory).value()];
        for (int i = 0; i < nArray3.length; ++i) {
            int n3 = referenceValue.integerArrayLoad(particularValueFactory.createIntegerValue(i), particularValueFactory).value();
            int n4 = Arrays.binarySearch(nArray, n3);
            nArray3[i] = n4 >= 0 ? nArray2[n4] : lookUpSwitchInstruction.defaultOffset;
        }
        TableSwitchInstruction tableSwitchInstruction = new TableSwitchInstruction(-86, lookUpSwitchInstruction.defaultOffset, 0, nArray3.length - 1, nArray3);
        this.replaceSimpleEnumSwitchInstruction(clazz, n, n2, (SwitchInstruction)tableSwitchInstruction);
        this.cleanUpSwitchInstruction(clazz, n2, tableSwitchInstruction);
        this.trimSwitchInstruction(clazz, n2, tableSwitchInstruction);
    }

    private void cleanUpSwitchInstruction(Clazz clazz, int n, SwitchInstruction switchInstruction) {
        InstructionOffsetValue instructionOffsetValue = this.partialEvaluator.branchTargets(n);
        int n2 = instructionOffsetValue.instructionOffset(instructionOffsetValue.instructionOffsetCount() - 1) - n;
        SwitchInstruction switchInstruction2 = null;
        int[] nArray = switchInstruction.jumpOffsets;
        for (int i = 0; i < nArray.length; ++i) {
            if (instructionOffsetValue.contains(n + nArray[i])) continue;
            nArray[i] = n2;
            switchInstruction2 = switchInstruction;
        }
        if (!instructionOffsetValue.contains(n + switchInstruction.defaultOffset)) {
            switchInstruction.defaultOffset = n2;
            switchInstruction2 = switchInstruction;
        }
        if (switchInstruction2 != null) {
            this.replaceInstruction(clazz, n, switchInstruction, switchInstruction2);
        }
    }

    private void trimSwitchInstruction(Clazz clazz, int n, TableSwitchInstruction tableSwitchInstruction) {
        int n2;
        int n3;
        int n4 = tableSwitchInstruction.defaultOffset;
        int[] nArray = tableSwitchInstruction.jumpOffsets;
        int n5 = nArray.length;
        for (n3 = 0; n3 < n5 && nArray[n3] == n4; ++n3) {
        }
        for (n2 = n5 - 1; n2 >= 0 && nArray[n2] == n4; --n2) {
        }
        int n6 = n2 - n3 + 1;
        if (n6 < n5) {
            if (n6 <= 0) {
                BranchInstruction branchInstruction = new BranchInstruction(-89, n4);
                this.replaceInstruction(clazz, n, tableSwitchInstruction, branchInstruction);
            } else {
                int[] nArray2 = new int[n6];
                System.arraycopy(nArray, n3, nArray2, 0, n6);
                tableSwitchInstruction.jumpOffsets = nArray2;
                tableSwitchInstruction.lowCase += n3;
                tableSwitchInstruction.highCase -= n5 - n6 - n3;
                this.replaceInstruction(clazz, n, tableSwitchInstruction, tableSwitchInstruction);
            }
        }
    }

    private void trimSwitchInstruction(Clazz clazz, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
        int n2;
        int n3 = lookUpSwitchInstruction.defaultOffset;
        int[] nArray = lookUpSwitchInstruction.jumpOffsets;
        int n4 = n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n3) continue;
            --n4;
        }
        if (n4 < n2) {
            if (n4 <= 0) {
                BranchInstruction branchInstruction = new BranchInstruction(-89, n3);
                this.replaceInstruction(clazz, n, lookUpSwitchInstruction, branchInstruction);
            } else {
                int[] nArray2 = lookUpSwitchInstruction.cases;
                int[] nArray3 = new int[n4];
                int[] nArray4 = new int[n4];
                int n5 = 0;
                for (int i = 0; i < n2; ++i) {
                    if (nArray[i] == n3) continue;
                    nArray3[n5] = nArray[i];
                    nArray4[n5++] = nArray2[i];
                }
                lookUpSwitchInstruction.jumpOffsets = nArray3;
                lookUpSwitchInstruction.cases = nArray4;
                this.replaceInstruction(clazz, n, lookUpSwitchInstruction, lookUpSwitchInstruction);
            }
        }
    }

    private boolean isDivisionByZero(int n, int n2) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(n);
        Value value = tracedStack.getTop(0);
        switch (n2) {
            case 1: {
                return value.computationalType() == 1 && value.isParticular() && value.integerValue().value() == 0;
            }
            case 2: {
                return value.computationalType() == 2 && value.isParticular() && value.longValue().value() == 0L;
            }
            case 3: {
                return value.computationalType() == 3 && value.isParticular() && value.floatValue().value() == 0.0f;
            }
            case 4: {
                return value.computationalType() == 4 && value.isParticular() && value.doubleValue().value() == 0.0;
            }
        }
        return false;
    }

    private boolean isNullReference(int n, int n2) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(n);
        Value value = tracedStack.getTop(n2);
        return value.computationalType() == 5 && value.isParticular() && value.referenceValue().isNull() == 1;
    }

    private void replaceByException(Clazz clazz, int n, Instruction instruction, String string) {
        ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
        Instruction[] instructionArray = new Instruction[]{new ConstantInstruction(-69, constantPoolEditor.addClassConstant(string, null)), new SimpleInstruction(89), new ConstantInstruction(-73, constantPoolEditor.addMethodrefConstant(string, "<init>", "()V", null, null)), new SimpleInstruction(-65)};
        this.codeAttributeEditor.replaceInstruction(n, instructionArray);
        if (this.extraInstructionVisitor != null) {
            instruction.accept(clazz, null, null, n, this.extraInstructionVisitor);
        }
    }

    private void replaceByInfiniteLoop(Clazz clazz, int n, Instruction instruction) {
        BranchInstruction branchInstruction = new BranchInstruction(-89, 0);
        this.codeAttributeEditor.replaceInstruction(n, branchInstruction);
        if (this.extraInstructionVisitor != null) {
            instruction.accept(clazz, null, null, n, this.extraInstructionVisitor);
        }
    }

    private void replaceInstruction(Clazz clazz, int n, Instruction instruction, Instruction instruction2) {
        int n2 = instruction.stackPopCount(clazz) - instruction2.stackPopCount(clazz);
        this.insertPopInstructions(n, n2);
        this.codeAttributeEditor.replaceInstruction(n, instruction2);
        if (this.extraInstructionVisitor != null) {
            instruction.accept(clazz, null, null, n, this.extraInstructionVisitor);
        }
    }

    private void insertPopInstructions(int n, int n2) {
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                SimpleInstruction simpleInstruction = new SimpleInstruction(87);
                this.codeAttributeEditor.insertBeforeInstruction(n, simpleInstruction);
                break;
            }
            case 2: {
                SimpleInstruction simpleInstruction = new SimpleInstruction(88);
                this.codeAttributeEditor.insertBeforeInstruction(n, simpleInstruction);
                break;
            }
            default: {
                Instruction[] instructionArray = new Instruction[n2 / 2 + n2 % 2];
                SimpleInstruction simpleInstruction = new SimpleInstruction(88);
                for (int i = 0; i < n2 / 2; ++i) {
                    instructionArray[i] = simpleInstruction;
                }
                if (n2 % 2 == 1) {
                    simpleInstruction = new SimpleInstruction(87);
                    instructionArray[n2 / 2] = simpleInstruction;
                }
                this.codeAttributeEditor.insertBeforeInstruction(n, instructionArray);
                break;
            }
        }
    }

    private void replaceSimpleEnumSwitchInstruction(Clazz clazz, int n, int n2, SwitchInstruction switchInstruction) {
        this.codeAttributeEditor.replaceInstruction(n, new Instruction[]{new SimpleInstruction(95), new SimpleInstruction(87)});
        this.codeAttributeEditor.replaceInstruction(n2, switchInstruction);
        if (this.extraInstructionVisitor != null) {
            switchInstruction.accept(clazz, null, null, n2, this.extraInstructionVisitor);
        }
    }
}

