/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JProgressBar;
import org.fest.assertions.Description;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.JProgressBarIndeterminateQuery;
import org.fest.swing.edt.GuiLazyLoadingDescription;
import org.fest.swing.format.Formatting;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.fest.swing.timing.Timeout;
import org.fest.util.Strings;

final class JProgressBarWaitUntilIsDeterminate {
    @RunsInEDT
    static void waitUntilValueIsDeterminate(final JProgressBar progressBar, Timeout timeout) {
        Pause.pause(new Condition(JProgressBarWaitUntilIsDeterminate.untilIsDeterminate(progressBar)){

            public boolean test() {
                return !JProgressBarIndeterminateQuery.isIndeterminate(progressBar);
            }
        }, timeout);
    }

    private static Description untilIsDeterminate(final JProgressBar progressBar) {
        return new GuiLazyLoadingDescription(){

            protected String loadDescription() {
                return Strings.concat((Object[])new Object[]{Formatting.format(progressBar), " to be in determinate mode"});
            }
        };
    }

    private JProgressBarWaitUntilIsDeterminate() {
    }
}

