/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Component;
import java.util.regex.Pattern;
import javax.swing.JTable;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.data.TableCell;
import org.fest.swing.driver.JTableDriver;
import org.fest.swing.fixture.ColorFixture;
import org.fest.swing.fixture.FontFixture;
import org.fest.swing.fixture.ItemFixture;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JTableFixture;

public class JTableCellFixture
implements ItemFixture {
    private final JTableFixture table;
    private final TableCell cell;

    protected JTableCellFixture(JTableFixture table, TableCell cell) {
        this.validateNotNull(table);
        this.validateNotNull(cell);
        this.table = table;
        this.cell = cell;
    }

    private void validateNotNull(JTableFixture newTable) {
        if (newTable == null) {
            throw new NullPointerException("The JTableFixture should not be null");
        }
    }

    private void validateNotNull(TableCell newCell) {
        if (newCell == null) {
            throw new NullPointerException("The TableCell should not be null");
        }
    }

    JTableFixture table() {
        return this.table;
    }

    TableCell cell() {
        return this.cell;
    }

    public JTableCellFixture select() {
        this.table.selectCell(this.cell);
        return this;
    }

    public JTableCellFixture click() {
        this.table.click(this.cell, MouseButton.LEFT_BUTTON);
        return this;
    }

    public JTableCellFixture click(MouseClickInfo mouseClickInfo) {
        this.table.click(this.cell, mouseClickInfo);
        return this;
    }

    public JTableCellFixture doubleClick() {
        return this.click(MouseButton.LEFT_BUTTON, 2);
    }

    public JTableCellFixture rightClick() {
        return this.click(MouseButton.RIGHT_BUTTON);
    }

    public JTableCellFixture click(MouseButton button) {
        this.table.click(this.cell, button);
        return this;
    }

    private JTableCellFixture click(MouseButton button, int times) {
        this.table.click(this.cell, button, times);
        return this;
    }

    public JTableCellFixture startEditing() {
        this.driver().startCellEditing(this.target(), this.cell);
        return this;
    }

    public JTableCellFixture stopEditing() {
        this.driver().stopCellEditing(this.target(), this.cell);
        return this;
    }

    public JTableCellFixture cancelEditing() {
        this.driver().cancelCellEditing(this.target(), this.cell);
        return this;
    }

    public Component editor() {
        return this.driver().cellEditor(this.target(), this.cell);
    }

    public JTableCellFixture enterValue(String value) {
        this.driver().enterValueInCell(this.target(), this.cell, value);
        return this;
    }

    private JTableDriver driver() {
        return this.table.driver();
    }

    private JTable target() {
        return (JTable)this.table.target;
    }

    public JTableCellFixture requireValue(String value) {
        this.table.requireCellValue(this.cell, value);
        return this;
    }

    public JTableCellFixture requireValue(Pattern pattern) {
        this.table.requireCellValue(this.cell, pattern);
        return this;
    }

    public FontFixture font() {
        return this.table.fontAt(this.cell);
    }

    public ColorFixture background() {
        return this.table.backgroundAt(this.cell);
    }

    public ColorFixture foreground() {
        return this.table.foregroundAt(this.cell);
    }

    public String value() {
        return this.table.valueAt(this.cell);
    }

    public JTableCellFixture drag() {
        this.table.drag(this.cell);
        return this;
    }

    public JTableCellFixture drop() {
        this.table.drop(this.cell);
        return this;
    }

    public JPopupMenuFixture showPopupMenu() {
        return this.table.showPopupMenuAt(this.cell);
    }

    public JTableCellFixture requireEditable() {
        this.table.requireEditable(this.cell);
        return this;
    }

    public JTableCellFixture requireNotEditable() {
        this.table.requireNotEditable(this.cell);
        return this;
    }

    public int row() {
        return this.cell.row;
    }

    public int column() {
        return this.cell.column;
    }
}

