/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Resizable;
import com.jidesoft.swing.ResizablePanel;
import com.jidesoft.swing.ResizableSupport;
import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class ResizableDialog
extends JDialog
implements ResizableSupport {
    private ResizablePanel _resizablePanel;
    private boolean _routingKeyStrokes;

    public ResizableDialog() throws HeadlessException {
        this.initComponents();
    }

    public ResizableDialog(Frame frame) throws HeadlessException {
        super(frame);
        this.initComponents();
    }

    public ResizableDialog(Frame frame, boolean bl) throws HeadlessException {
        super(frame, bl);
        this.initComponents();
    }

    public ResizableDialog(Frame frame, String string) throws HeadlessException {
        super(frame, string);
        this.initComponents();
    }

    public ResizableDialog(Frame frame, String string, boolean bl) throws HeadlessException {
        super(frame, string, bl);
        this.initComponents();
    }

    public ResizableDialog(Frame frame, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(frame, string, bl, graphicsConfiguration);
        this.initComponents();
    }

    public ResizableDialog(Dialog dialog) throws HeadlessException {
        super(dialog);
        this.initComponents();
    }

    public ResizableDialog(Dialog dialog, boolean bl) throws HeadlessException {
        super(dialog, bl);
        this.initComponents();
    }

    public ResizableDialog(Dialog dialog, String string) throws HeadlessException {
        super(dialog, string);
        this.initComponents();
    }

    public ResizableDialog(Dialog dialog, String string, boolean bl) throws HeadlessException {
        super(dialog, string, bl);
        this.initComponents();
    }

    public ResizableDialog(Dialog dialog, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) throws HeadlessException {
        super(dialog, string, bl, graphicsConfiguration);
        this.initComponents();
    }

    protected void initComponents() {
        this.setModal(false);
        this.setUndecorated(true);
        this._resizablePanel = new ResizablePanel(){

            @Override
            protected Resizable createResizable() {
                return new Resizable(this){

                    @Override
                    public void resizing(int n, int n2, int n3, int n4, int n5) {
                        Container container = ResizableDialog.this.getContentPane();
                        PortingUtils.setPreferredSize(container, new Dimension(n4, n5));
                        if (ResizableDialog.this.isUndecorated()) {
                            ResizableDialog.this.setBounds(n2, n3, n4, n5);
                        }
                        ResizableDialog.this.resizing();
                    }

                    @Override
                    public void beginResizing(int n) {
                        super.beginResizing(n);
                        ResizableDialog.this.beginResizing();
                    }

                    @Override
                    public void endResizing(int n) {
                        super.endResizing(n);
                        ResizableDialog.this.endResizing();
                    }

                    @Override
                    public boolean isTopLevel() {
                        return true;
                    }
                };
            }

            @Override
            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
                Component component;
                boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
                if (bl2 || keyEvent.isConsumed() || !ResizableDialog.this.isRoutingKeyStrokes()) {
                    return bl2;
                }
                if (keyEvent.getSource() instanceof JComponent) {
                    Class<?> clazz;
                    component = ((JComponent)keyEvent.getSource()).getRootPane();
                    for (clazz = component.getClass(); clazz != JComponent.class && clazz != null; clazz = clazz.getSuperclass()) {
                    }
                    try {
                        if (clazz != null) {
                            Method method = clazz.getDeclaredMethod("processKeyBinding", KeyStroke.class, KeyEvent.class, Integer.TYPE, Boolean.TYPE);
                            method.setAccessible(true);
                            bl2 = (Boolean)method.invoke((Object)component, keyStroke, keyEvent, 2, bl);
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        noSuchMethodException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                }
                if (bl2 || keyEvent.isConsumed()) {
                    return bl2;
                }
                component = ResizableDialog.this.getRoutingComponent();
                if (component == null) {
                    return false;
                }
                KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(component, keyEvent);
                return keyEvent.isConsumed();
            }
        };
        this.setContentPane(this._resizablePanel);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ResizableDialog.this._resizablePanel.setSize(ResizableDialog.this.getSize());
            }
        });
    }

    protected void beginResizing() {
    }

    protected void resizing() {
    }

    protected void endResizing() {
    }

    @Override
    public void setBorder(Border border) {
        this._resizablePanel.setBorder(border);
    }

    @Override
    public Border getBorder() {
        return this._resizablePanel.getBorder();
    }

    @Override
    public Resizable getResizable() {
        return this._resizablePanel.getResizable();
    }

    public Component getRoutingComponent() {
        return this.getOwner();
    }

    public void setRoutingKeyStrokes(boolean bl) {
        this._routingKeyStrokes = bl;
    }

    public boolean isRoutingKeyStrokes() {
        return this._routingKeyStrokes;
    }
}

