/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.EnumSet;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyLocale;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.Replayable;
import oracle.jdbc.replay.internal.OracleDataSource;
import oracle.jdbc.replay.internal.ReplayableConnection;
import oracle.sql.ARRAY;

@ProxyFor(value={Connection.class, OracleConnection.class, oracle.jdbc.internal.OracleConnection.class})
@ProxyLocale
public abstract class NonTxnReplayableConnection
extends NonTxnReplayableBase
implements Replayable,
ReplayableConnection {
    String originalUser = "";
    String originalPasswd = "";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Pre
    @Methods(signatures={@Signature(name="commit", args={}), @Signature(name="commit", args={EnumSet.class}), @Signature(name="rollback", args={}), @Signature(name="rollback", args={Savepoint.class}), @Signature(name="setSavepoint", args={}), @Signature(name="setSavepoint", args={String.class}), @Signature(name="releaseSavepoint", args={Savepoint.class}), @Signature(name="oracleRollback", args={OracleSavepoint.class}), @Signature(name="oracleSetSavepoint", args={}), @Signature(name="oracleSetSavepoint", args={String.class}), @Signature(name="oracleReleaseSavepoint", args={OracleSavepoint.class})})
    protected void preForTxnControl(Method method, Object object, Object ... objectArray) {
        String string;
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        String string2 = string = method == null ? "NULL METHOD" : method.getName();
        if (this.failoverMngr != null) {
            boolean bl = false;
            try {
                oracle.jdbc.internal.OracleConnection oracleConnection = (oracle.jdbc.internal.OracleConnection)this.getDelegate();
                EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
                if (enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
                    bl = true;
                }
            }
            catch (SQLException sQLException) {
                bl = true;
            }
            finally {
                if (bl) {
                    this.failoverMngr.disableReplayInternal(method, 371, "Replay disabled because of active transaction", null);
                } else {
                    super.preForAll(method, object, objectArray);
                }
            }
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="abort", args={}), @Signature(name="close", args={}), @Signature(name="close", args={int.class}), @Signature(name="close", args={Properties.class})})
    protected void preForClosure(Method method, Object object, Object ... objectArray) {
        this.isClosedAndNoReplay = true;
    }

    @Pre
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void preForCancel(Method method, Object object, Object ... objectArray) {
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        return super.postForAll(method, object);
    }

    @Post
    @Methods(signatures={@Signature(name="abort", args={}), @Signature(name="close", args={}), @Signature(name="close", args={int.class}), @Signature(name="close", args={Properties.class})})
    protected void postForClosure(Method method) {
    }

    @Post
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void postForCancel(Method method) {
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void setReplayInitiationTimeout(int n2) throws SQLException {
        this.failoverMngr.setReplayInitiationTimeout(n2);
    }

    @Override
    public void initialize(OracleDataSource oracleDataSource, String string, String string2) throws SQLException {
        FailoverManagerImpl failoverManagerImpl = (FailoverManagerImpl)FailoverManagerImpl.getFailoverManager(this, oracleDataSource);
        this.setFailoverManager(failoverManagerImpl);
        this.originalUser = string;
        this.originalPasswd = string2;
    }

    @Override
    public void beginRequest() throws SQLException {
        this.failoverMngr.beginRequest();
    }

    @Override
    public void endRequest() throws SQLException {
        this.failoverMngr.endRequest();
    }

    @Override
    public void disableReplay() throws SQLException {
        this.failoverMngr.disableReplay();
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public ARRAY createARRAY(String string, Object objectArray) throws SQLException {
        Object[] objectArray2;
        Object object;
        Object object2;
        if (objectArray != null && objectArray instanceof Object[]) {
            object2 = objectArray;
            if (((Object[])object2).length > 0) {
                object = new Object[((Object[])object2).length];
                int n2 = 0;
                for (Object object3 : object2) {
                    object[n2++] = object3 instanceof NonTxnReplayableBase ? ((NonTxnReplayableBase)object3).getDelegate() : object3;
                }
                objectArray2 = object;
            } else {
                objectArray2 = objectArray;
            }
        } else {
            objectArray2 = objectArray;
        }
        object2 = null;
        try {
            object2 = oracle.jdbc.internal.OracleConnection.class.getMethod("createARRAY", String.class, Object.class);
        }
        catch (Exception exception) {
            throw DatabaseError.createSqlException(1, "Cannot create ARRAY instance");
        }
        this.preForAll((Method)object2, this, string, objectArray2);
        try {
            object = (oracle.jdbc.internal.OracleConnection)this.getDelegate();
            ARRAY aRRAY = object.createARRAY(string, objectArray2);
            return (ARRAY)this.postForAll((Method)object2, aRRAY);
        }
        catch (SQLException sQLException) {
            return (ARRAY)this.postForAll((Method)object2, this.onErrorForAll((Method)object2, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public Array createOracleArray(String string, Object object) throws SQLException {
        return this.createARRAY(string, object);
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        Object[] objectArray2;
        if (objectArray != null && objectArray.length > 0) {
            objectArray2 = new Object[objectArray.length];
            int n2 = 0;
            for (Object object : objectArray) {
                objectArray2[n2++] = object instanceof NonTxnReplayableBase ? ((NonTxnReplayableBase)object).getDelegate() : object;
            }
        } else {
            objectArray2 = objectArray;
        }
        Method method = null;
        try {
            method = Connection.class.getDeclaredMethod("createArrayOf", String.class, Object[].class);
        }
        catch (Exception exception) {
            throw DatabaseError.createSqlException(1, "Cannot create Array instance");
        }
        this.preForAll(method, this, string, objectArray2);
        try {
            Connection connection = (Connection)this.getDelegate();
            Array array = connection.createArrayOf(string, objectArray2);
            return (Array)this.postForAll(method, array);
        }
        catch (SQLException sQLException) {
            return (Array)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        Object[] objectArray2;
        if (objectArray != null && objectArray.length > 0) {
            objectArray2 = new Object[objectArray.length];
            int n2 = 0;
            for (Object object : objectArray) {
                objectArray2[n2++] = object instanceof NonTxnReplayableBase ? ((NonTxnReplayableBase)object).getDelegate() : object;
            }
        } else {
            objectArray2 = objectArray;
        }
        Method method = null;
        try {
            method = Connection.class.getDeclaredMethod("createStruct", String.class, Object[].class);
        }
        catch (Exception exception) {
            throw DatabaseError.createSqlException(1, "Cannot create Struct instance");
        }
        this.preForAll(method, this, string, objectArray2);
        try {
            Connection connection = (Connection)this.getDelegate();
            Struct struct = connection.createStruct(string, objectArray2);
            return (Struct)this.postForAll(method, struct);
        }
        catch (SQLException sQLException) {
            return (Struct)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Blob createBlob() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Clob createClob() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract NClob createNClob() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract SQLXML createSQLXML() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Statement createStatement() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Statement createStatement(int var1, int var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Statement createStatement(int var1, int var2, int var3) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract CallableStatement prepareCall(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract CallableStatement prepareCall(String var1, int var2, int var3) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract CallableStatement prepareCall(String var1, int var2, int var3, int var4) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int[] var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3, int var4) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, String[] var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Savepoint setSavepoint() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Savepoint setSavepoint(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return (T)this.getDelegate();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public abstract Connection _getPC();

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract OracleSavepoint oracleSetSavepoint() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract OracleSavepoint oracleSetSavepoint(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection unwrap() {
        return ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).unwrap();
    }
}

