/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.fasta;

import java.io.PrintStream;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.fasta.ArtificialFastaUtils;

class ArtificialContig {
    public static final int COLUMN_WIDTH = 80;
    protected final String mName;
    protected final int mSize;
    protected final ArtificialFastaUtils.BASE_PATTERN mPattern;

    public ArtificialContig(String name, int size, ArtificialFastaUtils.BASE_PATTERN pat) {
        this.mName = name;
        this.mSize = size;
        this.mPattern = pat;
    }

    public void write(PrintStream stream) {
        stream.println(">" + this.mName);
        int count = 0;
        while (count < this.mSize) {
            for (int x = 0; x < 80; ++x) {
                stream.print(this.generateAppropriateBase());
                if (++count >= this.mSize) break;
            }
            stream.println();
        }
    }

    public String generateAppropriateBase() {
        switch (this.mPattern) {
            case RANDOM: {
                return ArtificialFastaUtils.BASES.values()[(int)Math.round(Math.random() * 4.0)].toString();
            }
            case ALL_A: {
                return "A";
            }
            case ALL_T: {
                return "T";
            }
            case ALL_C: {
                return "C";
            }
            case ALL_G: {
                return "G";
            }
        }
        throw new ReviewedGATKException("Unknown base pattern");
    }
}

