/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.handler;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.EnumerationType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.HandlerBase;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.Signature;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.TextMDMetadata;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class XmlHandler
extends HandlerBase {
    private static final String NAME = "XML";
    private static final String RELEASE = "1.6";
    private static final int[] DATE = new int[]{2009, 10, 14};
    private static final String NOTE = "This output handler is defined by the XML Schema http://hul.harvard.edu/ois/xml/xsd/jhove/jhove.xsd";
    private static final String RIGHTS = "Copyright 2003-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";
    private static final String EOL = System.getProperty("line.separator");
    private static final String SCHEMA_VERSION = "1.6";
    private double _sampleRate;

    public XmlHandler() {
        super(NAME, "1.6", DATE, NOTE, RIGHTS);
        Agent agent = new Agent("Harvard University Library", AgentType.EDUCATIONAL);
        agent.setAddress("Office for Information Systems, 90 Mt. Auburn St., Cambridge, MA 02138");
        agent.setTelephone("+1 (617) 495-3724");
        agent.setEmail("jhove-support@hulmail.harvard.edu");
        this._vendor = agent;
    }

    public XmlHandler(String string, String string2, int[] nArray, String string3, String string4) {
        super(string, string2, nArray, string3, string4);
        Agent agent = new Agent("Harvard University Library", AgentType.EDUCATIONAL);
        agent.setAddress("Office for Information Systems, 90 Mt. Auburn St., Cambridge, MA 02138");
        agent.setTelephone("+1 (617) 495-3724");
        agent.setEmail("jhove-support@hulmail.harvard.edu");
        this._vendor = agent;
    }

    public void show() {
        String string = XmlHandler.getIndent((int)(++this._level));
        --this._level;
    }

    public void show(App app) {
        String[][] stringArray;
        Module module;
        String string;
        String string2 = XmlHandler.getIndent((int)(++this._level));
        String string3 = string2 + " ";
        String string4 = string3 + " ";
        this._writer.println(string2 + XmlHandler.elementStart((String)"app"));
        String[][] stringArray2 = new String[][]{{"date", date.format(this._je.getDate())}};
        this._writer.println(string3 + XmlHandler.element((String)"api", (String[][])stringArray2, (String)this._je.getRelease()));
        String string5 = this._je.getConfigFile();
        if (string5 != null) {
            this._writer.println(string3 + XmlHandler.element((String)"configuration", (String)string5));
        }
        if ((string = this._je.getSaxClass()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"saxParser", (String)string));
        }
        if ((string = this._je.getJhoveHome()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"jhoveHome", (String)string));
        }
        if ((string = this._je.getEncoding()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"encoding", (String)string));
        }
        if ((string = this._je.getTempDirectory()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"tempDirectory", (String)string));
        }
        this._writer.println(string3 + XmlHandler.element((String)"bufferSize", (String)Integer.toString(this._je.getBufferSize())));
        this._writer.println(string3 + XmlHandler.elementStart((String)"modules"));
        Iterator iterator = this._je.getModuleMap().keySet().iterator();
        while (iterator.hasNext()) {
            module = this._je.getModule((String)iterator.next());
            stringArray = new String[][]{{"release", module.getRelease()}};
            this._writer.println(string4 + XmlHandler.element((String)"module", (String[][])stringArray, (String)module.getName()));
        }
        this._writer.println(string3 + XmlHandler.elementEnd((String)"modules"));
        this._writer.println(string3 + XmlHandler.elementStart((String)"outputHandlers"));
        iterator = this._je.getHandlerMap().keySet().iterator();
        while (iterator.hasNext()) {
            module = this._je.getHandler((String)iterator.next());
            stringArray = new String[][]{{"release", module.getRelease()}};
            this._writer.println(string4 + XmlHandler.element((String)"outputHandler", (String[][])stringArray, (String)module.getName()));
        }
        this._writer.println(string3 + XmlHandler.elementEnd((String)"outputHandlers"));
        this._writer.println(string3 + XmlHandler.element((String)"usage", (String)app.getUsage()));
        this._writer.println(string3 + XmlHandler.element((String)"rights", (String)app.getRights()));
        this._writer.println(string2 + XmlHandler.elementEnd((String)"app"));
        --this._level;
    }

    public void show(OutputHandler outputHandler) {
        String string;
        Agent agent;
        String string2 = XmlHandler.getIndent((int)(++this._level));
        String string3 = string2 + " ";
        this._writer.println(string2 + XmlHandler.elementStart((String)"handler"));
        this._writer.println(string3 + XmlHandler.element((String)"name", (String)outputHandler.getName()));
        this._writer.println(string3 + XmlHandler.element((String)"release", (String)outputHandler.getRelease()));
        this._writer.println(string3 + XmlHandler.element((String)"date", (String)date.format(outputHandler.getDate())));
        List list = outputHandler.getSpecification();
        int n = list.size();
        if (n > 0) {
            this._writer.println(string3 + XmlHandler.elementStart((String)"specifications"));
            ++this._level;
            for (int i = 0; i < n; ++i) {
                this.showDocument((Document)list.get(i));
            }
            --this._level;
            this._writer.println(string3 + XmlHandler.elementEnd((String)"specifications"));
        }
        if ((agent = outputHandler.getVendor()) != null) {
            this.showAgent(agent, "Vendor");
        }
        if ((string = outputHandler.getNote()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"note", (String)string));
        }
        if ((string = outputHandler.getRights()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"rights", (String)string));
        }
        this._writer.println(string2 + XmlHandler.elementEnd((String)"handler"));
        --this._level;
    }

    public void show(Module module) {
        List list;
        int n;
        List list2;
        int n2;
        String string5;
        String string2 = XmlHandler.getIndent((int)(++this._level));
        String string3 = string2 + " ";
        String string4 = string3 + " ";
        this._writer.println(string2 + XmlHandler.elementStart((String)"module"));
        this._writer.println(string3 + XmlHandler.element((String)"name", (String)module.getName()));
        this._writer.println(string3 + XmlHandler.element((String)"release", (String)module.getRelease()));
        this._writer.println(string3 + XmlHandler.element((String)"date", (String)HandlerBase.date.format(module.getDate())));
        String[] stringArray = module.getFormat();
        if (stringArray.length > 0) {
            this._writer.println(string3 + XmlHandler.elementStart((String)"formats"));
            for (int i = 0; i < stringArray.length; ++i) {
                this._writer.println(string4 + XmlHandler.element((String)"format", (String)stringArray[i]));
            }
            this._writer.println(string3 + XmlHandler.elementEnd((String)"formats"));
        }
        if ((string5 = module.getCoverage()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"coverage", (String)string5));
        }
        if ((stringArray = module.getMimeType()).length > 0) {
            this._writer.println(string3 + XmlHandler.elementStart((String)"mimeTypes"));
            for (int i = 0; i < stringArray.length; ++i) {
                this._writer.println(string4 + XmlHandler.element((String)"mimeType", (String)stringArray[i]));
            }
            this._writer.println(string3 + XmlHandler.elementEnd((String)"mimeTypes"));
        }
        if ((n2 = (list2 = module.getSignature()).size()) > 0) {
            this._writer.println(string3 + XmlHandler.elementStart((String)"signatures"));
            ++this._level;
            for (n = 0; n < n2; ++n) {
                this.showSignature((Signature)list2.get(n));
            }
            --this._level;
            this._writer.println(string3 + XmlHandler.elementEnd((String)"signatures"));
        }
        if ((n2 = (list2 = module.getSpecification()).size()) > 0) {
            this._writer.println(string3 + XmlHandler.elementStart((String)"specifications"));
            ++this._level;
            for (n = 0; n < n2; ++n) {
                this.showDocument((Document)list2.get(n));
            }
            --this._level;
            this._writer.println(string3 + XmlHandler.elementEnd((String)"specifications"));
        }
        if ((list = module.getFeatures()) != null && !list.isEmpty()) {
            this._writer.println(string3 + XmlHandler.elementStart((String)"features"));
            for (String string5 : list) {
                this._writer.println(string4 + XmlHandler.element((String)"feature", (String)string5));
            }
            this._writer.println(string3 + XmlHandler.elementEnd((String)"features"));
        }
        this._writer.println(string3 + XmlHandler.elementStart((String)"methodology"));
        string5 = module.getWellFormedNote();
        if (string5 != null) {
            this._writer.println(string4 + XmlHandler.element((String)"wellFormed", (String)string5));
        }
        if ((string5 = module.getValidityNote()) != null) {
            this._writer.println(string4 + XmlHandler.element((String)"validity", (String)string5));
        }
        if ((string5 = module.getRepInfoNote()) != null) {
            this._writer.println(string4 + XmlHandler.element((String)"repInfo", (String)string5));
        }
        this._writer.println(string3 + XmlHandler.elementEnd((String)"methodology"));
        Agent agent = module.getVendor();
        if (agent != null) {
            this.showAgent(agent, "Vendor");
        }
        if ((string5 = module.getNote()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"note", (String)string5));
        }
        if ((string5 = module.getRights()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"rights", (String)string5));
        }
        this._writer.println(string2 + XmlHandler.elementEnd((String)"module"));
        --this._level;
    }

    public void show(RepInfo repInfo) {
        Map map;
        int n;
        String string;
        String string2;
        long l;
        String[][] stringArray;
        String string3 = XmlHandler.getIndent((int)(++this._level));
        String string4 = string3 + " ";
        String string5 = string4 + " ";
        Module module = repInfo.getModule();
        String[][] stringArray2 = new String[][]{{"uri", this.cleanURIString(repInfo.getUri())}};
        this._writer.println(string3 + XmlHandler.elementStart((String)"repInfo", (String[][])stringArray2));
        if (module != null) {
            stringArray = new String[][]{{"release", module.getRelease()}, {"date", date.format(module.getDate())}};
            this._writer.println(string4 + XmlHandler.element((String)"reportingModule", (String[][])stringArray, (String)module.getName()));
        }
        if ((stringArray = repInfo.getCreated()) != null) {
            this._writer.println(string4 + XmlHandler.element((String)"created", (String)this.toDateTime((Date)stringArray)));
        }
        if ((stringArray = repInfo.getLastModified()) != null) {
            this._writer.println(string4 + XmlHandler.element((String)"lastModified", (String)this.toDateTime((Date)stringArray)));
        }
        if ((l = repInfo.getSize()) > -1L) {
            this._writer.println(string4 + XmlHandler.element((String)"size", (String)Long.toString(l)));
        }
        if ((string2 = repInfo.getFormat()) != null) {
            this._writer.println(string4 + XmlHandler.element((String)"format", (String)string2));
        }
        if ((string2 = repInfo.getVersion()) != null) {
            this._writer.println(string4 + XmlHandler.element((String)"version", (String)string2));
        }
        if (!this._je.getSignatureFlag()) {
            switch (repInfo.getWellFormed()) {
                case 1: {
                    string = "Well-Formed";
                    break;
                }
                case 0: {
                    string = "Not well-formed";
                    break;
                }
                default: {
                    string = "Unknown";
                }
            }
            if (repInfo.getWellFormed() == 1) {
                switch (repInfo.getValid()) {
                    case 1: {
                        string = string + " and valid";
                        break;
                    }
                    case 0: {
                        string = string + ", but not valid";
                    }
                }
            }
            this._writer.println(string4 + XmlHandler.element((String)"status", (String)string));
        } else {
            switch (repInfo.getWellFormed()) {
                case 1: {
                    string = "Well-Formed";
                    break;
                }
                default: {
                    string = "Not well-formed";
                }
            }
            this._writer.println(string4 + XmlHandler.element((String)"status", (String)string));
        }
        List list = repInfo.getSigMatch();
        int n2 = list.size();
        if (n2 > 0) {
            this._writer.println(string4 + XmlHandler.elementStart((String)"sigMatch"));
            ++this._level;
            for (n = 0; n < n2; ++n) {
                this._writer.println(string4 + XmlHandler.element((String)"module", (String)((String)list.get(n))));
            }
            --this._level;
            this._writer.println(string4 + XmlHandler.elementEnd((String)"sigMatch"));
        }
        if ((n2 = (list = repInfo.getMessage()).size()) > 0) {
            this._writer.println(string4 + XmlHandler.elementStart((String)"messages"));
            ++this._level;
            for (n = 0; n < n2; ++n) {
                this.showMessage((Message)list.get(n));
            }
            --this._level;
            this._writer.println(string4 + XmlHandler.elementEnd((String)"messages"));
        }
        if ((string2 = repInfo.getMimeType()) != null) {
            this._writer.println(string4 + XmlHandler.element((String)"mimeType", (String)string2));
        }
        if ((n2 = (list = repInfo.getProfile()).size()) > 0) {
            this._writer.println(string4 + XmlHandler.elementStart((String)"profiles"));
            for (n = 0; n < n2; ++n) {
                this._writer.println(string5 + XmlHandler.element((String)"profile", (String)((String)list.get(n))));
            }
            this._writer.println(string4 + XmlHandler.elementEnd((String)"profiles"));
        }
        if ((map = repInfo.getProperty()) != null && map.size() > 0) {
            this._writer.println(string4 + XmlHandler.elementStart((String)"properties"));
            for (String string6 : map.keySet()) {
                Property property = repInfo.getProperty(string6);
                this.showProperty(property);
            }
            this._writer.println(string4 + XmlHandler.elementEnd((String)"properties"));
        }
        if ((n2 = (list = repInfo.getChecksum()).size()) > 0) {
            this._writer.println(string4 + XmlHandler.elementStart((String)"checksums"));
            ++this._level;
            for (int i = 0; i < n2; ++i) {
                this.showChecksum((Checksum)list.get(i));
            }
            --this._level;
            this._writer.println(string4 + XmlHandler.elementEnd((String)"checksums"));
        }
        if ((string2 = repInfo.getNote()) != null) {
            this._writer.println(string4 + XmlHandler.element((String)"note", (String)string2));
        }
        this._writer.println(string3 + XmlHandler.elementEnd((String)"repInfo"));
        --this._level;
    }

    protected void showAgent(Agent agent, String string) {
        String string2 = XmlHandler.getIndent((int)(++this._level));
        String string3 = string2 + " ";
        String[][] stringArray = new String[][]{{"type", string}};
        this._writer.println(string2 + XmlHandler.elementStart((String)"agent", (String[][])stringArray));
        this._writer.println(string3 + XmlHandler.element((String)"name", (String)agent.getName()));
        this._writer.println(string3 + XmlHandler.element((String)"type", (String)agent.getType().toString()));
        String string4 = agent.getAddress();
        if (string4 != null) {
            this._writer.println(string3 + XmlHandler.element((String)"address", (String)string4));
        }
        if ((string4 = agent.getTelephone()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"telephone", (String)string4));
        }
        if ((string4 = agent.getFax()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"fax", (String)string4));
        }
        if ((string4 = agent.getEmail()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"email", (String)string4));
        }
        if ((string4 = agent.getWeb()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"web", (String)string4));
        }
        this._writer.println(string2 + XmlHandler.elementEnd((String)"agent"));
        --this._level;
    }

    protected void showChecksum(Checksum checksum) {
        String string = XmlHandler.getIndent((int)(++this._level));
        String[][] stringArray = new String[][]{{"type", checksum.getType().toString()}};
        this._writer.println(string + XmlHandler.element((String)"checksum", (String[][])stringArray, (String)checksum.getValue()));
        --this._level;
    }

    protected void showDocument(Document document) {
        String string;
        int n;
        String string2 = XmlHandler.getIndent((int)(++this._level));
        String string3 = string2 + " ";
        this._writer.println(string2 + XmlHandler.elementStart((String)"specification"));
        this._writer.println(string3 + XmlHandler.element((String)"title", (String)document.getTitle()));
        this._writer.println(string3 + XmlHandler.element((String)"type", (String)document.getType().toString()));
        List list = document.getAuthor();
        int n2 = list.size();
        if (n2 > 0) {
            this._writer.println(string3 + XmlHandler.elementStart((String)"authors"));
            ++this._level;
            for (n = 0; n < n2; ++n) {
                this.showAgent((Agent)list.get(n), "Author");
            }
            --this._level;
            this._writer.println(string3 + XmlHandler.elementEnd((String)"authors"));
        }
        if ((n2 = (list = document.getPublisher()).size()) > 0) {
            ++this._level;
            this._writer.println(string3 + XmlHandler.elementStart((String)"publishers"));
            for (n = 0; n < n2; ++n) {
                this.showAgent((Agent)list.get(n), "Publisher");
            }
            this._writer.println(string3 + XmlHandler.elementEnd((String)"publishers"));
            --this._level;
        }
        if ((string = document.getEdition()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"edition", (String)string));
        }
        if ((string = document.getDate()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"date", (String)string));
        }
        if ((string = document.getEnumeration()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"enumeration", (String)string));
        }
        if ((string = document.getPages()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"pages", (String)string));
        }
        if ((n2 = (list = document.getIdentifier()).size()) > 0) {
            this._writer.println(string3 + XmlHandler.elementStart((String)"identifiers"));
            ++this._level;
            for (int i = 0; i < n2; ++i) {
                this.showIdentifier((Identifier)list.get(i));
            }
            --this._level;
            this._writer.println(string3 + XmlHandler.elementEnd((String)"identifiers"));
        }
        if ((string = document.getNote()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"note", (String)string));
        }
        this._writer.println(string2 + XmlHandler.elementEnd((String)"specification"));
        --this._level;
    }

    public void showFooter() {
        String string = XmlHandler.getIndent((int)this._level--);
        this._writer.println(string + XmlHandler.elementEnd((String)"jhove"));
        this._writer.flush();
    }

    public void showHeader() {
        String string = XmlHandler.getIndent((int)(++this._level));
        String string2 = string + " ";
        if (this._encoding != null) {
            this._writer.println(string + XmlHandler.xmlDecl((String)this._encoding));
        } else {
            this._writer.println(string + XmlHandler.xmlDecl());
        }
        String[][] stringArray = new String[][]{{"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"}, {"xmlns", "http://hul.harvard.edu/ois/xml/ns/jhove"}, {"xsi:schemaLocation", "http://hul.harvard.edu/ois/xml/ns/jhove http://hul.harvard.edu/ois/xml/xsd/jhove/1.6/jhove.xsd"}, {"name", this._app.getName()}, {"release", this._app.getRelease()}, {"date", HandlerBase.date.format(this._app.getDate())}};
        this._writer.println(string + XmlHandler.elementStart((String)"jhove", (String[][])stringArray));
        this._writer.println(string2 + XmlHandler.element((String)"date", (String)this.toDateTime(new Date())));
    }

    protected void showIdentifier(Identifier identifier) {
        String string = XmlHandler.getIndent((int)(++this._level));
        String string2 = string + " ";
        this._writer.println(string + XmlHandler.elementStart((String)"identifier"));
        this._writer.println(string2 + XmlHandler.element((String)"value", (String)identifier.getValue()));
        this._writer.println(string2 + XmlHandler.element((String)"type", (String)identifier.getType().toString()));
        String string3 = identifier.getNote();
        if (string3 != null) {
            this._writer.println(string2 + XmlHandler.element((String)"note", (String)string3));
        }
        this._writer.println(string + XmlHandler.elementEnd((String)"identifier"));
        --this._level;
    }

    protected void showMessage(Message message) {
        long l;
        String string = XmlHandler.getIndent((int)(++this._level));
        String[][] stringArray = new String[3][];
        boolean bl = false;
        stringArray[0] = new String[]{"subMessage", null};
        stringArray[1] = new String[]{"offset", null};
        stringArray[2] = new String[]{"severity", null};
        String string2 = message.getSubMessage();
        if (string2 != null) {
            stringArray[0][1] = string2;
            bl = true;
        }
        if ((l = message.getOffset()) > -1L) {
            stringArray[1][1] = Long.toString(l);
            bl = true;
        }
        if (message instanceof ErrorMessage) {
            stringArray[2][1] = "error";
            bl = true;
        } else if (message instanceof InfoMessage) {
            stringArray[2][1] = "info";
            bl = true;
        }
        if (bl) {
            this._writer.println(string + XmlHandler.element((String)"message", (String[][])stringArray, (String)message.getMessage()));
        } else {
            this._writer.println(string + XmlHandler.element((String)"message", (String)message.getMessage()));
        }
        --this._level;
    }

    protected void showSignature(Signature signature) {
        String string;
        String string2;
        String string3 = XmlHandler.getIndent((int)(++this._level));
        String string4 = string3 + " ";
        this._writer.println(string3 + XmlHandler.elementStart((String)"signature"));
        String string5 = signature.isStringValue() ? signature.getValueString() : signature.getValueHexString();
        this._writer.println(string4 + XmlHandler.element((String)"type", (String)signature.getType().toString()));
        this._writer.println(string4 + XmlHandler.element((String)"value", (String)string5));
        if (signature.getType().equals((EnumerationType)SignatureType.MAGIC) && ((InternalSignature)signature).hasFixedOffset()) {
            this._writer.println(string4 + XmlHandler.element((String)"offset", (String)("0x" + Integer.toHexString(((InternalSignature)signature).getOffset()))));
        }
        if ((string2 = signature.getNote()) != null) {
            this._writer.println(string4 + XmlHandler.element((String)"note", (String)string2));
        }
        if ((string = signature.getUse().toString()) != null) {
            this._writer.println(string4 + XmlHandler.element((String)"use", (String)string));
        }
        this._writer.println(string3 + XmlHandler.elementEnd((String)"signature"));
        --this._level;
    }

    protected String valueToString(Object object) {
        if (object instanceof Date) {
            return this.toDateTime((Date)object);
        }
        return object.toString();
    }

    protected void showProperty(Property property) {
        String string = XmlHandler.getIndent((int)(++this._level));
        String string2 = string + " ";
        String string3 = string2 + " ";
        String string4 = string3 + " ";
        PropertyArity propertyArity = property.getArity();
        PropertyType propertyType = property.getType();
        if (this.isPropertyEmpty(property, propertyArity)) {
            return;
        }
        boolean bl = PropertyType.PROPERTY.equals((EnumerationType)propertyType);
        boolean bl2 = PropertyType.NISOIMAGEMETADATA.equals((EnumerationType)propertyType);
        boolean bl3 = PropertyType.AESAUDIOMETADATA.equals((EnumerationType)propertyType);
        boolean bl4 = PropertyType.TEXTMDMETADATA.equals((EnumerationType)propertyType);
        String[][] stringArray = new String[][]{{"arity", propertyArity.toString()}, {"type", propertyType.toString()}};
        this._writer.println(string2 + XmlHandler.elementStart((String)"property"));
        this._writer.println(string3 + XmlHandler.element((String)"name", (String)property.getName()));
        this._writer.println(string3 + XmlHandler.elementStart((String)"values", (String[][])stringArray));
        if (propertyArity.equals((EnumerationType)PropertyArity.SCALAR)) {
            if (bl) {
                this.showProperty((Property)property.getValue());
            } else if (bl2) {
                this._writer.println(string4 + XmlHandler.elementStart((String)"value"));
                this.showNisoImageMetadata((NisoImageMetadata)property.getValue());
                this._writer.println(string4 + XmlHandler.elementEnd((String)"value"));
            } else if (bl3) {
                this._writer.println(string4 + XmlHandler.elementStart((String)"value"));
                this.showAESAudioMetadata((AESAudioMetadata)property.getValue());
                this._writer.println(string4 + XmlHandler.elementEnd((String)"value"));
            } else if (bl4) {
                this._writer.println(string4 + XmlHandler.elementStart((String)"value"));
                this.showTextMDMetadata((TextMDMetadata)property.getValue());
                this._writer.println(string4 + XmlHandler.elementEnd((String)"value"));
            } else {
                this._writer.println(string4 + XmlHandler.element((String)"value", (String)property.getValue().toString()));
            }
        } else if (propertyArity.equals((EnumerationType)PropertyArity.LIST)) {
            List list = (List)property.getValue();
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Object e = listIterator.next();
                if (bl) {
                    this.showProperty((Property)e);
                    continue;
                }
                if (bl2) {
                    this._writer.println(string4 + XmlHandler.elementStart((String)"value"));
                    this.showNisoImageMetadata((NisoImageMetadata)property.getValue());
                    this._writer.println(string4 + XmlHandler.elementEnd((String)"value"));
                    continue;
                }
                if (bl3) {
                    this._writer.println(string4 + XmlHandler.elementStart((String)"value"));
                    this.showAESAudioMetadata((AESAudioMetadata)property.getValue());
                    this._writer.println(string4 + XmlHandler.elementEnd((String)"value"));
                    continue;
                }
                if (bl4) {
                    this._writer.println(string4 + XmlHandler.elementStart((String)"value"));
                    this.showTextMDMetadata((TextMDMetadata)property.getValue());
                    this._writer.println(string4 + XmlHandler.elementEnd((String)"value"));
                    continue;
                }
                this._writer.println(string4 + XmlHandler.element((String)"value", (String)this.valueToString(e)));
            }
        } else if (propertyArity.equals((EnumerationType)PropertyArity.MAP)) {
            Map map = (Map)property.getValue();
            for (Object k : map.keySet()) {
                String string5 = k.toString();
                Object v = map.get(k);
                String[][] stringArray2 = new String[1][];
                String[] stringArray3 = new String[]{"key", string5};
                stringArray2[0] = stringArray3;
                if (bl) {
                    Property property2 = (Property)v;
                    if (property2.getName().equals(string5)) {
                        this._writer.print(string4 + XmlHandler.elementStart((String)"value"));
                    } else {
                        this._writer.print(string4 + XmlHandler.elementStart((String)"value", (String[][])stringArray2));
                    }
                    this.showProperty(property2);
                    this._writer.println(string4 + XmlHandler.elementEnd((String)"value"));
                    continue;
                }
                if (bl2) {
                    this._writer.println(string4 + XmlHandler.elementStart((String)"value"));
                    this.showNisoImageMetadata((NisoImageMetadata)v);
                    this._writer.println(string4 + XmlHandler.elementEnd((String)"value"));
                    continue;
                }
                if (bl3) {
                    this._writer.println(string4 + XmlHandler.elementStart((String)"value"));
                    this.showAESAudioMetadata((AESAudioMetadata)v);
                    this._writer.println(string4 + XmlHandler.elementEnd((String)"value"));
                    continue;
                }
                if (bl4) {
                    this._writer.println(string4 + XmlHandler.elementStart((String)"value"));
                    this.showTextMDMetadata((TextMDMetadata)v);
                    this._writer.println(string4 + XmlHandler.elementEnd((String)"value"));
                    continue;
                }
                this._writer.println(string4 + XmlHandler.element((String)"value", (String[][])stringArray2, (String)this.valueToString(v)));
            }
        } else if (propertyArity.equals((EnumerationType)PropertyArity.SET)) {
            Set set = (Set)property.getValue();
            for (Object e : set) {
                if (bl) {
                    this.showProperty((Property)e);
                    continue;
                }
                this._writer.println(string4 + XmlHandler.element((String)"value", (String)this.valueToString(e)));
            }
        } else if (propertyArity.equals((EnumerationType)PropertyArity.ARRAY)) {
            this.showArrayProperty(property, string4);
        }
        this._writer.println(string3 + XmlHandler.elementEnd((String)"values"));
        this._writer.println(string2 + XmlHandler.elementEnd((String)"property"));
        --this._level;
    }

    private boolean isPropertyEmpty(Property property, PropertyArity propertyArity) {
        try {
            if (propertyArity.equals((EnumerationType)PropertyArity.SET)) {
                Set set = (Set)property.getValue();
                return set.isEmpty();
            }
            if (propertyArity.equals((EnumerationType)PropertyArity.LIST)) {
                List list = (List)property.getValue();
                return list.isEmpty();
            }
            if (propertyArity.equals((EnumerationType)PropertyArity.MAP)) {
                Map map = (Map)property.getValue();
                return map.isEmpty();
            }
            if (propertyArity.equals((EnumerationType)PropertyArity.ARRAY)) {
                boolean[] blArray = null;
                byte[] byArray = null;
                char[] cArray = null;
                Date[] dateArray = null;
                double[] dArray = null;
                float[] fArray = null;
                int[] nArray = null;
                long[] lArray = null;
                Object[] objectArray = null;
                Property[] propertyArray = null;
                short[] sArray = null;
                String[] stringArray = null;
                Rational[] rationalArray = null;
                NisoImageMetadata[] nisoImageMetadataArray = null;
                AESAudioMetadata[] aESAudioMetadataArray = null;
                TextMDMetadata[] textMDMetadataArray = null;
                int n = 0;
                PropertyType propertyType = property.getType();
                if (PropertyType.BOOLEAN.equals((EnumerationType)propertyType)) {
                    blArray = (boolean[])property.getValue();
                    n = blArray.length;
                } else if (PropertyType.BYTE.equals((EnumerationType)propertyType)) {
                    byArray = (byte[])property.getValue();
                    n = byArray.length;
                } else if (PropertyType.CHARACTER.equals((EnumerationType)propertyType)) {
                    cArray = (char[])property.getValue();
                    n = cArray.length;
                } else if (PropertyType.DATE.equals((EnumerationType)propertyType)) {
                    dateArray = (Date[])property.getValue();
                    n = dateArray.length;
                } else if (PropertyType.DOUBLE.equals((EnumerationType)propertyType)) {
                    dArray = (double[])property.getValue();
                    n = dArray.length;
                } else if (PropertyType.FLOAT.equals((EnumerationType)propertyType)) {
                    fArray = (float[])property.getValue();
                    n = fArray.length;
                } else if (PropertyType.INTEGER.equals((EnumerationType)propertyType)) {
                    nArray = (int[])property.getValue();
                    n = nArray.length;
                } else if (PropertyType.LONG.equals((EnumerationType)propertyType)) {
                    lArray = (long[])property.getValue();
                    n = lArray.length;
                } else if (PropertyType.OBJECT.equals((EnumerationType)propertyType)) {
                    objectArray = (Object[])property.getValue();
                    n = objectArray.length;
                } else if (PropertyType.SHORT.equals((EnumerationType)propertyType)) {
                    sArray = (short[])property.getValue();
                    n = sArray.length;
                } else if (PropertyType.STRING.equals((EnumerationType)propertyType)) {
                    stringArray = (String[])property.getValue();
                    n = stringArray.length;
                } else if (PropertyType.RATIONAL.equals((EnumerationType)propertyType)) {
                    rationalArray = (Rational[])property.getValue();
                    n = rationalArray.length;
                } else if (PropertyType.PROPERTY.equals((EnumerationType)propertyType)) {
                    propertyArray = (Property[])property.getValue();
                    n = propertyArray.length;
                } else if (PropertyType.NISOIMAGEMETADATA.equals((EnumerationType)propertyType)) {
                    nisoImageMetadataArray = (NisoImageMetadata[])property.getValue();
                    n = nisoImageMetadataArray.length;
                } else if (PropertyType.AESAUDIOMETADATA.equals((EnumerationType)propertyType)) {
                    aESAudioMetadataArray = (AESAudioMetadata[])property.getValue();
                    n = aESAudioMetadataArray.length;
                } else if (PropertyType.TEXTMDMETADATA.equals((EnumerationType)propertyType)) {
                    textMDMetadataArray = (TextMDMetadata[])property.getValue();
                    n = textMDMetadataArray.length;
                }
                return n == 0;
            }
            return property.getValue().toString().length() == 0;
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected void showArrayProperty(Property property, String string) {
        boolean[] blArray = null;
        byte[] byArray = null;
        char[] cArray = null;
        Date[] dateArray = null;
        double[] dArray = null;
        float[] fArray = null;
        int[] nArray = null;
        long[] lArray = null;
        Object[] objectArray = null;
        Property[] propertyArray = null;
        short[] sArray = null;
        String[] stringArray = null;
        Rational[] rationalArray = null;
        NisoImageMetadata[] nisoImageMetadataArray = null;
        AESAudioMetadata[] aESAudioMetadataArray = null;
        TextMDMetadata[] textMDMetadataArray = null;
        int n = 0;
        PropertyType propertyType = property.getType();
        if (PropertyType.BOOLEAN.equals((EnumerationType)propertyType)) {
            blArray = (boolean[])property.getValue();
            n = blArray.length;
        } else if (PropertyType.BYTE.equals((EnumerationType)propertyType)) {
            byArray = (byte[])property.getValue();
            n = byArray.length;
        } else if (PropertyType.CHARACTER.equals((EnumerationType)propertyType)) {
            cArray = (char[])property.getValue();
            n = cArray.length;
        } else if (PropertyType.DATE.equals((EnumerationType)propertyType)) {
            dateArray = (Date[])property.getValue();
            n = dateArray.length;
        } else if (PropertyType.DOUBLE.equals((EnumerationType)propertyType)) {
            dArray = (double[])property.getValue();
            n = dArray.length;
        } else if (PropertyType.FLOAT.equals((EnumerationType)propertyType)) {
            fArray = (float[])property.getValue();
            n = fArray.length;
        } else if (PropertyType.INTEGER.equals((EnumerationType)propertyType)) {
            nArray = (int[])property.getValue();
            n = nArray.length;
        } else if (PropertyType.LONG.equals((EnumerationType)propertyType)) {
            lArray = (long[])property.getValue();
            n = lArray.length;
        } else if (PropertyType.OBJECT.equals((EnumerationType)propertyType)) {
            objectArray = (Object[])property.getValue();
            n = objectArray.length;
        } else if (PropertyType.SHORT.equals((EnumerationType)propertyType)) {
            sArray = (short[])property.getValue();
            n = sArray.length;
        } else if (PropertyType.STRING.equals((EnumerationType)propertyType)) {
            stringArray = (String[])property.getValue();
            n = stringArray.length;
        } else if (PropertyType.RATIONAL.equals((EnumerationType)propertyType)) {
            rationalArray = (Rational[])property.getValue();
            n = rationalArray.length;
        } else if (PropertyType.PROPERTY.equals((EnumerationType)propertyType)) {
            propertyArray = (Property[])property.getValue();
            n = propertyArray.length;
        } else if (PropertyType.NISOIMAGEMETADATA.equals((EnumerationType)propertyType)) {
            nisoImageMetadataArray = (NisoImageMetadata[])property.getValue();
            n = nisoImageMetadataArray.length;
        } else if (PropertyType.AESAUDIOMETADATA.equals((EnumerationType)propertyType)) {
            aESAudioMetadataArray = (AESAudioMetadata[])property.getValue();
            n = aESAudioMetadataArray.length;
        } else if (PropertyType.TEXTMDMETADATA.equals((EnumerationType)propertyType)) {
            textMDMetadataArray = (TextMDMetadata[])property.getValue();
            n = textMDMetadataArray.length;
        }
        for (int i = 0; i < n; ++i) {
            String string2;
            if (PropertyType.BOOLEAN.equals((EnumerationType)propertyType)) {
                string2 = String.valueOf(blArray[i]);
            } else if (PropertyType.BYTE.equals((EnumerationType)propertyType)) {
                string2 = String.valueOf(byArray[i]);
            } else if (PropertyType.CHARACTER.equals((EnumerationType)propertyType)) {
                string2 = String.valueOf(cArray[i]);
            } else if (PropertyType.DATE.equals((EnumerationType)propertyType)) {
                string2 = dateArray[i].toString();
            } else if (PropertyType.DOUBLE.equals((EnumerationType)propertyType)) {
                string2 = String.valueOf(dArray[i]);
            } else if (PropertyType.FLOAT.equals((EnumerationType)propertyType)) {
                string2 = String.valueOf(fArray[i]);
            } else if (PropertyType.INTEGER.equals((EnumerationType)propertyType)) {
                string2 = String.valueOf(nArray[i]);
            } else if (PropertyType.LONG.equals((EnumerationType)propertyType)) {
                string2 = String.valueOf(lArray[i]);
            } else if (PropertyType.OBJECT.equals((EnumerationType)propertyType)) {
                string2 = this.valueToString(objectArray[i]);
            } else if (PropertyType.SHORT.equals((EnumerationType)propertyType)) {
                string2 = String.valueOf(sArray[i]);
            } else if (PropertyType.STRING.equals((EnumerationType)propertyType)) {
                string2 = stringArray[i];
            } else if (PropertyType.RATIONAL.equals((EnumerationType)propertyType)) {
                string2 = rationalArray[i].toString();
            } else {
                if (PropertyType.PROPERTY.equals((EnumerationType)propertyType)) {
                    this.showProperty(propertyArray[i]);
                    continue;
                }
                if (PropertyType.NISOIMAGEMETADATA.equals((EnumerationType)propertyType)) {
                    this.showNisoImageMetadata(nisoImageMetadataArray[i]);
                    continue;
                }
                if (PropertyType.AESAUDIOMETADATA.equals((EnumerationType)propertyType)) {
                    this.showAESAudioMetadata(aESAudioMetadataArray[i]);
                    continue;
                }
                if (PropertyType.TEXTMDMETADATA.equals((EnumerationType)propertyType)) {
                    this.showTextMDMetadata(textMDMetadataArray[i]);
                    continue;
                }
                string2 = "<error>";
            }
            this._writer.println(string + XmlHandler.element((String)"value", (String)string2));
        }
    }

    protected void showTextMDMetadata(TextMDMetadata textMDMetadata) {
        String[][] stringArray;
        String string = XmlHandler.getIndent((int)(++this._level));
        String string2 = string + " ";
        String string3 = string2 + " ";
        String[][] stringArray2 = new String[][]{{"xmlns:textmd", "info:lc/xmlns/textMD-v3"}, {"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"}, {"xsi:schemaLocation", "info:lc/xmlns/textMD-v3 http://www.loc.gov/standards/textMD/textMD-v3.01a.xsd"}};
        this._writer.println(string + XmlHandler.elementStart((String)"textmd:textMD", (String[][])stringArray2));
        this._writer.println(string2 + XmlHandler.elementStart((String)"textmd:character_info"));
        this._writer.println(string3 + XmlHandler.element((String)"textmd:charset", (String)textMDMetadata.getCharset()));
        this._writer.println(string3 + XmlHandler.element((String)"textmd:byte_order", (String)textMDMetadata.getByte_orderString()));
        this._writer.println(string3 + XmlHandler.element((String)"textmd:byte_size", (String)textMDMetadata.getByte_size()));
        if ("variable".equals(textMDMetadata.getCharacter_size())) {
            stringArray = new String[][]{{"encoding", textMDMetadata.getCharset()}};
            this._writer.println(string3 + XmlHandler.element((String)"textmd:character_size", (String[][])stringArray, (String)"variable"));
        } else {
            this._writer.println(string3 + XmlHandler.element((String)"textmd:character_size", (String)textMDMetadata.getCharacter_size()));
        }
        this._writer.println(string3 + XmlHandler.element((String)"textmd:linebreak", (String)textMDMetadata.getLinebreakString()));
        this._writer.println(string2 + XmlHandler.elementEnd((String)"textmd:character_info"));
        if (textMDMetadata.getLanguage() != null && textMDMetadata.getLanguage().length() != 0) {
            this._writer.println(string2 + XmlHandler.element((String)"textmd:language", (String)textMDMetadata.getLanguage()));
        }
        if (textMDMetadata.getMarkup_basis() != null && textMDMetadata.getMarkup_basis().length() != 0) {
            if (textMDMetadata.getMarkup_basis_version() != null) {
                stringArray = new String[][]{{"version", textMDMetadata.getMarkup_basis_version()}};
                this._writer.println(string2 + XmlHandler.element((String)"textmd:markup_basis", (String[][])stringArray, (String)textMDMetadata.getMarkup_basis()));
            } else {
                this._writer.println(string2 + XmlHandler.element((String)"textmd:markup_basis", (String)textMDMetadata.getMarkup_basis()));
            }
        }
        if (textMDMetadata.getMarkup_language() != null && textMDMetadata.getMarkup_language().length() != 0) {
            if (textMDMetadata.getMarkup_language_version() != null) {
                stringArray = new String[][]{{"version", textMDMetadata.getMarkup_language_version()}};
                this._writer.println(string2 + XmlHandler.element((String)"textmd:markup_language", (String[][])stringArray, (String)textMDMetadata.getMarkup_language()));
            } else {
                this._writer.println(string2 + XmlHandler.element((String)"textmd:markup_language", (String)textMDMetadata.getMarkup_language()));
            }
        }
        this._writer.println(string + XmlHandler.elementEnd((String)"textmd:textMD"));
        --this._level;
    }

    protected void showNisoImageMetadata(NisoImageMetadata nisoImageMetadata) {
        if ("0.2".equals(this._je.getMixVersion())) {
            this.showNisoImageMetadata02(nisoImageMetadata);
        } else if ("1.0".equals(this._je.getMixVersion())) {
            this.showNisoImageMetadata10(nisoImageMetadata);
        } else {
            this.showNisoImageMetadata20(nisoImageMetadata);
        }
    }

    protected void showNisoImageMetadata02(NisoImageMetadata nisoImageMetadata) {
        String string = XmlHandler.getIndent((int)(++this._level));
        String[][] stringArray = new String[][]{{"xmlns:mix", "http://www.loc.gov/mix/"}, {"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"}, {"xsi:schemaLocation", "http://www.loc.gov/mix/ http://www.loc.gov/mix/mix02.xsd"}};
        this._writer.println(string + XmlHandler.elementStart((String)"mix:mix", (String[][])stringArray));
        this.showNisoBasicImageParameters02(nisoImageMetadata, string);
        this.showNisoImageCreation02(nisoImageMetadata, string);
        this.showNisoImagingPerformanceAssessment02(nisoImageMetadata, string);
        this.showNisoChangeHistory02(nisoImageMetadata, string);
        this._writer.println(string + XmlHandler.elementEnd((String)"mix:mix"));
        --this._level;
    }

    protected void showNisoBasicImageParameters02(NisoImageMetadata nisoImageMetadata, String string) {
        long l;
        long[] lArray;
        Rational[] rationalArray;
        int[] nArray;
        String string2 = string + " ";
        String string3 = string2 + " ";
        String string4 = string3 + " ";
        String string5 = string4 + " ";
        String string6 = string5 + " ";
        this._writer.println(string2 + XmlHandler.elementStart((String)"mix:BasicImageParameters"));
        StringBuffer stringBuffer = new StringBuffer(string3 + XmlHandler.elementStart((String)"mix:Format") + EOL);
        boolean bl = false;
        String string7 = nisoImageMetadata.getMimeType();
        if (string7 != null) {
            stringBuffer.append(string4 + XmlHandler.element((String)"mix:MIMEType", (String)string7) + EOL);
            bl = true;
        }
        if ((string7 = nisoImageMetadata.getByteOrder()) != null) {
            stringBuffer.append(string4 + XmlHandler.element((String)"mix:ByteOrder", (String)string7) + EOL);
            bl = true;
        }
        int n = nisoImageMetadata.getCompressionScheme();
        int n2 = nisoImageMetadata.getCompressionLevel();
        if (n != -1 || n2 != -1) {
            stringBuffer.append(string4 + XmlHandler.elementStart((String)"mix:Compression") + EOL);
            if (n != -1) {
                stringBuffer.append(string5 + XmlHandler.element((String)"mix:CompressionScheme", (String)Integer.toString(n)) + EOL);
            }
            if (n2 != -1) {
                stringBuffer.append(string5 + XmlHandler.element((String)"mix:CompressionLevel", (String)Integer.toString(n2)) + EOL);
            }
            stringBuffer.append(string4 + XmlHandler.elementEnd((String)"mix:Compression") + EOL);
            bl = true;
        }
        StringBuffer stringBuffer2 = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:PhotometricInterpretation") + EOL);
        boolean bl2 = false;
        int n3 = nisoImageMetadata.getColorSpace();
        if (n3 != -1) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:ColorSpace", (String)Integer.toString(n3)) + EOL);
            bl2 = true;
        }
        String string8 = nisoImageMetadata.getProfileURL();
        string7 = nisoImageMetadata.getProfileName();
        if (string7 != null || string8 != null) {
            stringBuffer2.append(string5 + XmlHandler.elementStart((String)"mix:ICCProfile") + EOL);
            if (string7 != null) {
                stringBuffer2.append(string6 + XmlHandler.element((String)"mix:ProfileName", (String)string7) + EOL);
            }
            if (string8 != null) {
                stringBuffer2.append(string6 + XmlHandler.element((String)"mix:ProfileURL", (String)string8) + EOL);
            }
            stringBuffer2.append(string5 + XmlHandler.elementEnd((String)"mix:ICCProfile"));
            bl2 = true;
        }
        if ((nArray = nisoImageMetadata.getYCbCrSubSampling()) != null) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:YCbCrSubSampling", (String)XmlHandler.integerArray((int[])nArray)) + EOL);
            bl2 = true;
        }
        if ((n3 = nisoImageMetadata.getYCbCrPositioning()) != -1) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:YCbCrPositioning", (String)Integer.toString(n3)) + EOL);
            bl2 = true;
        }
        if ((rationalArray = nisoImageMetadata.getYCbCrCoefficients()) != null) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:YCbCrCoefficients", (String)XmlHandler.rationalArray((Rational[])rationalArray)) + EOL);
            bl2 = true;
        }
        if ((rationalArray = nisoImageMetadata.getReferenceBlackWhite()) != null) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:ReferenceBlackWhite", (String)XmlHandler.rationalArray((Rational[])rationalArray)) + EOL);
            bl2 = true;
        }
        stringBuffer2.append(string4 + XmlHandler.elementEnd((String)"mix:PhotometricInterpretation") + EOL);
        if (bl2) {
            stringBuffer.append(stringBuffer2);
            bl = true;
        }
        StringBuffer stringBuffer3 = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:Segments") + EOL);
        boolean bl3 = false;
        n3 = nisoImageMetadata.getSegmentType();
        if (n3 != -1) {
            stringBuffer3.append(string5 + XmlHandler.element((String)"mix:SegmentType", (String)Integer.toString(n3)) + EOL);
            bl3 = true;
        }
        if ((lArray = nisoImageMetadata.getStripOffsets()) != null) {
            stringBuffer3.append(string5 + XmlHandler.element((String)"mix:StripOffsets", (String)XmlHandler.longArray((long[])lArray)) + EOL);
            bl3 = true;
        }
        if ((l = nisoImageMetadata.getRowsPerStrip()) != -1L) {
            stringBuffer3.append(string5 + XmlHandler.element((String)"mix:RowsPerStrip", (String)Long.toString(l)) + EOL);
            bl3 = true;
        }
        if ((lArray = nisoImageMetadata.getStripByteCounts()) != null) {
            stringBuffer3.append(string5 + XmlHandler.element((String)"mix:StripByteCounts", (String)XmlHandler.longArray((long[])lArray)) + EOL);
            bl3 = true;
        }
        if ((l = nisoImageMetadata.getTileWidth()) != -1L) {
            stringBuffer3.append(string5 + XmlHandler.element((String)"mix:TileWidth", (String)Long.toString(l)) + EOL);
            bl3 = true;
        }
        if ((l = nisoImageMetadata.getTileLength()) != -1L) {
            stringBuffer3.append(string5 + XmlHandler.element((String)"mix:TileLength", (String)Long.toString(l)) + EOL);
            bl3 = true;
        }
        if ((lArray = nisoImageMetadata.getTileOffsets()) != null) {
            stringBuffer3.append(string5 + XmlHandler.element((String)"mix:TileOffsets", (String)XmlHandler.longArray((long[])lArray)) + EOL);
            bl3 = true;
        }
        if ((lArray = nisoImageMetadata.getTileByteCounts()) != null) {
            stringBuffer3.append(string5 + XmlHandler.element((String)"mix:TileByteCounts", (String)XmlHandler.longArray((long[])lArray)) + EOL);
            bl3 = true;
        }
        stringBuffer3.append(string4 + XmlHandler.elementEnd((String)"mix:Segments") + EOL);
        if (bl3) {
            stringBuffer.append(stringBuffer3);
            bl = true;
        }
        if ((n3 = nisoImageMetadata.getPlanarConfiguration()) != -1) {
            stringBuffer.append(string4 + XmlHandler.element((String)"mix:PlanarConfiguration", (String)Integer.toString(n3)) + EOL);
        }
        stringBuffer.append(string3 + XmlHandler.elementEnd((String)"mix:Format") + EOL);
        if (bl) {
            this._writer.print(stringBuffer.toString());
        }
        StringBuffer stringBuffer4 = new StringBuffer(string3 + XmlHandler.elementStart((String)"mix:File") + EOL);
        boolean bl4 = false;
        string7 = nisoImageMetadata.getImageIdentifier();
        if (string7 != null) {
            stringBuffer4.append(string4 + XmlHandler.element((String)"mix:ImageIdentifier", (String)string7) + EOL);
            bl4 = true;
        }
        if ((l = nisoImageMetadata.getFileSize()) != -1L) {
            stringBuffer4.append(string4 + XmlHandler.element((String)"mix:FileSize", (String)Long.toString(l)) + EOL);
            bl4 = true;
        }
        n3 = nisoImageMetadata.getChecksumMethod();
        string7 = nisoImageMetadata.getChecksumValue();
        if (n3 != -1 || string7 != null) {
            stringBuffer4.append(string4 + XmlHandler.elementStart((String)"mix:Checksum") + EOL);
            if (n3 != -1) {
                stringBuffer4.append(string5 + XmlHandler.element((String)"mix:ChecksumMethod", (String)Integer.toString(n3)) + EOL);
            }
            if (string7 != null) {
                stringBuffer4.append(string5 + XmlHandler.element((String)"mix:ChecksumValue", (String)string7) + EOL);
            }
            stringBuffer4.append(string4 + XmlHandler.elementEnd((String)"mix:Checksum") + EOL);
            bl4 = true;
        }
        if ((n3 = nisoImageMetadata.getOrientation()) != -1) {
            stringBuffer4.append(string4 + XmlHandler.element((String)"mix:Orientation", (String)Integer.toString(n3)) + EOL);
            bl4 = true;
        }
        if ((n3 = nisoImageMetadata.getDisplayOrientation()) != -1) {
            stringBuffer4.append(string4 + XmlHandler.element((String)"mix:DisplayOrientation", (String)Integer.toString(n3)) + EOL);
            bl4 = true;
        }
        l = nisoImageMetadata.getXTargetedDisplayAR();
        long l2 = nisoImageMetadata.getYTargetedDisplayAR();
        if (l != -1L || l2 != -1L) {
            stringBuffer4.append(string4 + XmlHandler.elementStart((String)"mix:TargetedDisplayAR") + EOL);
            if (l != -1L) {
                stringBuffer4.append(string5 + XmlHandler.element((String)"mix:XTargetedDisplayAR", (String)Long.toString(l)) + EOL);
            }
            if (l2 != -1L) {
                stringBuffer4.append(string5 + XmlHandler.element((String)"mix:YTargetedDisplayAR", (String)Long.toString(l2)) + EOL);
            }
            stringBuffer4.append(string4 + XmlHandler.elementEnd((String)"mix:TargetedDisplayAR") + EOL);
            bl4 = true;
        }
        stringBuffer4.append(string3 + XmlHandler.elementEnd((String)"mix:File") + EOL);
        if (bl4) {
            this._writer.print(stringBuffer4.toString());
        }
        this._writer.println(string2 + XmlHandler.elementEnd((String)"mix:BasicImageParameters"));
    }

    protected void showNisoImageCreation02(NisoImageMetadata nisoImageMetadata, String string) {
        int n;
        double[] dArray;
        String string2 = string + " ";
        String string3 = string2 + " ";
        String string4 = string3 + " ";
        String string5 = string4 + " ";
        String string6 = string5 + " ";
        this._writer.println(string2 + XmlHandler.elementStart((String)"mix:ImageCreation"));
        String string7 = nisoImageMetadata.getSourceType();
        if (string7 != null) {
            this._writer.println(string3 + XmlHandler.element((String)"mix:SourceType", (String)string7));
        }
        if ((string7 = nisoImageMetadata.getSourceID()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"mix:SourceID", (String)string7));
        }
        if ((string7 = nisoImageMetadata.getImageProducer()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"mix:ImageProducer", (String)string7));
        }
        StringBuffer stringBuffer = new StringBuffer(string3 + XmlHandler.elementStart((String)"mix:Host") + EOL);
        boolean bl = false;
        string7 = nisoImageMetadata.getHostComputer();
        if (string7 != null) {
            stringBuffer.append(string4 + XmlHandler.element((String)"mix:HostComputer", (String)string7) + EOL);
            bl = true;
        }
        if ((string7 = nisoImageMetadata.getOS()) != null) {
            stringBuffer.append(string4 + XmlHandler.element((String)"mix:OperatingSystem", (String)string7) + EOL);
            bl = true;
        }
        if ((string7 = nisoImageMetadata.getOSVersion()) != null) {
            stringBuffer.append(string4 + XmlHandler.element((String)"mix:OSVersion", (String)string7) + EOL);
            bl = true;
        }
        stringBuffer.append(string3 + XmlHandler.elementEnd((String)"mix:Host") + EOL);
        if (bl) {
            this._writer.print(stringBuffer);
        }
        if ((string7 = nisoImageMetadata.getDeviceSource()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"mix:DeviceSource", (String)string7));
        }
        StringBuffer stringBuffer2 = new StringBuffer(string3 + XmlHandler.elementStart((String)"mix:ScanningSystemCapture") + EOL);
        boolean bl2 = false;
        StringBuffer stringBuffer3 = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:ScanningSystemHardware") + EOL);
        boolean bl3 = false;
        string7 = nisoImageMetadata.getScannerManufacturer();
        if (string7 != null) {
            stringBuffer3.append(string5 + XmlHandler.element((String)"mix:ScannerManufacturer", (String)string7) + EOL);
            bl3 = true;
        }
        string7 = nisoImageMetadata.getScannerModelName();
        String string8 = nisoImageMetadata.getScannerModelNumber();
        String string9 = nisoImageMetadata.getScannerModelSerialNo();
        if (string7 != null || string8 != null || string9 != null) {
            stringBuffer3.append(string5 + XmlHandler.elementStart((String)"mix:ScannerModel") + EOL);
            if (string7 != null) {
                stringBuffer3.append(string6 + XmlHandler.element((String)"mix:ScannerModelName", (String)string7) + EOL);
                bl3 = true;
            }
            if (string8 != null) {
                stringBuffer3.append(string6 + XmlHandler.element((String)"mix:ScannerModelNumber", (String)string8) + EOL);
                bl3 = true;
            }
            if (string9 != null) {
                stringBuffer3.append(string6 + XmlHandler.element((String)"mix:ScannerModelSerialNo ", (String)string9) + EOL);
                bl3 = true;
            }
            stringBuffer3.append(string5 + XmlHandler.elementEnd((String)"mix:ScannerModel") + EOL);
        }
        stringBuffer3.append(string4 + XmlHandler.elementEnd((String)"mix:ScanningSystemHardware") + EOL);
        if (bl3) {
            stringBuffer2.append(stringBuffer3);
            bl2 = true;
        }
        StringBuffer stringBuffer4 = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:ScanningSystemSoftware") + EOL);
        boolean bl4 = false;
        string7 = nisoImageMetadata.getScanningSoftware();
        if (string7 != null) {
            stringBuffer4.append(string5 + XmlHandler.element((String)"mix:ScanningSoftware", (String)string7) + EOL);
            bl4 = true;
        }
        if ((string7 = nisoImageMetadata.getScanningSoftwareVersionNo()) != null) {
            stringBuffer4.append(string5 + XmlHandler.element((String)"mix:ScanningSoftwareVersionNo", (String)string7) + EOL);
            bl4 = true;
        }
        stringBuffer4.append(string4 + XmlHandler.elementEnd((String)"mix:ScanningSystemSoftware") + EOL);
        if (bl4) {
            stringBuffer2.append(stringBuffer4);
            bl2 = true;
        }
        StringBuffer stringBuffer5 = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:ScannerCaptureSettings") + EOL);
        boolean bl5 = false;
        double d = nisoImageMetadata.getPixelSize();
        if (d != -1.0) {
            stringBuffer5.append(string5 + XmlHandler.element((String)"mix:PixelSize", (String)Double.toString(d)) + EOL);
            bl5 = true;
        }
        d = nisoImageMetadata.getXPhysScanResolution();
        double d2 = nisoImageMetadata.getYPhysScanResolution();
        if (d != -1.0 || d2 != -1.0) {
            stringBuffer5.append(string5 + XmlHandler.elementStart((String)"mix:PhysScanResolution") + EOL);
            if (d != -1.0) {
                stringBuffer5.append(string6 + XmlHandler.element((String)"mix:XphysScanResolution", (String)Double.toString(d)) + EOL);
            }
            if (d2 != -1.0) {
                stringBuffer5.append(string6 + XmlHandler.element((String)"mix:YphysScanResolution", (String)Double.toString(d2)) + EOL);
            }
            stringBuffer5.append(string5 + XmlHandler.elementEnd((String)"mix:PhysScanResolution") + EOL);
            bl5 = true;
        }
        stringBuffer5.append(string4 + XmlHandler.elementEnd((String)"mix:ScannerCaptureSettings") + EOL);
        if (bl5) {
            stringBuffer2.append(stringBuffer5);
            bl2 = true;
        }
        stringBuffer2.append(string3 + XmlHandler.elementEnd((String)"mix:ScanningSystemCapture") + EOL);
        if (bl2) {
            this._writer.print(stringBuffer2.toString());
        }
        StringBuffer stringBuffer6 = new StringBuffer(string3 + XmlHandler.elementStart((String)"mix:DigitalCameraCapture") + EOL);
        boolean bl6 = false;
        string7 = nisoImageMetadata.getDigitalCameraManufacturer();
        if (string7 != null) {
            stringBuffer6.append(string4 + XmlHandler.element((String)"mix:DigitalCameraManufacturer", (String)string7) + EOL);
            bl6 = true;
        }
        if ((string7 = nisoImageMetadata.getDigitalCameraModel()) != null) {
            stringBuffer6.append(string4 + XmlHandler.element((String)"mix:DigitalCameraModel", (String)string7) + EOL);
            bl6 = true;
        }
        stringBuffer6.append(string3 + XmlHandler.elementEnd((String)"mix:DigitalCameraCapture") + EOL);
        if (bl6) {
            this._writer.print(stringBuffer6.toString());
        }
        StringBuffer stringBuffer7 = new StringBuffer(string3 + XmlHandler.elementStart((String)"mix:CameraCaptureSettings") + EOL);
        boolean bl7 = false;
        d = nisoImageMetadata.getFNumber();
        if (d != -1.0) {
            stringBuffer7.append(string4 + XmlHandler.element((String)"mix:FNumber", (String)Double.toString(d)) + EOL);
            bl7 = true;
        }
        if ((d = nisoImageMetadata.getExposureTime()) != -1.0) {
            stringBuffer7.append(string4 + XmlHandler.element((String)"mix:ExposureTime", (String)Double.toString(d)) + EOL);
            bl7 = true;
        }
        if ((d = nisoImageMetadata.getBrightness()) != -1.0) {
            stringBuffer7.append(string4 + XmlHandler.element((String)"mix:Brightness", (String)Double.toString(d)) + EOL);
            bl7 = true;
        }
        if ((d = nisoImageMetadata.getExposureBias()) != -1.0) {
            stringBuffer7.append(string4 + XmlHandler.element((String)"mix:ExposureBias", (String)Double.toString(d)) + EOL);
            bl7 = true;
        }
        if ((dArray = nisoImageMetadata.getSubjectDistance()) != null) {
            stringBuffer7.append(string4 + XmlHandler.element((String)"mix:SubjectDistance", (String)XmlHandler.doubleArray((double[])dArray)) + EOL);
            bl7 = true;
        }
        if ((n = nisoImageMetadata.getMeteringMode()) != -1) {
            stringBuffer7.append(string4 + XmlHandler.element((String)"mix:MeteringMode", (String)Integer.toString(n)) + EOL);
            bl7 = true;
        }
        if ((n = nisoImageMetadata.getSceneIlluminant()) != -1) {
            stringBuffer7.append(string4 + XmlHandler.element((String)"mix:SceneIlluminant", (String)Integer.toString(n)) + EOL);
            bl7 = true;
        }
        if ((d = nisoImageMetadata.getColorTemp()) != -1.0) {
            stringBuffer7.append(string4 + XmlHandler.element((String)"mix:ColorTemp", (String)Double.toString(d)) + EOL);
            bl7 = true;
        }
        if ((d = nisoImageMetadata.getFocalLength()) != -1.0) {
            stringBuffer7.append(string4 + XmlHandler.element((String)"mix:FocalLength", (String)Double.toString(d)) + EOL);
            bl7 = true;
        }
        if ((n = nisoImageMetadata.getFlash()) != -1) {
            stringBuffer7.append(string4 + XmlHandler.element((String)"mix:Flash", (String)Integer.toString(n)) + EOL);
            bl7 = true;
        }
        if ((d = nisoImageMetadata.getFlashEnergy()) != -1.0) {
            stringBuffer7.append(string4 + XmlHandler.element((String)"mix:FlashEnergy", (String)Double.toString(d)) + EOL);
            bl7 = true;
        }
        if ((n = nisoImageMetadata.getFlashReturn()) != -1) {
            stringBuffer7.append(string4 + XmlHandler.element((String)"mix:FlashReturn", (String)Integer.toString(n)) + EOL);
            bl7 = true;
        }
        if ((n = nisoImageMetadata.getBackLight()) != -1) {
            stringBuffer7.append(string4 + XmlHandler.element((String)"mix:BackLight", (String)Integer.toString(n)) + EOL);
            bl7 = true;
        }
        if ((d = nisoImageMetadata.getExposureIndex()) != -1.0) {
            stringBuffer7.append(string4 + XmlHandler.element((String)"mix:ExposureIndex", (String)Double.toString(d)) + EOL);
            bl7 = true;
        }
        if ((n = nisoImageMetadata.getAutoFocus()) != -1) {
            stringBuffer7.append(string4 + XmlHandler.element((String)"mix:AutoFocus", (String)Integer.toString(n)) + EOL);
            bl7 = true;
        }
        d = nisoImageMetadata.getXPrintAspectRatio();
        d2 = nisoImageMetadata.getYPrintAspectRatio();
        if (d != -1.0 || d2 != -1.0) {
            stringBuffer7.append(string4 + XmlHandler.elementStart((String)"mix:PrintAspectRatio") + EOL);
            if (d != -1.0) {
                stringBuffer7.append(string5 + XmlHandler.element((String)"mix:XPrintAspectRatio", (String)Double.toString(d)) + EOL);
            }
            if (d2 != -1.0) {
                stringBuffer7.append(string5 + XmlHandler.element((String)"mix:YPrintAspectRatio", (String)Double.toString(d2)) + EOL);
                stringBuffer7.append(string4 + XmlHandler.elementEnd((String)"mix:PrintAspectRatio") + EOL);
                bl7 = true;
            }
        }
        stringBuffer7.append(string3 + XmlHandler.elementEnd((String)"mix:CameraCaptureSettings") + EOL);
        if (bl7) {
            this._writer.print(stringBuffer7.toString());
        }
        if ((n = nisoImageMetadata.getSensor()) != -1) {
            this._writer.println(string3 + XmlHandler.element((String)"mix:Sensor", (String)Integer.toString(n)));
        }
        if ((string7 = nisoImageMetadata.getDateTimeCreated()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"mix:DateTimeCreated", (String)string7));
        }
        if ((string7 = nisoImageMetadata.getMethodology()) != null) {
            this._writer.println(string3 + XmlHandler.element((String)"mix:Methodology", (String)string7));
        }
        this._writer.println(string2 + XmlHandler.elementEnd((String)"mix:ImageCreation"));
    }

    protected void showNisoImagingPerformanceAssessment02(NisoImageMetadata nisoImageMetadata, String string) {
        Object object;
        Object object2;
        long l;
        Rational rational;
        String string2 = string + " ";
        String string3 = string2 + " ";
        String string4 = string3 + " ";
        String string5 = string4 + " ";
        String string6 = string5 + " ";
        String string7 = string6 + " ";
        StringBuffer stringBuffer = new StringBuffer(string3 + XmlHandler.elementStart((String)"mix:ImagingPerformanceAssessment") + EOL);
        boolean bl = false;
        StringBuffer stringBuffer2 = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:SpatialMetrics") + EOL);
        boolean bl2 = false;
        int n = nisoImageMetadata.getSamplingFrequencyPlane();
        if (n != -1) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:SamplingFrequencyPlane", (String)Integer.toString(n)) + EOL);
            bl2 = true;
        }
        if ((n = nisoImageMetadata.getSamplingFrequencyUnit()) != -1) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:SamplingFrequencyUnit", (String)Integer.toString(n)) + EOL);
            bl2 = true;
        }
        if ((rational = nisoImageMetadata.getXSamplingFrequency()) != null) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:XSamplingFrequency", (String)Long.toString(rational.toLong())) + EOL);
            bl2 = true;
        }
        if ((rational = nisoImageMetadata.getYSamplingFrequency()) != null) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:YSamplingFrequency", (String)Long.toString(rational.toLong())) + EOL);
            bl2 = true;
        }
        if ((l = nisoImageMetadata.getImageWidth()) != -1L) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:ImageWidth", (String)Long.toString(l)) + EOL);
            bl2 = true;
        }
        if ((l = nisoImageMetadata.getImageLength()) != -1L) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:ImageLength", (String)Long.toString(l)) + EOL);
            bl2 = true;
        }
        double d = nisoImageMetadata.getSourceXDimension();
        n = nisoImageMetadata.getSourceXDimensionUnit();
        if (d != -1.0 || n != -1) {
            stringBuffer2.append(string5 + XmlHandler.elementStart((String)"mix:Source_X") + EOL);
            if (d != -1.0) {
                stringBuffer2.append(string6 + XmlHandler.element((String)"mix:Source_Xdimension", (String)Double.toString(d)) + EOL);
            }
            if (n != -1) {
                stringBuffer2.append(string6 + XmlHandler.element((String)"mix:Source_XdimensionUnit", (String)Integer.toString(n)) + EOL);
            }
            stringBuffer2.append(string5 + XmlHandler.elementEnd((String)"mix:Source_X") + EOL);
            bl2 = true;
        }
        d = nisoImageMetadata.getSourceYDimension();
        n = nisoImageMetadata.getSourceYDimensionUnit();
        if (d != -1.0 || n != -1) {
            stringBuffer2.append(string4 + XmlHandler.elementStart((String)"mix:Source_Y") + EOL);
            if (d != -1.0) {
                stringBuffer2.append(string5 + XmlHandler.element((String)"mix:Source_Ydimension", (String)Double.toString(d)) + EOL);
            }
            if (n != -1) {
                stringBuffer2.append(string5 + XmlHandler.element((String)"mix:Source_YdimensionUnit", (String)Integer.toString(n)) + EOL);
            }
            stringBuffer2.append(string4 + XmlHandler.elementEnd((String)"mix:Source_Y") + EOL);
            bl2 = true;
        }
        stringBuffer2.append(string3 + XmlHandler.elementEnd((String)"mix:SpatialMetrics") + EOL);
        if (bl2) {
            stringBuffer.append(stringBuffer2);
            bl = true;
        }
        StringBuffer stringBuffer3 = new StringBuffer(string3 + XmlHandler.elementStart((String)"mix:Energetics") + EOL);
        boolean bl3 = false;
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (nArray != null) {
            stringBuffer3.append(string4 + XmlHandler.element((String)"mix:BitsPerSample", (String)XmlHandler.integerArray((int[])nArray, (char)',')) + EOL);
            bl3 = true;
        }
        if ((n = nisoImageMetadata.getSamplesPerPixel()) != -1) {
            stringBuffer3.append(string4 + XmlHandler.element((String)"mix:SamplesPerPixel", (String)Integer.toString(n)) + EOL);
            bl3 = true;
        }
        if ((nArray = nisoImageMetadata.getExtraSamples()) != null && (n = nArray[0]) >= 0 && n <= 3) {
            stringBuffer3.append(string4 + XmlHandler.element((String)"mix:ExtraSamples", (String)Integer.toString(n)) + EOL);
            bl3 = true;
        }
        StringBuffer stringBuffer4 = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:Colormap") + EOL);
        boolean bl4 = false;
        String string8 = nisoImageMetadata.getColormapReference();
        if (string8 != null) {
            stringBuffer4.append(string5 + XmlHandler.element((String)"mix:Reference", (String)string8) + EOL);
            bl4 = true;
        }
        if ((nArray = nisoImageMetadata.getColormapRedValue()) != null) {
            stringBuffer4.append(string5 + XmlHandler.elementStart((String)"mix:Wrap"));
            object2 = nisoImageMetadata.getColormapBitCodeValue();
            object = nisoImageMetadata.getColormapGreenValue();
            int[] nArray2 = nisoImageMetadata.getColormapBlueValue();
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    stringBuffer4.append(string6 + XmlHandler.elementStart((String)"mix:Color") + EOL);
                    n = object2[i];
                    if (n != -1) {
                        stringBuffer4.append(string7 + XmlHandler.element((String)"mix:BitCodeValue", (String)Integer.toString(n)) + EOL);
                    }
                    if ((n = nArray[i]) != -1) {
                        stringBuffer4.append(string7 + XmlHandler.element((String)"mix:RedValue", (String)Integer.toString(n)) + EOL);
                    }
                    if ((n = object[i]) != -1) {
                        stringBuffer4.append(string7 + XmlHandler.element((String)"mix:GreenValue", (String)Integer.toString(n)) + EOL);
                    }
                    if ((n = nArray2[i]) != -1) {
                        stringBuffer4.append(string7 + XmlHandler.element((String)"mix:BlueValue", (String)Integer.toString(n)) + EOL);
                    }
                    stringBuffer4.append(string6 + XmlHandler.elementEnd((String)"mix:Color") + EOL);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            stringBuffer4.append(string5 + XmlHandler.elementEnd((String)"mix:Wrap") + EOL);
            bl4 = true;
        }
        stringBuffer4.append(string4 + XmlHandler.elementEnd((String)"mix:Colormap"));
        if (bl4) {
            stringBuffer3.append(stringBuffer4);
            bl3 = true;
        }
        nArray = nisoImageMetadata.getGrayResponseCurve();
        n = nisoImageMetadata.getGrayResponseUnit();
        if (nArray != null || n != -1) {
            stringBuffer3.append(string4 + XmlHandler.elementStart((String)"mix:GrayResponse") + EOL);
            if (nArray != null) {
                stringBuffer3.append(string5 + XmlHandler.element((String)"mix:GrayResponseCurve", (String)XmlHandler.integerArray((int[])nArray)) + EOL);
            }
            if (n != -1) {
                stringBuffer3.append(string5 + XmlHandler.element((String)"mix:GrayResponseUnit", (String)Integer.toString(n)) + EOL);
            }
            stringBuffer3.append(string4 + XmlHandler.elementEnd((String)"mix:GrayResponse") + EOL);
            bl3 = true;
        }
        rational = nisoImageMetadata.getWhitePointXValue();
        object2 = nisoImageMetadata.getWhitePointYValue();
        if (rational != null || object2 != null) {
            stringBuffer3.append(string4 + XmlHandler.elementStart((String)"mix:WhitePoint") + EOL);
            if (rational != null) {
                stringBuffer3.append(string5 + XmlHandler.element((String)"mix:WhitePoint_Xvalue", (String)rational.toString()) + EOL);
            }
            if (object2 != null) {
                stringBuffer3.append(string5 + XmlHandler.element((String)"mix:WhitePoint_Yvalue", (String)object2.toString()) + EOL);
            }
            stringBuffer3.append(string4 + XmlHandler.elementEnd((String)"mix:WhitePoint") + EOL);
            bl3 = true;
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesRedX()) != null) {
            stringBuffer3.append(string4 + XmlHandler.elementStart((String)"mix:PrimaryChromaticities") + EOL);
            stringBuffer3.append(string5 + XmlHandler.element((String)"mix:PrimaryChromaticities_RedX", (String)rational.toString()) + EOL);
            rational = nisoImageMetadata.getPrimaryChromaticitiesRedY();
            if (rational != null) {
                stringBuffer3.append(string5 + XmlHandler.element((String)"mix:PrimaryChromaticities_RedY", (String)rational.toString()) + EOL);
            }
            if ((rational = nisoImageMetadata.getPrimaryChromaticitiesGreenX()) != null) {
                stringBuffer3.append(string5 + XmlHandler.element((String)"mix:PrimaryChromaticities_GreenX", (String)rational.toString()) + EOL);
            }
            if ((rational = nisoImageMetadata.getPrimaryChromaticitiesGreenY()) != null) {
                stringBuffer3.append(string5 + XmlHandler.element((String)"mix:PrimaryChromaticities_GreenY", (String)rational.toString()) + EOL);
            }
            if ((rational = nisoImageMetadata.getPrimaryChromaticitiesBlueX()) != null) {
                stringBuffer3.append(string5 + XmlHandler.element((String)"mix:PrimaryChromaticities_BlueX", (String)rational.toString()) + EOL);
            }
            if ((rational = nisoImageMetadata.getPrimaryChromaticitiesBlueY()) != null) {
                stringBuffer3.append(string5 + XmlHandler.element((String)"mix:PrimaryChromaticities_BlueY", (String)rational.toString()) + EOL);
            }
            stringBuffer3.append(string4 + XmlHandler.elementEnd((String)"mix:PrimaryChromaticities") + EOL);
            bl3 = true;
        }
        stringBuffer3.append(string3 + XmlHandler.elementEnd((String)"mix:Energetics") + EOL);
        if (bl3) {
            stringBuffer.append(stringBuffer3);
            bl = true;
        }
        object = new StringBuffer(string3 + XmlHandler.elementStart((String)"mix:TargetData") + EOL);
        boolean bl5 = false;
        n = nisoImageMetadata.getTargetType();
        if (n != -1) {
            ((StringBuffer)object).append(string4 + XmlHandler.element((String)"mix:TargetType", (String)Integer.toString(n)) + EOL);
            bl5 = true;
        }
        StringBuffer stringBuffer5 = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:TargetID") + EOL);
        boolean bl6 = false;
        string8 = nisoImageMetadata.getTargetIDManufacturer();
        if (string8 != null) {
            stringBuffer5.append(string5 + XmlHandler.element((String)"mix:TargetIDManufacturer", (String)string8) + EOL);
            bl6 = true;
        }
        if ((string8 = nisoImageMetadata.getTargetIDName()) != null) {
            stringBuffer5.append(string5 + XmlHandler.element((String)"mix:TargetIDName", (String)string8) + EOL);
            bl6 = true;
        }
        if ((string8 = nisoImageMetadata.getTargetIDNo()) != null) {
            stringBuffer5.append(string5 + XmlHandler.element((String)"mix:TargetIDNo", (String)string8) + EOL);
            bl6 = true;
        }
        if ((string8 = nisoImageMetadata.getTargetIDMedia()) != null) {
            stringBuffer5.append(string5 + XmlHandler.element((String)"mix:TargetIDMedia", (String)string8) + EOL);
            bl6 = true;
        }
        stringBuffer5.append(string4 + XmlHandler.elementEnd((String)"mix:TargetID") + EOL);
        if (bl6) {
            ((StringBuffer)object).append(stringBuffer5);
            bl5 = true;
        }
        if ((string8 = nisoImageMetadata.getImageData()) != null) {
            ((StringBuffer)object).append(string5 + XmlHandler.element((String)"mix:ImageData", (String)string8) + EOL);
            bl5 = true;
        }
        if ((string8 = nisoImageMetadata.getPerformanceData()) != null) {
            ((StringBuffer)object).append(string5 + XmlHandler.element((String)"mix:PerformanceData", (String)string8) + EOL);
            bl5 = true;
        }
        if ((string8 = nisoImageMetadata.getProfiles()) != null) {
            ((StringBuffer)object).append(string5 + XmlHandler.element((String)"mix:Profiles", (String)string8) + EOL);
            bl5 = true;
        }
        ((StringBuffer)object).append(string3 + XmlHandler.elementEnd((String)"mix:TargetData") + EOL);
        if (bl5) {
            stringBuffer.append((StringBuffer)object);
            bl = true;
        }
        stringBuffer.append(string2 + XmlHandler.elementEnd((String)"mix:ImagingPerformanceAssessment") + EOL);
        if (bl) {
            this._writer.print(stringBuffer.toString());
        }
    }

    protected void showNisoChangeHistory02(NisoImageMetadata nisoImageMetadata, String string) {
        String[] stringArray;
        String string2 = string + " ";
        String string3 = string2 + " ";
        String string4 = string3 + " ";
        String string5 = string4 + " ";
        String string6 = string5 + " ";
        String string7 = string6 + " ";
        StringBuffer stringBuffer = new StringBuffer(string2 + XmlHandler.elementStart((String)"mix:ChangeHistory") + EOL);
        boolean bl = false;
        StringBuffer stringBuffer2 = new StringBuffer(string3 + XmlHandler.elementStart((String)"mix:ImageProcessing") + EOL);
        boolean bl2 = false;
        String string8 = nisoImageMetadata.getDateTimeProcessed();
        if (string8 != null) {
            stringBuffer2.append(string4 + XmlHandler.element((String)"DateTimeProcessed", (String)string8) + EOL);
            bl2 = true;
        }
        if ((string8 = nisoImageMetadata.getSourceData()) != null) {
            stringBuffer2.append(string4 + XmlHandler.element((String)"SourceData", (String)string8) + EOL);
            bl2 = true;
        }
        if ((string8 = nisoImageMetadata.getProcessingAgency()) != null) {
            stringBuffer2.append(string4 + XmlHandler.element((String)"ProcessingAgency", (String)string8) + EOL);
            bl2 = true;
        }
        StringBuffer stringBuffer3 = new StringBuffer(string4 + XmlHandler.elementStart((String)"ProcessingSoftware") + EOL);
        boolean bl3 = false;
        string8 = nisoImageMetadata.getProcessingSoftwareName();
        if (string8 != null) {
            stringBuffer3.append(string5 + XmlHandler.element((String)"ProcessingSoftwareName", (String)string8) + EOL);
            bl3 = true;
        }
        if ((string8 = nisoImageMetadata.getProcessingSoftwareVersion()) != null) {
            stringBuffer3.append(string5 + XmlHandler.element((String)"ProcessingSoftwareVersion", (String)string8) + EOL);
            bl3 = true;
        }
        stringBuffer3.append(string4 + XmlHandler.elementEnd((String)"ProcessingSoftware") + EOL);
        if (bl3) {
            stringBuffer2.append(stringBuffer3);
            bl2 = true;
        }
        if ((stringArray = nisoImageMetadata.getProcessingActions()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer2.append(string4 + XmlHandler.element((String)"ProcessingActions", (String)stringArray[i]) + EOL);
            }
            bl2 = true;
        }
        stringBuffer2.append(string3 + XmlHandler.elementEnd((String)"mix:ImageProcessing") + EOL);
        if (bl2) {
            stringBuffer.append(stringBuffer2);
            bl = true;
        }
        stringBuffer.append(string2 + XmlHandler.elementEnd((String)"mix:ChangeHistory") + EOL);
        if (bl) {
            this._writer.print(stringBuffer.toString());
        }
    }

    protected void showNisoImageMetadata10(NisoImageMetadata nisoImageMetadata) {
        String string = XmlHandler.getIndent((int)(++this._level));
        String[][] stringArray = new String[][]{{"xmlns:mix", "http://www.loc.gov/mix/v10"}, {"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"}, {"xsi:schemaLocation", "http://www.loc.gov/mix/v10 http://www.loc.gov/standards/mix/mix10/mix10.xsd"}};
        this._writer.println(string + XmlHandler.elementStart((String)"mix:mix", (String[][])stringArray));
        this.showNisoBasicDigitalObjectInformation10(nisoImageMetadata, string);
        this.showNisoBasicImageInformation10(nisoImageMetadata, string);
        this.showNisoImageCaptureMetadata10(nisoImageMetadata, string);
        this.showNisoImageAssessmentMetadata10(nisoImageMetadata, string);
        this.showChangeHistory10(nisoImageMetadata, string);
        this._writer.println(string + XmlHandler.elementEnd((String)"mix:mix"));
        --this._level;
    }

    protected void showNisoBasicDigitalObjectInformation10(NisoImageMetadata nisoImageMetadata, String string) {
        long l;
        String string2 = string + " ";
        String string3 = string2 + " ";
        String string4 = string3 + " ";
        String string5 = string4 + " ";
        this._writer.println(string2 + XmlHandler.elementStart((String)"mix:BasicDigitalObjectInformation"));
        StringBuffer stringBuffer = new StringBuffer(string3 + XmlHandler.elementStart((String)"mix:ObjectIdentifier") + EOL);
        boolean bl = false;
        stringBuffer.append(string4 + XmlHandler.element((String)"mix:objectIdentifierType", (String)"JHOVE") + EOL);
        String string6 = nisoImageMetadata.getImageIdentifier();
        if (string6 != null) {
            stringBuffer.append(string4 + XmlHandler.element((String)"mix:objectIdentifierValue", (String)string6) + EOL);
            bl = true;
        }
        stringBuffer.append(string3 + XmlHandler.elementEnd((String)"mix:ObjectIdentifier") + EOL);
        if (bl) {
            this._writer.print(stringBuffer.toString());
        }
        if ((l = nisoImageMetadata.getFileSize()) != -1L) {
            this._writer.print(string4 + XmlHandler.element((String)"mix:fileSize", (String)Long.toString(l)) + EOL);
        }
        if ((string6 = nisoImageMetadata.getByteOrder()) != null) {
            if (string6.startsWith("big")) {
                string6 = "big_endian";
            } else if (string6.startsWith("little")) {
                string6 = "little_endian";
            }
            this._writer.print(string4 + XmlHandler.element((String)"mix:byteOrder", (String)string6) + EOL);
        }
        int n = nisoImageMetadata.getCompressionScheme();
        int n2 = nisoImageMetadata.getCompressionLevel();
        if (n != -1 || n2 != -1) {
            this._writer.print(string4 + XmlHandler.elementStart((String)"mix:Compression") + EOL);
            if (n != -1) {
                this._writer.print(string5 + XmlHandler.element((String)"mix:compressionScheme", (String)Integer.toString(n)) + EOL);
            }
            this._writer.print(string4 + XmlHandler.elementEnd((String)"mix:Compression") + EOL);
        }
        int n3 = nisoImageMetadata.getChecksumMethod();
        string6 = nisoImageMetadata.getChecksumValue();
        if (n3 != -1 || string6 != null) {
            this._writer.print(string4 + XmlHandler.elementStart((String)"mix:Fixity") + EOL);
            if (n3 != -1) {
                this._writer.print(string5 + XmlHandler.element((String)"mix:messageDigestAlgorithm", (String)Integer.toString(n3)) + EOL);
            }
            if (string6 != null) {
                this._writer.print(string5 + XmlHandler.element((String)"mix:messageDigest", (String)string6) + EOL);
            }
            this._writer.println(string4 + XmlHandler.elementEnd((String)"mix:Fixity"));
        }
        this._writer.println(string3 + XmlHandler.elementEnd((String)"mix:BasicDigitalObjectInformation"));
    }

    protected void showNisoBasicImageInformation10(NisoImageMetadata nisoImageMetadata, String string) {
        String string2 = string + " ";
        String string3 = string2 + " ";
        String string4 = string3 + " ";
        String string5 = string4 + " ";
        String string6 = string5 + " ";
        String string7 = string6 + " ";
        this._writer.println(string2 + XmlHandler.elementStart((String)"mix:BasicImageInformation"));
        StringBuffer stringBuffer = new StringBuffer(string3 + XmlHandler.elementStart((String)"mix:BasicImageCharacteristics") + EOL);
        boolean bl = false;
        long l = nisoImageMetadata.getImageWidth();
        if (l != -1L) {
            stringBuffer.append(string4 + XmlHandler.element((String)"mix:imageWidth", (String)Long.toString(l)) + EOL);
            bl = true;
        }
        if ((l = nisoImageMetadata.getImageLength()) != -1L) {
            stringBuffer.append(string4 + XmlHandler.element((String)"mix:imageHeight", (String)Long.toString(l)) + EOL);
            bl = true;
        }
        StringBuffer stringBuffer2 = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:PhotometricInterpretation") + EOL);
        boolean bl2 = false;
        int n = nisoImageMetadata.getColorSpace();
        if (n != -1) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:colorSpace", (String)Integer.toString(n)) + EOL);
            bl2 = true;
        }
        String string8 = nisoImageMetadata.getProfileName();
        String string9 = nisoImageMetadata.getProfileURL();
        if (string8 != null || string9 != null) {
            stringBuffer2.append(string5 + XmlHandler.elementStart((String)"mix:ColorProfile") + EOL);
            stringBuffer2.append(string6 + XmlHandler.elementStart((String)"mix:IccProfile") + EOL);
            if (string8 != null) {
                stringBuffer2.append(string7 + XmlHandler.element((String)"mix:iccProfileName", (String)string8) + EOL);
            }
            if (string9 != null) {
                stringBuffer2.append(string7 + XmlHandler.element((String)"mix:iccProfileURL", (String)string9) + EOL);
            }
            stringBuffer2.append(string6 + XmlHandler.elementEnd((String)"mix:IccProfile") + EOL);
            stringBuffer2.append(string5 + XmlHandler.elementEnd((String)"mix:ColorProfile") + EOL);
            bl2 = true;
        }
        int[] nArray = nisoImageMetadata.getYCbCrSubSampling();
        n = nisoImageMetadata.getYCbCrPositioning();
        Rational[] rationalArray = nisoImageMetadata.getYCbCrCoefficients();
        if (nArray != null || n != -1 || rationalArray != null) {
            stringBuffer2.append(string5 + XmlHandler.elementStart((String)"mix:YCbCr") + EOL);
            bl2 = true;
            if (nArray != null && nArray.length >= 2) {
                stringBuffer2.append(string6 + XmlHandler.elementStart((String)"mix:YCbCrSubSampling") + EOL);
                stringBuffer2.append(string7 + XmlHandler.element((String)"mix:yCbCrSubsampleHoriz", (String)Integer.toString(nArray[0])) + EOL);
                stringBuffer2.append(string7 + XmlHandler.element((String)"mix:yCbCrSubsampleVert", (String)Integer.toString(nArray[1])) + EOL);
                stringBuffer2.append(string6 + XmlHandler.elementEnd((String)"mix:YCbCrSubSampling") + EOL);
            }
            if (n != -1) {
                stringBuffer2.append(string6 + XmlHandler.element((String)"mix:yCbCrPositioning", (String)Integer.toString(n)) + EOL);
            }
            if (rationalArray != null) {
                stringBuffer2.append(string6 + XmlHandler.element((String)"mix:yCbCrCoefficients", (String)XmlHandler.rationalArray10((Rational[])rationalArray)) + EOL);
            }
            stringBuffer2.append(string5 + XmlHandler.elementEnd((String)"mix:YCbCr") + EOL);
        }
        if ((rationalArray = nisoImageMetadata.getReferenceBlackWhite()) != null) {
            stringBuffer2.append(string6 + XmlHandler.element((String)"mix:referenceBlackWhite", (String)XmlHandler.rationalArray10((Rational[])rationalArray)) + EOL);
            bl2 = true;
        }
        stringBuffer2.append(string4 + XmlHandler.elementEnd((String)"mix:PhotometricInterpretation") + EOL);
        if (bl2) {
            stringBuffer.append(stringBuffer2);
            bl = true;
        }
        stringBuffer.append(string3 + XmlHandler.elementEnd((String)"mix:BasicImageCharacteristics"));
        if (bl) {
            this._writer.println(stringBuffer);
        }
        this._writer.println(string2 + XmlHandler.elementEnd((String)"mix:BasicImageInformation"));
    }

    protected void showNisoImageCaptureMetadata10(NisoImageMetadata nisoImageMetadata, String string) {
        double[] dArray;
        String string2 = string + " ";
        String string3 = string2 + " ";
        String string4 = string3 + " ";
        String string5 = string4 + " ";
        String string6 = string5 + " ";
        String string7 = string6 + " ";
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        String string8 = nisoImageMetadata.getSourceType();
        if (string8 != null) {
            stringBuffer.append(string3 + XmlHandler.element((String)"mix:sourceType", (String)string8));
            bl = true;
        }
        if ((string8 = nisoImageMetadata.getSourceID()) != null) {
            stringBuffer.append(string3 + XmlHandler.elementStart((String)"mix:SourceID"));
            stringBuffer.append(string3 + XmlHandler.element((String)"mix:sourceIDValue", (String)string8));
            stringBuffer.append(string3 + XmlHandler.elementEnd((String)"mix:sourceID"));
            bl = true;
        }
        double d = nisoImageMetadata.getSourceXDimension();
        int n = nisoImageMetadata.getSourceXDimensionUnit();
        if (d != -1.0 || n != -1) {
            stringBuffer.append(string3 + XmlHandler.elementStart((String)"mix:SourceSize"));
            stringBuffer.append(string4 + XmlHandler.elementStart((String)"mix:SourceXDimension") + EOL);
            if (d != -1.0) {
                stringBuffer.append(string5 + XmlHandler.element((String)"mix:sourceXDimensionValue", (String)Double.toString(d)) + EOL);
            }
            if (n != -1) {
                stringBuffer.append(string5 + XmlHandler.element((String)"mix:sourceXDimensionUnit", (String)Integer.toString(n)) + EOL);
            }
            stringBuffer.append(string4 + XmlHandler.elementEnd((String)"mix:SourceXDimension") + EOL);
            d = nisoImageMetadata.getSourceYDimension();
            n = nisoImageMetadata.getSourceYDimensionUnit();
            if (d != -1.0 || n != -1) {
                stringBuffer.append(string4 + XmlHandler.elementStart((String)"mix:SourceYDimension") + EOL);
                if (d != -1.0) {
                    stringBuffer.append(string5 + XmlHandler.element((String)"mix:sourceYDimensionValue", (String)Double.toString(d)) + EOL);
                }
                if (n != -1) {
                    stringBuffer.append(string5 + XmlHandler.element((String)"mix:sourceYDimensionUnit", (String)Integer.toString(n)) + EOL);
                }
                stringBuffer.append(string4 + XmlHandler.elementEnd((String)"mix:SourceYDimension") + EOL);
            }
            stringBuffer.append(string3 + XmlHandler.elementEnd((String)"mix:SourceSize") + EOL);
            bl = true;
        }
        StringBuffer stringBuffer2 = new StringBuffer(string3 + XmlHandler.elementStart((String)"mix:GeneralCaptureInformation") + EOL);
        boolean bl2 = false;
        string8 = nisoImageMetadata.getDateTimeCreated();
        if (string8 != null) {
            stringBuffer2.append(string3 + XmlHandler.element((String)"mix:dateTimeCreated", (String)string8) + EOL);
            bl2 = true;
        }
        if ((string8 = nisoImageMetadata.getImageProducer()) != null) {
            stringBuffer2.append(string3 + XmlHandler.element((String)"mix:imageProducer", (String)string8) + EOL);
            bl2 = true;
        }
        if ((string8 = nisoImageMetadata.getDeviceSource()) != null) {
            stringBuffer2.append(string3 + XmlHandler.element((String)"mix:captureDevice", (String)string8) + EOL);
        }
        stringBuffer2.append(string3 + XmlHandler.elementEnd((String)"mix:GeneralCaptureInformation") + EOL);
        if (bl2) {
            stringBuffer.append(stringBuffer2);
            bl = true;
        }
        StringBuffer stringBuffer3 = new StringBuffer(string3 + XmlHandler.elementStart((String)"mix:ScannerCapture") + EOL);
        boolean bl3 = false;
        String string9 = nisoImageMetadata.getScannerManufacturer();
        if (string9 != null) {
            stringBuffer3.append(string4 + XmlHandler.element((String)"mix:scannerManufacturer", (String)string9) + EOL);
            bl3 = true;
        }
        String string10 = nisoImageMetadata.getScannerModelName();
        String string11 = nisoImageMetadata.getScannerModelNumber();
        String string12 = nisoImageMetadata.getScannerModelSerialNo();
        if (string10 != null || string11 != null || string12 != null) {
            bl3 = true;
            stringBuffer3.append(string4 + XmlHandler.elementStart((String)"mix:ScannerModel") + EOL);
            if (string10 != null) {
                stringBuffer3.append(string5 + XmlHandler.element((String)"mix:scannerModelName", (String)string10) + EOL);
            }
            if (string11 != null) {
                stringBuffer3.append(string5 + XmlHandler.element((String)"mix:scannerModelNumber", (String)string11) + EOL);
            }
            if (string12 != null) {
                stringBuffer3.append(string5 + XmlHandler.element((String)"mix:scannerModelSerialNo", (String)string12) + EOL);
            }
            stringBuffer3.append(string4 + XmlHandler.elementEnd((String)"mix:ScannerModel") + EOL);
        }
        double d2 = nisoImageMetadata.getXPhysScanResolution();
        double d3 = nisoImageMetadata.getYPhysScanResolution();
        if (d2 != -1.0 && d3 != -1.0) {
            double d4 = d2 > d3 ? d2 : d3;
            stringBuffer3.append(string4 + XmlHandler.element((String)"mix:maximumOpticalResolution", (String)Double.toString(d4)) + EOL);
        }
        if ((string8 = nisoImageMetadata.getScanningSoftware()) != null) {
            bl3 = true;
            stringBuffer3.append(string4 + XmlHandler.elementStart((String)"mix:ScanningSystemSoftware") + EOL);
            stringBuffer3.append(string5 + XmlHandler.element((String)"mix:scanningSoftwareName", (String)string8) + EOL);
            string8 = nisoImageMetadata.getScanningSoftwareVersionNo();
            if (string8 != null) {
                stringBuffer3.append(string5 + XmlHandler.element((String)"mix:scanningSoftwareVersionNo", (String)string8) + EOL);
            }
            stringBuffer3.append(string4 + XmlHandler.elementEnd((String)"mix:ScanningSystemSoftware") + EOL);
        }
        stringBuffer3.append(string3 + XmlHandler.elementEnd((String)"mix:ScannerCapture") + EOL);
        if (bl3) {
            stringBuffer.append(stringBuffer3);
            bl = true;
        }
        StringBuffer stringBuffer4 = new StringBuffer(string3 + XmlHandler.elementStart((String)"mix:DigitalCameraCapture") + EOL);
        boolean bl4 = false;
        string8 = nisoImageMetadata.getDigitalCameraManufacturer();
        if (string8 != null) {
            stringBuffer4.append(string4 + XmlHandler.element((String)"mix:digitalCameraManufacturer") + EOL);
            bl4 = true;
        }
        if ((string8 = nisoImageMetadata.getDigitalCameraModel()) != null) {
            stringBuffer4.append(string4 + XmlHandler.elementStart((String)"mix:DigitalCameraModel") + EOL);
            stringBuffer4.append(string5 + XmlHandler.element((String)"mix:digitalCameraModelName") + string8 + EOL);
            stringBuffer4.append(string4 + XmlHandler.elementEnd((String)"mix:DigitalCameraModel") + EOL);
            bl4 = true;
        }
        StringBuffer stringBuffer5 = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:CameraCaptureSettings") + EOL);
        boolean bl5 = false;
        stringBuffer5.append(string5 + XmlHandler.elementStart((String)"mix:ImageData") + EOL);
        d = nisoImageMetadata.getFNumber();
        if (d != -1.0) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:fNumber", (String)Double.toString(d)) + EOL);
            bl5 = true;
        }
        if ((d = nisoImageMetadata.getExposureTime()) != -1.0) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:exposureTime", (String)Double.toString(d)) + EOL);
            bl5 = true;
        }
        if ((d = nisoImageMetadata.getBrightness()) != -1.0) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:brightnessValue", (String)Double.toString(d)) + EOL);
            bl5 = true;
        }
        if ((d = nisoImageMetadata.getExposureBias()) != -1.0) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:exposureBiasValue", (String)Double.toString(d)) + EOL);
            bl5 = true;
        }
        if ((dArray = nisoImageMetadata.getSubjectDistance()) != null) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:subjectDistance", (String)Double.toString(dArray[0])) + EOL);
            bl5 = true;
        }
        if ((n = nisoImageMetadata.getMeteringMode()) != -1) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:meteringMode", (String)Integer.toString(n)) + EOL);
            bl5 = true;
        }
        if ((n = nisoImageMetadata.getFlash()) != -1) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:flash", (String)Integer.toString(n)) + EOL);
            bl5 = true;
        }
        if ((d = nisoImageMetadata.getFocalLength()) != -1.0) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:focalLength", (String)Double.toString(d)) + EOL);
            bl5 = true;
        }
        if ((d = nisoImageMetadata.getFlashEnergy()) != -1.0) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:flashEnergy", (String)Double.toString(d)) + EOL);
            bl5 = true;
        }
        if ((n = nisoImageMetadata.getBackLight()) != -1) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:backLight", (String)Integer.toString(n)) + EOL);
            bl5 = true;
        }
        if ((d = nisoImageMetadata.getExposureIndex()) != -1.0) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:exposureIndex", (String)Double.toString(d)) + EOL);
            bl5 = true;
        }
        if ((n = nisoImageMetadata.getAutoFocus()) != -1) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:autoFocus", (String)Integer.toString(n)) + EOL);
            bl5 = true;
        }
        d = nisoImageMetadata.getXPrintAspectRatio();
        double d5 = nisoImageMetadata.getYPrintAspectRatio();
        if (d != -1.0 || d5 != -1.0) {
            stringBuffer5.append(string6 + XmlHandler.elementStart((String)"mix:PrintAspectRatio") + EOL);
            if (d != -1.0) {
                stringBuffer5.append(string7 + XmlHandler.element((String)"mix:xPrintAspectRatio", (String)Double.toString(d)) + EOL);
            }
            if (d5 != -1.0) {
                stringBuffer5.append(string7 + XmlHandler.element((String)"mix:yPrintAspectRatio", (String)Double.toString(d)) + EOL);
            }
            stringBuffer5.append(string6 + XmlHandler.elementEnd((String)"mix:PrintAspectRatio") + EOL);
        }
        stringBuffer5.append(string5 + XmlHandler.elementEnd((String)"mix:ImageData") + EOL);
        stringBuffer5.append(string4 + XmlHandler.elementEnd((String)"mix:CameraCaptureSettings") + EOL);
        if (bl5) {
            stringBuffer4.append(stringBuffer5);
            bl4 = true;
        }
        stringBuffer4.append(string3 + XmlHandler.elementEnd((String)"mix:DigitalCameraCapture") + EOL);
        if (bl4) {
            stringBuffer.append(stringBuffer4);
            bl = true;
        }
        if ((n = nisoImageMetadata.getOrientation()) != -1) {
            stringBuffer.append(string3 + XmlHandler.element((String)"mix:orientation", (String)Integer.toString(n)) + EOL);
            bl = true;
        }
        if ((string8 = nisoImageMetadata.getMethodology()) != null) {
            stringBuffer.append(string3 + XmlHandler.element((String)"mix:methodology", (String)string8) + EOL);
        }
        if (bl) {
            this._writer.println(string2 + XmlHandler.elementStart((String)"mix:ImageCaptureMetadata"));
            this._writer.print(stringBuffer.toString());
            this._writer.println(string2 + XmlHandler.elementEnd((String)"mix:ImageCaptureMetadata"));
        }
    }

    protected void showNisoImageAssessmentMetadata10(NisoImageMetadata nisoImageMetadata, String string) {
        String string2;
        Rational rational;
        String string3 = string + " ";
        String string4 = string3 + " ";
        String string5 = string4 + " ";
        String string6 = string5 + " ";
        String string7 = string6 + " ";
        this._writer.println(string3 + XmlHandler.elementStart((String)"mix:ImageAssessmentMetadata"));
        StringBuffer stringBuffer = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:SpatialMetrics") + EOL);
        boolean bl = false;
        int n = nisoImageMetadata.getSamplingFrequencyPlane();
        if (n != -1) {
            stringBuffer.append(string5 + XmlHandler.element((String)"mix:samplingFrequencyPlane", (String)Integer.toString(n)) + EOL);
            bl = true;
        }
        if ((n = nisoImageMetadata.getSamplingFrequencyUnit()) != -1) {
            stringBuffer.append(string5 + XmlHandler.element((String)"mix:samplingFrequencyUnit", (String)Integer.toString(n)) + EOL);
            bl = true;
        }
        if ((rational = nisoImageMetadata.getXSamplingFrequency()) != null) {
            this.rationalToString(stringBuffer, "mix:xSamplingFrequency", string5, rational);
        }
        if ((rational = nisoImageMetadata.getYSamplingFrequency()) != null) {
            this.rationalToString(stringBuffer, "mix:ySamplingFrequency", string5, rational);
        }
        stringBuffer.append(string4 + XmlHandler.elementEnd((String)"mix:SpatialMetrics"));
        if (bl) {
            this._writer.println(stringBuffer);
        }
        StringBuffer stringBuffer2 = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:ImageColorEncoding") + EOL);
        boolean bl2 = false;
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (nArray != null) {
            stringBuffer2.append(string5 + XmlHandler.elementStart((String)"mix:bitsPerSample") + EOL);
            stringBuffer2.append(string6 + XmlHandler.element((String)"mix:bitsPerSampleValue", (String)XmlHandler.integerArray((int[])nArray, (char)',')) + EOL);
            stringBuffer2.append(string6 + XmlHandler.element((String)"mix:bitsPerSampleUnit", (String)"integer") + EOL);
            stringBuffer2.append(string5 + XmlHandler.elementEnd((String)"mix:bitsPerSample") + EOL);
            bl2 = true;
        }
        if ((n = nisoImageMetadata.getSamplesPerPixel()) != -1) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:samplesPerPixel", (String)Integer.toString(n)) + EOL);
            bl2 = true;
        }
        if ((nArray = nisoImageMetadata.getExtraSamples()) != null && (n = nArray[0]) >= 0 && n <= 3) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:extraSamples", (String)Integer.toString(n)) + EOL);
            bl2 = true;
        }
        if ((string2 = nisoImageMetadata.getColormapReference()) != null) {
            stringBuffer2.append(string5 + XmlHandler.elementStart((String)"mix:Colormap") + EOL);
            stringBuffer2.append(string6 + XmlHandler.element((String)"mix:colormapReference", (String)string2) + EOL);
            stringBuffer2.append(string5 + XmlHandler.elementEnd((String)"mix:Colormap") + EOL);
            bl2 = true;
        }
        if ((nArray = nisoImageMetadata.getGrayResponseCurve()) != null) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:grayResponseCurve", (String)"N") + EOL);
            bl2 = true;
        }
        if ((n = nisoImageMetadata.getGrayResponseUnit()) != -1) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:grayResponseUnit", (String)Integer.toString(n)) + EOL);
            bl2 = true;
        }
        rational = nisoImageMetadata.getWhitePointXValue();
        Rational rational2 = nisoImageMetadata.getWhitePointYValue();
        if (rational != null || rational2 != null) {
            stringBuffer2.append(string5 + XmlHandler.elementStart((String)"mix:WhitePoint") + EOL);
            if (rational != null) {
                this.rationalToString(stringBuffer2, "mix:whitePointXValue", string6, rational);
            }
            if (rational2 != null) {
                this.rationalToString(stringBuffer2, "mix:whitePointYValue", string6, rational2);
            }
            stringBuffer2.append(string5 + XmlHandler.elementEnd((String)"mix:WhitePoint") + EOL);
            bl2 = true;
        }
        StringBuffer stringBuffer3 = new StringBuffer(string5 + XmlHandler.elementStart((String)"mix:PrimaryChromaticities") + EOL);
        boolean bl3 = false;
        rational = nisoImageMetadata.getPrimaryChromaticitiesRedX();
        if (rational != null) {
            this.rationalToString(stringBuffer3, "mix:primaryChromaticitiesRedX", string6, rational);
            bl3 = true;
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesRedY()) != null) {
            this.rationalToString(stringBuffer3, "mix:primaryChromaticitiesRedY", string6, rational);
            bl3 = true;
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesGreenX()) != null) {
            this.rationalToString(stringBuffer3, "mix:primaryChromaticitiesGreenX", string6, rational);
            bl3 = true;
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesGreenY()) != null) {
            this.rationalToString(stringBuffer3, "mix:primaryChromaticitiesGreenY", string6, rational);
            bl3 = true;
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesBlueX()) != null) {
            this.rationalToString(stringBuffer3, "mix:primaryChromaticitiesBlueX", string6, rational);
            bl3 = true;
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesBlueY()) != null) {
            this.rationalToString(stringBuffer3, "mix:primaryChromaticitiesBlueY", string6, rational);
            bl3 = true;
        }
        stringBuffer3.append(string5 + XmlHandler.elementEnd((String)"mix:PrimaryChromaticities") + EOL);
        if (bl3) {
            stringBuffer2.append(stringBuffer3);
            bl2 = true;
        }
        stringBuffer2.append(string4 + XmlHandler.elementEnd((String)"mix:ImageColorEncoding") + EOL);
        if (bl2) {
            this._writer.print(stringBuffer2);
        }
        StringBuffer stringBuffer4 = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:TargetData") + EOL);
        boolean bl4 = false;
        n = nisoImageMetadata.getTargetType();
        if (n != -1) {
            stringBuffer4.append(string5 + XmlHandler.element((String)"mix:targetType", (String)Integer.toString(n)) + EOL);
            bl4 = true;
        }
        StringBuffer stringBuffer5 = new StringBuffer(string5 + XmlHandler.elementStart((String)"mix:TargetID") + EOL);
        boolean bl5 = false;
        string2 = nisoImageMetadata.getTargetIDManufacturer();
        if (string2 != null) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:targetManufacturer", (String)string2) + EOL);
            bl5 = true;
        }
        if ((string2 = nisoImageMetadata.getTargetIDName()) != null) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:targetName", (String)string2) + EOL);
            bl5 = true;
        }
        if ((string2 = nisoImageMetadata.getTargetIDNo()) != null) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:targetNo", (String)string2) + EOL);
            bl5 = true;
        }
        if ((string2 = nisoImageMetadata.getTargetIDMedia()) != null) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:targetMedia", (String)string2) + EOL);
            bl5 = true;
        }
        stringBuffer5.append(string5 + XmlHandler.elementEnd((String)"mix:TargetID") + EOL);
        if (bl5) {
            stringBuffer4.append(stringBuffer5);
            bl4 = true;
        }
        if ((string2 = nisoImageMetadata.getImageData()) != null) {
            stringBuffer4.append(string5 + XmlHandler.element((String)"mix:externalTarget", (String)string2) + EOL);
            bl4 = true;
        }
        if ((string2 = nisoImageMetadata.getPerformanceData()) != null) {
            stringBuffer4.append(string5 + XmlHandler.element((String)"mix:performanceData", (String)string2) + EOL);
            bl4 = true;
        }
        stringBuffer4.append(string4 + XmlHandler.elementEnd((String)"mix:TargetData") + EOL);
        if (bl4) {
            this._writer.print(stringBuffer4);
        }
        this._writer.println(string3 + XmlHandler.elementEnd((String)"mix:ImageAssessmentMetadata"));
    }

    protected void showChangeHistory10(NisoImageMetadata nisoImageMetadata, String string) {
        String[] stringArray;
        String string2 = string + " ";
        String string3 = string2 + " ";
        String string4 = string3 + " ";
        String string5 = string4 + " ";
        String string6 = string5 + " ";
        StringBuffer stringBuffer = new StringBuffer(string2 + XmlHandler.elementStart((String)"mix:ChangeHistory") + EOL);
        boolean bl = false;
        stringBuffer.append(string3 + XmlHandler.elementStart((String)"mix:ImageProcessing") + EOL);
        String string7 = nisoImageMetadata.getSourceData();
        if (string7 != null) {
            stringBuffer.append(string4 + XmlHandler.element((String)"mix:sourceData") + EOL);
            bl = true;
        }
        if ((string7 = nisoImageMetadata.getProcessingAgency()) != null) {
            stringBuffer.append(string4 + XmlHandler.element((String)"mix:processingAgency") + EOL);
            bl = true;
        }
        StringBuffer stringBuffer2 = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:ProcessingSoftware") + EOL);
        boolean bl2 = false;
        string7 = nisoImageMetadata.getProcessingSoftwareName();
        if (string7 != null) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:processingSoftwareName", (String)string7) + EOL);
            bl2 = true;
        }
        if ((string7 = nisoImageMetadata.getProcessingSoftwareVersion()) != null) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:processingSoftwareVersion", (String)string7) + EOL);
            bl2 = true;
        }
        if ((string7 = nisoImageMetadata.getOS()) != null) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:processingOperatingSystemName", (String)string7) + EOL);
            bl2 = true;
        }
        if ((string7 = nisoImageMetadata.getOSVersion()) != null) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:processingOperatingSystemVersion", (String)string7) + EOL);
            bl2 = true;
        }
        stringBuffer2.append(string4 + XmlHandler.elementEnd((String)"mix:ProcessingSoftware") + EOL);
        if (bl2) {
            stringBuffer.append(stringBuffer2);
            bl = true;
        }
        if ((stringArray = nisoImageMetadata.getProcessingActions()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(string4 + XmlHandler.element((String)"mix:processingActions", (String)stringArray[i]) + EOL);
            }
            bl = true;
        }
        stringBuffer.append(string3 + XmlHandler.elementEnd((String)"mix:ImageProcessing") + EOL);
        stringBuffer.append(string2 + XmlHandler.elementEnd((String)"mix:ChangeHistory") + EOL);
        if (bl) {
            this._writer.println(stringBuffer);
        }
    }

    protected void showNisoImageMetadata20(NisoImageMetadata nisoImageMetadata) {
        String string = XmlHandler.getIndent((int)(++this._level));
        String[][] stringArray = new String[][]{{"xmlns:mix", "http://www.loc.gov/mix/v20"}, {"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"}, {"xsi:schemaLocation", "http://www.loc.gov/mix/v20 http://www.loc.gov/standards/mix/mix20/mix20.xsd"}};
        this._writer.println(string + XmlHandler.elementStart((String)"mix:mix", (String[][])stringArray));
        this.showNisoBasicDigitalObjectInformation20(nisoImageMetadata, string);
        this.showNisoBasicImageInformation20(nisoImageMetadata, string);
        this.showNisoImageCaptureMetadata20(nisoImageMetadata, string);
        this.showNisoImageAssessmentMetadata20(nisoImageMetadata, string);
        this.showChangeHistory20(nisoImageMetadata, string);
        this._writer.println(string + XmlHandler.elementEnd((String)"mix:mix"));
        --this._level;
    }

    protected void showNisoBasicDigitalObjectInformation20(NisoImageMetadata nisoImageMetadata, String string) {
        String string2;
        String string3 = string + " ";
        String string4 = string3 + " ";
        String string5 = string4 + " ";
        String string6 = string5 + " ";
        this._writer.println(string3 + XmlHandler.elementStart((String)"mix:BasicDigitalObjectInformation"));
        StringBuffer stringBuffer = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:ObjectIdentifier") + EOL);
        stringBuffer.append(string5 + XmlHandler.element((String)"mix:objectIdentifierType", (String)"JHOVE") + EOL);
        String string7 = nisoImageMetadata.getImageIdentifier();
        if (string7 != null) {
            stringBuffer.append(string5 + XmlHandler.element((String)"mix:objectIdentifierValue", (String)string7) + EOL);
        }
        stringBuffer.append(string4 + XmlHandler.elementEnd((String)"mix:ObjectIdentifier") + EOL);
        this._writer.print(stringBuffer.toString());
        long l = nisoImageMetadata.getFileSize();
        if (l != -1L) {
            this._writer.print(string4 + XmlHandler.element((String)"mix:fileSize", (String)Long.toString(l)) + EOL);
        }
        if ((string7 = nisoImageMetadata.getByteOrder()) != null) {
            if (string7.startsWith("big")) {
                string7 = "big endian";
            } else if (string7.startsWith("little")) {
                string7 = "little endian";
            }
            this._writer.print(string4 + XmlHandler.element((String)"mix:byteOrder", (String)string7) + EOL);
        }
        int n = nisoImageMetadata.getCompressionScheme();
        int n2 = nisoImageMetadata.getCompressionLevel();
        switch (n) {
            case 1: {
                string2 = "Uncompressed";
                break;
            }
            case 2: {
                string2 = "CCITT 1D";
                break;
            }
            case 3: {
                string2 = "Group 3 Fax";
                break;
            }
            case 4: {
                string2 = "Group 4 Fax";
                break;
            }
            case 5: {
                string2 = "LZW";
                break;
            }
            case 6: {
                string2 = "JPEG";
                break;
            }
            case 32773: {
                string2 = "PackBits";
                break;
            }
            default: {
                string2 = "Unknown";
            }
        }
        if (n != -1 || n2 != -1) {
            this._writer.print(string4 + XmlHandler.elementStart((String)"mix:Compression") + EOL);
            if (n != -1) {
                this._writer.print(string5 + XmlHandler.element((String)"mix:compressionScheme", (String)string2) + EOL);
            }
            this._writer.print(string4 + XmlHandler.elementEnd((String)"mix:Compression") + EOL);
        }
        int n3 = nisoImageMetadata.getChecksumMethod();
        string7 = nisoImageMetadata.getChecksumValue();
        if (n3 != -1 || string7 != null) {
            this._writer.print(string5 + XmlHandler.elementStart((String)"mix:Fixity") + EOL);
            if (n3 != -1) {
                this._writer.print(string6 + XmlHandler.element((String)"mix:messageDigestAlgorithm", (String)Integer.toString(n3)) + EOL);
            }
            if (string7 != null) {
                this._writer.print(string6 + XmlHandler.element((String)"mix:messageDigest", (String)string7) + EOL);
            }
            this._writer.println(string5 + XmlHandler.elementEnd((String)"mix:Fixity"));
        }
        this._writer.print(string3 + XmlHandler.elementEnd((String)"mix:BasicDigitalObjectInformation") + EOL);
    }

    protected void showNisoBasicImageInformation20(NisoImageMetadata nisoImageMetadata, String string) {
        String string2 = string + " ";
        String string3 = string2 + " ";
        String string4 = string3 + " ";
        String string5 = string4 + " ";
        String string6 = string5 + " ";
        String string7 = string6 + " ";
        this._writer.println(string2 + XmlHandler.elementStart((String)"mix:BasicImageInformation"));
        StringBuffer stringBuffer = new StringBuffer(string3 + XmlHandler.elementStart((String)"mix:BasicImageCharacteristics") + EOL);
        boolean bl = false;
        long l = nisoImageMetadata.getImageWidth();
        if (l != -1L) {
            stringBuffer.append(string4 + XmlHandler.element((String)"mix:imageWidth", (String)Long.toString(l)) + EOL);
            bl = true;
        }
        if ((l = nisoImageMetadata.getImageLength()) != -1L) {
            stringBuffer.append(string4 + XmlHandler.element((String)"mix:imageHeight", (String)Long.toString(l)) + EOL);
            bl = true;
        }
        StringBuffer stringBuffer2 = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:PhotometricInterpretation") + EOL);
        boolean bl2 = false;
        int n = nisoImageMetadata.getColorSpace();
        if (n != -1) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:colorSpace", (String)this.photometricInterpretationToString(n)) + EOL);
            bl2 = true;
        }
        String string8 = nisoImageMetadata.getProfileName();
        String string9 = nisoImageMetadata.getProfileURL();
        if (string8 != null || string9 != null) {
            stringBuffer2.append(string5 + XmlHandler.elementStart((String)"mix:ColorProfile") + EOL);
            stringBuffer2.append(string6 + XmlHandler.elementStart((String)"mix:IccProfile") + EOL);
            if (string8 != null) {
                stringBuffer2.append(string7 + XmlHandler.element((String)"mix:iccProfileName", (String)string8) + EOL);
            }
            if (string9 != null) {
                stringBuffer2.append(string7 + XmlHandler.element((String)"mix:iccProfileURI", (String)string9) + EOL);
            }
            stringBuffer2.append(string6 + XmlHandler.elementEnd((String)"mix:IccProfile") + EOL);
            stringBuffer2.append(string5 + XmlHandler.elementEnd((String)"mix:ColorProfile") + EOL);
            bl2 = true;
        }
        int[] nArray = nisoImageMetadata.getYCbCrSubSampling();
        n = nisoImageMetadata.getYCbCrPositioning();
        Rational[] rationalArray = nisoImageMetadata.getYCbCrCoefficients();
        if (nArray != null || n != -1 || rationalArray != null) {
            stringBuffer2.append(string5 + XmlHandler.elementStart((String)"mix:YCbCr") + EOL);
            bl2 = true;
            if (nArray != null && nArray.length >= 2) {
                stringBuffer2.append(string6 + XmlHandler.elementStart((String)"mix:YCbCrSubSampling") + EOL);
                stringBuffer2.append(string7 + XmlHandler.element((String)"mix:yCbCrSubsampleHoriz", (String)Integer.toString(nArray[0])) + EOL);
                stringBuffer2.append(string7 + XmlHandler.element((String)"mix:yCbCrSubsampleVert", (String)Integer.toString(nArray[1])) + EOL);
                stringBuffer2.append(string6 + XmlHandler.elementEnd((String)"mix:YCbCrSubSampling") + EOL);
            }
            if (n != -1) {
                stringBuffer2.append(string6 + XmlHandler.element((String)"mix:yCbCrPositioning", (String)Integer.toString(n)) + EOL);
            }
            if (rationalArray != null && rationalArray.length >= 3) {
                stringBuffer2.append(string6 + XmlHandler.elementStart((String)"mix:YCbCrCoefficients") + EOL);
                this.rationalToString(stringBuffer2, "mix:lumaRed", string7, rationalArray[0]);
                this.rationalToString(stringBuffer2, "mix:lumaGreen", string7, rationalArray[1]);
                this.rationalToString(stringBuffer2, "mix:lumaBlue", string7, rationalArray[2]);
                stringBuffer2.append(string6 + XmlHandler.elementEnd((String)"mix:YCbCrCoefficients") + EOL);
            }
            stringBuffer2.append(string5 + XmlHandler.elementEnd((String)"mix:YCbCr") + EOL);
        }
        if ((rationalArray = nisoImageMetadata.getReferenceBlackWhite()) != null) {
            stringBuffer2.append(string5 + XmlHandler.elementStart((String)"mix:ReferenceBlackWhite") + EOL);
            for (int i = 0; i < rationalArray.length - 1; i += 2) {
                String string10;
                stringBuffer2.append(string6 + XmlHandler.elementStart((String)"mix:Component") + EOL);
                stringBuffer2.append(string7 + XmlHandler.elementStart((String)"mix:componentPhotometricInterpretation"));
                if (nisoImageMetadata.getColorSpace() == 6) {
                    switch (i) {
                        case 0: {
                            string10 = "Y";
                            break;
                        }
                        case 2: {
                            string10 = "Cb";
                            break;
                        }
                        default: {
                            string10 = "Cr";
                            break;
                        }
                    }
                } else {
                    switch (i) {
                        case 0: {
                            string10 = "R";
                            break;
                        }
                        case 2: {
                            string10 = "G";
                            break;
                        }
                        default: {
                            string10 = "B";
                        }
                    }
                }
                stringBuffer2.append(string10 + XmlHandler.elementEnd((String)"mix:componentPhotometricInterpretation") + EOL);
                this.rationalToString(stringBuffer2, "mix:footroom", string7, rationalArray[i]);
                this.rationalToString(stringBuffer2, "mix:headroom", string7, rationalArray[i + 1]);
                stringBuffer2.append(string7 + XmlHandler.elementEnd((String)"mix:Component") + EOL);
            }
            stringBuffer2.append(string6 + XmlHandler.elementEnd((String)"mix:ReferenceBlackWhite") + EOL);
            bl2 = true;
        }
        stringBuffer2.append(string4 + XmlHandler.elementEnd((String)"mix:PhotometricInterpretation") + EOL);
        if (bl2) {
            stringBuffer.append(stringBuffer2);
            bl = true;
        }
        stringBuffer.append(string3 + XmlHandler.elementEnd((String)"mix:BasicImageCharacteristics"));
        if (bl) {
            this._writer.println(stringBuffer);
        }
        this._writer.println(string2 + XmlHandler.elementEnd((String)"mix:BasicImageInformation"));
    }

    protected void showNisoImageCaptureMetadata20(NisoImageMetadata nisoImageMetadata, String string) {
        double[] dArray;
        int n;
        String string2 = string + " ";
        String string3 = string2 + " ";
        String string4 = string3 + " ";
        String string5 = string4 + " ";
        String string6 = string5 + " ";
        String string7 = string6 + " ";
        String string8 = string7 + " ";
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        String string9 = nisoImageMetadata.getSourceType();
        String string10 = nisoImageMetadata.getSourceID();
        double d = nisoImageMetadata.getSourceXDimension();
        if (string9 != null || string10 != null || d != -1.0) {
            stringBuffer.append(string3 + XmlHandler.element((String)"mix:SourceInformation", (String)string9));
            bl = true;
            if (string9 != null) {
                stringBuffer.append(string4 + XmlHandler.element((String)"mix:sourceType", (String)string9));
            }
            if (string10 != null) {
                stringBuffer.append(string4 + XmlHandler.elementStart((String)"mix:SourceID"));
                stringBuffer.append(string4 + XmlHandler.element((String)"mix:sourceIDValue", (String)string10));
                stringBuffer.append(string4 + XmlHandler.elementEnd((String)"mix:sourceID"));
            }
            n = nisoImageMetadata.getSourceXDimensionUnit();
            if (d != -1.0 || n != -1) {
                stringBuffer.append(string4 + XmlHandler.elementStart((String)"mix:SourceSize"));
                stringBuffer.append(string5 + XmlHandler.elementStart((String)"mix:SourceXDimension") + EOL);
                if (d != -1.0) {
                    stringBuffer.append(string6 + XmlHandler.element((String)"mix:sourceXDimensionValue", (String)Double.toString(d)) + EOL);
                }
                if (n != -1) {
                    stringBuffer.append(string6 + XmlHandler.element((String)"mix:sourceXDimensionUnit", (String)Integer.toString(n)) + EOL);
                }
                stringBuffer.append(string5 + XmlHandler.elementEnd((String)"mix:SourceXDimension") + EOL);
                d = nisoImageMetadata.getSourceYDimension();
                n = nisoImageMetadata.getSourceYDimensionUnit();
                if (d != -1.0 || n != -1) {
                    stringBuffer.append(string5 + XmlHandler.elementStart((String)"mix:SourceYDimension") + EOL);
                    if (d != -1.0) {
                        stringBuffer.append(string6 + XmlHandler.element((String)"mix:sourceYDimensionValue", (String)Double.toString(d)) + EOL);
                    }
                    if (n != -1) {
                        stringBuffer.append(string6 + XmlHandler.element((String)"mix:sourceYDimensionUnit", (String)Integer.toString(n)) + EOL);
                    }
                    stringBuffer.append(string5 + XmlHandler.elementEnd((String)"mix:SourceYDimension") + EOL);
                }
                stringBuffer.append(string4 + XmlHandler.elementEnd((String)"mix:SourceSize") + EOL);
            }
            stringBuffer.append(string3 + XmlHandler.elementEnd((String)"mix:SourceInformation") + EOL);
        }
        StringBuffer stringBuffer2 = new StringBuffer(string3 + XmlHandler.elementStart((String)"mix:GeneralCaptureInformation") + EOL);
        boolean bl2 = false;
        string9 = nisoImageMetadata.getDateTimeCreated();
        if (string9 != null) {
            stringBuffer2.append(string3 + XmlHandler.element((String)"mix:dateTimeCreated", (String)string9) + EOL);
            bl2 = true;
        }
        if ((string9 = nisoImageMetadata.getImageProducer()) != null) {
            stringBuffer2.append(string3 + XmlHandler.element((String)"mix:imageProducer", (String)string9) + EOL);
            bl2 = true;
        }
        if ((string9 = nisoImageMetadata.getDeviceSource()) != null) {
            stringBuffer2.append(string3 + XmlHandler.element((String)"mix:captureDevice", (String)string9) + EOL);
        }
        stringBuffer2.append(string3 + XmlHandler.elementEnd((String)"mix:GeneralCaptureInformation") + EOL);
        if (bl2) {
            stringBuffer.append(stringBuffer2);
            bl = true;
        }
        StringBuffer stringBuffer3 = new StringBuffer(string3 + XmlHandler.elementStart((String)"mix:ScannerCapture") + EOL);
        boolean bl3 = false;
        String string11 = nisoImageMetadata.getScannerManufacturer();
        if (string11 != null) {
            stringBuffer3.append(string4 + XmlHandler.element((String)"mix:scannerManufacturer", (String)string11) + EOL);
            bl3 = true;
        }
        String string12 = nisoImageMetadata.getScannerModelName();
        String string13 = nisoImageMetadata.getScannerModelNumber();
        String string14 = nisoImageMetadata.getScannerModelSerialNo();
        if (string12 != null || string13 != null || string14 != null) {
            bl3 = true;
            stringBuffer3.append(string4 + XmlHandler.elementStart((String)"mix:ScannerModel") + EOL);
            if (string12 != null) {
                stringBuffer3.append(string5 + XmlHandler.element((String)"mix:scannerModelName", (String)string12) + EOL);
            }
            if (string13 != null) {
                stringBuffer3.append(string5 + XmlHandler.element((String)"mix:scannerModelNumber", (String)string13) + EOL);
            }
            if (string14 != null) {
                stringBuffer3.append(string5 + XmlHandler.element((String)"mix:scannerModelSerialNo", (String)string14) + EOL);
            }
            stringBuffer3.append(string4 + XmlHandler.elementEnd((String)"mix:ScannerModel") + EOL);
        }
        double d2 = nisoImageMetadata.getXPhysScanResolution();
        double d3 = nisoImageMetadata.getYPhysScanResolution();
        if (d2 != -1.0 && d3 != -1.0) {
            stringBuffer3.append(string4 + XmlHandler.elementStart((String)"mix:MaximumOpticalResolution") + EOL);
            stringBuffer3.append(string5 + XmlHandler.element((String)"mix:xOpticalResolution", (String)Double.toString(d2)) + EOL);
            stringBuffer3.append(string5 + XmlHandler.element((String)"mix:yOpticalResolution", (String)Double.toString(d3)) + EOL);
            stringBuffer3.append(string5 + XmlHandler.element((String)"mix:resolutionUnit", (String)"in.") + EOL);
            stringBuffer3.append(string4 + XmlHandler.elementEnd((String)"mix:MaximumOpticalResolution"));
        }
        if ((string9 = nisoImageMetadata.getScanningSoftware()) != null) {
            bl3 = true;
            stringBuffer3.append(string4 + XmlHandler.elementStart((String)"mix:ScanningSystemSoftware") + EOL);
            stringBuffer3.append(string5 + XmlHandler.element((String)"mix:scanningSoftwareName", (String)string9) + EOL);
            string9 = nisoImageMetadata.getScanningSoftwareVersionNo();
            if (string9 != null) {
                stringBuffer3.append(string5 + XmlHandler.element((String)"mix:scanningSoftwareVersionNo", (String)string9) + EOL);
            }
            stringBuffer3.append(string4 + XmlHandler.elementEnd((String)"mix:ScanningSystemSoftware") + EOL);
        }
        stringBuffer3.append(string3 + XmlHandler.elementEnd((String)"mix:ScannerCapture") + EOL);
        if (bl3) {
            stringBuffer.append(stringBuffer3);
            bl = true;
        }
        StringBuffer stringBuffer4 = new StringBuffer(string3 + XmlHandler.elementStart((String)"mix:DigitalCameraCapture") + EOL);
        boolean bl4 = false;
        string9 = nisoImageMetadata.getDigitalCameraManufacturer();
        if (string9 != null) {
            stringBuffer4.append(string4 + XmlHandler.element((String)"mix:digitalCameraManufacturer") + EOL);
            bl4 = true;
        }
        if ((string9 = nisoImageMetadata.getDigitalCameraModel()) != null) {
            stringBuffer4.append(string4 + XmlHandler.elementStart((String)"mix:DigitalCameraModel") + EOL);
            stringBuffer4.append(string5 + XmlHandler.element((String)"mix:digitalCameraModelName") + string9 + EOL);
            stringBuffer4.append(string4 + XmlHandler.elementEnd((String)"mix:DigitalCameraModel") + EOL);
            bl4 = true;
        }
        StringBuffer stringBuffer5 = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:CameraCaptureSettings") + EOL);
        boolean bl5 = false;
        stringBuffer5.append(string5 + XmlHandler.elementStart((String)"mix:ImageData") + EOL);
        d = nisoImageMetadata.getFNumber();
        if (d != -1.0) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:fNumber", (String)Double.toString(d)) + EOL);
            bl5 = true;
        }
        if ((d = nisoImageMetadata.getExposureTime()) != -1.0) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:exposureTime", (String)Double.toString(d)) + EOL);
            bl5 = true;
        }
        if ((d = nisoImageMetadata.getBrightness()) != -1.0) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:brightnessValue", (String)Double.toString(d)) + EOL);
            bl5 = true;
        }
        if ((d = nisoImageMetadata.getExposureBias()) != -1.0) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:exposureBiasValue", (String)Double.toString(d)) + EOL);
            bl5 = true;
        }
        if ((dArray = nisoImageMetadata.getSubjectDistance()) != null) {
            stringBuffer5.append(string6 + XmlHandler.elementStart((String)"mix:SubjectDistance") + EOL);
            bl5 = true;
            if (dArray[0] == dArray[1]) {
                stringBuffer5.append(string7 + XmlHandler.element((String)"mix:distance", (String)Double.toString(dArray[0])) + EOL);
            } else {
                stringBuffer5.append(string7 + XmlHandler.elementStart((String)"mix:MinMaxDistance") + EOL);
                stringBuffer5.append(string8 + XmlHandler.element((String)"mix:minDistance", (String)Double.toString(dArray[0])) + EOL);
                stringBuffer5.append(string8 + XmlHandler.element((String)"mix:maxDistance", (String)Double.toString(dArray[1])) + EOL);
                stringBuffer5.append(string7 + XmlHandler.elementEnd((String)"mix:MinMaxDistance") + EOL);
            }
            stringBuffer5.append(string6 + XmlHandler.elementEnd((String)"mix:SubjectDistance") + EOL);
        }
        if ((n = nisoImageMetadata.getMeteringMode()) != -1) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:meteringMode", (String)Integer.toString(n)) + EOL);
            bl5 = true;
        }
        if ((n = nisoImageMetadata.getFlash()) != -1) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:flash", (String)Integer.toString(n)) + EOL);
            bl5 = true;
        }
        if ((d = nisoImageMetadata.getFocalLength()) != -1.0) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:focalLength", (String)Double.toString(d)) + EOL);
            bl5 = true;
        }
        if ((d = nisoImageMetadata.getFlashEnergy()) != -1.0) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:flashEnergy", (String)Double.toString(d)) + EOL);
            bl5 = true;
        }
        if ((n = nisoImageMetadata.getBackLight()) != -1) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:backLight", (String)Integer.toString(n)) + EOL);
            bl5 = true;
        }
        if ((d = nisoImageMetadata.getExposureIndex()) != -1.0) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:exposureIndex", (String)Double.toString(d)) + EOL);
            bl5 = true;
        }
        if ((n = nisoImageMetadata.getAutoFocus()) != -1) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:autoFocus", (String)Integer.toString(n)) + EOL);
            bl5 = true;
        }
        d = nisoImageMetadata.getXPrintAspectRatio();
        double d4 = nisoImageMetadata.getYPrintAspectRatio();
        if (d != -1.0 || d4 != -1.0) {
            stringBuffer5.append(string6 + XmlHandler.elementStart((String)"mix:PrintAspectRatio") + EOL);
            if (d != -1.0) {
                stringBuffer5.append(string7 + XmlHandler.element((String)"mix:xPrintAspectRatio", (String)Double.toString(d)) + EOL);
            }
            if (d4 != -1.0) {
                stringBuffer5.append(string7 + XmlHandler.element((String)"mix:yPrintAspectRatio", (String)Double.toString(d)) + EOL);
            }
            stringBuffer5.append(string6 + XmlHandler.elementEnd((String)"mix:PrintAspectRatio") + EOL);
        }
        stringBuffer5.append(string5 + XmlHandler.elementEnd((String)"mix:ImageData") + EOL);
        stringBuffer5.append(string4 + XmlHandler.elementEnd((String)"mix:CameraCaptureSettings") + EOL);
        if (bl5) {
            stringBuffer4.append(stringBuffer5);
            bl4 = true;
        }
        stringBuffer4.append(string3 + XmlHandler.elementEnd((String)"mix:DigitalCameraCapture") + EOL);
        if (bl4) {
            stringBuffer.append(stringBuffer4);
            bl = true;
        }
        if ((n = nisoImageMetadata.getOrientation()) != -1) {
            String[] stringArray = new String[]{"unknown", "normal*", "normal, image flipped", "normal, rotated 180\ufffd", "normal, image flipped, rotated 180\ufffd", "normal, image flipped, rotated cw 90\ufffd", "normal, rotated ccw 90\ufffd", "normal, image flipped, rotated ccw 90\ufffd", "normal, rotated cw 90\ufffd"};
            if (n > 8 || n < 0) {
                n = 0;
            }
            stringBuffer.append(string3 + XmlHandler.element((String)"mix:orientation", (String)stringArray[n]) + EOL);
            bl = true;
        }
        if ((string9 = nisoImageMetadata.getMethodology()) != null) {
            stringBuffer.append(string3 + XmlHandler.element((String)"mix:methodology", (String)string9) + EOL);
        }
        if (bl) {
            this._writer.println(string2 + XmlHandler.elementStart((String)"mix:ImageCaptureMetadata"));
            this._writer.print(stringBuffer.toString());
            this._writer.println(string2 + XmlHandler.elementEnd((String)"mix:ImageCaptureMetadata"));
        }
    }

    protected void showNisoImageAssessmentMetadata20(NisoImageMetadata nisoImageMetadata, String string) {
        String string2;
        int n;
        Rational rational;
        String string3 = string + " ";
        String string4 = string3 + " ";
        String string5 = string4 + " ";
        String string6 = string5 + " ";
        String string7 = string6 + " ";
        this._writer.println(string3 + XmlHandler.elementStart((String)"mix:ImageAssessmentMetadata"));
        StringBuffer stringBuffer = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:SpatialMetrics") + EOL);
        boolean bl = false;
        int n2 = nisoImageMetadata.getSamplingFrequencyPlane();
        if (n2 != -1) {
            stringBuffer.append(string5 + XmlHandler.element((String)"mix:samplingFrequencyPlane", (String)Integer.toString(n2)) + EOL);
            bl = true;
        }
        if ((n2 = nisoImageMetadata.getSamplingFrequencyUnit()) != -1) {
            rational = new Rational[]{null, "no absolute unit of measurement", "in.", "cm"};
            if (n2 < 1 || n2 > 3) {
                n2 = 1;
            }
            stringBuffer.append(string5 + XmlHandler.element((String)"mix:samplingFrequencyUnit", (String)rational[n2]) + EOL);
            bl = true;
        }
        if ((rational = nisoImageMetadata.getXSamplingFrequency()) != null) {
            this.rationalToString(stringBuffer, "mix:xSamplingFrequency", string5, rational);
        }
        if ((rational = nisoImageMetadata.getYSamplingFrequency()) != null) {
            this.rationalToString(stringBuffer, "mix:ySamplingFrequency", string5, rational);
        }
        stringBuffer.append(string4 + XmlHandler.elementEnd((String)"mix:SpatialMetrics"));
        if (bl) {
            this._writer.println(stringBuffer);
        }
        StringBuffer stringBuffer2 = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:ImageColorEncoding") + EOL);
        boolean bl2 = false;
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (nArray != null) {
            stringBuffer2.append(string5 + XmlHandler.elementStart((String)"mix:BitsPerSample") + EOL);
            for (n = 1; n < nArray.length; ++n) {
                stringBuffer2.append(string6 + XmlHandler.element((String)"mix:bitsPerSampleValue", (String)Integer.toString(nArray[n])) + EOL);
            }
            stringBuffer2.append(string6 + XmlHandler.element((String)"mix:bitsPerSampleUnit", (String)"integer") + EOL);
            stringBuffer2.append(string5 + XmlHandler.elementEnd((String)"mix:BitsPerSample") + EOL);
            bl2 = true;
        }
        if ((n2 = nisoImageMetadata.getSamplesPerPixel()) != -1) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:samplesPerPixel", (String)Integer.toString(n2)) + EOL);
            bl2 = true;
        }
        if ((nArray = nisoImageMetadata.getExtraSamples()) != null) {
            for (n = 0; n < nArray.length; ++n) {
                n2 = nArray[n];
                if (n2 < 0 || n2 > 3) continue;
                stringBuffer2.append(string5 + XmlHandler.element((String)"mix:extraSamples", (String)Integer.toString(n2)) + EOL);
                bl2 = true;
            }
        }
        if ((string2 = nisoImageMetadata.getColormapReference()) != null) {
            stringBuffer2.append(string5 + XmlHandler.elementStart((String)"mix:Colormap") + EOL);
            stringBuffer2.append(string6 + XmlHandler.element((String)"mix:colormapReference", (String)string2) + EOL);
            stringBuffer2.append(string5 + XmlHandler.elementEnd((String)"mix:Colormap") + EOL);
            bl2 = true;
        }
        if ((nArray = nisoImageMetadata.getGrayResponseCurve()) != null) {
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer2.append(string5 + XmlHandler.element((String)"mix:GrayResponseCurve", (String)Integer.toString(nArray[i])) + EOL);
            }
            bl2 = true;
        }
        if ((n2 = nisoImageMetadata.getGrayResponseUnit()) != -1) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:grayResponseUnit", (String)Integer.toString(n2)) + EOL);
            bl2 = true;
        }
        rational = nisoImageMetadata.getWhitePointXValue();
        Rational rational2 = nisoImageMetadata.getWhitePointYValue();
        if (rational != null || rational2 != null) {
            stringBuffer2.append(string5 + XmlHandler.elementStart((String)"mix:WhitePoint") + EOL);
            if (rational != null) {
                this.rationalToString(stringBuffer2, "mix:whitePointXValue", string6, rational);
            }
            if (rational2 != null) {
                this.rationalToString(stringBuffer2, "mix:whitePointYValue", string6, rational2);
            }
            stringBuffer2.append(string5 + XmlHandler.elementEnd((String)"mix:WhitePoint") + EOL);
            bl2 = true;
        }
        StringBuffer stringBuffer3 = new StringBuffer(string5 + XmlHandler.elementStart((String)"mix:PrimaryChromaticities") + EOL);
        boolean bl3 = false;
        rational = nisoImageMetadata.getPrimaryChromaticitiesRedX();
        if (rational != null) {
            this.rationalToString(stringBuffer3, "mix:primaryChromaticitiesRedX", string6, rational);
            bl3 = true;
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesRedY()) != null) {
            this.rationalToString(stringBuffer3, "mix:primaryChromaticitiesRedY", string6, rational);
            bl3 = true;
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesGreenX()) != null) {
            this.rationalToString(stringBuffer3, "mix:primaryChromaticitiesGreenX", string6, rational);
            bl3 = true;
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesGreenY()) != null) {
            this.rationalToString(stringBuffer3, "mix:primaryChromaticitiesGreenY", string6, rational);
            bl3 = true;
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesBlueX()) != null) {
            this.rationalToString(stringBuffer3, "mix:primaryChromaticitiesBlueX", string6, rational);
            bl3 = true;
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesBlueY()) != null) {
            this.rationalToString(stringBuffer3, "mix:primaryChromaticitiesBlueY", string6, rational);
            bl3 = true;
        }
        stringBuffer3.append(string5 + XmlHandler.elementEnd((String)"mix:PrimaryChromaticities") + EOL);
        if (bl3) {
            stringBuffer2.append(stringBuffer3);
            bl2 = true;
        }
        stringBuffer2.append(string4 + XmlHandler.elementEnd((String)"mix:ImageColorEncoding") + EOL);
        if (bl2) {
            this._writer.print(stringBuffer2);
        }
        StringBuffer stringBuffer4 = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:TargetData") + EOL);
        boolean bl4 = false;
        n2 = nisoImageMetadata.getTargetType();
        if (n2 != -1) {
            stringBuffer4.append(string5 + XmlHandler.element((String)"mix:targetType", (String)Integer.toString(n2)) + EOL);
            bl4 = true;
        }
        StringBuffer stringBuffer5 = new StringBuffer(string5 + XmlHandler.elementStart((String)"mix:TargetID") + EOL);
        boolean bl5 = false;
        string2 = nisoImageMetadata.getTargetIDManufacturer();
        if (string2 != null) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:targetManufacturer", (String)string2) + EOL);
            bl5 = true;
        }
        if ((string2 = nisoImageMetadata.getTargetIDName()) != null) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:targetName", (String)string2) + EOL);
            bl5 = true;
        }
        if ((string2 = nisoImageMetadata.getTargetIDNo()) != null) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:targetNo", (String)string2) + EOL);
            bl5 = true;
        }
        if ((string2 = nisoImageMetadata.getTargetIDMedia()) != null) {
            stringBuffer5.append(string6 + XmlHandler.element((String)"mix:targetMedia", (String)string2) + EOL);
            bl5 = true;
        }
        stringBuffer5.append(string5 + XmlHandler.elementEnd((String)"mix:TargetID") + EOL);
        if (bl5) {
            stringBuffer4.append(stringBuffer5);
            bl4 = true;
        }
        if ((string2 = nisoImageMetadata.getImageData()) != null) {
            stringBuffer4.append(string5 + XmlHandler.element((String)"mix:externalTarget", (String)string2) + EOL);
            bl4 = true;
        }
        if ((string2 = nisoImageMetadata.getPerformanceData()) != null) {
            stringBuffer4.append(string5 + XmlHandler.element((String)"mix:performanceData", (String)string2) + EOL);
            bl4 = true;
        }
        stringBuffer4.append(string4 + XmlHandler.elementEnd((String)"mix:TargetData") + EOL);
        if (bl4) {
            this._writer.print(stringBuffer4);
        }
        this._writer.println(string3 + XmlHandler.elementEnd((String)"mix:ImageAssessmentMetadata"));
    }

    protected void showChangeHistory20(NisoImageMetadata nisoImageMetadata, String string) {
        String[] stringArray;
        String string2 = string + " ";
        String string3 = string2 + " ";
        String string4 = string3 + " ";
        String string5 = string4 + " ";
        StringBuffer stringBuffer = new StringBuffer(string2 + XmlHandler.elementStart((String)"mix:ChangeHistory") + EOL);
        boolean bl = false;
        stringBuffer.append(string3 + XmlHandler.elementStart((String)"mix:ImageProcessing") + EOL);
        String string6 = nisoImageMetadata.getSourceData();
        if (string6 != null) {
            stringBuffer.append(string4 + XmlHandler.element((String)"mix:sourceData") + EOL);
            bl = true;
        }
        if ((string6 = nisoImageMetadata.getProcessingAgency()) != null) {
            stringBuffer.append(string4 + XmlHandler.element((String)"mix:processingAgency") + EOL);
            bl = true;
        }
        StringBuffer stringBuffer2 = new StringBuffer(string4 + XmlHandler.elementStart((String)"mix:ProcessingSoftware") + EOL);
        boolean bl2 = false;
        string6 = nisoImageMetadata.getProcessingSoftwareName();
        if (string6 != null) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:processingSoftwareName", (String)string6) + EOL);
            bl2 = true;
        }
        if ((string6 = nisoImageMetadata.getProcessingSoftwareVersion()) != null) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:processingSoftwareVersion", (String)string6) + EOL);
            bl2 = true;
        }
        if ((string6 = nisoImageMetadata.getOS()) != null) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:processingOperatingSystemName", (String)string6) + EOL);
            bl2 = true;
        }
        if ((string6 = nisoImageMetadata.getOSVersion()) != null) {
            stringBuffer2.append(string5 + XmlHandler.element((String)"mix:processingOperatingSystemVersion", (String)string6) + EOL);
            bl2 = true;
        }
        stringBuffer2.append(string4 + XmlHandler.elementEnd((String)"mix:ProcessingSoftware") + EOL);
        if (bl2) {
            stringBuffer.append(stringBuffer2);
            bl = true;
        }
        if ((stringArray = nisoImageMetadata.getProcessingActions()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(string4 + XmlHandler.element((String)"mix:processingActions", (String)stringArray[i]) + EOL);
            }
            bl = true;
        }
        stringBuffer.append(string3 + XmlHandler.elementEnd((String)"mix:ImageProcessing") + EOL);
        stringBuffer.append(string2 + XmlHandler.elementEnd((String)"mix:ChangeHistory") + EOL);
        if (bl) {
            this._writer.println(stringBuffer);
        }
    }

    private String photometricInterpretationToString(int n) {
        String string = "Unknown";
        switch (n) {
            case 0: {
                string = "WhiteIsZero";
                break;
            }
            case 1: {
                string = "BlackIsZero";
                break;
            }
            case 2: {
                string = "RGB";
                break;
            }
            case 3: {
                string = "PaletteColor";
                break;
            }
            case 4: {
                string = "TransparencyMask";
                break;
            }
            case 5: {
                string = "CMYK";
                break;
            }
            case 6: {
                string = "YCbCr";
                break;
            }
            case 8: {
                string = "CIELab";
                break;
            }
            case 9: {
                string = "ICCLab";
                break;
            }
            case 10: {
                string = "ITULab";
                break;
            }
            case 32803: {
                string = "CFA";
                break;
            }
            case 34892: {
                string = "LinearRaw";
            }
        }
        return string;
    }

    protected void showAESAudioMetadata(AESAudioMetadata aESAudioMetadata) {
        String[] stringArray;
        int n;
        String[][] stringArray2;
        Object object;
        String[][] stringArray3;
        String[] stringArray4;
        long l;
        int n2;
        this._level += 3;
        String string = XmlHandler.getIndent((int)this._level);
        String string2 = string + " ";
        String string3 = string2 + " ";
        String string4 = string3 + " ";
        String string5 = string4 + " ";
        this._sampleRate = aESAudioMetadata.getSampleRate();
        String[][] stringArray5 = new String[][]{{"xmlns:aes", "http://www.aes.org/audioObject"}, {"xmlns:tcf", "http://www.aes.org/tcf"}, {"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"}, {"ID", "J4"}, {"analogDigitalFlag", aESAudioMetadata.getAnalogDigitalFlag()}, {"disposition", "Validated by JHOVE"}, {"schemaVersion", "1.02b"}};
        this._writer.println(string + XmlHandler.elementStart((String)"aes:audioObject", (String[][])stringArray5));
        String string6 = aESAudioMetadata.getFormat();
        if (string6 != null) {
            String string7 = aESAudioMetadata.getSpecificationVersion();
            String[][] stringArray6 = new String[1][2];
            stringArray6[0][0] = "specificationVersion";
            stringArray6[0][1] = string7 != null ? string7 : "";
            this._writer.println(string2 + XmlHandler.element((String)"aes:format", (String[][])stringArray6, (String)string6));
        }
        if ((string6 = aESAudioMetadata.getAppSpecificData()) != null) {
            this._writer.println(string2 + XmlHandler.element((String)"aes:appSpecificData", (String)string6));
        }
        if ((string6 = aESAudioMetadata.getAudioDataEncoding()) != null) {
            this._writer.println(string2 + XmlHandler.element((String)"aes:audioDataEncoding", (String)string6));
        }
        if ((n2 = aESAudioMetadata.getByteOrder()) != -1) {
            this._writer.println(string2 + XmlHandler.element((String)"aes:byteOrder", (String)(n2 == 0 ? "BIG_ENDIAN" : "LITTLE_ENDIAN")));
        }
        if ((l = aESAudioMetadata.getFirstSampleOffset()) != -1L) {
            this._writer.println(string2 + XmlHandler.element((String)"aes:firstSampleOffset", (String)Long.toString(l)));
        }
        if ((stringArray4 = aESAudioMetadata.getUse()) != null) {
            stringArray3 = new String[][]{{"useType", stringArray4[0]}, {"otherType", stringArray4[1]}};
            this._writer.println(string2 + XmlHandler.element((String)"aes:use", (String[][])stringArray3));
        }
        if ((string6 = aESAudioMetadata.getPrimaryIdentifier()) != null) {
            stringArray3 = aESAudioMetadata.getPrimaryIdentifierType();
            object = new String[1][2];
            object[0][0] = "identifierType";
            object[0][1] = stringArray3 != null ? stringArray3 : "";
            this._writer.println(string2 + XmlHandler.element((String)"aes:primaryIdentifier", (String[][])object, (String)string6));
        }
        if (!(stringArray3 = aESAudioMetadata.getFaceList()).isEmpty()) {
            object = new String[][]{{"ID", "J2"}, {"formatRef", "J1"}, {"faceRef", "J3"}, {"label", "BuiltByJHOVE"}};
            stringArray2 = new String[][]{{"direction", null}, {"ID", "J3"}, {"audioObjectRef", "J4"}, {"label", "Face"}};
            AESAudioMetadata.Face face = (AESAudioMetadata.Face)stringArray3.get(0);
            stringArray2[0][1] = face.getDirection();
            this._writer.println(string2 + XmlHandler.elementStart((String)"aes:face", (String[][])stringArray2));
            AESAudioMetadata.TimeDesc timeDesc = face.getStartTime();
            if (timeDesc != null) {
                this._writer.println(string3 + XmlHandler.elementStart((String)"aes:timeline"));
                this.writeAESTimeRange(string3, timeDesc, face.getDuration());
                this._writer.println(string3 + XmlHandler.elementEnd((String)"aes:timeline"));
            }
            AESAudioMetadata.FaceRegion faceRegion = face.getFaceRegion(0);
            this._writer.println(string3 + XmlHandler.elementStart((String)"aes:region", (String[][])object));
            this._writer.println(string4 + XmlHandler.elementStart((String)"aes:timeRange"));
            this.writeAESTimeRange(string3, faceRegion.getStartTime(), faceRegion.getDuration());
            this._writer.println(string4 + XmlHandler.elementEnd((String)"aes:timeRange"));
            n = aESAudioMetadata.getNumChannels();
            if (n != -1) {
                this._writer.println(string4 + XmlHandler.element((String)"aes:numChannels", (String)Integer.toString(n)));
            }
            stringArray = aESAudioMetadata.getMapLocations();
            for (int i = 0; i < n; ++i) {
                String[][] stringArray7 = new String[][]{{"ID", "J9" + Integer.toString(i)}, {"label", "JHOVE"}, {"faceRegionRef", "J2"}};
                this._writer.println(string4 + XmlHandler.elementStart((String)"aes:stream", (String[][])stringArray7));
                String[][] stringArray8 = new String[][]{{"channelNum", Integer.toString(i)}, {"mapLocation", stringArray[i]}};
                this._writer.println(string5 + XmlHandler.element((String)"aes:channelAssignment", (String[][])stringArray8));
                this._writer.println(string4 + XmlHandler.elementEnd((String)"aes:stream"));
            }
            this._writer.println(string3 + XmlHandler.elementEnd((String)"aes:region"));
            this._writer.println(string2 + XmlHandler.elementEnd((String)"aes:face"));
        }
        if (!(object = aESAudioMetadata.getFormatList()).isEmpty()) {
            stringArray2 = (String[][])object.get(0);
            int n3 = stringArray2.getBitDepth();
            double d = stringArray2.getSampleRate();
            n = stringArray2.getWordSize();
            stringArray = stringArray2.getBitrateReduction();
            if (n3 != -1 || d != -1.0 || n != -1) {
                this._writer.println(string2 + XmlHandler.elementStart((String)"aes:formatList"));
                String[][] stringArray9 = new String[][]{{"ID", "J1"}};
                this._writer.println(string3 + XmlHandler.elementStart((String)"aes:formatRegion", (String[][])stringArray9));
                if (n3 != -1) {
                    this._writer.println(string4 + XmlHandler.element((String)"aes:bitDepth", (String)Integer.toString(n3)));
                }
                if (d != -1.0) {
                    this._writer.println(string4 + XmlHandler.element((String)"aes:sampleRate", (String)Double.toString(d)));
                }
                if (n != -1) {
                    this._writer.println(string4 + XmlHandler.element((String)"aes:wordSize", (String)Integer.toString(n)));
                }
                if (stringArray != null) {
                    this._writer.println(string4 + XmlHandler.elementStart((String)"aes:bitrateReduction"));
                    this._writer.println(string5 + XmlHandler.element((String)"aes:codecName", (String)stringArray[0]));
                    this._writer.println(string5 + XmlHandler.element((String)"aes:codecNameVersion", (String)stringArray[1]));
                    this._writer.println(string5 + XmlHandler.element((String)"aes:codecCreatorApplication", (String)stringArray[2]));
                    this._writer.println(string5 + XmlHandler.element((String)"aes:codecCreatorApplicationVersion", (String)stringArray[3]));
                    this._writer.println(string5 + XmlHandler.element((String)"aes:codecQuality", (String)stringArray[4]));
                    this._writer.println(string5 + XmlHandler.element((String)"aes:dataRate", (String)stringArray[5]));
                    this._writer.println(string5 + XmlHandler.element((String)"aes:dataRateMode", (String)stringArray[6]));
                    this._writer.println(string4 + XmlHandler.elementEnd((String)"aes:bitrateReduction"));
                }
                this._writer.println(string3 + XmlHandler.elementEnd((String)"aes:formatRegion"));
                this._writer.println(string2 + XmlHandler.elementEnd((String)"aes:formatList"));
            }
        }
        this._writer.println(string + XmlHandler.elementEnd((String)"aes:audioObject"));
        this._level -= 3;
    }

    private void writeAESTimeRange(String string, AESAudioMetadata.TimeDesc timeDesc, AESAudioMetadata.TimeDesc timeDesc2) {
        String string2 = string + " ";
        String string3 = string2 + " ";
        String string4 = string3 + " ";
        String[][] stringArray = new String[][]{{"tcf:frameCount", "30"}, {"tcf:timeBase", "1000"}, {"tcf:videoField", "FIELD_1"}, {"tcf:countingMode", "NTSC_NON_DROP_FRAME"}};
        String[][] stringArray2 = new String[][]{{"tcf:framing", "NOT_APPLICABLE"}, {"xsi:type", "tcf:ntscFilmFramingType"}};
        this._writer.println(string2 + XmlHandler.elementStart((String)"tcf:startTime", (String[][])stringArray));
        this._writer.println(string3 + XmlHandler.element((String)"tcf:hours", (String)Integer.toString(timeDesc.getHours())));
        this._writer.println(string3 + XmlHandler.element((String)"tcf:minutes", (String)Integer.toString(timeDesc.getMinutes())));
        this._writer.println(string3 + XmlHandler.element((String)"tcf:seconds", (String)Integer.toString(timeDesc.getSeconds())));
        this._writer.println(string3 + XmlHandler.element((String)"tcf:frames", (String)Integer.toString(timeDesc.getFrames())));
        String[][] stringArray3 = new String[][]{{"tcf:sampleRate", ""}};
        double d = timeDesc.getSampleRate();
        if (d == 1.0) {
            d = this._sampleRate;
        }
        stringArray3[0][1] = "S" + Integer.toString((int)d);
        this._writer.println(string3 + XmlHandler.elementStart((String)"tcf:samples", (String[][])stringArray3));
        this._writer.println(string4 + XmlHandler.element((String)"tcf:numberOfSamples", (String)Integer.toString(timeDesc.getSamples())));
        this._writer.println(string3 + XmlHandler.elementEnd((String)"tcf:samples"));
        this._writer.println(string3 + XmlHandler.element((String)"tcf:filmFraming", (String[][])stringArray2));
        this._writer.println(string2 + XmlHandler.elementEnd((String)"tcf:startTime"));
        if (timeDesc2 != null) {
            this._writer.println(string2 + XmlHandler.elementStart((String)"tcf:duration", (String[][])stringArray));
            this._writer.println(string3 + XmlHandler.element((String)"tcf:hours", (String)Integer.toString(timeDesc2.getHours())));
            this._writer.println(string3 + XmlHandler.element((String)"tcf:minutes", (String)Integer.toString(timeDesc2.getMinutes())));
            this._writer.println(string3 + XmlHandler.element((String)"tcf:seconds", (String)Integer.toString(timeDesc2.getSeconds())));
            this._writer.println(string3 + XmlHandler.element((String)"tcf:frames", (String)Integer.toString(timeDesc2.getFrames())));
            d = timeDesc2.getSampleRate();
            if (d == 1.0) {
                d = this._sampleRate;
            }
            stringArray3[0][1] = "S" + Integer.toString((int)d);
            this._writer.println(string3 + XmlHandler.elementStart((String)"tcf:samples", (String[][])stringArray3));
            this._writer.println(string4 + XmlHandler.element((String)"tcf:numberOfSamples", (String)Integer.toString(timeDesc2.getSamples())));
            this._writer.println(string3 + XmlHandler.elementEnd((String)"tcf:samples"));
            this._writer.println(string3 + XmlHandler.element((String)"tcf:filmFraming", (String[][])stringArray2));
            this._writer.println(string2 + XmlHandler.elementEnd((String)"tcf:duration"));
        }
    }

    private String cleanURIString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '%' || "-_.!~*'();/?:@=+$,".indexOf(c) >= 0) {
                stringBuffer.append(c);
                continue;
            }
            char c2 = c;
            int n = c2 >> 4;
            n = n >= 10 ? (n += 55) : (n += 48);
            stringBuffer.append('%');
            stringBuffer.append((char)n);
            int n2 = c2 & 0xF;
            n2 = n2 >= 10 ? (n2 += 55) : (n2 += 48);
            stringBuffer.append((char)n2);
            bl = true;
        }
        if (bl) {
            return stringBuffer.toString();
        }
        return string;
    }

    public void rationalToString(StringBuffer stringBuffer, String string, String string2, Rational rational) {
        String string3 = string2 + " ";
        long l = rational.getNumerator();
        long l2 = rational.getDenominator();
        stringBuffer.append(string2 + XmlHandler.elementStart((String)string) + EOL);
        stringBuffer.append(string3 + XmlHandler.element((String)"mix:numerator", (String)Long.toString(l)) + EOL);
        if (l2 != 1L) {
            stringBuffer.append(string3 + XmlHandler.element((String)"mix:denominator", (String)Long.toString(l2)) + EOL);
        }
        stringBuffer.append(string2 + XmlHandler.elementEnd((String)string) + EOL);
    }
}

