package it.eng.jhove;

import java.util.HashMap;
import java.util.ArrayList;

import java.util.Iterator;

/**
 * Extend base Jhove RepInfo class with informations about embedded
 * objects (used for odf documents).
 *
 *
 * Created: Mon Aug  6 10:55:34 2007
 *
 * @author <a href="mailto:saint@eng.it">Gian Uberto Lauri</a>
 * @version $Revision$
 */
public class RepInfo extends edu.harvard.hul.ois.jhove.RepInfo {

    /**
     *  Creates a RepInfo with a URI reference
     *
     *  @param uri   Object file pathname or URI
     */
    public RepInfo (String uri)
    {
		super(uri);
    }

    /**
     *  Creates a RepInfo with a URI reference and an external RepInfo.
     *
     *  By default, urlFlag is <code>false</code>.
     *
     *  @param uri       Object file pathname or URI
     *  @param external  External representation information
     */
    public RepInfo (String uri, RepInfo external)
    {
		super(uri, external);
    }


    ArrayList containedRepInfos = new ArrayList();

    /**
     * <code>addContainedRepInfo</code> add a RepInfo describing a
     * part of the document
     *
     * @param info a <code>RepInfo</code>
     */
    public void addContainedRepInfo(RepInfo info) {
		containedRepInfos.add(info);
    }

    /**
     * <code>getContainedRepInfos</code> Gets the Iterator on all the parts
     * of the document
     *
     * @return an <code>Iterator</code>
     */
    public Iterator getContainedRepInfos() {
		return containedRepInfos.iterator();
    }

    /**
     * <code>getContainedRepInfosCount</code> Gets the number the parts of
     * the document
     *
     * @return an <code>int</code>
     */
    public int getContainedRepInfosCount() {
		return containedRepInfos.size();
    }

    // Infos for OLE Objects, i.e. in Open Document
    HashMap embeddedRepInfos = new HashMap();

    /**
     * <code>putEmbeddedRepInfo</code> Adds the description of a named
     * subdocument (i.e. OLE subdocuments in Open Document). Each
     * subdocument may have parts.
     *
     * @param key a <code>String</code> the key to access the subdocument
     * later, when it's time to add the parts
     * @param info a <code>RepInfo</code> the RepInfo about the
     * subdocument.
     */
    public void putEmbeddedRepInfo(String key, RepInfo info) {
		embeddedRepInfos.put(key,info);
    }

    /**
     * <code>getEmbeddedRepInfos</code> Gets the Iterator on all the
     * subdocuments of the document
     *
     * @return an <code>RepInfo</code>
     */
    public RepInfo getEmbeddedRepInfo(String key) {
		return (RepInfo)embeddedRepInfos.get(key);
    }

    /**
     * <code>getEmbeddedRepInfos</code> Gets the Iterator on all the
     * subdocuments of the document
     *
     * @return an <code>Iterator</code>
     */
    public Iterator getEmbeddedRepInfos() {
		return embeddedRepInfos.values().iterator();
    }

    /**
     * <code>getEmbeddedRepInfosCount</code> Gets the number the
     * subdocuments of the document
     *
     * @return an <code>int</code>
     */
    public int getEmbeddedRepInfosCount() {
		return embeddedRepInfos.size();
    }
}
