/*  link.c: 
 *	link user mode server's lt core to the low level driver
 *	shared are bamil_d7, BaseAddressIndex, BaseAddress...
 *
 *  Author: A. Chentsov <chentsov at ukr.net>
 *  Copying: LGPL
 */

#include <stdio.h>

#include <elf.h>
#include <asm/types.h>
#include "../martian.h"
#include "common.h"

#define PREFIX "ld"
#include "log.h"

#include "core.h"

extern __u8 *rd7_isr;

/*** imported from relocator ***/
extern int initialize_map (char *program); 
extern void relocate_symbol (char *symbol, void *newptr);

#define CHECK_COMMON_SYMBOL(symbol) \
{ \
  extern typeof (common->symbol) symbol; \
  if (& symbol != & common->symbol) { \
	LOGERR ("failed to relocate %s\n", #symbol); \
	return 0; \
  } \
}

#define CHECK_COMMON_ARRAY_SYMBOL_TO_MEMBER(symbol, member) \
{ \
  extern typeof (common->member) symbol; 		\
  if (& symbol != & common->member || 			\
      &symbol[0] != &common->member[0] ||		\
      &symbol[sizeof symbol / sizeof symbol[0]] !=	\
	&common->member[sizeof symbol / sizeof symbol[0]]) { \
	LOGERR ("failed to relocate %s\n", #symbol); \
	return 0; \
  } \
}

#define CHECK_COMMON_ARRAY_SYMBOL(symbol) \
	CHECK_COMMON_ARRAY_SYMBOL_TO_MEMBER(symbol, symbol)

#define RELOCATECHECK_SYMBOL(symbol) \
	relocate_symbol (#symbol,      & common->symbol); \
	CHECK_COMMON_SYMBOL(symbol)

#define RELOCATECHECK_ARRAY_SYMBOL(symbol) \
	relocate_symbol (#symbol,      & common->symbol); \
	CHECK_COMMON_ARRAY_SYMBOL(symbol)

int test_S (struct martian_common *common) {
	extern typeof (common->S) S;
	unsigned char c = S[0x12b]; common->S[0x12b] ^= 0xff; 
	if (c != (unsigned char)~S[0x12b]) {
		LOGDEBUG(Note, "c: %d, S[0x12b]: %d, common->S[0x12b]: %d\n", c, S[0x12b], common->S[0x12b]);
		common->S[0x12b] ^= 0xff; 
		LOGDEBUG (Note, "S: %x, common->S: %x\n", S, common->S);
		LOGDEBUG (Note, "&S: %x, &common->S: %x\n", &S[0], &common->S[0]);
		LOGERR ("Failed check of array\n"); 

		return 0;
	}
	S[0x12b] ^= 0xff;
	return 1;
}

int link_to_driver (char *image, struct martian_common *common) {
	if (! initialize_map (image)) 
		return 0;
	
	RELOCATECHECK_SYMBOL (BaseAddress);
	RELOCATECHECK_SYMBOL (BaseAddress2);
	RELOCATECHECK_SYMBOL (BaseValue);
	RELOCATECHECK_SYMBOL (BaseAddressIndex);
	RELOCATECHECK_SYMBOL (BaseAddressData);
	RELOCATECHECK_SYMBOL (dp_bamil_rd7);
	RELOCATECHECK_SYMBOL (dp_byte_f);
	RELOCATECHECK_SYMBOL (x_dsp_mars);
	RELOCATECHECK_SYMBOL (x_dsp_mars3);	/* TODO: should be set after conf call */
	RELOCATECHECK_SYMBOL (dp_version);
	RELOCATECHECK_SYMBOL (x_chip_version);

	LOGDEBUG (Note, "Relocating isr symbols\n");
	RELOCATECHECK_SYMBOL (V34Mode);
	RELOCATECHECK_SYMBOL (dp_dsp_data_in_progress);
	RELOCATECHECK_SYMBOL (dp_ring_int_count);
	RELOCATECHECK_SYMBOL (dp_sleep);
	RELOCATECHECK_ARRAY_SYMBOL (S);
	RELOCATECHECK_ARRAY_SYMBOL (io_dce_tx_buff);
	RELOCATECHECK_SYMBOL (io_dce_tx_wptr);
	RELOCATECHECK_SYMBOL (io_dce_tx_rptr);
	common->io_dce_tx_buff_um = (__u32 ) common->io_dce_tx_buff;
	RELOCATECHECK_ARRAY_SYMBOL (io_dce_rx_buff);
	RELOCATECHECK_SYMBOL (io_dce_rx_wptr);
	RELOCATECHECK_SYMBOL (io_dce_rx_rptr);
	common->io_dce_rx_buff_um = (__u32 ) common->io_dce_rx_buff;

	if (test_S (common) == 0) return 0;

	relocate_symbol ("io_pdm_rx_buffer", &common->io_pdm_rx_buff);
	CHECK_COMMON_ARRAY_SYMBOL_TO_MEMBER (io_pdm_rx_buffer, io_pdm_rx_buff);
	RELOCATECHECK_SYMBOL (io_pdm_rx_wptr);
	RELOCATECHECK_SYMBOL (io_pdm_rx_rptr);
	common->io_pdm_rx_buff_um = (__u32 ) common->io_pdm_rx_buff;
	RELOCATECHECK_SYMBOL (RBS_tick_rx);
	RELOCATECHECK_SYMBOL (init_RBS_tick_flag);


	rd7_isr = & common->rd7_isr;

	return 1;	// done
}
