/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.properties;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperImages;
import com.nvidia.viper.actions.ResetAnalysisAction;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.parts.SessionEditPart;
import com.nvidia.viper.parts.TimelineEditPart;
import com.nvidia.viper.ui.SessionEditor;
import com.nvidia.viper.ui.SessionEditorInput;
import com.nvidia.viper.ui.TimelineOptionsControl;
import com.nvidia.viper.ui.UVMSegmentComposite;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class TimelineOptionsSection
extends AbstractPropertySection {
    private TimelineOptionsControl timelineOptionControl;
    private UVMSegmentComposite uvmSegmentControl;
    private Session session;
    private Button newSessionCheck;

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof SessionEditPart) {
            this.session = ((SessionEditPart)input).getCastedModel();
        } else if (input instanceof TimelineEditPart) {
            this.session = ((TimelineEditPart)input).getCastedModel().getSession();
        }
        this.timelineOptionControl.init(this.session);
        this.uvmSegmentControl.init(this.session);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage page) {
        super.createControls(parent, page);
        Composite top = this.getWidgetFactory().createFlatFormComposite(parent);
        this.uvmSegmentControl = new UVMSegmentComposite(top, 0);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.uvmSegmentControl.setLayoutData(data);
        this.timelineOptionControl = new TimelineOptionsControl(top, 0);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.uvmSegmentControl, 4);
        this.timelineOptionControl.setLayoutData(data);
        this.newSessionCheck = new Button(top, 32);
        this.newSessionCheck.setText("Open in new session");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.timelineOptionControl, 4);
        this.newSessionCheck.setLayoutData((Object)data);
        final Button applyButton = new Button(top, 0);
        applyButton.setText("Apply");
        applyButton.setToolTipText("Update existing timeline with given options");
        applyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TimelineOptionsSection.this.applyNewOptions();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(10, 0);
        data.top = new FormAttachment((Control)this.newSessionCheck, 4);
        applyButton.setLayoutData((Object)data);
        this.timelineOptionControl.addListener(new TimelineOptionsControl.ITimelineOptionListener(){

            @Override
            public void firePageComplete(boolean complete, String message) {
                if (complete) {
                    if (!applyButton.isEnabled()) {
                        applyButton.setEnabled(true);
                        TimelineOptionsSection.this.timelineOptionControl.setNote(null, null);
                    }
                } else {
                    applyButton.setEnabled(false);
                    TimelineOptionsSection.this.timelineOptionControl.setNote(message, ViperImages.get("icons/en/analysis_bad.gif"));
                }
            }
        });
        this.timelineOptionControl.setBackgroundMode(1);
        this.timelineOptionControl.setBackground(top.getBackground());
        this.uvmSegmentControl.setBackgroundMode(1);
        this.uvmSegmentControl.setBackground(top.getBackground());
        this.newSessionCheck.setBackground(top.getBackground());
    }

    protected void applyNewOptions() {
        if (this.newSessionCheck.getSelection()) {
            this.openNewSession();
        } else {
            this.updateExistingSession();
        }
    }

    private void updateExistingSession() {
        if (this.session != null) {
            this.timelineOptionControl.updateTimelineOptions(this.session);
            this.uvmSegmentControl.updateTimelineOptions(this.session);
            new ResetAnalysisAction(this.session, false).run();
            try {
                this.session.recreateTimelines();
            }
            catch (ViperException e) {
                ViperExceptionHandler.handle("Apply Failed", "Unable to apply new timeline options", e);
            }
        }
    }

    private void openNewSession() {
        Session newSession = new Session();
        this.timelineOptionControl.updateTimelineOptions(newSession);
        this.uvmSegmentControl.updateTimelineOptions(newSession);
        this.session.clone(newSession);
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            SessionEditor newEditor = (SessionEditor)activePage.openEditor((IEditorInput)new SessionEditorInput(newSession), "com.nvidia.viper.sessioneditor");
            newEditor.scaleToFit();
            newEditor.setDirty(true);
            newSession.setDirty(true);
        }
        catch (Exception e) {
            ViperExceptionHandler.handle("Apply Failed", "Unable to apply new timeline options", e);
        }
    }
}

