/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.launch;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.debug.core.DebugPreferencesListener;
import com.nvidia.cuda.ide.debug.launch.CudaDebugServicesFactory;
import com.nvidia.cuda.ide.debug.launch.CudaLaunch;
import com.nvidia.cuda.ide.debug.util.DebugPerspectiveListener;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import com.nvidia.cuda.ide.util.NsightUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunchDelegate;
import org.eclipse.cdt.launch.LaunchUtils;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.osgi.util.NLS;

public class CudaGdbLaunchDelegate
extends GdbLaunchDelegate {
    public CudaGdbLaunchDelegate() {
    }

    public CudaGdbLaunchDelegate(boolean requireCProject) {
        super(requireCProject);
    }

    protected IDsfDebugServicesFactory newServiceFactory(String version) {
        return new CudaDebugServicesFactory(version);
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block6: {
            if ("run".equals(mode)) {
                this.runApplication(config, launch, monitor);
            } else {
                try {
                    String filter = config.getAttribute("lc.devices", "");
                    DebugPreferencesListener.ignore(config);
                    if (this.canTogglePreemption()) {
                        DebugUtil.localDarwinDebuggingPrompt();
                        DebugUtil.preemptionPrompt(filter);
                        if (launch instanceof CudaLaunch) {
                            ((CudaLaunch)launch).setPreemptionEnabled(this.isPreemption(filter));
                        }
                    }
                    DebugPreferencesListener.donotIgnore(config);
                    super.launch(config, mode, launch, monitor);
                    DebugPerspectiveListener.install();
                }
                catch (CoreException e) {
                    if (launch.isTerminated() && CoreUtil.isTrue((Object)NsightUtil.isCudaGdbRunning((boolean)false))) break block6;
                    throw e;
                }
            }
        }
    }

    protected boolean canTogglePreemption() {
        return true;
    }

    protected IBinaryParser.IBinaryObject verifyBinary(ICProject proj, IPath exePath) throws CoreException {
        try {
            return LaunchUtils.getBinary((IProject)(proj != null ? proj.getProject() : null), (IPath)exePath);
        }
        catch (ClassCastException e) {
            ClassCastException exception = e;
            Status status = new Status(4, this.getPluginID(), 107, String.valueOf(LaunchMessages.AbstractCLaunchDelegate_Program_is_not_a_recognized_executable) + " " + exePath.toOSString(), (Throwable)exception);
            throw new CoreException((IStatus)status);
        }
    }

    public String[] getProgramArgumentsArray(ILaunchConfiguration config) throws CoreException {
        return LaunchUtils.getProgramArgumentsArray((ILaunchConfiguration)config);
    }

    protected void runApplication(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(LaunchMessages.LocalRunLaunchDelegate_Launching_Local_C_Application, 10);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            monitor.worked(1);
            ICProject project = CDebugUtils.getCProject((ILaunchConfiguration)config);
            IPath exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config, (project == null ? 1 : 0) != 0);
            if (exePath != null) {
                this.verifyBinary(project, exePath);
            }
            String[] arguments = this.getProgramArgumentsArray(config);
            File wd = this.getWorkingDirectory(config);
            if (wd == null) {
                wd = new File(System.getProperty("user.home", "."));
            }
            ArrayList<String> command = new ArrayList<String>(1 + arguments.length);
            command.add(exePath.toOSString());
            command.addAll(Arrays.asList(arguments));
            String[] commandArray = command.toArray(new String[command.size()]);
            boolean usePty = config.getAttribute("org.eclipse.cdt.launch.use_terminal", true);
            monitor.worked(5);
            Process process = this.exec(commandArray, this.getEnvironment(config), wd, usePty);
            monitor.worked(3);
            DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(commandArray[0]));
        }
        finally {
            monitor.done();
        }
    }

    public File getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        return this.verifyWorkingDirectory(configuration);
    }

    public File verifyWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        IPath path = this.getWorkingDirectoryPath(configuration);
        if (path == null) {
            ICProject cp = CDebugUtils.getCProject((ILaunchConfiguration)configuration);
            if (cp != null) {
                IProject p = cp.getProject();
                return p.getLocation().toFile();
            }
        } else if (path.isAbsolute()) {
            File dir = new File(path.toOSString());
            if (dir.isDirectory()) {
                return dir;
            }
            this.abort(LaunchMessages.AbstractCLaunchDelegate_Working_directory_does_not_exist, new FileNotFoundException(NLS.bind((String)LaunchMessages.AbstractCLaunchDelegate_WORKINGDIRECTORY_PATH_not_found, (Object)path.toOSString())), 101);
        } else {
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (res instanceof IContainer && res.exists()) {
                return res.getLocation().toFile();
            }
            this.abort(LaunchMessages.AbstractCLaunchDelegate_Working_directory_does_not_exist, new FileNotFoundException(NLS.bind((String)LaunchMessages.AbstractCLaunchDelegate_WORKINGDIRECTORY_PATH_not_found, (Object)path.toOSString())), 101);
        }
        return null;
    }

    protected IPath getWorkingDirectoryPath(ILaunchConfiguration config) throws CoreException {
        String expandedLocation;
        String location = config.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
        if (location != null && (expandedLocation = LaunchUtils.getStringVariableManager().performStringSubstitution(location)).length() > 0) {
            return new Path(expandedLocation);
        }
        return null;
    }

    protected String[] getEnvironment(ILaunchConfiguration config) throws CoreException {
        String[] array = DebugPlugin.getDefault().getLaunchManager().getEnvironment(config);
        if (array == null) {
            array = new String[]{};
        }
        return DebugUtil.addDevicesEnvironmentVariable(array, config);
    }

    protected String renderProcessLabel(String commandLine) {
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        return MessageFormat.format("{0} ({1})", commandLine, timestamp);
    }

    protected Process exec(String[] cmdLine, String[] environ, File workingDirectory, boolean usePty) throws CoreException {
        Process p;
        block3: {
            p = null;
            try {
                p = workingDirectory == null ? ProcessFactory.getFactory().exec(cmdLine, environ) : (usePty && PTY.isSupported() ? ProcessFactory.getFactory().exec(cmdLine, environ, workingDirectory, new PTY()) : ProcessFactory.getFactory().exec(cmdLine, environ, workingDirectory));
            }
            catch (IOException e) {
                this.abort(LaunchMessages.LocalRunLaunchDelegate_Error_starting_process, e, 150);
            }
            catch (NoSuchMethodError e) {
                Object result;
                Status status = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 100, LaunchMessages.LocalRunLaunchDelegate_Does_not_support_working_dir, (Throwable)e);
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                if (handler == null || !((result = handler.handleStatus((IStatus)status, (Object)this)) instanceof Boolean) || !((Boolean)result).booleanValue()) break block3;
                p = this.exec(cmdLine, environ, null, usePty);
            }
        }
        return p;
    }

    protected CudaLaunch createGdbLaunch(ILaunchConfiguration configuration, String mode, ISourceLocator locator) throws CoreException {
        CudaLaunch launch = new CudaLaunch(configuration, mode, locator);
        launch.setPreemptionEnabled(this.isPreemption(configuration.getAttribute("lc.devices", null)));
        return launch;
    }

    protected boolean isPreemption(String filter) {
        return DebugUtil.isPreemptionEnabled(filter);
    }

    protected String getGDBVersion(ILaunchConfiguration config) throws CoreException {
        return "7.2";
    }

    protected IPath checkBinaryDetails(ILaunchConfiguration config) throws CoreException {
        String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
        String cpuCoreName = config.getAttribute("org.eclipse.cdt.launch.COREFILE_PATH", "");
        if ("core".equals(debugMode) && cpuCoreName.trim().length() == 0) {
            return new Path("/bin/bash");
        }
        return super.checkBinaryDetails(config);
    }
}

