/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.filters;

import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ICoordSorter;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.ICudaVisitor;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.Lane;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import com.nvidia.cuda.ide.debug.model.Warp;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.ICudaElementFilter;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class HardwareElementsFilter
implements ICudaElementFilter {
    public static final String ID = HardwareElementsFilter.class.getName();

    @Override
    public void updateChildren(boolean inLogicalMode, ICudaRuntimeObject object, int offset, int length, ICoordSorter sorter, DataRequestMonitor<IDMContext[]> rm) {
        object.accept(new GetChildren(rm, offset, length));
    }

    @Override
    public void updateChildrenCount(boolean isLogical, ICudaRuntimeObject object, ICoordSorter sorter, DataRequestMonitor<Integer> drm) {
        object.accept(new GetChildrenCount((RequestMonitor)drm, (DataRequestMonitor)drm){
            private final /* synthetic */ DataRequestMonitor val$drm;
            {
                this.val$drm = dataRequestMonitor;
                super($anonymous0);
            }

            @Override
            protected void setCount(int count) {
                this.val$drm.setData((Object)count);
                this.val$drm.done();
            }
        });
    }

    @Override
    public void updateHasChildren(boolean isLogical, ICudaRuntimeObject object, DataRequestMonitor<Boolean> drm) {
        object.accept(new GetChildrenCount((RequestMonitor)drm, (DataRequestMonitor)drm){
            private final /* synthetic */ DataRequestMonitor val$drm;
            {
                this.val$drm = dataRequestMonitor;
                super($anonymous0);
            }

            @Override
            protected void setCount(int count) {
                this.val$drm.setData((Object)(count > 0 ? 1 : 0));
                this.val$drm.done();
            }
        });
    }

    private static final class GetChildren
    implements ICudaVisitor {
        private final int length;
        private final int offset;
        private final DataRequestMonitor<IDMContext[]> rm;

        public GetChildren(DataRequestMonitor<IDMContext[]> rm, int offset, int length) {
            this.rm = rm;
            this.offset = offset > 0 ? offset : 0;
            this.length = length > 0 ? length : Integer.MAX_VALUE;
        }

        @Override
        public void visitApplication(final ICudaApplication application) {
            application.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    application.getDevices(new DataRequestMonitor<Device[]>(application.getExecutor(), (RequestMonitor)GetChildren.this.rm){

                        protected void handleSuccess() {
                            IDMContext[] contexts = new IDMContext[Math.min(GetChildren.this.length, ((Device[])this.getData()).length - GetChildren.this.offset)];
                            int i = 0;
                            while (i < contexts.length) {
                                contexts[i] = ((Device[])this.getData())[GetChildren.this.offset + i];
                                ++i;
                            }
                            GetChildren.this.rm.setData((Object)contexts);
                            GetChildren.this.rm.done();
                        }
                    });
                }
            });
        }

        @Override
        public void visitBlock(Block block) {
            this.rm.setData((Object)new IDMContext[0]);
            this.rm.done();
        }

        @Override
        public void visitDevice(Device device) {
            try {
                short count = device.getSmCount();
                IDMContext[] contexts = new IDMContext[Math.max(0, Math.min(this.length, count - this.offset))];
                int i = 0;
                while (i < contexts.length) {
                    contexts[i] = device.getSm((short)(this.offset + i));
                    ++i;
                }
                this.rm.setData((Object)contexts);
            }
            catch (CudaException e) {
                this.rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
            }
            this.rm.done();
        }

        @Override
        public void visitKernel(Kernel kernel) {
            this.rm.setData((Object)new IDMContext[0]);
            this.rm.done();
        }

        @Override
        public void visitLane(Lane lane) {
            this.rm.setData((Object)new IDMContext[0]);
            this.rm.done();
        }

        @Override
        public void visitSM(StreamingMultiprocessor sm) {
            try {
                short count = ((Device)DMContexts.getAncestorOfType((IDMContext)sm, Device.class)).getWarpCount();
                IDMContext[] contexts = new IDMContext[Math.min(this.length, count - this.offset)];
                int i = 0;
                while (i < contexts.length) {
                    contexts[i] = sm.getWarp((short)(this.offset + i));
                    ++i;
                }
                this.rm.setData((Object)contexts);
            }
            catch (CudaException e) {
                this.rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
            }
            this.rm.done();
        }

        @Override
        public void visitThread(DeviceThread deviceThread) {
            this.rm.setData((Object)new IDMContext[0]);
            this.rm.done();
        }

        @Override
        public void visitWarp(Warp warp) {
            try {
                short count = ((Device)DMContexts.getAncestorOfType((IDMContext)warp, Device.class)).getLaneCount();
                IDMContext[] contexts = new IDMContext[Math.min(this.length, count - this.offset)];
                int i = 0;
                while (i < contexts.length) {
                    contexts[i] = warp.getLane((short)(this.offset + i));
                    ++i;
                }
                this.rm.setData((Object)contexts);
            }
            catch (CudaException e) {
                this.rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
            }
            this.rm.done();
        }
    }

    private static abstract class GetChildrenCount
    implements ICudaVisitor {
        private final RequestMonitor rm;

        public GetChildrenCount(RequestMonitor update) {
            this.rm = update;
        }

        protected abstract void setCount(int var1);

        @Override
        public void visitApplication(final ICudaApplication application) {
            application.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    application.getDevices(new DataRequestMonitor<Device[]>(application.getExecutor(), GetChildrenCount.this.rm){

                        protected void handleSuccess() {
                            GetChildrenCount.this.setCount(this.getData() != null ? ((Device[])this.getData()).length : 0);
                        }
                    });
                }
            });
        }

        @Override
        public void visitBlock(Block block) {
            this.setCount(0);
        }

        @Override
        public void visitDevice(Device device) {
            this.setCount(device.getSmCount());
        }

        @Override
        public void visitKernel(Kernel kernel) {
            this.setCount(0);
        }

        @Override
        public void visitLane(Lane lane) {
            this.setCount(0);
        }

        @Override
        public void visitSM(StreamingMultiprocessor sm) {
            this.setCount(((Device)DMContexts.getAncestorOfType((IDMContext)sm, Device.class)).getWarpCount());
        }

        @Override
        public void visitThread(DeviceThread deviceThread) {
            this.setCount(0);
        }

        @Override
        public void visitWarp(Warp warp) {
            this.setCount(((Device)DMContexts.getAncestorOfType((IDMContext)warp, Device.class)).getLaneCount());
        }
    }
}

