/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.includebrowser;

import java.net.URI;
import java.util.Objects;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;

public class IBFile {
    public final ITranslationUnit fTU;
    public final IIndexFileLocation fLocation;
    public final String fName;

    public IBFile(ITranslationUnit tu) {
        this.fTU = tu;
        this.fLocation = IndexLocationFactory.getIFL((ITranslationUnit)tu);
        this.fName = tu.getElementName();
    }

    public IBFile(ICProject preferredProject, IIndexFileLocation location) throws CModelException {
        this.fLocation = location;
        ITranslationUnit TU = CoreModelUtil.findTranslationUnitForLocation((IIndexFileLocation)location, (ICProject)preferredProject);
        if (TU == null) {
            TU = CoreModelUtil.findTranslationUnitForLocation((URI)location.getURI(), (ICProject)preferredProject);
        }
        this.fTU = TU;
        String name = this.fLocation.getURI().getPath();
        this.fName = name.substring(name.lastIndexOf(47) + 1);
    }

    public IBFile(String name) {
        this.fName = name;
        this.fLocation = null;
        this.fTU = null;
    }

    public IIndexFileLocation getLocation() {
        return this.fLocation;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IBFile) {
            IBFile file = (IBFile)obj;
            return Objects.equals(this.fLocation, file.fLocation) && Objects.equals(this.fTU, file.fTU);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hashCode(this.fLocation) + 31 * (Objects.hashCode(this.fTU) + 31 * Objects.hashCode(this.fName));
    }

    public ITranslationUnit getTranslationUnit() {
        return this.fTU;
    }

    public IFile getResource() {
        IResource file;
        String fullPath;
        if (this.fLocation != null && (fullPath = this.fLocation.getFullPath()) != null && (file = ResourcesPlugin.getWorkspace().getRoot().findMember(fullPath)) instanceof IFile) {
            return (IFile)file;
        }
        return null;
    }

    public String getName() {
        return this.fName;
    }
}

