/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.cdtvariables;

import java.util.Arrays;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.cdtvariables.BuildSystemVariableSupplier;
import org.eclipse.cdt.internal.core.cdtvariables.CdtMacroSupplier;
import org.eclipse.cdt.internal.core.cdtvariables.CoreVariableSubstitutor;
import org.eclipse.cdt.internal.core.cdtvariables.DefaultVariableContextInfo;
import org.eclipse.cdt.internal.core.cdtvariables.EclipseVariablesVariableSupplier;
import org.eclipse.cdt.internal.core.cdtvariables.EnvironmentVariableSupplier;
import org.eclipse.cdt.internal.core.cdtvariables.StorableCdtVariable;
import org.eclipse.cdt.internal.core.cdtvariables.StorableCdtVariables;
import org.eclipse.cdt.internal.core.cdtvariables.UserDefinedVariableSupplier;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescriptionCache;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.cdt.utils.cdtvariables.ICdtVariableSupplier;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableManager;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableSubstitutor;
import org.eclipse.core.variables.IStringVariable;

public class CdtVariableManager
implements ICdtVariableManager {
    private static CdtVariableManager fDefault;
    public static final UserDefinedVariableSupplier fUserDefinedMacroSupplier;
    public static final BuildSystemVariableSupplier fBuildSystemVariableSupplier;
    public static final EnvironmentVariableSupplier fEnvironmentMacroSupplier;
    public static final CdtMacroSupplier fCdtMacroSupplier;
    public static final EclipseVariablesVariableSupplier fEclipseVariablesMacroSupplier;

    static {
        fUserDefinedMacroSupplier = UserDefinedVariableSupplier.getInstance();
        fBuildSystemVariableSupplier = BuildSystemVariableSupplier.getInstance();
        fEnvironmentMacroSupplier = EnvironmentVariableSupplier.getInstance();
        fCdtMacroSupplier = CdtMacroSupplier.getInstance();
        fEclipseVariablesMacroSupplier = EclipseVariablesVariableSupplier.getInstance();
    }

    protected CdtVariableManager() {
    }

    public static CdtVariableManager getDefault() {
        if (fDefault == null) {
            fDefault = new CdtVariableManager();
        }
        return fDefault;
    }

    @Override
    public ICdtVariable getVariable(String macroName, ICConfigurationDescription cfg) {
        StorableCdtVariables macros;
        if (cfg instanceof CConfigurationDescriptionCache && (macros = ((CConfigurationDescriptionCache)cfg).getCachedVariables()) != null) {
            return macros.getMacro(macroName);
        }
        int type = this.getContextType(cfg);
        return SupplierBasedCdtVariableManager.getVariable(macroName, this.getMacroContextInfo(type, cfg), true);
    }

    private IVariableContextInfo getVariableContextInfo(ICConfigurationDescription cfg) {
        int type = this.getContextType(cfg);
        return this.getMacroContextInfo(type, cfg);
    }

    @Override
    public ICdtVariable[] getVariables(ICConfigurationDescription cfg) {
        StorableCdtVariables macros;
        if (cfg instanceof CConfigurationDescriptionCache && (macros = ((CConfigurationDescriptionCache)cfg).getCachedVariables()) != null) {
            return macros.getMacros();
        }
        int type = this.getContextType(cfg);
        return SupplierBasedCdtVariableManager.getVariables(this.getMacroContextInfo(type, cfg), true);
    }

    public ICdtVariableSupplier[] getSuppliers(int contextType, Object contextData) {
        IVariableContextInfo info = this.getMacroContextInfo(contextType, contextData);
        if (info != null) {
            return info.getSuppliers();
        }
        return null;
    }

    public IVariableContextInfo getMacroContextInfo(int contextType, Object contextData) {
        DefaultVariableContextInfo info = new DefaultVariableContextInfo(contextType, contextData);
        if (info.getSuppliers() != null) {
            return info;
        }
        return null;
    }

    @Override
    public String convertStringListToString(String[] value, String listDelimiter) {
        return CdtVariableResolver.convertStringListToString(value, listDelimiter);
    }

    @Override
    public String resolveValue(String value, String nonexistentMacrosValue, String listDelimiter, ICConfigurationDescription cfg) throws CdtVariableException {
        IVariableContextInfo info = this.getMacroContextInfo(this.getContextType(cfg), cfg);
        if (info != null) {
            return CdtVariableResolver.resolveToString(value, this.getMacroSubstitutor(info, nonexistentMacrosValue, listDelimiter));
        }
        return null;
    }

    @Override
    public String[] resolveStringListValue(String value, String nonexistentMacrosValue, String listDelimiter, ICConfigurationDescription cfg) throws CdtVariableException {
        IVariableContextInfo info = this.getMacroContextInfo(this.getContextType(cfg), cfg);
        if (info != null) {
            return CdtVariableResolver.resolveToStringList(value, this.getMacroSubstitutor(info, nonexistentMacrosValue, listDelimiter));
        }
        return null;
    }

    @Override
    public boolean isStringListValue(String value, ICConfigurationDescription cfg) throws CdtVariableException {
        try {
            CdtVariableResolver.resolveToStringList(value, this.getMacroSubstitutor(this.getMacroContextInfo(this.getContextType(cfg), cfg), " ", null));
        }
        catch (CdtVariableException cdtVariableException) {
            return false;
        }
        return true;
    }

    @Override
    public void checkVariableIntegrity(ICConfigurationDescription cfg) throws CdtVariableException {
        int type = this.getContextType(cfg);
        IVariableContextInfo info = this.getMacroContextInfo(type, cfg);
        CoreVariableSubstitutor subst = new CoreVariableSubstitutor(info, null, ""){

            @Override
            protected SupplierBasedCdtVariableSubstitutor.ResolvedMacro resolveMacro(ICdtVariable macro) throws CdtVariableException {
                if (macro instanceof EclipseVariablesVariableSupplier.EclipseVarMacro) {
                    return new SupplierBasedCdtVariableSubstitutor.ResolvedMacro((SupplierBasedCdtVariableSubstitutor)this, macro.getName(), "");
                }
                return super.resolveMacro(macro);
            }
        };
        if (info != null) {
            CdtVariableResolver.checkIntegrity(info, subst);
        }
    }

    private int getContextType(ICConfigurationDescription des) {
        if (des != null) {
            return 3;
        }
        return 5;
    }

    public IVariableSubstitutor getMacroSubstitutor(IVariableContextInfo info, String inexistentMacroValue, String listDelimiter) {
        return new CoreVariableSubstitutor(info, inexistentMacroValue, listDelimiter);
    }

    @Override
    public String[] resolveStringListValues(String[] value, String nonexistentMacrosValue, String listDelimiter, ICConfigurationDescription cfg) throws CdtVariableException {
        IVariableContextInfo info = this.getMacroContextInfo(this.getContextType(cfg), cfg);
        if (info != null) {
            return CdtVariableResolver.resolveStringListValues(value, this.getMacroSubstitutor(info, nonexistentMacrosValue, listDelimiter), true);
        }
        return null;
    }

    @Override
    public boolean isEnvironmentVariable(ICdtVariable variable, ICConfigurationDescription cfg) {
        if (variable instanceof EnvironmentVariableSupplier.EnvVarMacro) {
            return true;
        }
        IVariableContextInfo info = this.getVariableContextInfo(cfg);
        ICdtVariable var = fEnvironmentMacroSupplier.getVariable(variable.getName(), info);
        return var != null && CdtVariableManager.variablesEqual(var, variable);
    }

    private static boolean variablesEqual(ICdtVariable var1, ICdtVariable var2) {
        block9: {
            if (CDataUtil.objectsEqual(var1, var2)) {
                return true;
            }
            if (var1 == null || var2 == null) {
                return false;
            }
            if (var1.getValueType() != var2.getValueType()) {
                return false;
            }
            if (!var1.getName().equals(var2.getName())) {
                return false;
            }
            try {
                Object[] v2;
                if (!CdtVariableResolver.isStringListVariable(var1.getValueType())) break block9;
                Object[] v1 = var1.getStringListValue();
                if (!Arrays.equals(v1, v2 = var2.getStringListValue())) {
                    return false;
                }
            }
            catch (CdtVariableException cdtVariableException) {
                return false;
            }
        }
        if (!CDataUtil.objectsEqual(var1.getStringValue(), var2.getStringValue())) {
            return false;
        }
        return true;
    }

    @Override
    public IStringVariable toEclipseVariable(ICdtVariable variable, ICConfigurationDescription cfg) {
        if (variable instanceof EclipseVariablesVariableSupplier.EclipseVarMacro) {
            return ((EclipseVariablesVariableSupplier.EclipseVarMacro)variable).getVariable();
        }
        return null;
    }

    @Override
    public boolean isUserVariable(ICdtVariable variable, ICConfigurationDescription cfg) {
        if (!(variable instanceof StorableCdtVariable)) {
            return false;
        }
        if (cfg != null) {
            return UserDefinedVariableSupplier.getInstance().containsVariable(3, cfg, variable);
        }
        return UserDefinedVariableSupplier.getInstance().containsVariable(5, null, variable);
    }
}

