/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.BitSet;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.AbstractGNUSourceCodeParser;

public final class TemplateIdStrategy
implements AbstractGNUSourceCodeParser.ITemplateIdStrategy {
    private int fCurrentBranchPoint = -1;
    private BitSet fSimpleIDs;
    private IASTName[] fTemplateNames = IASTName.EMPTY_NAME_ARRAY;

    @Override
    public boolean shallParseAsTemplateID(IASTName name) {
        boolean templateID;
        ++this.fCurrentBranchPoint;
        boolean bl = templateID = this.fSimpleIDs == null || !this.fSimpleIDs.get(this.fCurrentBranchPoint);
        if (templateID) {
            this.fTemplateNames = ArrayUtil.append(this.fTemplateNames, name);
        }
        return templateID;
    }

    public boolean setNextAlternative() {
        int bp = this.fCurrentBranchPoint;
        if (bp < 0) {
            return false;
        }
        this.fCurrentBranchPoint = -1;
        IASTName[] names = this.getTemplateNames();
        int nameLen = names.length;
        this.fTemplateNames = IASTName.EMPTY_NAME_ARRAY;
        if (this.fSimpleIDs == null) {
            this.fSimpleIDs = new BitSet();
        }
        while (bp >= 0) {
            if (!(this.fSimpleIDs.get(bp) || nameLen != 0 && this.hasMultipleArgs(names[--nameLen]))) {
                this.fSimpleIDs.clear(bp + 1, Integer.MAX_VALUE);
                this.fSimpleIDs.set(bp);
                return true;
            }
            --bp;
        }
        return false;
    }

    private boolean hasMultipleArgs(IASTName templateName) {
        IASTNode parent = templateName.getParent();
        if (parent instanceof ICPPASTTemplateId) {
            return ((ICPPASTTemplateId)parent).getTemplateArguments().length > 1;
        }
        return false;
    }

    public IASTName[] getTemplateNames() {
        return ArrayUtil.trim(this.fTemplateNames);
    }
}

