/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.math.BigInteger;
import org.eclipse.cdt.debug.core.cdi.ICDIAddressLocation;
import org.eclipse.cdt.debug.core.cdi.ICDIFileLocation;
import org.eclipse.cdt.debug.core.cdi.ICDIFunctionLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILineLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;

public abstract class Location {
    BigInteger fAddress = null;
    String fFile = null;
    String fFunction = null;
    int fLine;

    public Location(String file) {
        this(file, null, 0, null);
    }

    public Location(String file, String function) {
        this(file, function, 0, null);
    }

    public Location(String file, int line) {
        this(file, null, line, null);
    }

    public Location(BigInteger address) {
        this(null, null, 0, address);
    }

    protected Location(String file, String function, int line, BigInteger address) {
        this.fFile = file;
        this.fFunction = function;
        this.fLine = line;
        this.fAddress = address;
    }

    public BigInteger getAddress() {
        return this.fAddress;
    }

    public String getFile() {
        return this.fFile;
    }

    public String getFunction() {
        return this.fFunction;
    }

    public int getLineNumber() {
        return this.fLine;
    }

    public boolean equals(ICDILocation location) {
        if (location == this) {
            return true;
        }
        if (location instanceof ICDILineLocation) {
            ICDILineLocation lineLocation = (ICDILineLocation)location;
            String oFile = lineLocation.getFile();
            if (oFile != null && oFile.length() > 0 && this.fFile != null && this.fFile.length() > 0 && oFile.equals(this.fFile) ? lineLocation.getLineNumber() == this.fLine : !(this.fFile != null && this.fFile.length() != 0 || oFile != null && oFile.length() != 0 || lineLocation.getLineNumber() != this.fLine)) {
                return true;
            }
        } else if (location instanceof ICDIFunctionLocation) {
            ICDIFunctionLocation funcLocation = (ICDIFunctionLocation)location;
            String oFile = funcLocation.getFile();
            String oFunction = funcLocation.getFunction();
            if (oFile != null && oFile.length() > 0 && this.fFile != null && this.fFile.length() > 0 && oFile.equals(this.fFile)) {
                if (oFunction != null && oFunction.length() > 0 && this.fFunction != null && this.fFunction.length() > 0 && oFunction.equals(this.fFunction)) {
                    return true;
                }
                if (!(oFunction != null && oFunction.length() != 0 || this.fFunction != null && this.fFunction.length() != 0)) {
                    return true;
                }
            } else if (!(this.fFile != null && this.fFile.length() != 0 || oFile != null && oFile.length() != 0)) {
                if (oFunction != null && oFunction.length() > 0 && this.fFunction != null && this.fFunction.length() > 0 && oFunction.equals(this.fFunction)) {
                    return true;
                }
                if (!(oFunction != null && oFunction.length() != 0 || this.fFunction != null && this.fFunction.length() != 0)) {
                    return true;
                }
            }
        } else if (location instanceof ICDIAddressLocation) {
            ICDIAddressLocation addrLocation = (ICDIAddressLocation)location;
            BigInteger oAddr = addrLocation.getAddress();
            if (oAddr != null && oAddr.equals(this.fAddress)) {
                return true;
            }
            if (oAddr == null && this.fAddress == null) {
                return true;
            }
        } else if (location instanceof ICDIFileLocation) {
            ICDIFileLocation fileLocation = (ICDIFileLocation)location;
            String oFile = fileLocation.getFile();
            if (oFile != null && oFile.length() > 0 && this.fFile != null && this.fFile.length() > 0 && oFile.equals(this.fFile)) {
                return true;
            }
            if (!(this.fFile != null && this.fFile.length() != 0 || oFile != null && oFile.length() != 0)) {
                return true;
            }
        }
        return false;
    }
}

